/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import kd.bd.master.MaterialGroupFilterController;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.AbstractBasedataController;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.field.events.BaseDataCustomControllerEvent;
import kd.bos.form.field.events.BasedataControllerSourceEnum;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class BaseGroupFilterController
extends AbstractBasedataController {
    private static final long serialVersionUID = 1L;
    private static final Log logger = LogFactory.getLog(BaseGroupFilterController.class);

    protected void getGroupFilter(BaseDataCustomControllerEvent event, String entityType) {
        if (BasedataControllerSourceEnum.FUZZY.equals((Object)event.getSourceEnum())) {
            Long useorgid = event.getListShowParameter().getUseOrgId();
            if (useorgid == null || useorgid.equals(0L)) {
                return;
            }
            QFilter qFilter = null;
            Set<Long> useOrgIds = BaseGroupFilterController.getGroupOrgId(entityType, useorgid);
            qFilter = new QFilter("createorg", "in", useOrgIds);
            Set<Long> standardIds = this.getGroupStandardByOrgs(entityType, useOrgIds, Boolean.TRUE);
            QFilter f1 = new QFilter("standard", "in", standardIds);
            qFilter.and(f1);
            event.getQfilters().add(qFilter);
            logger.info(event.getQfilters().toString());
        }
    }

    protected static Set<Long> getGroupOrgId(String entity, Long useOrg) {
        DynamicObject ctrlview = BaseDataServiceHelper.getCtrlview((String)entity);
        HashSet<String> longnumberSet = new HashSet<String>();
        ORM ormOv = ORM.create();
        DataSet ds = ormOv.queryDataSet(MaterialGroupFilterController.class.getName(), "bos_org_structure", "longnumber", new QFilter[]{new QFilter("org", "in", (Object)useOrg), new QFilter("view.id", "=", (Object)ctrlview.getLong("id"))});
        Object object = null;
        try {
            for (Row row : ds) {
                if (row.getString("longnumber") == null) continue;
                longnumberSet.add(row.getString("longnumber"));
            }
        }
        catch (Throwable iter) {
            object = iter;
            throw iter;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable iter) {
                        ((Throwable)object).addSuppressed(iter);
                    }
                } else {
                    ds.close();
                }
            }
        }
        HashSet<String> numberSets = new HashSet<String>();
        for (String longnumber : longnumberSet) {
            String[] numbers = longnumber.split("!");
            numberSets.addAll(new HashSet<String>(Arrays.asList(numbers)));
        }
        HashSet<Long> ids = new HashSet<Long>();
        try (DataSet ds2 = ormOv.queryDataSet(MaterialGroupFilterController.class.getName(), "bos_org", "id", new QFilter[]{new QFilter("number", "in", numberSets)});){
            for (Row row : ds2) {
                if (row.getLong("id") == null) continue;
                ids.add(row.getLong("id"));
            }
        }
        return ids;
    }

    protected Set<Long> getGroupStandardByOrgs(String entityNumber, Set<Long> useOrgIds, boolean isAddEnable) {
        HashSet<Long> standardSetIds = new HashSet<Long>();
        try {
            DynamicObject ctrlview = BaseDataServiceHelper.getCtrlview((String)entityNumber);
            if (ctrlview == null) {
                return standardSetIds;
            }
            ORM ormOv = ORM.create();
            QFilter f1 = new QFilter("view.id", "=", ctrlview.getPkValue());
            QFilter f2 = new QFilter("org", "in", useOrgIds);
            HashSet<String> orglongnumberSets = new HashSet<String>();
            try (DataSet ds = ormOv.queryDataSet(MaterialGroupFilterController.class.getName(), "bos_org_structure", "longnumber", new QFilter[]{f1, f2});){
                for (Row row : ds) {
                    if (row.getString("longnumber") == null) continue;
                    orglongnumberSets.add(row.getString("longnumber"));
                }
            }
            ArrayList orglongnumberList = new ArrayList(orglongnumberSets);
            Collections.sort(orglongnumberList, Comparator.comparingInt(String::length));
            String orgLongNumber = "";
            if (orglongnumberList.size() <= 0) {
                return standardSetIds;
            }
            orgLongNumber = (String)orglongnumberList.get(orglongnumberList.size() - 1);
            String[] orgnumbers = orgLongNumber.split("!");
            HashSet<String> orgnumberSets = new HashSet<String>();
            orgnumberSets.addAll(new HashSet<String>(Arrays.asList(orgnumbers)));
            QFilter f = new QFilter("number", "in", orgnumberSets);
            f2 = new QFilter("enable", "=", (Object)"1");
            QFilter[] qFilters = new QFilter[]{f, f2};
            HashSet<Long> orgIdSets = new HashSet<Long>();
            try (DataSet ds = ormOv.queryDataSet(MaterialGroupFilterController.class.getName(), "bos_org", "id", qFilters);){
                for (Row row : ds) {
                    if (row.getLong("id") == null) continue;
                    orgIdSets.add(row.getLong("id"));
                }
            }
            f = new QFilter("createorg", "in", orgIdSets);
            qFilters = isAddEnable ? new QFilter[]{f, f2} : new QFilter[]{f};
            logger.info("\u5206\u7c7b\u6807\u51c6\u7684\u67e5\u8be2\u6761\u4ef6\uff1a" + qFilters);
            ds = ormOv.queryDataSet(MaterialGroupFilterController.class.getName(), entityNumber + "groupstandard", "id", qFilters);
            var18_23 = null;
            try {
                for (Row row : ds) {
                    if (row.get("id") == null) continue;
                    standardSetIds.add(Long.parseLong(row.get("id").toString()));
                }
            }
            catch (Throwable throwable) {
                var18_23 = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (var18_23 != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            var18_23.addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
        }
        return standardSetIds;
    }
}

