/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bd.master.MasterDataFormPlugin;
import kd.bd.master.helper.AddressHelper;
import kd.bd.master.helper.MasterDataHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public abstract class MasterDataBaseFormPlugin
extends MasterDataFormPlugin
implements HyperLinkClickListener,
TabSelectListener,
BeforeF7SelectListener {
    private static final String TABPAGEAP_ADDRESS = "tabpageap_address";
    public static final String TABPAGEAP_LINKMAN = "tabpageap_linkman";
    public static final String TABPAGEAP_BASE = "tabpageap_base";
    public static final String TABPAGEAP_BANK = "tabpageap_bank";
    private static final String TABAP = "tabap";
    private static final String CANCEL_TAX_REGIST_PLACE_CHANGE = "cancelTaxRegistPlaceChange";
    private static final String CONFIRM_DELETEENTRY_TAX = "confirmDeleteEntryTax";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addTabSelectListener(this, new String[]{TABAP});
        BasedataEdit taxCertificate = (BasedataEdit)this.getControl("taxcertificate");
        if (taxCertificate != null) {
            taxCertificate.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"expirydt", "effectivedt", "savechangename"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"expirydt", "effectivedt"});
        AddressHelper.queryAddressData((IDataModel)this.getModel(), (String)this.getType());
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView != null) {
            IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
            MasterDataHelper.setEnrtyPropertyEnable((IDataModel)this.getModel(), (IFormView)this.getView(), (IPageCache)pageCache, (EntryGrid)((EntryGrid)this.getControl("entry_bank")), (EntryGrid)((EntryGrid)this.getControl("entry_linkman")));
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operKey = operate.getOperateKey();
        if ("newentry_tax".equals(operKey)) {
            DynamicObject taxRegistPlace = this.getModel().getDataEntity().getDynamicObject("taxregistplace");
            if (taxRegistPlace == null) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u7a0e\u52a1\u6ce8\u518c\u5730\u3002", (String)"MasterDataBaseFormPlugin_3", (String)"bd-master-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if ("deleteentry_tax".equals(operKey)) {
            if (this.getPageCache().get(CONFIRM_DELETEENTRY_TAX) != null) {
                this.getPageCache().remove(CONFIRM_DELETEENTRY_TAX);
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\uff1f", (String)"MasterDataBaseFormPlugin_1", (String)"bd-master-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("deleteentry_tax", (IFormPlugin)this));
            args.setCancel(true);
        } else if ("save".equals(operKey) || "submit".equals(operKey)) {
            DynamicObjectCollection banks = this.getModel().getDataEntity(true).getDynamicObjectCollection("entry_bank");
            if (banks == null || banks.size() == 0) {
                return;
            }
            for (DynamicObject bank : banks) {
                if (StringUtils.isEmpty((String)bank.getString("bankaccount"))) continue;
                bank.set("bankaccount", (Object)bank.getString("bankaccount").trim());
            }
        } else if ("change".equals(operKey)) {
            this.addEntryGridFilter("entry_linkman", "deleteidentity");
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView != null) {
            MasterDataHelper.setEnrtyPropertyEnable((IDataModel)this.getModel(), (IFormView)this.getView(), (IPageCache)((IPageCache)parentView.getService(IPageCache.class)), (EntryGrid)((EntryGrid)this.getControl("entry_bank")), (EntryGrid)((EntryGrid)this.getControl("entry_linkman")));
        }
    }

    @Override
    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getModel().deleteEntryData("entry_address");
        this.getModel().deleteEntryData("entry_linkman");
        this.getModel().deleteEntryData("entry_bank");
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        if (closedCallBackEvent.getReturnData() instanceof Map) {
            Map data = (Map)closedCallBackEvent.getReturnData();
            if (("supplieraddress".equalsIgnoreCase(closedCallBackEvent.getActionId()) || "customeraddress".equalsIgnoreCase(closedCallBackEvent.getActionId())) && !data.isEmpty() && data.size() > 0) {
                AddressHelper.queryAddressData((IDataModel)this.getModel(), (String)this.getType());
                DynamicObjectCollection entryList = this.getModel().getEntryEntity("entry_linkman");
                DynamicObject entry = null;
                if (entryList != null && entryList.size() > 0) {
                    for (int i = 0; i < entryList.size(); ++i) {
                        entry = (DynamicObject)entryList.get(i);
                        DynamicObject address = entry.getDynamicObject("associatedaddress");
                        if (address == null || address.getDynamicObject("admindivisiondata") == null) continue;
                        entry.set("phonecode", (Object)BusinessDataServiceHelper.loadSingle((Object)address.getDynamicObject("admindivisiondata").getPkValue(), (String)"bd_admindivision", (String)"citynumber").getString("citynumber"));
                    }
                    this.getView().updateView("entry_linkman");
                }
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        DynamicObject currentDyn = e.getChangeSet()[0].getDataEntity();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if ("isdefault_linkman".equals(propName) || "isdefault_bank".equals(propName)) {
            MasterDataHelper.changeDefaultValue((IDataModel)this.getModel(), (IFormView)this.getView(), (DynamicObject)currentDyn, (String)propName);
        } else if ("internal_company".equals(propName)) {
            MasterDataHelper.changeInformationByInternalCompany((IDataModel)this.getModel());
        } else if ("associatedaddress".equals(propName)) {
            MasterDataHelper.changePhonecodeValue((IDataModel)this.getModel(), (IFormView)this.getView(), (DynamicObject)currentDyn);
        } else if ("taxregistplace".equals(propName)) {
            this.changeTaxRegistPlace(e);
        } else if ("taxcertificate".equals(propName)) {
            Date startDate = null;
            Date endDate = null;
            if (newValue instanceof DynamicObject) {
                DynamicObject taxcertificate = (DynamicObject)newValue;
                startDate = taxcertificate.getDate("startdate");
                endDate = taxcertificate.getDate("enddate");
            }
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            this.getModel().setValue("effectivedate", (Object)startDate, rowIndex);
            this.getModel().setValue("expirydate", (Object)endDate, rowIndex);
        }
    }

    private void changeTaxRegistPlace(PropertyChangedArgs e) {
        if (this.getModel().getDataEntity(true).getDynamicObjectCollection("entry_tax").isEmpty()) {
            return;
        }
        if (this.getPageCache().get(CANCEL_TAX_REGIST_PLACE_CHANGE) != null) {
            this.getPageCache().remove(CANCEL_TAX_REGIST_PLACE_CHANGE);
            return;
        }
        Object oldValue = e.getChangeSet()[0].getOldValue();
        if (!(oldValue instanceof DynamicObject)) {
            return;
        }
        DynamicObject taxRegistPlaceOldVal = (DynamicObject)oldValue;
        this.getView().showConfirm(ResManager.loadKDString((String)"\u4fee\u6539\u7a0e\u52a1\u6ce8\u518c\u5730\u5c06\u6e05\u7a7a\u73b0\u6709\u7a0e\u52a1\u8d44\u8d28\u6570\u636e\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"MasterDataBaseFormPlugin_2", (String)"bd-master-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, null, new ConfirmCallBackListener("taxregistplace", (IFormPlugin)this), null, taxRegistPlaceOldVal.getPkValue().toString());
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        MessageBoxResult result = e.getResult();
        if ("taxregistplace".equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                this.getModel().deleteEntryData("entry_tax");
            } else {
                this.getPageCache().put(CANCEL_TAX_REGIST_PLACE_CHANGE, "true");
                Long taxRegistPlaceOldVal = Long.parseLong(e.getCustomVaule());
                this.getModel().setValue("taxregistplace", (Object)taxRegistPlaceOldVal);
                this.getModel().setDataChanged(false);
            }
        } else if ("deleteentry_tax".equals(callBackId) && MessageBoxResult.Yes.equals((Object)result)) {
            this.getPageCache().put(CONFIRM_DELETEENTRY_TAX, "true");
            this.getView().invokeOperation("deleteentry_tax");
        }
    }

    private void addTabSelectListener(TabSelectListener form, String[] tabName) {
        Tab tab = null;
        int len = tabName.length;
        for (int i = 0; i < len; ++i) {
            tab = (Tab)this.getControl(tabName[i]);
            if (tab == null) continue;
            tab.addTabSelectListener(form);
        }
    }

    public void tabSelected(TabSelectEvent arg0) {
        String tabKey = arg0.getTabKey();
        if (TABPAGEAP_ADDRESS.equals(tabKey)) {
            AddressHelper.queryAddressData((IDataModel)this.getModel(), (String)this.getType());
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String fieldKey = arg0.getProperty().getName();
        if ("taxcertificate".equals(fieldKey)) {
            QFilter qf1;
            DynamicObject taxRegistPlace = this.getModel().getDataEntity().getDynamicObject("taxregistplace");
            ArrayList<QFilter> qfs = new ArrayList<QFilter>(10);
            if (taxRegistPlace == null) {
                qf1 = new QFilter("id", "=", (Object)0L);
                qfs.add(qf1);
            } else {
                qf1 = new QFilter("country", "=", taxRegistPlace.getPkValue());
                qfs.add(qf1);
            }
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            showParameter.getListFilterParameter().setQFilters(qfs);
        }
    }

    protected void addEntryGridFilter(String entityType, String property) {
        Control cv = this.getView().getControl(entityType);
        if (cv instanceof EntryGrid) {
            ArrayList<FilterValue> list = new ArrayList<FilterValue>();
            FilterValue filterValue = new FilterValue();
            filterValue.setValue((Object)"0");
            list.add(filterValue);
            SimpleFilterRow filterRow = new SimpleFilterRow("", "17", property, "", "and", list);
            ArrayList<SimpleFilterRow> filters = new ArrayList<SimpleFilterRow>();
            filters.add(filterRow);
            ((EntryGrid)cv).getGridDataByDefaultFilterRow(filters);
        }
        this.getView().updateView(entityType);
    }
}

