/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.bill;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bd.master.helper.TemplateMaterialHelper;
import kd.bd.master.util.FormShowParameterUtil;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public class MaterialReleaseBillPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String OP_COPYLINE = "copyline";
    private static final String ADVCONTOOLBARAP = "advcontoolbarap";
    private static final String TBMAIN = "tbmain";
    private static final String BTN_CONFIGPROPERTIES = "configproperties";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{ADVCONTOOLBARAP, TBMAIN});
        BasedataEdit orgEdit = (BasedataEdit)this.getControl("org");
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit templatematerial = (BasedataEdit)this.getControl("templatematerial");
        templatematerial.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        IPageCache parentPageCache;
        super.afterCreateNewData(e);
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView != null && (parentPageCache = (IPageCache)parentView.getService(IPageCache.class)).get("createOrg") != null) {
            String useOrg = parentPageCache.get("createOrg");
            this.getModel().setValue("createorg", (Object)useOrg);
        }
        this.getModel().setValue("filingdate", (Object)new Date());
        DynamicObjectCollection materialReleaseBillEntryList = (DynamicObjectCollection)this.getModel().getValue("billentry");
        int entrySize = materialReleaseBillEntryList.size();
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String userId = pageCache.get("proposer");
        if (!StringUtils.isEmpty((String)userId)) {
            this.getModel().setValue("proposer", (Object)userId);
        }
        for (int i = 0; i < entrySize; ++i) {
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"templatematerial"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = null;
        ChangeData cd = null;
        if ("baseunit".equals(propName) || "materialtype".equals(propName) || "group".equals(propName)) {
            DynamicObject tempMaterial = null;
            for (int i = 0; i < valueSet.length; ++i) {
                newValue = valueSet[i].getNewValue();
                int rowIndex = valueSet[i].getRowIndex();
                tempMaterial = TemplateMaterialHelper.getTemplateMaterial((IDataModel)this.getModel(), (IFormView)this.getView(), (Object)newValue, (int)rowIndex, (ChangeData)valueSet[i]);
                this.getModel().setValue("templatematerial", tempMaterial == null ? null : tempMaterial.getPkValue(), rowIndex);
            }
        } else if ("templatematerial".equals(propName)) {
            for (int i = 0; i < valueSet.length; ++i) {
                int rowIndex = valueSet[i].getRowIndex();
                this.getModel().setValue("istempmaterial", (Object)Boolean.TRUE, rowIndex);
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"templatematerial"});
            }
        } else if ("proposer".equals(propName)) {
            cd = valueSet[0];
            DynamicObject user = (DynamicObject)cd.getNewValue();
            if (user == null) {
                return;
            }
            DynamicObject userAll = BusinessDataServiceHelper.loadSingleFromCache((Object)user.getPkValue(), (String)user.getDynamicObjectType().getName());
            IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
            pageCache.put("proposer", userAll.getString("id"));
            DynamicObjectCollection entryentitys = userAll.getDynamicObjectCollection("entryentity");
            if (entryentitys != null && entryentitys.size() > 0) {
                DynamicObject dpt = null;
                for (DynamicObject en : entryentitys) {
                    dpt = en.getDynamicObject("dpt");
                    if (dpt == null) continue;
                    this.getModel().setValue("org", dpt.getPkValue());
                    break;
                }
            } else {
                this.getModel().setValue("org", null);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        EntryGrid grid = (EntryGrid)this.getView().getControl("billentry");
        int[] rows = grid.getEntryState().getSelectedRows();
        if (OP_COPYLINE.equals(key)) {
            if (rows.length != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"MaterialReleaseBillPlugin_0", (String)"bd-master-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection billentry = grid.getModel().getEntryEntity("billentry");
            if (billentry != null && billentry.size() > 0 && !((DynamicObject)billentry.get(rows[0])).getBoolean("istempmaterial")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u6a21\u7248\u7269\u6599\uff0c\u4e0d\u5141\u8bb8\u505a\u5173\u8054\u590d\u5236\u884c\u64cd\u4f5c\u3002", (String)"MaterialReleaseBillPlugin_1", (String)"bd-master-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter fsp = FormShowParameterUtil.getDynamicForm((String)"bd_insertentry", null, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "bd_insertentry"), (ShowType)ShowType.Floating, (String)"");
            this.getView().showForm(fsp);
        }
        if (BTN_CONFIGPROPERTIES.equals(key)) {
            this.configproperties();
        }
    }

    private void configproperties() {
        ListShowParameter lsp = FormShowParameterUtil.getListShowParameter((String)"bd_propertiesconfig", (String)"bos_list", (ShowType)ShowType.MainNewTabPage, (String)"_toolbar_");
        this.getView().showForm((FormShowParameter)lsp);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionKey = closedCallBackEvent.getActionId();
        Map dataMap = (Map)closedCallBackEvent.getReturnData();
        EntryGrid grid = (EntryGrid)this.getView().getControl("billentry");
        if (dataMap != null && dataMap.size() > 0 && dataMap.get("integerfield") != null && (Integer)dataMap.get("integerfield") > 0 && "bd_insertentry".equals(actionKey)) {
            int[] rows = grid.getEntryState().getSelectedRows();
            DynamicObjectCollection billentry = grid.getModel().getEntryEntity("billentry");
            DynamicObject billEntryObject = (DynamicObject)billentry.get(rows[0]);
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("applynumber", new Object[0]);
            vs.addField("materialname", new Object[0]);
            vs.addField("baseunit", new Object[0]);
            vs.addField("materialtype", new Object[0]);
            vs.addField("group", new Object[0]);
            vs.addField("templatematerial", new Object[0]);
            vs.addField("istempmaterial", new Object[0]);
            for (int i = (Integer)dataMap.get("integerfield") - 1; i >= 0; --i) {
                Object[] value = new Object[vs.getFields().size()];
                DynamicObject baseunit = billEntryObject.getDynamicObject("baseunit");
                value[2] = baseunit == null ? Integer.valueOf(0) : baseunit.getPkValue();
                value[3] = billEntryObject.get("materialtype");
                DynamicObject group = billEntryObject.getDynamicObject("group");
                value[4] = group == null ? Integer.valueOf(0) : group.getPkValue();
                DynamicObject templatematerial = billEntryObject.getDynamicObject("templatematerial");
                value[5] = templatematerial == null ? Integer.valueOf(0) : templatematerial.getPkValue();
                value[6] = Boolean.FALSE;
                vs.addRow(value);
            }
            model.batchCreateNewEntryRow("billentry", vs);
            model.endInit();
            this.getView().updateView("billentry");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String fieldKey = arg0.getProperty().getName();
        if ("org".equals(fieldKey)) {
            DynamicObject user = (DynamicObject)this.getModel().getValue("proposer");
            if (user == null) {
                return;
            }
            DynamicObject userAll = BusinessDataServiceHelper.loadSingleFromCache((Object)user.getPkValue(), (String)user.getDynamicObjectType().getName());
            DynamicObjectCollection entryentitys = userAll.getDynamicObjectCollection("entryentity");
            ArrayList<Long> ids = new ArrayList<Long>();
            if (entryentitys != null && entryentitys.size() > 0) {
                for (DynamicObject en : entryentitys) {
                    ids.add(en.getDynamicObject("dpt").getLong("id"));
                }
            } else {
                ids.add(0L);
            }
            QFilter qf1 = new QFilter("id", "in", ids);
            ArrayList<QFilter> qfs = new ArrayList<QFilter>();
            qfs.add(qf1);
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            showParameter.getListFilterParameter().setQFilters(qfs);
        } else if ("templatematerial".equals(fieldKey)) {
            String ctrlstrategy = (String)this.getModel().getValue("ctrlstrategy");
            QFilter qf1 = new QFilter("ctrlstrategy", "=", (Object)ctrlstrategy);
            QFilter qf2 = new QFilter("status", "=", (Object)"C");
            ArrayList<QFilter> qfs = new ArrayList<QFilter>();
            qfs.add(qf1);
            qfs.add(qf2);
            int rowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
            String materialType = (String)this.getModel().getValue("materialtype", rowIndex);
            DynamicObject baseunit = (DynamicObject)this.getModel().getValue("baseunit", rowIndex);
            if (!StringUtils.isEmpty((String)materialType)) {
                QFilter qf3 = new QFilter("materialtype", "=", (Object)materialType);
                qfs.add(qf3);
            }
            if (baseunit != null) {
                QFilter qf4 = new QFilter("baseunit", "=", baseunit.getPkValue());
                qfs.add(qf4);
            }
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            showParameter.getListFilterParameter().setQFilters(qfs);
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getModel().setValue("filingdate", (Object)new Date());
        DynamicObjectCollection entrys = this.getModel().getDataEntity().getDynamicObjectCollection("billentry");
        if (entrys != null && entrys.size() > 0) {
            DynamicObject temp = null;
            for (DynamicObject dyn : entrys) {
                temp = dyn.getDynamicObject("templatematerial");
                if (temp != null && !"C".equals(temp.getString("status"))) {
                    dyn.set("templatematerial", null);
                }
                dyn.set("modelnum", null);
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        RowDataEntity[] rows;
        super.afterAddRow(e);
        for (RowDataEntity row : rows = e.getRowDataEntities()) {
            if (row.getDataEntity().getDynamicObject("baseunit") != null && row.getDataEntity().getDynamicObject("group") != null && !StringUtils.isEmpty((String)row.getDataEntity().getString("materialtype"))) continue;
            this.getView().setEnable(Boolean.FALSE, row.getRowIndex(), new String[]{"templatematerial"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate oper = (FormOperate)args.getSource();
        if (("save".equals(oper.getOperateKey()) || "submit".equals(oper.getOperateKey())) && (BaseDataCommonService.isNewModel((String)"bd_material") || BaseDataCommonService.isNewModel((String)"bd_materialsalinfo") || BaseDataCommonService.isNewModel((String)"bd_materialinventoryinfo") || BaseDataCommonService.isNewModel((String)"bd_materialpurchaseinfo") || BaseDataCommonService.isNewModel((String)"bd_materialmftinfo") || BaseDataCommonService.isNewModel((String)"bd_inspect_cfg") || BaseDataCommonService.isNewModel((String)"bd_materialcalinfo") || BaseDataCommonService.isNewModel((String)"mpdm_materialplan"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7269\u6599\u6279\u91cf\u590d\u5236\u5355\u6682\u4e0d\u652f\u6301\u65b0\u7ba1\u63a7\u7b56\u7565\u6a21\u578b\u3002", (String)"MaterialReleaseBillPlugin_2", (String)"bd-master-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }
}

