/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.opplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bd.sbd.enums.EnableStatusEnum;
import kd.bd.sbd.enums.StatusEnum;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class AuxPtyValueDataImportOp
extends BatchImportPlugin {
    private static final Log log = LogFactory.getLog(AuxPtyValueDataImportOp.class);

    protected boolean isForceBatch() {
        return super.isForceBatch();
    }

    protected int getBatchImportSize() {
        return 1000;
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        try (TraceSpan span = Tracer.create((String)"AuxPtyValueDataImportOp", (String)"beforeImportBill");){
            if (rowdatas.isEmpty()) {
                ApiResult apiResult = null;
                return apiResult;
            }
            this.beforeImportBill(rowdatas, logger);
        }
        return super.save(rowdatas, logger);
    }

    private void beforeImportBill(List<ImportBillData> rowDatas, ImportLogger logger) {
        ArrayList<String> materialNumberList = new ArrayList<String>(rowDatas.size());
        ArrayList<String> auxptyNumberList = new ArrayList<String>(rowDatas.size());
        JSONObject jsonData = null;
        for (ImportBillData rowData : rowDatas) {
            jsonData = rowData == null ? new JSONObject() : rowData.getData();
            JSONObject material = jsonData.getJSONObject("material");
            JSONObject auxpty = jsonData.getJSONObject("auxpty");
            String materialNumber = material == null ? "" : material.getString("number");
            String auxptyNumber = auxpty == null ? "" : auxpty.getString("number");
            materialNumberList.add(materialNumber);
            auxptyNumberList.add(auxptyNumber);
        }
        QFilter[] materialFilter = new QFilter[]{new QFilter("number", "in", materialNumberList)};
        Map materialMap = BusinessDataServiceHelper.loadFromCache((String)"bd_material", (String)"number,status,enable,isuseauxpty", (QFilter[])materialFilter);
        QFilter[] auxptyFilter = new QFilter[]{new QFilter("number", "in", auxptyNumberList), new QFilter("flexid.formid", "=", (Object)"bd_flexauxprop")};
        Map auxptyMap = BusinessDataServiceHelper.loadFromCache((String)"bd_auxproperty", (String)"number,status,enable", (QFilter[])auxptyFilter);
        HashMap<String, Object> materialNumberMap = new HashMap<String, Object>(materialMap.size());
        for (Object material : materialMap.values()) {
            String materialNumber = material.getString("number");
            materialNumberMap.put(materialNumber, material);
        }
        HashMap<String, DynamicObject> auxptyNumberMap = new HashMap<String, DynamicObject>(auxptyMap.size());
        for (DynamicObject auxpty : auxptyMap.values()) {
            String auxptyNumber = auxpty.getString("number");
            auxptyNumberMap.put(auxptyNumber, auxpty);
        }
        HashMap<Integer, String> errMsgLog = new HashMap<Integer, String>(rowDatas.size());
        Iterator<ImportBillData> rowDataIterator = rowDatas.iterator();
        StringBuilder errMsgBuilder = null;
        while (rowDataIterator.hasNext()) {
            ImportBillData billData = rowDataIterator.next();
            if (billData == null) continue;
            jsonData = billData.getData();
            JSONObject importMaterial = jsonData.getJSONObject("material");
            JSONObject importAuxpty = jsonData.getJSONObject("auxpty");
            String materialNumber = importMaterial == null ? "" : importMaterial.getString("number");
            String auxptyNumber = importAuxpty == null ? "" : importAuxpty.getString("number");
            DynamicObject material = (DynamicObject)materialNumberMap.get(materialNumber);
            DynamicObject auxpty = (DynamicObject)auxptyNumberMap.get(auxptyNumber);
            int errMsgRowIndex = billData.getStartIndex();
            errMsgBuilder = new StringBuilder();
            if (material == null) {
                errMsgBuilder.append(ResManager.loadKDString((String)"\u5f15\u7528\u7684\u7269\u6599\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"AuxPtyValueDataImportOp_0", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
            }
            if (material != null && !StatusEnum.AUDIT.getValue().equals(material.getString("status"))) {
                errMsgBuilder.append(ResManager.loadKDString((String)"\u5f15\u7528\u7684\u7269\u6599\u6570\u636e\uff0c\u6570\u636e\u72b6\u6001\u5fc5\u987b\u662f\u5df2\u5ba1\u6838\u3002", (String)"AuxPtyValueDataImportOp_1", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
            }
            if (material != null && EnableStatusEnum.DISABLE.getValue().equals(material.getString("enable"))) {
                errMsgBuilder.append(ResManager.loadKDString((String)"\u5f15\u7528\u7684\u7269\u6599\u6570\u636e\uff0c\u4f7f\u7528\u72b6\u6001\u5fc5\u987b\u662f\u542f\u7528\u3002", (String)"AuxPtyValueDataImportOp_2", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
            }
            if (material != null && !material.getBoolean("isuseauxpty")) {
                errMsgBuilder.append(ResManager.loadKDString((String)"\u5f15\u7528\u7684\u7269\u6599\u6570\u636e\uff0c\u5fc5\u987b\u542f\u7528\u8f85\u52a9\u5c5e\u6027\u3002", (String)"AuxPtyValueDataImportOp_3", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
            }
            if (auxpty == null) {
                errMsgBuilder.append(ResManager.loadKDString((String)"\u5f15\u7528\u7684\u8f85\u52a9\u5c5e\u6027\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"AuxPtyValueDataImportOp_4", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
            }
            if (auxpty != null && !StatusEnum.AUDIT.getValue().equals(auxpty.getString("status"))) {
                errMsgBuilder.append(ResManager.loadKDString((String)"\u5f15\u7528\u7684\u8f85\u52a9\u5c5e\u6027\u6570\u636e\uff0c\u6570\u636e\u72b6\u6001\u5fc5\u987b\u662f\u5df2\u5ba1\u6838\u3002", (String)"AuxPtyValueDataImportOp_5", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
            }
            if (auxpty != null && EnableStatusEnum.DISABLE.getValue().equals(auxpty.getString("enable"))) {
                errMsgBuilder.append(ResManager.loadKDString((String)"\u5f15\u7528\u7684\u8f85\u52a9\u5c5e\u6027\u6570\u636e\uff0c\u4f7f\u7528\u72b6\u6001\u5fc5\u987b\u662f\u542f\u7528\u3002", (String)"AuxPtyValueDataImportOp_6", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
            }
            if (errMsgBuilder.length() <= 0) continue;
            errMsgLog.put(errMsgRowIndex, errMsgBuilder.toString());
            logger.log(Integer.valueOf(errMsgRowIndex), errMsgBuilder.toString()).fail();
            rowDataIterator.remove();
        }
        log.info("Failed to import row info: " + errMsgLog);
    }
}

