/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.validator;

import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class MaterialInspectValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity entity : this.getDataEntities()) {
            DynamicObject material = entity.getDataEntity().getDynamicObject("masterid");
            if (null != material && "3".equals(material.get("configproperties"))) {
                ResManager.loadKDString((String)"\u914d\u7f6e\u5c5e\u6027\u4e3a\u7279\u5f81\u4ef6\u7684\u7269\u6599\u4e0d\u53ef\u8d28\u68c0\u3002", (String)"MaterialInspectValidator_1", (String)"bd-sbd-opplugin", (Object[])new Object[0]);
            }
            this.qcpCheck(entity);
        }
    }

    private void qcpCheck(ExtendedDataEntity entity) {
        DynamicObjectCollection entryQcp = entity.getDataEntity().getDynamicObjectCollection("entryqcp");
        List<Object> produceList = entryQcp.stream().filter(x -> null != x.get("supplier")).map(x -> ((DynamicObject)x.get("supplier")).getPkValue()).collect(Collectors.toList());
        this.checkSingleList(entity, produceList, ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u7684\u4f9b\u5e94\u5546\u3002", (String)"MaterialInspectValidator_0", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
    }

    private void checkSingleList(ExtendedDataEntity entity, List<Object> checkList, String msg) {
        HashSet<Object> hashSet = new HashSet<Object>(checkList);
        if (checkList.size() != hashSet.size()) {
            this.addErrMsg(entity, msg);
        }
    }

    private void addErrMsg(ExtendedDataEntity entity, String msg) {
        this.addErrorMessage(entity, ResManager.loadKDString((String)msg, (String)"MaterialInspectValidator_0", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
    }
}

