/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.business.helper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bd.sbd.business.custom.ext.BatchUpdExtCheckingImpl;
import kd.bd.sbd.business.custom.ext.IBatchUpdExtChecking;
import kd.bd.sbd.business.util.FormShowParameterUtil;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.property.TextProp;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.operate.MutexHelper;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.AssistantDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.JSONUtils;

public class BatchUpdFieldHelper {
    private static final Log log = LogFactory.getLog(BatchUpdFieldHelper.class);
    public static final String KEY_MTPURINFO_COMBO_FIELD = "mtpurinfocombofield";
    public static final String KEY_MTSALEINFO_COMBO_FIELD = "mtsaleinfocombofield";
    public static final String KEY_UPDATE_VALUE_F7 = "updatevaluef7";
    private static final String KEY_UPDATE_VALUE_COMBO = "updatevaluecombo";
    private static final String KEY_UPDATE_VALUE_MULCOMBO = "updatevaluemulcombo";
    private static final String KEY_UPDATE_VALUE_CHECKBOX = "updatevaluecheckbox";
    private static final String KEY_UPDATE_VALUE_QTY = "updatevalueqty";
    private static final String KEY_UPDATE_VALUE_TEXT = "updatevaluetext";
    private static final String KEY_ITEM_CLASS_TYPE_FIELD = "itemclasstypefield";
    private static final String MEASUREUNIT = "measureunit";
    private static final String KEY_PURINFO_CTRLDAY_PANEL = "purinfoctrldaypanel";
    private static final String KEY_PURINFO_ISCONTROLDAY = "iscontrolday";
    private static final String KEY_PURINFO_CTRLQTY_PANEL = "purinfoctrlqtypanel";
    private static final String KEY_PURINFO_ISCONTROLQTY = "iscontrolqty";
    private static final String KEY_SALEINFO_CTRLDAY_PANEL = "saleinfoctrldaypanel";
    private static final String KEY_SALEINFO_ISCONTROLDAY = "iscontrolday2";
    private static final String KEY_SALEINFO_CTRLQTY_PANEL = "saleinfoctrlqtypanel";
    private static final String KEY_SALEINFO_ISCONTROLQTY = "iscontrolqty2";
    private static final String KEY_MODIFY_TIME = "modifytime";
    private static final String KEY_MODIFIER = "modifier";
    private static final String KEY_ENTITYNUMBER_PARAM = "entityNumber";
    private static final String KEY_DATAIDS_PARAM = "dataIds";
    private static final String KEY_ID_NUMBER_MAP = "idNumberMap";
    public static final String KEY_OK_BTN = "btnok";
    private static final String KEY_BOS_OPERATIONRESULT = "bos_operationresult";
    private static final String LINE_BREAK = "\r\n";
    private static final Set<String> PURINFO_FORBIDDEN_UPD_FIELDS = Stream.of("number", "name", "status", "creator", "modifier", "enable", "createtime", "modifytime", "masterid", "group", "org", "createorg", "useorg", "ctrlstrategy", "sourcedata", "bitindex", "srcindex", "disabler", "disabledate", "auditor", "audittime", "purchaseunit", "purchasepriceunit", "isreturn", "receiverateup", "receiveratedown", "receivedayup", "receivedaydown", "material", "showcreateorg", "isautonew", "mbdmasterid").collect(Collectors.toCollection(HashSet::new));
    private static final Set<String> SALEINFO_FORBIDDEN_UPD_FIELDS = Stream.of("number", "name", "status", "creator", "modifier", "enable", "createtime", "modifytime", "masterid", "group", "org", "createorg", "useorg", "ctrlstrategy", "sourcedata", "bitindex", "srcindex", "disabler", "disabledate", "salesunit", "salesvalunit", "isatpcheck", "isreturn", "ispartialreturn", "deliveradvdays", "deliverdelaydays", "dlivrateceiling", "dlivratefloor", "controlunit", "audittime", "auditor", "qcorg", "isqcbfdeliver", "isreturnneedntqc", "isstockinbaseqc", "iswarranty", "warrantyperiod", "warrantyunit", "material", "showcreateorg", "isautonew", "mbdmasterid").collect(Collectors.toCollection(HashSet::new));

    public static void showBatchUpdForm(IFormView view, IPageCache pageCache, String entityNumber, ListSelectedRowCollection selectedRows) {
        if (!BatchUpdFieldHelper.selectedRecordChecking(view, pageCache, entityNumber, selectedRows)) {
            return;
        }
        Map<String, Object> params = BatchUpdFieldHelper.prepareFormParams(entityNumber, selectedRows);
        view.showForm(FormShowParameterUtil.getDynamicForm("sbd_batchupdfield", params, null, ShowType.Modal, ResManager.loadKDString((String)"\u6279\u91cf\u4fee\u6539", (String)"BatchUpdFieldHelper_0", (String)"bd-sbd-business", (Object[])new Object[0])));
    }

    private static boolean selectedRecordChecking(IFormView view, IPageCache pageCache, String entityNumber, ListSelectedRowCollection selectedRows) {
        String bizOrg = pageCache.get("createOrg");
        String appNumber = view.getFormShowParameter().getAppId();
        StringBuilder invalidTipsBuilder = new StringBuilder();
        boolean checkPermission = true;
        if (selectedRows.isEmpty()) {
            return false;
        }
        if (PermissionServiceHelper.checkPermission((long)RequestContext.get().getCurrUserId(), (String)"DIM_ORG", (long)Long.parseLong(bizOrg), (String)appNumber, (String)entityNumber, (String)"4715a0df000000ac") == 0) {
            checkPermission = false;
        }
        int invalidTipsCount = 0;
        for (ListSelectedRow selectedRow : selectedRows) {
            if (selectedRow.getMainOrgId() != Long.parseLong(bizOrg)) {
                invalidTipsBuilder.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u8be5\u57fa\u7840\u6570\u636e\u7684\u521b\u5efa\u7ec4\u7ec7\u4e0e\u5f53\u524d\u4e1a\u52a1\u7ec4\u7ec7\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u6279\u91cf\u4fee\u6539\u3002", (String)"BatchUpdFieldHelper_1", (String)"bd-sbd-business", (Object[])new Object[0]), selectedRow.getNumber())).append(LINE_BREAK);
                ++invalidTipsCount;
                continue;
            }
            if (checkPermission) continue;
            invalidTipsBuilder.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u8be5\u7528\u6237\u5728\u5f53\u524d\u4e1a\u52a1\u7ec4\u7ec7\u4e0b\u6ca1\u6709\u4fee\u6539\u6743\u9650\u3002", (String)"BatchUpdFieldHelper_5", (String)"bd-sbd-business", (Object[])new Object[0]), selectedRow.getNumber())).append(LINE_BREAK);
            ++invalidTipsCount;
        }
        if (invalidTipsCount == 1) {
            view.showTipNotification(invalidTipsBuilder.toString().replace(LINE_BREAK, ""));
            return false;
        }
        if (invalidTipsCount > 1) {
            HashMap<String, Object> params = new HashMap<String, Object>(2);
            params.put("errorMsg", invalidTipsBuilder);
            view.showForm(FormShowParameterUtil.getOperResultForm(KEY_BOS_OPERATIONRESULT, params, null, ShowType.Modal));
            return false;
        }
        return true;
    }

    private static Map<String, Object> prepareFormParams(String entityNumber, ListSelectedRowCollection selectedRows) {
        ArrayList<Long> dataIds = new ArrayList<Long>(selectedRows.size());
        HashMap<Long, String> idNumberMap = new HashMap<Long, String>(selectedRows.size());
        for (ListSelectedRow row : selectedRows) {
            Long id = (Long)row.getPrimaryKeyValue();
            dataIds.add(id);
            idNumberMap.put(id, row.getNumber());
        }
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put(KEY_ENTITYNUMBER_PARAM, entityNumber);
        params.put(KEY_DATAIDS_PARAM, dataIds);
        params.put(KEY_ID_NUMBER_MAP, idNumberMap);
        return params;
    }

    public static void setUpdFieldVisibility(IFormView view) {
        Map formShowParams = view.getFormShowParameter().getCustomParams();
        String entityNumber = (String)formShowParams.get(KEY_ENTITYNUMBER_PARAM);
        if ("bd_materialpurchaseinfo".equals(entityNumber)) {
            view.setVisible(Boolean.TRUE, new String[]{KEY_MTPURINFO_COMBO_FIELD});
            view.setVisible(Boolean.FALSE, new String[]{KEY_MTSALEINFO_COMBO_FIELD});
        } else if ("bd_materialsalinfo".equals(entityNumber)) {
            view.setVisible(Boolean.TRUE, new String[]{KEY_MTSALEINFO_COMBO_FIELD});
            view.setVisible(Boolean.FALSE, new String[]{KEY_MTPURINFO_COMBO_FIELD});
        } else {
            log.info("unsupport entityNumber:" + entityNumber);
            view.setVisible(Boolean.FALSE, new String[]{KEY_MTPURINFO_COMBO_FIELD});
            view.setVisible(Boolean.FALSE, new String[]{KEY_MTSALEINFO_COMBO_FIELD});
        }
    }

    public static void setUpdValVisibility(IFormView view) {
        IDataEntityProperty property = BatchUpdFieldHelper.getSuperFormFieldProp(view);
        if (property == null) {
            return;
        }
        Map formShowParams = view.getFormShowParameter().getCustomParams();
        String entityNumber = (String)formShowParams.get(KEY_ENTITYNUMBER_PARAM);
        BatchUpdFieldHelper.hideAllUpdValControl(view);
        if (property instanceof MulComboProp) {
            view.setVisible(Boolean.TRUE, new String[]{KEY_UPDATE_VALUE_MULCOMBO});
        } else if (property instanceof ComboProp) {
            view.setVisible(Boolean.TRUE, new String[]{KEY_UPDATE_VALUE_COMBO});
        } else if (property instanceof BasedataProp) {
            view.setVisible(Boolean.TRUE, new String[]{KEY_UPDATE_VALUE_F7});
        } else if (property instanceof BooleanProp) {
            if ("bd_materialpurchaseinfo".equals(entityNumber) && KEY_PURINFO_ISCONTROLDAY.equals(property.getName())) {
                view.setVisible(Boolean.TRUE, new String[]{KEY_PURINFO_CTRLDAY_PANEL});
            } else if ("bd_materialpurchaseinfo".equals(entityNumber) && KEY_PURINFO_ISCONTROLQTY.equals(property.getName())) {
                view.setVisible(Boolean.TRUE, new String[]{KEY_PURINFO_CTRLQTY_PANEL});
            } else if ("bd_materialsalinfo".equals(entityNumber) && KEY_PURINFO_ISCONTROLDAY.equals(property.getName())) {
                view.setVisible(Boolean.TRUE, new String[]{KEY_SALEINFO_CTRLDAY_PANEL});
            } else if ("bd_materialsalinfo".equals(entityNumber) && KEY_PURINFO_ISCONTROLQTY.equals(property.getName())) {
                view.setVisible(Boolean.TRUE, new String[]{KEY_SALEINFO_CTRLQTY_PANEL});
            } else {
                view.setVisible(Boolean.TRUE, new String[]{KEY_UPDATE_VALUE_CHECKBOX});
            }
        } else if (property instanceof QtyProp) {
            view.setVisible(Boolean.TRUE, new String[]{KEY_UPDATE_VALUE_QTY});
        } else if (property instanceof TextProp) {
            view.setVisible(Boolean.TRUE, new String[]{KEY_UPDATE_VALUE_TEXT});
        } else {
            view.showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u5b57\u6bb5\u7c7b\u578b\u3002", (String)"BatchUpdFieldHelper_9", (String)"bd-sbd-business", (Object[])new Object[0]));
        }
    }

    private static void hideAllUpdValControl(IFormView view) {
        view.setVisible(Boolean.FALSE, new String[]{KEY_UPDATE_VALUE_F7});
        view.setVisible(Boolean.FALSE, new String[]{KEY_UPDATE_VALUE_COMBO});
        view.setVisible(Boolean.FALSE, new String[]{KEY_UPDATE_VALUE_MULCOMBO});
        view.setVisible(Boolean.FALSE, new String[]{KEY_UPDATE_VALUE_CHECKBOX});
        view.setVisible(Boolean.FALSE, new String[]{KEY_UPDATE_VALUE_QTY});
        view.setVisible(Boolean.FALSE, new String[]{KEY_UPDATE_VALUE_TEXT});
        view.setVisible(Boolean.FALSE, new String[]{KEY_PURINFO_CTRLDAY_PANEL});
        view.setVisible(Boolean.FALSE, new String[]{KEY_PURINFO_CTRLQTY_PANEL});
        view.setVisible(Boolean.FALSE, new String[]{KEY_SALEINFO_CTRLDAY_PANEL});
        view.setVisible(Boolean.FALSE, new String[]{KEY_SALEINFO_CTRLQTY_PANEL});
    }

    public static void setUpdValOptions(IFormView view, IDataModel dataModal) {
        IDataEntityProperty superFormFieldProp = BatchUpdFieldHelper.getSuperFormFieldProp(view);
        if (superFormFieldProp instanceof MulComboProp) {
            dataModal.setValue(KEY_UPDATE_VALUE_MULCOMBO, (Object)"");
            MulComboProp comboProp = (MulComboProp)superFormFieldProp;
            List srcComboItems = comboProp.getComboItems();
            ArrayList<ComboItem> targComboItems = new ArrayList<ComboItem>(srcComboItems.size());
            ComboEdit targCombo = (ComboEdit)view.getControl(KEY_UPDATE_VALUE_MULCOMBO);
            ComboItem item = null;
            for (ValueMapItem srcComboItem : srcComboItems) {
                item = new ComboItem();
                item.setValue(srcComboItem.getValue());
                item.setCaption(srcComboItem.getName());
                targComboItems.add(item);
            }
            targCombo.setComboItems(targComboItems);
        } else if (superFormFieldProp instanceof ComboProp) {
            dataModal.setValue(KEY_UPDATE_VALUE_COMBO, (Object)"");
            ComboProp comboProp = (ComboProp)superFormFieldProp;
            List srcComboItems = comboProp.getComboItems();
            ArrayList<ComboItem> targComboItems = new ArrayList<ComboItem>(srcComboItems.size());
            ComboEdit targCombo = (ComboEdit)view.getControl(KEY_UPDATE_VALUE_COMBO);
            ComboItem item = null;
            for (ValueMapItem srcComboItem : srcComboItems) {
                item = new ComboItem();
                item.setValue(srcComboItem.getValue());
                item.setCaption(srcComboItem.getName());
                targComboItems.add(item);
            }
            targCombo.setComboItems(targComboItems);
        } else if (superFormFieldProp instanceof BasedataProp) {
            dataModal.setValue(KEY_UPDATE_VALUE_F7, (Object)"");
            BasedataProp basedataProp = (BasedataProp)superFormFieldProp;
            String baseDataId = basedataProp.getBaseEntityId();
            dataModal.setValue(KEY_ITEM_CLASS_TYPE_FIELD, (Object)baseDataId);
        } else if (superFormFieldProp instanceof QtyProp) {
            Map formShowParams = view.getFormShowParameter().getCustomParams();
            String entityNumber = (String)formShowParams.get(KEY_ENTITYNUMBER_PARAM);
            List dataIds = (List)formShowParams.get(KEY_DATAIDS_PARAM);
            QtyProp qtyProp = (QtyProp)superFormFieldProp;
            String measureUnitKey = qtyProp.getRelatedUnit();
            Long minPrecisionSalesUnitId = BatchUpdFieldHelper.queryMinPrecisionUnitId(entityNumber, dataIds, measureUnitKey);
            dataModal.setValue(MEASUREUNIT, (Object)minPrecisionSalesUnitId);
        }
    }

    private static Long queryMinPrecisionUnitId(String entityNumber, List<Long> dataIds, String measureUnitKey) {
        try (TraceSpan span = Tracer.create((String)"sbd BatchUpdFieldHelper", (String)"queryMinPrecisionUnitId");){
            Long result = 0L;
            Map dataInfoMap = BusinessDataServiceHelper.loadFromCache((Object[])dataIds.toArray(), (String)entityNumber);
            List unitNotNullList = dataInfoMap.values().stream().filter(p -> p.getDynamicObject(measureUnitKey) != null).collect(Collectors.toList());
            Optional<DynamicObject> minPrecisionUnit = unitNotNullList.stream().map(s -> s.getDynamicObject(measureUnitKey)).min(Comparator.comparingInt(p -> p.getInt("precision")));
            if (minPrecisionUnit.isPresent()) {
                result = minPrecisionUnit.get().getLong("id");
            } else {
                log.info("sbd BatchUpdFieldHelper.queryMinPrecisionUnitId: minPrecisionUnit is empty");
            }
            Long l = result;
            return l;
        }
    }

    public static void setUpdValProp(IFormView view, IDataModel dataModal) {
        IDataEntityProperty superFormFieldProp = BatchUpdFieldHelper.getSuperFormFieldProp(view);
        if (superFormFieldProp instanceof BasedataProp) {
            BasedataProp basedataProp = (BasedataProp)superFormFieldProp;
            HashMap prop = new HashMap(2);
            HashMap<String, String> editor = new HashMap<String, String>(2);
            editor.put("dsp", basedataProp.getDisplayProp());
            prop.put("item", editor);
            view.updateControlMetadata(KEY_UPDATE_VALUE_F7, prop);
        }
    }

    private static IDataEntityProperty getSuperFormFieldProp(IFormView view) {
        Map formShowParams = view.getFormShowParameter().getCustomParams();
        String entityNumber = (String)formShowParams.get(KEY_ENTITYNUMBER_PARAM);
        String updField = (String)view.getModel().getValue(BatchUpdFieldHelper.getUpdFieldNumber(entityNumber));
        MainEntityType superEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        return superEntityType.findProperty(updField);
    }

    private static String getUpdFieldNumber(String entityNumber) {
        String result = "";
        switch (StringUtils.trimToEmpty((String)entityNumber)) {
            case "bd_materialpurchaseinfo": {
                result = KEY_MTPURINFO_COMBO_FIELD;
                break;
            }
            case "bd_materialsalinfo": {
                result = KEY_MTSALEINFO_COMBO_FIELD;
                break;
            }
        }
        return result;
    }

    public static void batchUpdate(IFormView view, IDataModel dataModal) {
        Map formShowParams = view.getFormShowParameter().getCustomParams();
        String entityNumber = (String)formShowParams.get(KEY_ENTITYNUMBER_PARAM);
        List dataIds = (List)formShowParams.get(KEY_DATAIDS_PARAM);
        Map idNumberMap = (Map)formShowParams.get(KEY_ID_NUMBER_MAP);
        String updField = (String)dataModal.getValue(BatchUpdFieldHelper.getUpdFieldNumber(entityNumber));
        HashMap<String, Object> updFieldValMap = new HashMap<String, Object>(16);
        IDataEntityProperty property = BatchUpdFieldHelper.getSuperFormFieldProp(view);
        if (property instanceof MulComboProp) {
            updFieldValMap.put(updField, dataModal.getValue(KEY_UPDATE_VALUE_MULCOMBO));
        } else if (property instanceof ComboProp) {
            updFieldValMap.put(updField, dataModal.getValue(KEY_UPDATE_VALUE_COMBO));
        } else if (property instanceof BasedataProp) {
            Object updValF7 = dataModal.getValue(KEY_UPDATE_VALUE_F7);
            Object updVal = updValF7 instanceof DynamicObject ? ((DynamicObject)updValF7).getPkValue() : Integer.valueOf(0);
            updFieldValMap.put(updField, updVal);
        } else if (property instanceof BooleanProp) {
            if ("bd_materialpurchaseinfo".equals(entityNumber) && KEY_PURINFO_ISCONTROLDAY.equals(property.getName())) {
                updFieldValMap.put(KEY_PURINFO_ISCONTROLDAY, dataModal.getValue(KEY_PURINFO_ISCONTROLDAY));
                updFieldValMap.put("receivedayup", dataModal.getValue("receivedayup"));
                updFieldValMap.put("receivedaydown", dataModal.getValue("receivedaydown"));
            } else if ("bd_materialpurchaseinfo".equals(entityNumber) && KEY_PURINFO_ISCONTROLQTY.equals(property.getName())) {
                updFieldValMap.put(KEY_PURINFO_ISCONTROLQTY, dataModal.getValue(KEY_PURINFO_ISCONTROLQTY));
                updFieldValMap.put("receiverateup", dataModal.getValue("receiverateup"));
                updFieldValMap.put("receiveratedown", dataModal.getValue("receiveratedown"));
            } else if ("bd_materialsalinfo".equals(entityNumber) && KEY_PURINFO_ISCONTROLDAY.equals(property.getName())) {
                updFieldValMap.put(KEY_PURINFO_ISCONTROLDAY, dataModal.getValue(KEY_SALEINFO_ISCONTROLDAY));
                updFieldValMap.put("deliveradvdays", dataModal.getValue("deliveradvdays"));
                updFieldValMap.put("deliverdelaydays", dataModal.getValue("deliverdelaydays"));
            } else if ("bd_materialsalinfo".equals(entityNumber) && KEY_PURINFO_ISCONTROLQTY.equals(property.getName())) {
                updFieldValMap.put(KEY_PURINFO_ISCONTROLQTY, dataModal.getValue(KEY_SALEINFO_ISCONTROLQTY));
                updFieldValMap.put("dlivrateceiling", dataModal.getValue("dlivrateceiling"));
                updFieldValMap.put("dlivratefloor", dataModal.getValue("dlivratefloor"));
            } else {
                updFieldValMap.put(updField, dataModal.getValue(KEY_UPDATE_VALUE_CHECKBOX));
            }
        } else if (property instanceof QtyProp) {
            updFieldValMap.put(updField, dataModal.getValue(KEY_UPDATE_VALUE_QTY));
        } else if (property instanceof TextProp) {
            updFieldValMap.put(updField, dataModal.getValue(KEY_UPDATE_VALUE_TEXT));
        }
        if (!BatchUpdFieldHelper.updFieldChecking(view, entityNumber, updField)) {
            return;
        }
        StringBuilder errMsgBuilder = new StringBuilder();
        try (TraceSpan span = Tracer.create((String)"BatchUpdFieldHelper", (String)"networkMutexChecking");){
            StringBuilder checkingResult = BatchUpdFieldHelper.networkMutexChecking(view, entityNumber, dataIds);
            errMsgBuilder.append((CharSequence)checkingResult);
        }
        BatchUpdExtCheckingImpl extCheckingImpl = new BatchUpdExtCheckingImpl();
        PluginProxy pluginProxy = PluginProxy.create((Object)extCheckingImpl, IBatchUpdExtChecking.class, (String)"SYS_SBD_BATCHUPDATE_UPDATE", null);
        List extCheckingResultList = pluginProxy.callReplace(p -> p.doExtChecking(entityNumber, idNumberMap, dataIds, updField, updFieldValMap.get(updField)));
        extCheckingResultList.stream().forEach(errMsgBuilder::append);
        DynamicObject[] updEntityArr = new DynamicObject[]{};
        if (!dataIds.isEmpty()) {
            try (TraceSpan span = Tracer.create((String)"BatchUpdFieldHelper", (String)"BusinessDataServiceHelper.load");){
                updEntityArr = BusinessDataServiceHelper.load((Object[])dataIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityNumber));
            }
        }
        List<Map<String, Object>> beforeUpdateBillInfos = BatchUpdFieldHelper.getBeforeUpdateBillInfos(updEntityArr, updFieldValMap);
        OperationResult updResult = new OperationResult();
        try (TraceSpan span = Tracer.create((String)"BatchUpdFieldHelper", (String)"doUpdate");){
            log.info("BatchUpdFieldHelper.batchUpdate,record num: " + dataIds.size());
            updResult = BatchUpdFieldHelper.doUpdate(entityNumber, updEntityArr, updFieldValMap);
            if (!updResult.isSuccess()) {
                errMsgBuilder.append(BatchUpdFieldHelper.getOperateErrMsg(updResult));
            }
        }
        catch (Exception e) {
            log.error("BatchUpdFieldHelper.batchUpdate exception", (Throwable)e);
            errMsgBuilder.append(ResManager.loadKDString((String)"\u4fee\u6539\u5931\u8d25\uff1a", (String)"BatchUpdFieldHelper_4", (String)"bd-sbd-business", (Object[])new Object[0])).append(e.getLocalizedMessage()).append(LINE_BREAK);
        }
        int totalRecordsCount = ((Map)formShowParams.get(KEY_ID_NUMBER_MAP)).size();
        List successPkIdList = updResult.getSuccessPkIds();
        HashSet successPkIdSet = new HashSet(successPkIdList.size());
        for (Object successPkId : successPkIdList) {
            successPkIdSet.add(successPkId);
        }
        int successRecordsCount = successPkIdSet.size();
        String batchUpdResult = BatchUpdFieldHelper.batchUpdResultTips(view, errMsgBuilder, totalRecordsCount, successRecordsCount);
        try (TraceSpan span = Tracer.create((String)"BatchUpdFieldHelper", (String)"saveOperLog");){
            BatchUpdFieldHelper.saveOperLog(entityNumber, batchUpdResult, beforeUpdateBillInfos, updFieldValMap);
        }
    }

    private static boolean updFieldChecking(IFormView view, String entityNumber, String updField) {
        Set<String> forbiddenUpdFields;
        if (StringUtils.isBlank((CharSequence)updField)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6279\u6539\u5b57\u6bb5", (String)"BatchUpdFieldHelper_3", (String)"bd-sbd-business", (Object[])new Object[0]));
            return false;
        }
        boolean isValidFieldType = false;
        IDataEntityProperty property = BatchUpdFieldHelper.getSuperFormFieldProp(view);
        if (property instanceof MulComboProp || property instanceof ComboProp || property instanceof AssistantProp || property instanceof BasedataProp || property instanceof BooleanProp || property instanceof QtyProp || property instanceof TextProp) {
            isValidFieldType = true;
        }
        if (!isValidFieldType) {
            view.showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u5b57\u6bb5\u7c7b\u578b\u3002", (String)"BatchUpdFieldHelper_9", (String)"bd-sbd-business", (Object[])new Object[0]));
            return false;
        }
        Set<String> set = forbiddenUpdFields = "bd_materialpurchaseinfo".equals(entityNumber) ? PURINFO_FORBIDDEN_UPD_FIELDS : SALEINFO_FORBIDDEN_UPD_FIELDS;
        if (forbiddenUpdFields.contains(updField)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u975e\u51fa\u5382\u9884\u7f6e\u7684\u6807\u51c6\u4ea7\u54c1\u5b57\u6bb5\uff0c\u4e0d\u5141\u8bb8\u6279\u91cf\u4fee\u6539\u3002", (String)"BatchUpdFieldHelper_8", (String)"bd-sbd-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private static List<Map<String, Object>> getBeforeUpdateBillInfos(DynamicObject[] beforeUpdateDataArr, Map<String, Object> updFieldValMap) {
        LinkedList<Map<String, Object>> result = new LinkedList<Map<String, Object>>();
        if (beforeUpdateDataArr == null || beforeUpdateDataArr.length == 0) {
            return result;
        }
        HashMap<String, Object> billInfoMap = null;
        for (DynamicObject beforeUpdateData : beforeUpdateDataArr) {
            billInfoMap = new HashMap<String, Object>(16);
            StringJoiner beforeUpdateValJoiner = new StringJoiner(",");
            billInfoMap.put("billId", beforeUpdateData.getPkValue());
            billInfoMap.put("billNo", beforeUpdateData.get("number"));
            for (String updField : updFieldValMap.keySet()) {
                Object beforeUpdateVal = beforeUpdateData.get(updField);
                if (beforeUpdateVal instanceof DynamicObject) {
                    beforeUpdateVal = beforeUpdateData.getDynamicObject(updField).getPkValue();
                }
                if (beforeUpdateVal == null) {
                    beforeUpdateVal = "";
                }
                beforeUpdateValJoiner.add(beforeUpdateVal.toString());
            }
            billInfoMap.put("beforeUpdateVal", beforeUpdateValJoiner.toString());
            result.add(billInfoMap);
        }
        return result;
    }

    private static void saveOperLog(String entityNumber, String batchUpdResult, List<Map<String, Object>> beforeUpdateBillInfos, Map<String, Object> updFieldValMap) {
        HashMap<String, Object> modifyContentTag = new HashMap<String, Object>(16);
        modifyContentTag.put("entity", entityNumber);
        modifyContentTag.put("operateResult", batchUpdResult);
        modifyContentTag.put("updateField", updFieldValMap.keySet());
        modifyContentTag.put("updateVal", updFieldValMap.values());
        modifyContentTag.put("beforeUpdateBillInfoSize", beforeUpdateBillInfos.size());
        modifyContentTag.put("beforeUpdateBillInfos", beforeUpdateBillInfos);
        OpLogAppInfo logInfo = new OpLogAppInfo();
        logInfo.setBizAppID("15IWD0BF6M6/");
        logInfo.setBizObjID(entityNumber);
        logInfo.setOpName("batchupdate", "");
        String opDesc = batchUpdResult;
        if (opDesc.length() >= 250) {
            opDesc = opDesc.substring(0, 250);
        }
        logInfo.setOpDescription(opDesc);
        try {
            logInfo.setModifyContentTag(JSONUtils.toString(modifyContentTag));
        }
        catch (IOException e) {
            logInfo.setModifyContentTag("BatchUpdFieldHelper saveOperLog,call JSONUtils.toString err:" + e.getMessage());
            log.error("BatchUpdFieldHelper saveOperLog,call JSONUtils.toString err:", (Throwable)e);
        }
        ILogService logSrv = (ILogService)ServiceFactory.getService(ILogService.class);
        logSrv.addLog((AppLogInfo)logInfo);
    }

    private static StringBuilder networkMutexChecking(IFormView view, String entityNumber, List<Long> dataIds) {
        StringBuilder checkingResult = new StringBuilder();
        Map formShowParams = view.getFormShowParameter().getCustomParams();
        Map idNumberMap = (Map)formShowParams.get(KEY_ID_NUMBER_MAP);
        try (DataMutex dataMutex = DataMutex.create();){
            Iterator<Long> iterator = dataIds.iterator();
            while (iterator.hasNext()) {
                Long dataId = iterator.next();
                Map info = dataMutex.getLockInfo(String.valueOf(dataId), MutexHelper.getMutexGroupId((String)entityNumber, (String)"modify"), entityNumber);
                if (info == null) continue;
                checkingResult.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u8be5\u57fa\u7840\u6570\u636e\u6b63\u5728\u7f16\u8f91\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"BatchUpdFieldHelper_6", (String)"bd-sbd-business", (Object[])new Object[0]), idNumberMap.get(dataId))).append(LINE_BREAK);
                iterator.remove();
            }
        }
        catch (IOException e) {
            log.error("BatchUpdFieldHelper-networkMutexChecking exception", (Throwable)e);
        }
        return checkingResult;
    }

    private static OperationResult doUpdate(String entityNumber, DynamicObject[] updEntityArr, Map<String, Object> updFieldValMap) {
        Long curUserId = RequestContext.get().getCurrUserId();
        Date modifytime = new Date();
        OperationResult updResult = new OperationResult();
        if (updEntityArr == null || updEntityArr.length == 0) {
            return updResult;
        }
        for (DynamicObject updateEntity : updEntityArr) {
            for (Map.Entry<String, Object> updFieldValEntry : updFieldValMap.entrySet()) {
                updateEntity.set(updFieldValEntry.getKey(), updFieldValEntry.getValue());
            }
            updateEntity.set(KEY_MODIFIER, (Object)curUserId);
            updateEntity.set(KEY_MODIFY_TIME, (Object)modifytime);
        }
        updResult = OperationServiceHelper.executeOperate((String)"save", (String)entityNumber, (DynamicObject[])updEntityArr, (OperateOption)OperateOption.create());
        log.info("BatchUpdFieldHelper doUpdate: " + updEntityArr.length + " record, result: " + updResult.isSuccess());
        if (!updResult.isSuccess()) {
            log.error("BatchUpdFieldHelper doUpdate failed: " + BatchUpdFieldHelper.getOperateErrMsg(updResult));
        }
        return updResult;
    }

    private static String batchUpdResultTips(IFormView view, StringBuilder errMsg, int totalRecordsCount, int successRecordsCount) {
        StringBuilder result = new StringBuilder();
        if (StringUtils.isBlank((CharSequence)errMsg)) {
            String tip = String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff0c\u5171\u4fee\u6539%s\u6761\u6570\u636e\u3002", (String)"BatchUpdFieldHelper_2", (String)"bd-sbd-business", (Object[])new Object[0]), totalRecordsCount);
            view.getParentView().showSuccessNotification(tip);
            result.append(tip);
        } else {
            HashMap<String, Object> params = new HashMap<String, Object>(2);
            String title = String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u6570\u636e\uff0c\u4fee\u6539\u6210\u529f%2$s\u6761\uff0c\u5931\u8d25%3$s\u6761\u3002", (String)"BatchUpdFieldHelper_7", (String)"bd-sbd-business", (Object[])new Object[0]), totalRecordsCount, successRecordsCount, totalRecordsCount - successRecordsCount);
            params.put("title", title);
            params.put("errorMsg", errMsg);
            view.getParentView().showForm(FormShowParameterUtil.getOperResultForm(KEY_BOS_OPERATIONRESULT, params, null, ShowType.Modal));
            result.append(title).append(':').append((CharSequence)errMsg);
        }
        view.sendFormAction(view.getParentView());
        view.close();
        return result.toString();
    }

    public static void updValF7Filter(BeforeF7SelectEvent f7Event, IFormView view) {
        IDataEntityProperty dataEntityProperty;
        IFormView parentView = view.getParentView();
        IPageCache pageCache = parentView == null ? null : (IPageCache)parentView.getService(IPageCache.class);
        Long bizOrg = 0L;
        String bizOrgStr = "";
        if (pageCache != null) {
            bizOrgStr = pageCache.get("createOrg");
        }
        if (StringUtils.isNotBlank((CharSequence)bizOrgStr)) {
            bizOrg = Long.valueOf(bizOrgStr);
        }
        if ((dataEntityProperty = BatchUpdFieldHelper.getSuperFormFieldProp(view)) == null) {
            return;
        }
        ListShowParameter param = (ListShowParameter)f7Event.getFormShowParameter();
        if (dataEntityProperty instanceof AssistantProp) {
            AssistantProp assistantProp = (AssistantProp)dataEntityProperty;
            Long groupId = Long.parseLong(assistantProp.getAsstTypeId());
            QFilter groupFilter = new QFilter("group", "=", (Object)groupId);
            QFilter orgFilter = AssistantDataServiceHelper.getAssistantDataFilter((Long)groupId, (Long)bizOrg);
            param.getListFilterParameter().getQFilters().add(groupFilter);
            param.getListFilterParameter().getQFilters().add(orgFilter);
        }
    }

    private static String getOperateErrMsg(OperationResult updResult) {
        StringBuilder errMsgBuilder = new StringBuilder();
        List allErrorOrValidateInfo = updResult.getAllErrorOrValidateInfo();
        if (allErrorOrValidateInfo.isEmpty()) {
            errMsgBuilder.append(updResult.getMessage()).append(LINE_BREAK);
        } else {
            for (IOperateInfo operInfo : allErrorOrValidateInfo) {
                errMsgBuilder.append(operInfo.getMessage()).append(LINE_BREAK);
            }
        }
        return errMsgBuilder.toString();
    }
}

