/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.business.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.formula.ExpressionParameter;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.formula.FormulaEngine;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public class BizTypeConfigHelper {
    public List<Map<String, Long>> getBiztype(DynamicObjectCollection param) {
        ArrayList<Map<String, Long>> resultList = new ArrayList<Map<String, Long>>();
        String mateDataName = param.getDynamicObjectType().getName();
        DynamicObject[] bizConfigArray = this.getBizTypeConfigByCon(mateDataName);
        for (DynamicObject elObj : param) {
            this.compareConfig(elObj, bizConfigArray, resultList);
        }
        return resultList;
    }

    private void compareConfig(DynamicObject elObj, DynamicObject[] bizConfigArray, List<Map<String, Long>> resultList) {
        MainEntityType mainEntityType = (MainEntityType)elObj.getDataEntityType();
        String entityName = mainEntityType.getName();
        for (DynamicObject configObj : bizConfigArray) {
            String filterStr = configObj.getString("filterstring_tag");
            DynamicObject biztype = configObj.getDynamicObject("biztype");
            if (StringUtils.isEmpty((String)filterStr)) continue;
            HashMap<String, Long> elMap = new HashMap<String, Long>(16);
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterStr, FilterCondition.class);
            FilterBuilder filterBuilder = new FilterBuilder(mainEntityType, filterCondition);
            String[] scripts = filterBuilder.buildFilterScript();
            String expression = scripts[0];
            if (StringUtils.isEmpty((String)expression)) {
                elMap.put("srcObjectId", elObj.getLong("id"));
                elMap.put("bizTypeId", biztype.getLong("id"));
                resultList.add(elMap);
                break;
            }
            RowDataModel rowDataModel = new RowDataModel(entityName, mainEntityType);
            ExpressionParameter expressionParameter = new ExpressionParameter(expression, rowDataModel);
            Set vars = expressionParameter.getBOSExpression().getVars();
            HashMap<String, Object> params = new HashMap<String, Object>();
            for (String fieldName : vars) {
                Object value = elObj.get(fieldName);
                if (value instanceof OrmLocaleValue) {
                    params.put(fieldName, ((OrmLocaleValue)value).getLocaleValue());
                    continue;
                }
                params.put(fieldName, value);
            }
            boolean flag = (Boolean)FormulaEngine.execExcelFormula((String)expression, params);
            if (!flag) continue;
            elMap.put("srcObjectId", elObj.getLong("id"));
            elMap.put("bizTypeId", biztype.getLong("id"));
            resultList.add(elMap);
            break;
        }
    }

    private DynamicObject[] getBizTypeConfigByCon(String mateDataName) {
        QFilter filter = new QFilter("srcbill.number", "=", (Object)mateDataName);
        filter.and("enable", "=", (Object)"1");
        filter.and("status", "=", (Object)"C");
        return BusinessDataServiceHelper.load((String)"bd_biztypeconfig", (String)"number,biztype,srcbill,filterstring_tag", (QFilter[])filter.toArray());
    }
}

