/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.business.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bd.sbd.business.helper.BillTreeBuildParameter;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.tree.TreeNode;

public class LotCodeEntityParseHelper {
    public static TreeNode buildBillTreeNodes(BillTreeBuildParameter parameter) {
        MainEntityType mainType = parameter.getMainType();
        TreeNode billNode = new TreeNode("", mainType.getName(), mainType.getDisplayName().toString());
        billNode.setIsOpened(true);
        List<TreeNode> fldNodes = LotCodeEntityParseHelper.buildFldTreeNodes(parameter);
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>(fldNodes.size());
        for (TreeNode node : fldNodes) {
            nodeMap.put(node.getId(), node);
        }
        for (TreeNode node : fldNodes) {
            TreeNode parentNode = (TreeNode)nodeMap.get(node.getParentid());
            if (parentNode == null) {
                node.setParentid(billNode.getId());
                billNode.addChild(node);
                continue;
            }
            parentNode.addChild(node);
        }
        return billNode;
    }

    public static List<TreeNode> buildFldTreeNodes(BillTreeBuildParameter parameter) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        MainEntityType mainType = parameter.getMainType();
        HashSet<String> selectedEntity = new HashSet<String>();
        selectedEntity.addAll(parameter.getSelectedEntity());
        if (selectedEntity.size() == 0) {
            selectedEntity = new HashSet();
            for (String entityKey : mainType.getAllEntities().keySet()) {
                selectedEntity.add(entityKey);
            }
        }
        for (Map.Entry entry : mainType.getAllEntities().entrySet()) {
            EntityType entityType;
            if (!selectedEntity.contains(entry.getKey()) || (entityType = (EntityType)entry.getValue()) instanceof LinkEntryType || ("im_adjustbill".equals(mainType.getName()) || "im_disassemblebill".equals(mainType.getName()) ? "snentity".equals(entry.getKey()) : entityType instanceof SubEntryType)) continue;
            String entityNodeId = entityType.getName();
            String entityNodeName = "";
            if (entityType instanceof MainEntityType) {
                entityNodeName = ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"LotCodeEntityParseHelper_0", (String)"bd-sbd-business", (Object[])new Object[0]);
                entityNodeId = "billhead";
            } else if (entityType.getDisplayName() != null) {
                entityNodeName = entityType.getDisplayName().toString();
            }
            TreeNode entityNode = new TreeNode(mainType.getName(), entityNodeId, entityNodeName);
            entityNode.setIsOpened(true);
            ArrayList<TreeNode> entityFldNodes = new ArrayList<TreeNode>();
            if (parameter.isIncludePKField()) {
                LotCodeEntityParseHelper.buildPKFldTreeNode(entityType, entityNode, entityFldNodes, parameter);
            }
            if (parameter.getMatchedProperty() instanceof EntryProp) {
                TreeNode seqNode;
                nodes.add(entityNode);
                DynamicProperty seqProp = entityType.getProperty("seq");
                if (seqProp != null && (seqNode = LotCodeEntityParseHelper.BuildFldTreeNode((IDataEntityProperty)seqProp, parameter.getMatchedProperty(), parameter.getMatchedClassType(), entityNode, entityType.getName(), parameter.isDynamicText())) != null) {
                    seqNode.setText(String.format(ResManager.loadKDString((String)"%1$s.\u5e8f\u53f7", (String)"LotCodeEntityParseHelper_1", (String)"bd-sbd-business", (Object[])new Object[0]), entityType.getDisplayName().toString()));
                    entityFldNodes.add(seqNode);
                }
                nodes.addAll(entityFldNodes);
                continue;
            }
            for (IDataEntityProperty property : entityType.getFields().values()) {
                BasedataProp bdProp;
                MainEntityType bdType;
                List<TreeNode> refNodes;
                boolean matched = false;
                if (parameter.isOnlyPhysicsField() && StringUtils.isBlank((CharSequence)property.getAlias()) || "id".equalsIgnoreCase(property.getName()) || "seq".equalsIgnoreCase(property.getName())) continue;
                TreeNode fldNode = LotCodeEntityParseHelper.BuildFldTreeNode(property, parameter.getMatchedProperty(), parameter.getMatchedClassType(), entityNode, "", parameter.isDynamicText());
                if (fldNode != null) {
                    entityFldNodes.add(fldNode);
                    matched = true;
                }
                if (!(property instanceof BasedataProp)) continue;
                if (fldNode == null) {
                    fldNode = LotCodeEntityParseHelper.BuildFldTreeNode(property, null, null, entityNode, "", parameter.isDynamicText());
                }
                if ((refNodes = LotCodeEntityParseHelper.BuildBDFldRefPropNodes(bdType = (MainEntityType)(bdProp = (BasedataProp)property).getComplexType(), parameter.getMatchedProperty(), parameter.getMatchedClassType(), fldNode, property.getName(), parameter.isDynamicText())).size() <= 0) continue;
                entityFldNodes.addAll(refNodes);
                if (matched) continue;
                entityFldNodes.add(fldNode);
            }
            if (entityFldNodes.size() <= 0) continue;
            nodes.add(entityNode);
            nodes.addAll(entityFldNodes);
        }
        return nodes;
    }

    private static List<TreeNode> BuildBDFldRefPropNodes(MainEntityType bdType, IDataEntityProperty matchedProperty, Class<?> matchedClassType, TreeNode bdFldNode, String prefix, boolean isDynamicText) {
        ArrayList<TreeNode> refNodes = new ArrayList<TreeNode>();
        for (IDataEntityProperty property : bdType.getFields().values()) {
            String prefix2;
            BasedataProp bdProp2;
            MainEntityType bdType2;
            List<TreeNode> refNodes2;
            if (property instanceof EntryProp) continue;
            TreeNode fldNode = LotCodeEntityParseHelper.BuildFldTreeNode(property, matchedProperty, matchedClassType, bdFldNode, prefix, isDynamicText);
            boolean matched = false;
            if (fldNode != null) {
                refNodes.add(fldNode);
                matched = true;
            }
            if (!(property instanceof BasedataProp)) continue;
            if (fldNode == null) {
                fldNode = LotCodeEntityParseHelper.BuildFldTreeNode(property, null, null, bdFldNode, prefix, isDynamicText);
            }
            if ((refNodes2 = LotCodeEntityParseHelper.BuildBDFldRefPropNodes(bdType2 = (MainEntityType)(bdProp2 = (BasedataProp)property).getComplexType(), matchedProperty, matchedClassType, fldNode, prefix2 = prefix + "." + property.getName(), isDynamicText)).size() <= 0) continue;
            refNodes.addAll(refNodes2);
            if (matched) continue;
            refNodes.add(fldNode);
        }
        return refNodes;
    }

    private static TreeNode BuildFldTreeNode(IDataEntityProperty fldProperty, IDataEntityProperty matchedProperty, Class<?> matchedClassType, TreeNode parentNode, String prefix, boolean isDynamicText) {
        TreeNode fldNode = null;
        boolean isMatch = LotCodeEntityParseHelper.isMatchType(fldProperty, matchedProperty, matchedClassType);
        DynamicProperty prop = (DynamicProperty)fldProperty;
        if (isMatch && prop != null) {
            String fullPropName;
            String fldNodeId = fullPropName = StringUtils.isBlank((CharSequence)prefix) ? prop.getName() : prefix + "." + prop.getName();
            if (isDynamicText) {
                fldNodeId = "{" + fullPropName + "}";
            }
            String fldNodeName = prop.getDisplayName() == null ? prop.getName() : prop.getDisplayName().toString();
            fldNode = new TreeNode(parentNode.getId(), fldNodeId, fldNodeName);
            fldNode.setIsOpened(false);
        }
        return fldNode;
    }

    private static void buildPKFldTreeNode(EntityType entityType, TreeNode entityNode, List<TreeNode> entityFldNodes, BillTreeBuildParameter parameter) {
        if (entityType instanceof MainEntityType) {
            TreeNode idNode = LotCodeEntityParseHelper.BuildFldTreeNode((IDataEntityProperty)entityType.getPrimaryKey(), parameter.getMatchedProperty(), parameter.getMatchedClassType(), entityNode, "", parameter.isDynamicText());
            if (idNode != null) {
                idNode.setText(String.format(ResManager.loadKDString((String)"%1$s.\u5185\u7801", (String)"LotCodeEntityParseHelper_2", (String)"bd-sbd-business", (Object[])new Object[0]), entityType.getDisplayName().toString()));
                entityFldNodes.add(idNode);
            }
        } else {
            TreeNode seqNode;
            DynamicProperty seqProp;
            TreeNode idNode = LotCodeEntityParseHelper.BuildFldTreeNode((IDataEntityProperty)entityType.getPrimaryKey(), parameter.getMatchedProperty(), parameter.getMatchedClassType(), entityNode, entityType.getName(), parameter.isDynamicText());
            if (idNode != null) {
                idNode.setText(String.format(ResManager.loadKDString((String)"%1$s.\u5185\u7801", (String)"LotCodeEntityParseHelper_2", (String)"bd-sbd-business", (Object[])new Object[0]), entityType.getDisplayName().toString()));
                entityFldNodes.add(idNode);
            }
            if ((seqProp = entityType.getProperty("seq")) != null && (seqNode = LotCodeEntityParseHelper.BuildFldTreeNode((IDataEntityProperty)seqProp, parameter.getMatchedProperty(), parameter.getMatchedClassType(), entityNode, entityType.getName(), parameter.isDynamicText())) != null) {
                seqNode.setText(String.format(ResManager.loadKDString((String)"%1$s.\u5e8f\u53f7", (String)"LotCodeEntityParseHelper_1", (String)"bd-sbd-business", (Object[])new Object[0]), entityType.getDisplayName().toString()));
                entityFldNodes.add(seqNode);
            }
        }
    }

    private static boolean isMatchType(IDataEntityProperty fldProperty, IDataEntityProperty matchedProperty, Class<?> matchedClassType) {
        boolean isMatch = true;
        if (matchedClassType != null && !matchedClassType.isInstance(fldProperty)) {
            isMatch = false;
        }
        if (matchedProperty != null) {
            if (matchedProperty instanceof BasedataProp && fldProperty instanceof BasedataProp) {
                BasedataProp bdProp1 = (BasedataProp)matchedProperty;
                BasedataProp bdProp2 = (BasedataProp)fldProperty;
                if (!StringUtils.equalsIgnoreCase((CharSequence)bdProp1.getBaseEntityId(), (CharSequence)bdProp2.getBaseEntityId())) {
                    isMatch = false;
                }
            } else if (!matchedProperty.getClass().isInstance(fldProperty)) {
                isMatch = false;
            }
        }
        return isMatch;
    }
}

