/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.business.helper;

import java.util.List;
import java.util.Map;
import kd.bd.sbd.enums.EnableStatusEnum;
import kd.bd.sbd.utils.StringUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class OrgHelper {
    public static DynamicObjectCollection getAuzOrgByUser(Long userID, String entityID, String permissionItem, String orgType) {
        List orgIdList = PermissionServiceHelper.getAllPermissionOrgs((Long)userID, (String)"sbd", (String)entityID, (String)permissionItem);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"bos_org");
        Map orgMap = BusinessDataServiceHelper.loadFromCache((Object[])orgIdList.toArray(), (DynamicObjectType)entityType);
        DynamicObjectCollection orgColl = new DynamicObjectCollection((DynamicObjectType)entityType, null);
        for (DynamicObject org : orgMap.values()) {
            if (!org.getBoolean("enable") || !org.getBoolean(orgType)) continue;
            orgColl.add((Object)org);
        }
        return orgColl;
    }

    public static List<Long> getAuthorizedOrgId(Long userID, String entityID, String permissionItem, String orgType) {
        DynamicObjectCollection orgColl = OrgHelper.getAuzOrgByUser(userID, entityID, permissionItem, orgType);
        return StringUtils.getIdList((DynamicObjectCollection)orgColl);
    }

    public static Map<Object, DynamicObject> getAuthorizedOrgDOMap(Long userID, String entityID, String permissionItem, String orgType) {
        List<Long> orgIdList = OrgHelper.getAuthorizedOrgId(userID, entityID, permissionItem, orgType);
        QFilter[] gpOrgFilters = new QFilter[]{new QFilter("id", "in", orgIdList)};
        Map gpOrgCollection = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (QFilter[])gpOrgFilters);
        return gpOrgCollection;
    }

    public static HasPermOrgResult ishasAllOrgPerm(Long userID, String appId, String entityID, String permissionItem) {
        HasPermOrgResult orgPermResult = PermissionServiceHelper.getAllPermOrgs((Long)userID, (String)appId, (String)entityID, (String)permissionItem);
        return orgPermResult;
    }

    public static DynamicObjectCollection getAuthorizedOrg(HasPermOrgResult orgPermResult) {
        MainEntityType orgType = EntityMetadataCache.getDataEntityType((String)"bos_org");
        Map orgMap = BusinessDataServiceHelper.loadFromCache((Object[])orgPermResult.getHasPermOrgs().toArray(), (DynamicObjectType)orgType);
        DynamicObjectCollection orgColl = new DynamicObjectCollection((DynamicObjectType)orgType, null);
        for (DynamicObject org : orgMap.values()) {
            if (!org.getBoolean("enable") || org.getBoolean("fiscontrolunit")) continue;
            orgColl.add((Object)org);
        }
        return orgColl;
    }

    public static DynamicObjectCollection getAllExcludeTypeOrg(Long userID, String appId, String entityID, String permissionItem, String excludeType) {
        HasPermOrgResult orgPermResult = OrgHelper.ishasAllOrgPerm(userID, appId, entityID, permissionItem);
        MainEntityType orgType = EntityMetadataCache.getDataEntityType((String)"bos_org");
        DynamicObjectCollection orgCol = new DynamicObjectCollection((DynamicObjectType)orgType, null);
        Map orgMap = null;
        if (!orgPermResult.hasAllOrgPerm()) {
            orgMap = BusinessDataServiceHelper.loadFromCache((Object[])orgPermResult.getHasPermOrgs().toArray(), (String)"bos_org");
            for (DynamicObject org : orgMap.values()) {
                if (!org.getBoolean("enable") || org.getBoolean(excludeType)) continue;
                orgCol.add((Object)org);
            }
        } else {
            QFilter qFilter = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
            qFilter.and(new QFilter(excludeType, "=", (Object)Boolean.FALSE));
            orgMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (QFilter[])new QFilter[]{qFilter});
            for (DynamicObject org : orgMap.values()) {
                orgCol.add((Object)org);
            }
        }
        return orgCol;
    }
}

