/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.sbd.business.helper.BillImportHelper;
import kd.bd.sbd.business.pdm.helper.MaterialHelper;
import kd.bd.sbd.enums.KitStructCtlEnum;
import kd.bd.sbd.enums.KitTransferModelEnum;
import kd.bd.sbd.enums.PriceModelEnum;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class MaterialSalInfoImportPlugin
extends AbstractBasePlugIn {
    private static final int batchSize = 2000;
    private Map<String, Object> tempCache = new HashMap<String, Object>();

    public void initImportData(InitImportDataEventArgs e) {
        List sourceDataList = e.getSourceDataList();
        if (sourceDataList.isEmpty()) {
            return;
        }
        this.getCanUseMaterial4Cache(sourceDataList);
        this.cacheUnit(sourceDataList);
        IDataModel model = (IDataModel)e.getSource();
        HashSet hasPermissionOrg = (HashSet)this.tempCache.get("hasPermissionOrg");
        if (hasPermissionOrg == null) {
            String appId = this.getView().getFormShowParameter().getAppId();
            Long userId = UserServiceHelper.getCurrentUserId();
            hasPermissionOrg = new HashSet(BillImportHelper.getHasPermissionOrg((String)appId, (String)model.getDataEntityType().getName(), (String)"03", (Long)userId));
            this.tempCache.put("hasPermissionOrg", hasPermissionOrg);
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        String cancelMessage;
        boolean isControlQty;
        String cancelMessage2;
        boolean isControlDay;
        Map map;
        this.checkOrgPermission(e);
        Map innerMap = null;
        String materialProp = null;
        Map materialMap = (Map)this.tempCache.get("materialInfo");
        Map propMap = BillImportHelper.format4ImportAndApi(e.getSourceData().get("masterid"));
        if (propMap != null && (map = BillImportHelper.format4ImportAndApi((Object)propMap)) != null) {
            materialProp = String.valueOf(map.get(map.get("importprop")));
            if (!materialMap.containsKey(materialProp)) {
                String cancelMessage3 = String.format(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801\u4e3a\u3010%s\u3011\u7684\u7269\u6599\u4e0d\u662f\u53ef\u9500\u552e\u7269\u6599\u3002", (String)"MaterialSalInfoImportPlugin_1", (String)"bd-sbd-formplugin", (Object[])new Object[0]), materialProp);
                this.cancelImport(e, cancelMessage3);
            }
            innerMap = (Map)materialMap.get(materialProp);
        }
        if (innerMap != null) {
            boolean isCheckUnit;
            Long baseUnitId;
            String unitProp = null;
            Long unitId = 0L;
            Map unitPropMap = BillImportHelper.format4ImportAndApi(e.getSourceData().get("salesunit"));
            if (unitPropMap != null) {
                String propName = (String)unitPropMap.get("importprop");
                unitProp = String.valueOf(unitPropMap.get(propName));
                if ("id".equals(propName)) {
                    unitId = Long.parseLong(unitProp);
                } else {
                    Map unitMap = (Map)this.tempCache.get("unitInfo");
                    unitId = unitMap.getOrDefault(unitProp, 0L);
                }
            }
            if ((baseUnitId = (Long)innerMap.get("baseUnitId")) != null && !unitId.equals(baseUnitId) && !(isCheckUnit = MaterialHelper.checkUnit((Long)((Long)innerMap.get("id")), (Long)baseUnitId, (Long)unitId))) {
                String cancelMessage4 = String.format(ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d\u7f16\u7801\u3010%1$s\u3011\u4e0d\u662f\u7269\u6599\u7f16\u7801\u3010%2$s\u3011\u7684\u53ef\u7528\u8ba1\u91cf\u5355\u4f4d\u3002", (String)"MaterialSalInfoImportPlugin_2", (String)"bd-sbd-formplugin", (Object[])new Object[0]), unitProp, materialProp);
                this.cancelImport(e, cancelMessage4);
            }
        }
        Object isControlDayObj = e.getSourceData().get("iscontrolday");
        Object deliverAdvanceDaysObj = e.getSourceData().get("deliveradvdays");
        Object deliverDelayDaysObj = e.getSourceData().get("deliverdelaydays");
        if (isControlDayObj == null) {
            isControlDayObj = Boolean.FALSE;
        }
        if (!(isControlDay = Boolean.parseBoolean(isControlDayObj.toString())) && deliverAdvanceDaysObj != null && Integer.parseInt(deliverAdvanceDaysObj.toString()) != 0) {
            cancelMessage2 = ResManager.loadKDString((String)"\u63a7\u5236\u65f6\u95f4\u4e3a\u5426\u65f6\uff0c\u4e0d\u9700\u8981\u5f55\u5165\u53d1\u8d27\u63d0\u524d\u5929\u6570\u3002", (String)"MaterialSalInfoImportPlugin_3", (String)"bd-sbd-formplugin", (Object[])new Object[0]);
            this.cancelImport(e, cancelMessage2);
        }
        if (!isControlDay && deliverDelayDaysObj != null && Integer.parseInt(deliverDelayDaysObj.toString()) != 0) {
            cancelMessage2 = ResManager.loadKDString((String)"\u63a7\u5236\u65f6\u95f4\u4e3a\u5426\u65f6\uff0c\u4e0d\u9700\u8981\u5f55\u5165\u53d1\u8d27\u5ef6\u8fdf\u5929\u6570\u3002", (String)"MaterialSalInfoImportPlugin_4", (String)"bd-sbd-formplugin", (Object[])new Object[0]);
            this.cancelImport(e, cancelMessage2);
        }
        Object isControlQtyObj = e.getSourceData().get("iscontrolqty");
        Object deliverRateCeilingObj = e.getSourceData().get("dlivrateceiling");
        Object deliverRateFloorObj = e.getSourceData().get("dlivratefloor");
        if (isControlQtyObj == null) {
            isControlQtyObj = Boolean.FALSE;
        }
        if (!(isControlQty = Boolean.parseBoolean(isControlQtyObj.toString())) && deliverRateCeilingObj != null && !BigDecimal.ZERO.equals(new BigDecimal(deliverRateCeilingObj.toString()))) {
            cancelMessage = ResManager.loadKDString((String)"\u63a7\u5236\u53d1\u8d27\u6570\u91cf\u4e3a\u5426\u65f6\uff0c\u4e0d\u9700\u8981\u5f55\u5165\u53d1\u8d27\u8d85\u53d1\u6bd4\u7387(%)\u3002", (String)"MaterialSalInfoImportPlugin_5", (String)"bd-sbd-formplugin", (Object[])new Object[0]);
            this.cancelImport(e, cancelMessage);
        }
        if (!isControlQty && deliverRateFloorObj != null && !BigDecimal.ZERO.equals(new BigDecimal(deliverRateFloorObj.toString()))) {
            cancelMessage = ResManager.loadKDString((String)"\u63a7\u5236\u53d1\u8d27\u6570\u91cf\u4e3a\u5426\u65f6\uff0c\u4e0d\u9700\u8981\u5f55\u5165\u53d1\u8d27\u6b20\u53d1\u6bd4\u7387(%)\u3002", (String)"MaterialSalInfoImportPlugin_6", (String)"bd-sbd-formplugin", (Object[])new Object[0]);
            this.cancelImport(e, cancelMessage);
        }
        if (innerMap != null) {
            Boolean enableInspect = (Boolean)innerMap.get("enableinspect");
            Object isDeliverInspectObj = e.getSourceData().get("isdeliverinspect");
            Object isReturnInspectObj = e.getSourceData().get("isreturninspect");
            if (enableInspect != null && !enableInspect.booleanValue()) {
                String cancelMessage5;
                if (isDeliverInspectObj != null && Boolean.parseBoolean(isDeliverInspectObj.toString())) {
                    cancelMessage5 = ResManager.loadKDString((String)"\u5f00\u542f\u3010\u53d1\u8d27\u68c0\u9a8c\u3011\u65f6\uff0c\u8bf7\u5148\u5f00\u542f\u7269\u6599\u3010\u53ef\u8d28\u68c0\u3011\u5f00\u5173\u3002", (String)"MaterialSalInfoImportPlugin_7", (String)"bd-sbd-formplugin", (Object[])new Object[0]);
                    this.cancelImport(e, cancelMessage5);
                }
                if (isReturnInspectObj != null && Boolean.parseBoolean(isReturnInspectObj.toString())) {
                    cancelMessage5 = ResManager.loadKDString((String)"\u5f00\u542f\u3010\u9000\u8d27\u68c0\u9a8c\u3011\u65f6\uff0c\u8bf7\u5148\u5f00\u542f\u7269\u6599\u3010\u53ef\u8d28\u68c0\u3011\u5f00\u5173\u3002", (String)"MaterialSalInfoImportPlugin_8", (String)"bd-sbd-formplugin", (Object[])new Object[0]);
                    this.cancelImport(e, cancelMessage5);
                }
            }
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        IDataModel model = this.getModel();
        DynamicObject data = model.getDataEntity(true);
        DynamicObject material = data.getDynamicObject("masterid");
        if (material != null) {
            boolean suite = material.getBoolean("suite");
            String priceModel = data.getString("pricemodel");
            String kitTransferModel = data.getString("kittransfermodel");
            String kitReturnModel = data.getString("kitreturnmodel");
            String kitStructCtl = data.getString("kitstructctl");
            if (suite) {
                if (priceModel == null || priceModel.isEmpty()) {
                    data.set("pricemodel", (Object)PriceModelEnum.PARENT.getValue());
                }
                if (kitTransferModel == null || kitTransferModel.isEmpty()) {
                    data.set("kittransfermodel", (Object)KitTransferModelEnum.KIT.getValue());
                }
                if (kitReturnModel == null || kitReturnModel.isEmpty()) {
                    data.set("kitreturnmodel", (Object)KitTransferModelEnum.KIT.getValue());
                }
                if (kitStructCtl == null || kitStructCtl.isEmpty()) {
                    data.set("kitstructctl", (Object)KitStructCtlEnum.NONADJ.getValue());
                }
            }
        }
    }

    private void checkOrgPermission(BeforeImportDataEventArgs e) {
        DynamicObject org = BillImportHelper.getBaseDataFromCache((Map)e.getSourceData(), (String)"createorg", (String)"bos_org", null, null, this.tempCache);
        if (org == null) {
            return;
        }
        Set hasPermissionOrg = (Set)this.tempCache.get("hasPermissionOrg");
        if (CollectionUtils.isNotEmpty((Collection)hasPermissionOrg) && !hasPermissionOrg.contains(org.getPkValue())) {
            Map propMap = BillImportHelper.format4ImportAndApi(e.getSourceData().get("createorg"));
            if (propMap == null) {
                return;
            }
            String orgProp = propMap.containsKey("number") ? String.valueOf(propMap.get("number")) : (propMap.containsKey("name") ? String.valueOf(propMap.get("name")) : String.valueOf(propMap.get("id")));
            String cancelMessage = String.format(ResManager.loadKDString((String)"\u9500\u552e\u7ec4\u7ec7\u3010%s\u3011\u4e0d\u5728\u7528\u6237\u6743\u9650\u8303\u56f4\u5185\u3002", (String)"MaterialSalInfoImportPlugin_0", (String)"bd-sbd-formplugin", (Object[])new Object[0]), orgProp);
            this.cancelImport(e, cancelMessage);
        }
    }

    private void getCanUseMaterial4Cache(List<Map<String, Object>> sourceDataList) {
        HashSet<String> materialPropSet = new HashSet<String>();
        String propName = "";
        HashMap materialMap = (HashMap)this.tempCache.get("materialInfo");
        if (materialMap == null) {
            materialMap = new HashMap();
            this.tempCache.put("materialInfo", materialMap);
        }
        for (Map<String, Object> data : sourceDataList) {
            String propVal;
            Map materialPropMap;
            if (data.get("masterid") == null || (materialPropMap = BillImportHelper.format4ImportAndApi((Object)data.get("masterid"))) == null) continue;
            if (StringUtils.isBlank((String)propName)) {
                propName = (String)materialPropMap.get("importprop");
            }
            if (materialMap.containsKey(propVal = String.valueOf(materialPropMap.get(propName)))) continue;
            materialPropSet.add(propVal);
        }
        List partitionList = BillImportHelper.partition(new ArrayList(materialPropSet), (int)2000);
        if (CollectionUtils.isNotEmpty((Collection)partitionList)) {
            for (List partition : partitionList) {
                DynamicObject[] materialInfoArray;
                QFilter materialFilter1 = new QFilter("enablesale", "=", (Object)true);
                QFilter materialFilter2 = new QFilter("enable", "=", (Object)"1");
                QFilter materialFilter3 = new QFilter(propName, "in", (Object)partition);
                for (DynamicObject materialInfo : materialInfoArray = BusinessDataServiceHelper.load((String)"bd_material", (String)"id,masterid,baseunit,enableinspect", (QFilter[])new QFilter[]{materialFilter1, materialFilter2, materialFilter3})) {
                    HashMap<String, Object> innerMap = new HashMap<String, Object>();
                    innerMap.put("id", materialInfo.getPkValue());
                    DynamicObject baseUnit = (DynamicObject)materialInfo.get("baseunit");
                    innerMap.put("baseUnitId", baseUnit.getPkValue());
                    innerMap.put("enableinspect", materialInfo.get("enableinspect"));
                    materialMap.put(materialInfo.getString(propName), innerMap);
                }
            }
        }
    }

    private void cacheUnit(List<Map<String, Object>> sourceDataList) {
        HashSet<String> unitPropSet = new HashSet<String>();
        String propName = "";
        HashMap<String, Long> unitMap = (HashMap<String, Long>)this.tempCache.get("unitInfo");
        if (unitMap == null) {
            unitMap = new HashMap<String, Long>();
            this.tempCache.put("unitInfo", unitMap);
        }
        for (Map<String, Object> data : sourceDataList) {
            Map unitPropMap;
            if (data.get("salesunit") == null || (unitPropMap = BillImportHelper.format4ImportAndApi((Object)data.get("salesunit"))) == null) continue;
            if (StringUtils.isBlank((String)propName)) {
                propName = (String)unitPropMap.get("importprop");
            }
            if ("id".equals(propName)) {
                return;
            }
            String propVal = String.valueOf(unitPropMap.get(propName));
            if (unitMap.containsKey(propVal)) continue;
            unitPropSet.add(propVal);
        }
        List partitionList = BillImportHelper.partition(new ArrayList(unitPropSet), (int)2000);
        if (CollectionUtils.isNotEmpty((Collection)partitionList)) {
            for (List partition : partitionList) {
                DynamicObject[] unitInfoArray;
                QFilter filter = new QFilter(propName, "in", (Object)partition);
                for (DynamicObject unitInfo : unitInfoArray = BusinessDataServiceHelper.load((String)"bd_measureunits", (String)"id, number, name", (QFilter[])new QFilter[]{filter})) {
                    unitMap.put(unitInfo.getString(propName), (Long)unitInfo.getPkValue());
                }
            }
        }
    }

    private void cancelImport(BeforeImportDataEventArgs e, String cancelMessage) {
        e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), cancelMessage);
        e.setCancel(true);
        e.setFireAfterImportData(false);
    }
}

