/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bd.sbd.enums.ControlUnitEnum;
import kd.bd.sbd.enums.StatusEnum;
import kd.bd.sbd.servicehelper.BDServiceHelper;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.MasterBasedataEdit;
import kd.bos.form.field.UnitEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class MaterialSalesInfoPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final String CHARACTERISTIC = "3";
    private static final Log LOG = LogFactory.getLog(MaterialSalesInfoPlugin.class);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.getModel().getValue("masterid") != null) {
            DynamicObject masterid = (DynamicObject)this.getModel().getValue("masterid");
            this.getModel().setValue("material", masterid.getPkValue());
            this.getModel().setDataChanged(false);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        MasterBasedataEdit materialEdit = (MasterBasedataEdit)this.getView().getControl("masterid");
        materialEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        UnitEdit saleUnitEdit = (UnitEdit)this.getView().getControl("salesunit");
        saleUnitEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        UnitEdit saleValUnitEdit = (UnitEdit)this.getView().getControl("salesvalunit");
        saleValUnitEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (key) {
            case "masterid": {
                QFilter saleMaterialFilter = new QFilter("enablesale", "=", (Object)Boolean.TRUE);
                QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
                QFilter auditFilter = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue());
                QFilter configPropertiesFilter = new QFilter("configproperties", "!=", (Object)CHARACTERISTIC);
                DynamicObject createOrg = (DynamicObject)this.getModel().getValue("createorg");
                QFilter orgIdFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_material", (Long)(createOrg != null ? Long.parseLong(createOrg.getPkValue().toString()) : 0L));
                ArrayList<QFilter> list = new ArrayList<QFilter>();
                list.add(saleMaterialFilter);
                list.add(enableFilter);
                list.add(auditFilter);
                list.add(configPropertiesFilter);
                list.add(orgIdFilter);
                showParameter.getListFilterParameter().getQFilters().addAll(list);
                break;
            }
            case "salesunit": {
                if (this.getModel().getValue("masterid") == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7269\u6599\u3002", (String)"MaterialSalesInfoPlugin_0", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                DynamicObject matDO = (DynamicObject)this.getModel().getValue("masterid");
                DynamicObject baseunitDO = matDO.getDynamicObject("baseunit");
                Long mid = matDO.getLong("id");
                Long buid = baseunitDO.getLong("id");
                List fixconunitlist = BDServiceHelper.getAssistMUListResult((Long)mid, (Long)buid, (String)"1");
                QFilter fixconFilter = new QFilter("id", "in", (Object)fixconunitlist);
                showParameter.getListFilterParameter().getQFilters().add(fixconFilter);
                break;
            }
            case "salesvalunit": {
                if (this.getModel().getValue("masterid") == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7269\u6599\u3002", (String)"MaterialSalesInfoPlugin_0", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                DynamicObject matDO = (DynamicObject)this.getModel().getValue("masterid");
                DynamicObject baseunitDO = matDO.getDynamicObject("baseunit");
                Long mid = matDO.getLong("id");
                Long buid = baseunitDO.getLong("id");
                List fixconunitlist = BDServiceHelper.getAssistMUListResult((Long)mid, (Long)buid, (String)"");
                QFilter fixconFilter = new QFilter("id", "in", (Object)fixconunitlist);
                showParameter.getListFilterParameter().getQFilters().add(fixconFilter);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] changeDatas = e.getChangeSet();
        Object newVal = changeDatas[0].getNewValue();
        switch (key) {
            case "masterid": {
                this.masterIDChanged(newVal);
                break;
            }
            case "iscontrolday": {
                this.isControlDayChanged(newVal);
                break;
            }
            case "iscontrolqty": {
                this.isControlQTYChanged(newVal);
                break;
            }
            default: {
                super.propertyChanged(e);
            }
        }
    }

    private void isControlQTYChanged(Object newVal) {
        boolean isControlQTY = (Boolean)newVal;
        this.controlChanged(isControlQTY, new String[]{"dlivrateceiling", "dlivratefloor"});
        this.getView().setEnable(Boolean.valueOf(isControlQTY), new String[]{"controlunit"});
        IDataModel model = this.getModel();
        if (isControlQTY) {
            model.setValue("controlunit", (Object)ControlUnitEnum.SALESUNIT.getValue());
        } else {
            model.setValue("controlunit", null);
        }
    }

    private void isControlDayChanged(Object newVal) {
        this.controlChanged((Boolean)newVal, new String[]{"deliveradvdays", "deliverdelaydays"});
    }

    private void controlChanged(boolean isControl, String[] fields) {
        if (!isControl) {
            IDataModel model = this.getModel();
            for (String field : fields) {
                model.setValue(field, (Object)0);
            }
        }
        IFormView view = this.getView();
        view.setEnable(Boolean.valueOf(isControl), fields);
    }

    private void masterIDChanged(Object newVal) {
        IDataModel model = this.getModel();
        if (newVal == null) {
            model.setValue("salesunit", null);
            model.setValue("salesvalunit", null);
            model.setValue("material", null);
        } else {
            Long materialid = (Long)((DynamicObject)newVal).getPkValue();
            model.setValue("material", (Object)materialid);
            DynamicObject baseUnit = ((DynamicObject)newVal).getDynamicObject("baseunit");
            if (baseUnit != null) {
                Long baseUnitID = (Long)baseUnit.getPkValue();
                model.setValue("salesunit", (Object)baseUnitID);
                model.setValue("salesvalunit", (Object)baseUnitID);
            }
        }
        model.setValue("isdeliverinspect", (Object)false);
        model.setValue("isreturninspect", (Object)false);
    }
}

