/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.ai.v2.fah;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.ext.fi.ai.v2.fah.ExtDataQueryHelper;
import kd.bos.ext.fi.ai.v2.fah.FahSerializeHelper;
import kd.bos.ext.fi.ai.v2.fah.SysParamConfig;
import kd.bos.ext.fi.ai.v2.fah.constant.FormConstant;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class BuildXLAAndGLUtils {
    public static String createXlaMode() {
        return SysParamConfig.get("fah.create.xla.mode");
    }

    public static boolean createXlaWay() {
        return "true".equalsIgnoreCase(SysParamConfig.get("fah.create.xla.way"));
    }

    public static boolean checkHasRegBill(String entityId) {
        return QueryServiceHelper.exists((String)"fah_regbill", (QFilter[])new QFilter("srcbilltype", "=", (Object)entityId).and(new QFilter("enable", "=", (Object)"1")).toArray());
    }

    public static boolean checkHasRegBillWithData(String entityId, Set<Long> selectedBillIds) {
        if ("ai_event".equalsIgnoreCase(entityId)) {
            Map<String, List<Long>> billTypeGroups = ExtDataQueryHelper.groupByBillType(selectedBillIds);
            if (billTypeGroups.size() != 1) {
                return true;
            }
            Iterator<String> iterator = billTypeGroups.keySet().iterator();
            while (iterator.hasNext()) {
                String billType;
                entityId = billType = iterator.next();
            }
        }
        return BuildXLAAndGLUtils.checkHasRegBill(entityId);
    }

    public static boolean checkHasDispatchRule(String entityId) {
        SqlBuilder sb = new SqlBuilder();
        sb.append("select t.fid from t_fah_evt_disp_scheme t where t.fsourcebill = ? and t.fenable = '1'", new Object[]{entityId});
        try (DataSet dataset = DB.queryDataSet((String)"checkHasDispatchRule", (DBRoute)FormConstant.AI, (SqlBuilder)sb);){
            boolean bl = dataset.hasNext();
            return bl;
        }
    }

    public static OperationResult buildResult(Collection<Long> ids, String returnData, OperationResult result) {
        if (StringUtils.isEmpty((CharSequence)returnData)) {
            return result;
        }
        Map returnMap = FahSerializeHelper.fromJsonString(returnData, Map.class);
        if (returnMap.containsKey("errorMsg")) {
            result.setSuccess(false);
            result.setMessage(ResManager.loadKDString((String)"\u51b2\u9500\u4e8b\u4ef6\u53ca\u4f1a\u8ba1\u5206\u5f55\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u4e8b\u4ef6\u521b\u5efa\u8bb0\u5f55\u3002", (String)"BuildXLAAndGLUtils_1", (String)"bos-ext-fi", (Object[])new Object[0]));
            return result;
        }
        Long requestId = (Long)returnMap.get("requestId");
        if (null != requestId) {
            String status = null;
            Integer failBillCnt = 0;
            String sql = "select fstatus,ffailbillcnt from t_fah_request_task where fid = " + requestId;
            try (DataSet queryDataSet = DB.queryDataSet((String)BuildXLAAndGLUtils.class.getName(), (DBRoute)FormConstant.AI, (String)sql);){
                for (Row row : queryDataSet) {
                    status = row.getString("fstatus");
                    failBillCnt = row.getInteger("ffailbillcnt");
                }
                if (!"4".equals(status) || failBillCnt > 0) {
                    result.setSuccess(false);
                    result.setMessage(ResManager.loadKDString((String)"\u51b2\u9500\u4e8b\u4ef6\u53ca\u4f1a\u8ba1\u5206\u5f55\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u4e8b\u4ef6\u521b\u5efa\u8bb0\u5f55\u3002", (String)"BuildXLAAndGLUtils_2", (String)"bos-ext-fi", (Object[])new Object[0]));
                } else {
                    result.setSuccess(true);
                }
            }
        }
        return result;
    }

    public static OperationResult buildXlaResult(Set<Long> ids, String returnData, OperationResult result) {
        if (StringUtils.isEmpty((CharSequence)returnData)) {
            return result;
        }
        Map returnMap = FahSerializeHelper.fromJsonString(returnData, Map.class);
        if (returnMap.containsKey("errorMsg")) {
            result.setSuccess(false);
            result.setMessage(ResManager.loadKDString((String)"\u751f\u6210\u4e8b\u4ef6\u53ca\u5b50\u5206\u7c7b\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u4e8b\u4ef6\u521b\u5efa\u8bb0\u5f55\u3002", (String)"BuildXLAAndGLUtils_3", (String)"bos-ext-fi", (Object[])new Object[0]));
            return result;
        }
        Long requestId = (Long)returnMap.get("requestId");
        if (null != requestId) {
            String status = null;
            Integer failBillCnt = 0;
            String sql = "select fstatus,ffailbillcnt from t_fah_request_task where fid = " + requestId;
            try (DataSet queryDataSet = DB.queryDataSet((String)BuildXLAAndGLUtils.class.getName(), (DBRoute)FormConstant.AI, (String)sql);){
                for (Row row : queryDataSet) {
                    status = row.getString("fstatus");
                    failBillCnt = row.getInteger("ffailbillcnt");
                }
                if (!"4".equals(status) || failBillCnt > 0) {
                    BuildXLAAndGLUtils.setXlaErrorInfo(result, ids, requestId);
                } else {
                    BuildXLAAndGLUtils.setXlaSuccessInfo(result, ids, requestId);
                }
            }
        }
        return result;
    }

    private static void setXlaSuccessInfo(OperationResult result, Set<Long> ids, Long requestId) {
        result.setSuccessPkIds(new ArrayList<Long>(ids));
        result.setMessage(ResManager.loadKDString((String)"\u521b\u5efa\u5b50\u5206\u7c7b\u8d26\u548c\u603b\u8d26\u6210\u529f\u3002", (String)"BuildVoucher_18", (String)"bos-ext-fi", (Object[])new Object[0]));
    }

    private static void setXlaErrorInfo(OperationResult result, Set<Long> ids, Long requestId) {
        Set<Long> failBills = BuildXLAAndGLUtils.getFailBills(ids, requestId);
        if (!failBills.isEmpty()) {
            for (Long failId : failBills) {
                OperateErrorInfo errorInfo = new OperateErrorInfo();
                errorInfo.setPkValue((Object)failId);
                errorInfo.setLevel(ErrorLevel.Error);
                errorInfo.setMessage(ResManager.loadKDString((String)"\u751f\u6210\u4e8b\u4ef6\u53ca\u5b50\u5206\u7c7b\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u4e8b\u4ef6\u521b\u5efa\u8bb0\u5f55\u3002", (String)"BuildXLAAndGLUtils_4", (String)"bos-ext-fi", (Object[])new Object[0]));
                result.addErrorInfo(errorInfo);
            }
            ids.removeAll(failBills);
        }
        if (!ids.isEmpty()) {
            result.setSuccessPkIds(new ArrayList<Long>(ids));
            result.setMessage(ResManager.loadKDString((String)"\u521b\u5efa\u5b50\u5206\u7c7b\u8d26\u548c\u603b\u8d26\u6210\u529f\u3002", (String)"BuildVoucher_18", (String)"bos-ext-fi", (Object[])new Object[0]));
        }
    }

    private static Set<Long> getFailBills(Set<Long> ids, Long requestId) {
        SqlBuilder selectFailedBill = new SqlBuilder();
        selectFailedBill.append("select fsrcbillid fsrcbillid from t_fah_task_fail_bills a where a.frequestid = ? ", new Object[]{requestId});
        selectFailedBill.append(" union ", new Object[0]);
        selectFailedBill.append("select fsrcbillid fsrcbillid from t_fah_task_skip_bills a where a.frequestid = ? ", new Object[]{requestId});
        HashSet<Long> failDatas = new HashSet<Long>(ids.size());
        try (DataSet dataSet = DB.queryDataSet((String)"setXlaErrorInfo", (DBRoute)FormConstant.AI, (SqlBuilder)selectFailedBill);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                failDatas.add(row.getLong("fsrcbillid"));
            }
        }
        return failDatas;
    }

    public static <SRC, RES> Set<RES> buildSetDataEx(SRC[] srcValues, Function<SRC, RES> convertor) {
        if (srcValues == null || srcValues.length == 0) {
            return Collections.EMPTY_SET;
        }
        if (convertor == null) {
            throw new IllegalArgumentException("Value Convertor cannot be null!");
        }
        HashSet<RES> dataSet = new HashSet<RES>(srcValues.length);
        for (SRC srcVal : srcValues) {
            if (null == srcVal) continue;
            dataSet.add(convertor.apply(srcVal));
        }
        return dataSet;
    }

    public static Set<Long> buildSetData(Object[] srcValues) {
        if (DynamicObject.class.isAssignableFrom(srcValues.getClass().getComponentType())) {
            return BuildXLAAndGLUtils.buildSetDataEx(srcValues, dynamicObject -> Long.valueOf(((DynamicObject)dynamicObject).getPkValue().toString()));
        }
        return BuildXLAAndGLUtils.buildSetDataEx(srcValues, srcId -> Long.valueOf(srcId.toString()));
    }
}

