/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.ai.v2.fah.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.ext.fi.ai.Voucher;
import kd.bos.ext.fi.util.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;

public class FahVoucherDao {
    private static Log logger = LogFactory.getLog(FahVoucherDao.class);

    public static List<Long> queryVoucherId(String billType, Set<Long> deleteIds) {
        ArrayList<Long> result = new ArrayList<Long>();
        if (StringUtils.isBlank(billType) || deleteIds.isEmpty()) {
            return result;
        }
        SqlBuilder sql = new SqlBuilder();
        String appenddata = "'" + billType + "'";
        sql.append("select fgl_header_id from t_fah_evt_tracker where fstatus = '4' and fsrc_billtype = ", new Object[0]).append(appenddata, new Object[0]).append(" and ", new Object[0]).appendIn("fsrc_billid", deleteIds.toArray());
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.bos.ext.fi.ai.v2.fah.dao.FahVoucherDao", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sql);){
            Iterator iterator = queryDataSet.iterator();
            while (iterator.hasNext()) {
                Long fglHeaderId = ((Row)iterator.next()).getLong("fgl_header_id");
                result.add(fglHeaderId);
            }
        }
        return result;
    }

    public static void queryHasVoucherBillId(String billType, List<Long> deleteIds, List<Long> hasVoucherBillIds) {
        if (StringUtils.isBlank(billType) || deleteIds.isEmpty()) {
            return;
        }
        SqlBuilder sql = new SqlBuilder();
        String appenddata = "'" + billType + "'";
        sql.append("select fsrc_billid from t_fah_evt_tracker where fstatus = '4' and fsrc_billtype = ", new Object[0]).append(appenddata, new Object[0]).append(" and ", new Object[0]).appendIn("fsrc_billid", deleteIds.toArray());
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.bos.ext.fi.ai.v2.fah.dao.FahVoucherDao", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sql);){
            Iterator iterator = queryDataSet.iterator();
            while (iterator.hasNext()) {
                Long fsrcBillid = ((Row)iterator.next()).getLong("fsrc_billid");
                hasVoucherBillIds.add(fsrcBillid);
            }
        }
    }

    public static void queryBillNumber(String billType, List<Long> billIds, Map<Long, String> billIdAndNumberMap) {
        if (StringUtils.isBlank(billType) || billIds.isEmpty()) {
            return;
        }
        String billNumber = null;
        if ("ai_event".equals(billType)) {
            billNumber = "number";
        } else {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billType);
            if (dataEntityType != null) {
                BillEntityType bnt = (BillEntityType)dataEntityType;
                billNumber = bnt.getBillNo();
            }
        }
        if (StringUtils.isBlank(billNumber)) {
            return;
        }
        DynamicObjectCollection dataCol = QueryServiceHelper.query((String)billType, (String)(billNumber + ",id"), (QFilter[])new QFilter("id", "in", billIds).toArray());
        for (DynamicObject data : dataCol) {
            billIdAndNumberMap.put(data.getLong("id"), data.getString(billNumber));
        }
    }

    public static Map<String, List<Long>> queryBillIds(List<Long> voucherIds) {
        HashMap<String, List<Long>> result = new HashMap<String, List<Long>>();
        if (voucherIds.isEmpty()) {
            return result;
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fsrc_billid,fsrc_billtype from t_fah_evt_tracker where ", new Object[0]).appendIn("fgl_header_id", voucherIds.toArray());
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.bos.ext.fi.ai.v2.fah.dao.FahVoucherDao", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sql);){
            for (Row row : queryDataSet) {
                String fsrcBilltype = row.getString("fsrc_billtype");
                Long fsrcBillid = row.getLong("fsrc_billid");
                result.computeIfAbsent(fsrcBilltype, v -> new ArrayList()).add(fsrcBillid);
            }
        }
        return result;
    }

    public static void queryEventData(List<Long> voucherIds, List<Long> eventIds, List<Long> xlaIds, List<Long> interfaceTableIds, List<Long> trackerId) {
        if (voucherIds.isEmpty()) {
            return;
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fxla_header_id,fgl_header_id,fid from t_fah_evt_tracker where ", new Object[0]).appendIn("fgl_header_id", voucherIds.toArray());
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.bos.ext.fi.ai.v2.fah.dao.FahVoucherDao", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sql);){
            for (Row row : queryDataSet) {
                Long fxlaHeaderId = row.getLong("fxla_header_id");
                xlaIds.add(fxlaHeaderId);
                Long fglHeaderId = row.getLong("fgl_header_id");
                interfaceTableIds.add(fglHeaderId);
                Long id = row.getLong("fid");
                trackerId.add(id);
            }
        }
        if (xlaIds.isEmpty()) {
            return;
        }
        SqlBuilder sqlevent = new SqlBuilder();
        sqlevent.append("select fsrceventid from t_fah_ae_headers where ", new Object[0]).appendIn("fid", xlaIds.toArray());
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.bos.ext.fi.ai.v2.fah.dao.FahVoucherDao", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlevent);){
            for (Row row : queryDataSet) {
                Long fsrceventid = row.getLong("fsrceventid");
                eventIds.add(fsrceventid);
            }
        }
    }

    public static void getVoucherInfo(String billType, List<Long> billIds, Map<Long, Set<Long>> vchIdAndBillIds, List<Long> hasReverseBills) {
        if (billIds.isEmpty()) {
            return;
        }
        ArrayList<Long> voucherIds = new ArrayList<Long>();
        SqlBuilder sqlbd = new SqlBuilder();
        String appenddata = "'" + billType + "'";
        sqlbd.append("select fsrc_billid,fgl_header_id,freverseflag from t_fah_evt_tracker where fstatus = '4' and fsrc_billtype = ", new Object[0]).append(appenddata, new Object[0]).append(" and ", new Object[0]).appendIn("fsrc_billid", billIds.toArray());
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.bos.ext.fi.ai.operation.DeleteVoucherValidator", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlbd);){
            for (Row row : queryDataSet) {
                Long fsourcebillid = row.getLong("fsrc_billid");
                Long fvoucherid = row.getLong("fgl_header_id");
                voucherIds.add(fvoucherid);
                int freverseflag = row.getInteger("freverseflag");
                if (freverseflag == 0) continue;
                hasReverseBills.add(fsourcebillid);
            }
        }
        if (voucherIds.isEmpty()) {
            return;
        }
        SqlBuilder sbd = new SqlBuilder();
        sbd.append("select fsrc_billid,fgl_header_id from t_fah_evt_tracker where ", new Object[0]).appendIn("fgl_header_id", voucherIds.toArray());
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.bos.ext.fi.ai.operation.DeleteVoucherValidator", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sbd);){
            for (Row row : queryDataSet) {
                Long fsourcebillid = row.getLong("fsrc_billid");
                Long fvoucherid = row.getLong("fgl_header_id");
                vchIdAndBillIds.computeIfAbsent(fvoucherid, v -> new HashSet()).add(fsourcebillid);
            }
        }
    }

    public static void insertErrorInfo(List<Object[]> params) {
        if (params.isEmpty()) {
            return;
        }
        String sql = "insert into t_fah_task_fail_bills(fid, frequestid, fbilltype, fsrcbillid, fmsg, fmsg_code,  fsrcbillno) values (?,?,?,?,?,?,?)";
        try (TXHandle h = TX.requiresNew();){
            try {
                DB.executeBatch((DBRoute)DBRoute.of((String)"fi"), (String)sql, params);
            }
            catch (Exception e) {
                logger.error("--FAH---FahDeleteVoucherRequestTask:{}", (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
        }
    }

    public static List<Long> queryCompleteBillIds(Map<String, List<Long>> missBillMap, String billType) {
        ArrayList<Long> result = new ArrayList<Long>();
        ArrayList<Long> voucherIds = new ArrayList<Long>();
        SqlBuilder sqlBuilder = new SqlBuilder();
        missBillMap.values().forEach(f -> result.addAll((Collection<Long>)f));
        sqlBuilder.append("select fgl_header_id from t_fah_evt_tracker where fstatus = '4'", new Object[0]).appendIn(" and fsrc_billid", result.toArray());
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.bos.ext.fi.ai.operation.DeleteVoucherValidator", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);){
            Iterator iterator = queryDataSet.iterator();
            while (iterator.hasNext()) {
                voucherIds.add(((Row)iterator.next()).getLong("fgl_header_id"));
            }
        }
        result.clear();
        if (voucherIds.isEmpty()) {
            return result;
        }
        SqlBuilder sbd = new SqlBuilder();
        sbd.append("select fsrc_billid,fsrc_billtype from t_fah_evt_tracker where fstatus = '4'", new Object[0]).appendIn(" and fgl_header_id", voucherIds.toArray());
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.bos.ext.fi.ai.operation.DeleteVoucherValidator", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sbd);){
            for (Row row : queryDataSet) {
                String fsrcBilltype = row.getString("fsrc_billtype");
                Long fsrcBillid = row.getLong("fsrc_billid");
                if (!billType.equals(fsrcBilltype)) continue;
                result.add(fsrcBillid);
            }
        }
        return result;
    }

    public static Map<String, List<Map<Long, Voucher>>> getBilltypeAndVoucher_event(Map<Long, String> vchIdAndBillNo) {
        HashMap<String, List<Map<Long, Voucher>>> result = new HashMap<String, List<Map<Long, Voucher>>>();
        if (vchIdAndBillNo.isEmpty()) {
            return result;
        }
        SqlBuilder sbd = new SqlBuilder();
        sbd.append("select fsrc_billid,fsrc_billtype,fgl_header_id from t_fah_evt_tracker where fstatus = '4'", new Object[0]).appendIn(" and fgl_header_id", vchIdAndBillNo.keySet().toArray());
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.bos.ext.fi.ai.operation.DeleteVoucherValidator", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sbd);){
            for (Row row : queryDataSet) {
                String fsrcBilltype = row.getString("fsrc_billtype");
                Long fsrcBillid = row.getLong("fsrc_billid");
                Long fglHeaderId = row.getLong("fgl_header_id");
                List mapList = result.computeIfAbsent(fsrcBilltype, v -> new ArrayList());
                Voucher vch = new Voucher();
                vch.setId(fglHeaderId);
                vch.setReoper("audit");
                vch.setVoucherNo(vchIdAndBillNo.get(fglHeaderId));
                Boolean dataDone = false;
                for (int i = 0; i < mapList.size(); ++i) {
                    Map longVoucherMap = (Map)mapList.get(i);
                    if (longVoucherMap.containsKey(fsrcBillid)) continue;
                    longVoucherMap.put(fsrcBillid, vch);
                    dataDone = true;
                    break;
                }
                if (dataDone.booleanValue()) continue;
                HashMap<Long, Voucher> appendMap = new HashMap<Long, Voucher>(16);
                appendMap.put(fsrcBillid, vch);
                mapList.add(appendMap);
            }
        }
        return result;
    }
}

