/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.ai.v2.fah.dto;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.ext.fi.ai.v2.fah.dao.FahVoucherDao;

public class FahVoucherCompleteDto {
    private final Set<Long> deleteIds;
    private final String billType;
    private Map<String, List<Long>> missBillMap = new HashMap<String, List<Long>>();

    public FahVoucherCompleteDto(Set<Long> deleteIds, String billType) {
        this.deleteIds = deleteIds;
        this.billType = billType;
    }

    public Boolean check() {
        List<Long> voucherIds = FahVoucherDao.queryVoucherId(this.billType, this.deleteIds);
        if (voucherIds.isEmpty()) {
            return true;
        }
        Map<String, List<Long>> billMap = FahVoucherDao.queryBillIds(voucherIds);
        HashMap<String, List<Long>> incrementBillMap = new HashMap<String, List<Long>>();
        HashMap<String, List<Long>> currBillMap = new HashMap<String, List<Long>>();
        currBillMap.put(this.billType, new ArrayList<Long>(this.deleteIds));
        for (Map.Entry<String, List<Long>> entries : billMap.entrySet()) {
            String key = entries.getKey();
            List<Long> value = entries.getValue();
            if (currBillMap.containsKey(key)) {
                value.removeAll((Collection)currBillMap.get(key));
            }
            if (value.isEmpty()) continue;
            this.missBillMap.computeIfAbsent(key, v -> new ArrayList()).addAll(value);
            incrementBillMap.put(key, value);
            currBillMap.computeIfAbsent(key, v -> new ArrayList()).addAll(value);
        }
        if (!incrementBillMap.isEmpty()) {
            this.queryDateRecursion(incrementBillMap, currBillMap, voucherIds, 5);
        }
        return this.missBillMap.isEmpty();
    }

    private void queryDateRecursion(Map<String, List<Long>> incrementBillMap, Map<String, List<Long>> currBillMap, List<Long> voucherIds, int maxSize) {
        if (maxSize <= 0) {
            return;
        }
        HashMap<String, List<Long>> incrementBillMapCopy = new HashMap<String, List<Long>>();
        for (Map.Entry<String, List<Long>> entries : incrementBillMap.entrySet()) {
            String key = entries.getKey();
            List<Long> value = entries.getValue();
            List<Long> newVchIds = FahVoucherDao.queryVoucherId(key, new HashSet<Long>(value));
            newVchIds.removeAll(voucherIds);
            if (newVchIds.isEmpty()) continue;
            Map<String, List<Long>> billMapData = FahVoucherDao.queryBillIds(newVchIds);
            for (Map.Entry<String, List<Long>> billMap : billMapData.entrySet()) {
                String billKey = billMap.getKey();
                List<Long> billValue = billMap.getValue();
                if (currBillMap.containsKey(billKey)) {
                    billValue.removeAll((Collection)currBillMap.get(billKey));
                }
                if (billValue.isEmpty()) continue;
                this.missBillMap.computeIfAbsent(billKey, v -> new ArrayList()).addAll(billValue);
                incrementBillMapCopy.put(billKey, billValue);
                currBillMap.computeIfAbsent(billKey, v -> new ArrayList()).addAll(billValue);
            }
            voucherIds.addAll(newVchIds);
        }
        if (!incrementBillMapCopy.isEmpty()) {
            this.queryDateRecursion(incrementBillMapCopy, currBillMap, voucherIds, --maxSize);
        }
    }

    public Map<String, List<Long>> getMissBillMap() {
        Set<String> strings = this.missBillMap.keySet();
        for (String aa : strings) {
            List<Long> ids = this.missBillMap.get(aa);
            List ds = ids.stream().distinct().collect(Collectors.toList());
            this.missBillMap.put(aa, ds);
        }
        return this.missBillMap;
    }

    public List<Long> getCompleteIds() {
        return FahVoucherDao.queryCompleteBillIds(this.missBillMap, this.billType);
    }

    public void setMissBillMap(Map<String, List<Long>> missBillMap) {
        this.missBillMap = missBillMap;
    }
}

