/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.ai.v2.fah.operation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.fi.ai.dap.cache.CacheHelper;
import kd.bos.ext.fi.ai.dap.cache.CacheModule;
import kd.bos.ext.fi.ai.dap.cache.DistributeCache;
import kd.bos.ext.fi.ai.v2.fah.BuildXLAAndGLUtils;
import kd.bos.ext.fi.ai.v2.fah.constant.BuildVoucherServiceParamConstants;
import kd.bos.service.operation.EntityOperateService;
import kd.bos.servicehelper.DispatchServiceHelper;

public class ReverseGLAndAcctJEService
extends EntityOperateService {
    protected void preparePropertys(List<String> fieldKeys) {
        if ("ai_event".equals(this.getBillEntityType().getName())) {
            fieldKeys.add("number");
        }
        super.preparePropertys(fieldKeys);
    }

    protected void executeOperate(DynamicObject[] objs) {
        HashSet<Long> ids = new HashSet<Long>();
        for (DynamicObject obj : objs) {
            ids.add((Long)obj.getPkValue());
        }
        String billType = this.getOption().getVariableValue("entityId");
        String returnData = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ai", (String)"IReverseGLAndAcctJEService", (String)"reverseGLAndAcctJE", (Object[])new Object[]{billType, ids, BuildVoucherServiceParamConstants.TaskGrps_Reverse_GL_XLA_Event});
        OperationResult buildResult = BuildXLAAndGLUtils.buildResult(ids, returnData, this.getOperationResult());
        String generateProcessKey = this.getOption().getVariableValue("GenerateProcessKey");
        DistributeCache distributeCache = CacheHelper.getDistributeCache(CacheModule.GenerateVoucherTaskProcess);
        String cacheData = distributeCache.get(generateProcessKey);
        Map<String, String> cacheDataMap = new HashMap<String, Integer>(8);
        if (cacheData != null) {
            cacheDataMap = (Map)SerializationUtils.fromJsonString((String)cacheData, Map.class);
        }
        cacheDataMap.put("currProgress", (String)((Object)Integer.valueOf(100)));
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeComplexProperty(true);
        cacheDataMap.put("operationResult", DataEntitySerializer.serializerToString((Object)buildResult, (DataEntitySerializerOption)option));
        distributeCache.put(generateProcessKey, SerializationUtils.toJsonString(cacheDataMap));
    }

    protected DynamicObject[] callOperation(DynamicObject[] objs) {
        DynamicObject[] sd = super.callOperation(objs);
        List successPkIds = this.getOperationResult().getSuccessPkIds();
        DynamicObject[] rel = (DynamicObject[])Stream.of(sd).filter(d -> successPkIds.contains(d.getPkValue())).toArray(DynamicObject[]::new);
        successPkIds.removeAll(Stream.of(rel).map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        IDataEntityProperty billNoProp = null;
        if (this.subEntityType instanceof BasedataEntityType) {
            BasedataEntityType bdType = (BasedataEntityType)this.subEntityType;
            if (StringUtils.isNotBlank((CharSequence)bdType.getNumberProperty())) {
                billNoProp = this.subEntityType.findProperty(bdType.getNumberProperty());
            }
        } else if (this.subEntityType instanceof BillEntityType) {
            billNoProp = "ai_event".equals(this.subEntityType.getName()) ? this.subEntityType.findProperty("number") : this.subEntityType.findProperty(((BillEntityType)this.subEntityType).getBillNo());
        }
        List errors = this.getOperationResult().getAllErrorInfo();
        HashMap<Object, DynamicObject> dataMap = new HashMap<Object, DynamicObject>(sd.length);
        for (DynamicObject dd : sd) {
            dataMap.put(dd.getPkValue(), dd);
        }
        for (OperateErrorInfo error : errors) {
            String billNo;
            DynamicObject errorObj = (DynamicObject)dataMap.get(error.getPkValue());
            if (errorObj == null) continue;
            String string = billNo = billNoProp == null ? "" : (String)billNoProp.getValue((Object)errorObj);
            if (billNo == null) {
                error.setMessage(String.format(ResManager.loadKDString((String)"\u51b2\u9500\u4e8b\u4ef6\u53ca\u4f1a\u8ba1\u5206\u5f55\u5931\u8d25\uff1a%s", (String)"ReverseGLAndAcctJEService_1", (String)"bos-ext-fi", (Object[])new Object[0]), error.getMessage()));
                continue;
            }
            error.setMessage(String.format(ResManager.loadKDString((String)"\u7f16\u53f7%1$s\u51b2\u9500\u4e8b\u4ef6\u53ca\u4f1a\u8ba1\u5206\u5f55\uff1a%2$s", (String)"ReverseGLAndAcctJEService_2", (String)"bos-ext-fi", (Object[])new Object[0]), billNo, error.getMessage()));
        }
        return rel;
    }
}

