/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.botp.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.botp.helper.SystemStatusCtrolHelper;
import kd.bos.ext.fi.util.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class OrgHelper {
    public static final String ORGTYPE_ACCOUNTING = "fisaccounting";
    public static final String ORGTYPE_SETTLEMENT = "fissettlement";
    public static final String ORGTYPE_BANKROLL = "fisbankroll";
    public static final String ORGTYPE_SALE = "fissale";
    public static final String NO_LEGAL_PERSON = "3";

    public static DynamicObject getAccountOrgByFundsOrg(DynamicObject fundsOrg) {
        DynamicObject accountOrg = null;
        boolean isAccount = fundsOrg.getBoolean(ORGTYPE_ACCOUNTING);
        if (isAccount) {
            DynamicObject tempSuperOrg;
            DynamicObject superOrg = fundsOrg;
            do {
                boolean isLegalPerson = false;
                DynamicObject orgpattern = superOrg.getDynamicObject("orgpattern");
                if (orgpattern != null) {
                    boolean bl = isLegalPerson = !NO_LEGAL_PERSON.equals((orgpattern = BusinessDataServiceHelper.loadSingle((Object)orgpattern.getPkValue(), (String)"bos_org_pattern", (String)"id, patterntype")).getString("patterntype"));
                }
                if (!isLegalPerson) continue;
                accountOrg = superOrg;
                break;
            } while (((tempSuperOrg = OrgHelper.getSuperiorBankOrg("10", fundsOrg.getLong("id"))) == null || tempSuperOrg.getLong("id") != fundsOrg.getLong("id")) && (superOrg = tempSuperOrg) != null);
        } else {
            try {
                Long orgid = OrgServiceHelper.getToOrg((String)ORGTYPE_BANKROLL, (String)ORGTYPE_ACCOUNTING, (Long)fundsOrg.getLong("id"), (Long)0L);
                accountOrg = BusinessDataServiceHelper.loadSingle((Object)orgid, (String)"bos_org");
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        return accountOrg;
    }

    public static DynamicObject getSuperiorBankOrg(String attributes, long orgId) {
        List superiorOrgs = OrgUnitServiceHelper.getSuperiorOrgs((String)attributes, (long)orgId);
        if (superiorOrgs == null || superiorOrgs.size() < 1) {
            return null;
        }
        DynamicObject org = BusinessDataServiceHelper.loadSingle((String)"bos_org", (String)"id, orgpattern", (QFilter[])new QFilter[]{new QFilter("id", "in", superiorOrgs.get(0))});
        return org;
    }

    public static DynamicObjectCollection getAuthorizedBankOrg(Long userID, String entityID, String permissionItem) {
        return OrgHelper.getAuthorizedOrg(userID, entityID, permissionItem, ORGTYPE_BANKROLL);
    }

    public static DynamicObjectCollection getAuthorizedAcctOrg(Long userID, String entityID, String permissionItem) {
        return OrgHelper.getAuthorizedOrg(userID, entityID, permissionItem, ORGTYPE_ACCOUNTING);
    }

    private static DynamicObjectCollection getAuthorizedOrg(Long userID, String entityID, String permissionItem, String funType) {
        String appId = AppMetadataCache.getAppInfo((String)"cas").getId();
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((Long)userID, (String)appId, (String)entityID, (String)permissionItem);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter functionFilter = new QFilter(funType, "=", (Object)Boolean.TRUE);
        Map orgs = new HashMap();
        if (allPermOrgs.hasAllOrgPerm()) {
            orgs = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (QFilter[])new QFilter[]{enableFilter, functionFilter});
        } else {
            List orgIdList = allPermOrgs.getHasPermOrgs();
            QFilter pkFilter = new QFilter("id", "in", (Object)orgIdList);
            orgs = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (QFilter[])new QFilter[]{enableFilter, functionFilter, pkFilter});
        }
        MainEntityType orgType = EntityMetadataCache.getDataEntityType((String)"bos_org");
        DynamicObjectCollection orgColl = new DynamicObjectCollection((DynamicObjectType)orgType, null);
        for (DynamicObject org : orgs.values()) {
            orgColl.add((Object)org);
        }
        return orgColl;
    }

    public static List<Long> getAuthorizedBankOrgId(Long userID, String entityID, String permissionItem) {
        DynamicObjectCollection orgColl = OrgHelper.getAuthorizedBankOrg(userID, entityID, permissionItem);
        return OrgHelper.getIdList(orgColl);
    }

    public static List<Long> getIdList(DynamicObjectCollection orgList) {
        ArrayList<Long> idList = new ArrayList<Long>();
        for (DynamicObject org : orgList) {
            idList.add(org.getLong("id"));
        }
        return idList;
    }

    public static DynamicObject getOrgById(long id) {
        Map orgMap = BusinessDataServiceHelper.loadFromCache((Object[])new Object[]{id}, (String)"bos_org");
        return (DynamicObject)orgMap.get(id);
    }

    public static DynamicObject getBaseCurrency(long orgId) {
        try {
            return SystemStatusCtrolHelper.getStandardCurrency(orgId);
        }
        catch (KDBizException e) {
            return null;
        }
    }

    public static Map<DynamicObject, DynamicObject> batchGetBaseCurrency(List<DynamicObject> bills) {
        HashMap<DynamicObject, DynamicObject> billToBaseCurrency = new HashMap<DynamicObject, DynamicObject>(4);
        ArrayList<DynamicObject> newBills = new ArrayList<DynamicObject>(4);
        for (DynamicObject bill : bills) {
            DynamicObject org = bill.getDynamicObject("org");
            if (org != null) {
                newBills.add(bill);
                continue;
            }
            billToBaseCurrency.put(bill, null);
        }
        Map objToOrgId = newBills.stream().collect(Collectors.toMap(Function.identity(), o -> o.getDynamicObject("org").getLong("id")));
        QFilter qFilterId = new QFilter("org", "in", objToOrgId.values());
        DynamicObject[] cashMgtInits = BusinessDataServiceHelper.load((String)"cas_cashmgtinit", (String)"org,standardcurrency", (QFilter[])qFilterId.toArray());
        Map orgTdToCurrency = Arrays.stream(cashMgtInits).filter(o -> o.getDynamicObject("org") != null).collect(HashMap::new, (map, item) -> map.put(item.getDynamicObject("org").getLong("id"), item.getDynamicObject("standardcurrency")), HashMap::putAll);
        for (Map.Entry entry : objToOrgId.entrySet()) {
            Long id = entry.getValue();
            if (orgTdToCurrency.get(id) == null) {
                billToBaseCurrency.put((DynamicObject)entry.getKey(), (DynamicObject)null);
                continue;
            }
            billToBaseCurrency.put((DynamicObject)entry.getKey(), (DynamicObject)orgTdToCurrency.get(id));
        }
        return billToBaseCurrency;
    }

    public static DynamicObject getOrgByNumber(String number) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter numFilter = new QFilter("number", "=", (Object)number);
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bos_org", (String)"id,number,name,fisasset", (QFilter[])new QFilter[]{enableFilter, numFilter});
        if (null != orgs && orgs.size() > 0) {
            return (DynamicObject)orgs.get(0);
        }
        return null;
    }

    public static DynamicObject getCurrentPermOrg(String permissionEntity, String permissionItem) throws KDBizException {
        MainEntityType orgType;
        DynamicObject currentOrg;
        Long userPK = Long.valueOf(RequestContext.get().getUserId());
        Long orgId = RequestContext.get().getOrgId();
        if (OrgHelper.hasPermission("cas", userPK, orgId, permissionEntity, permissionItem) && (currentOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (DynamicObjectType)(orgType = EntityMetadataCache.getDataEntityType((String)"bos_org")))).getBoolean(ORGTYPE_BANKROLL)) {
            return currentOrg;
        }
        DynamicObjectCollection orgList = OrgHelper.getAuthorizedBankOrg(userPK, permissionEntity, permissionItem);
        if (orgList.size() > 0) {
            return (DynamicObject)orgList.get(0);
        }
        throw new KDBizException("\u60a8\u6ca1\u6709\u6709\u6743\u9650\u7684\u7ec4\u7ec7\uff01");
    }

    public static boolean hasPermission(String appId, long userId, long orgId, String entityId, String permissionItemId) {
        int res;
        if (StringUtils.isEmpty(appId) && StringUtils.isNotEmpty(entityId)) {
            appId = EntityMetadataCache.getDataEntityType((String)entityId).getAppId();
        }
        return (res = PermissionServiceHelper.checkFunctionPermission((String)(appId = AppMetadataCache.getAppInfo((String)appId).getId()), (long)userId, (long)orgId, (String)entityId, (String)permissionItemId)) == 1;
    }
}

