/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.botp.helper;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.Tuple;
import kd.bos.ext.fi.util.StringUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class QuotationHelper {
    public static final String INDIRECT_PARITY = "1";
    public static final String ONE = "1";
    public static final String DIRECT_PARITY = "0";
    public static final String ZERO = "0";
    public static final int DF_ROUND = 10;
    public static final int df_Round = 10;
    private final Map<String, Tuple<String, BigDecimal>> exchangeCache = new HashMap<String, Tuple<String, BigDecimal>>(8);

    public static BigDecimal callToCurrency(BigDecimal amount, BigDecimal rate, String quotation, int round) {
        if (round == 0) {
            round = 10;
        }
        if (StringUtils.isEmpty(quotation) || amount == null || rate == null || BigDecimal.ONE.compareTo(rate) == 0 || BigDecimal.ZERO.compareTo(rate) == 0) {
            return amount;
        }
        if ("0".equals(quotation)) {
            return amount.multiply(rate).setScale(round, 4);
        }
        return amount.divide(rate, round, 4);
    }

    public Tuple<String, BigDecimal> getExchangeRateMap(Long exrateTableId, Long srcCurrencyId, Long destCurrencyId, Date exrateDate) {
        Tuple tupleDefault = Tuple.create((Object)"0", (Object)BigDecimal.ONE);
        if (srcCurrencyId == null || srcCurrencyId == 0L || destCurrencyId == null || destCurrencyId == 0L || srcCurrencyId.equals(destCurrencyId)) {
            return tupleDefault;
        }
        if (exrateDate == null) {
            exrateDate = new Date();
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String exchangeId = srcCurrencyId + "_" + destCurrencyId + "_" + exrateTableId + "_" + formatter.format(exrateDate);
        Tuple tuple = this.exchangeCache.get(exchangeId);
        if (tuple == null) {
            Map exrateMap = BaseDataServiceHelper.getExchangeRateMap((Long)srcCurrencyId, (Long)destCurrencyId, (Long)exrateTableId, (Date)exrateDate);
            if (exrateMap != null) {
                boolean quoteType = (Boolean)exrateMap.get("quoteType");
                String quotation = quoteType ? "1" : "0";
                BigDecimal exchangeRate = (BigDecimal)exrateMap.get("exchangeRate");
                tuple = Tuple.create((Object)quotation, (Object)exchangeRate);
                this.exchangeCache.put(exchangeId, (Tuple<String, BigDecimal>)tuple);
            } else {
                tuple = tupleDefault;
                this.exchangeCache.put(exchangeId, (Tuple<String, BigDecimal>)tupleDefault);
            }
        }
        return tuple;
    }
}

