/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.fcm;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.fi.fcm.ExecuteStatus;
import kd.bos.ext.fi.fcm.mservice.CheckItemDetail;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;

public class CheckExecutionResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    List<CheckResultWrapper> itemCheckResultList;

    public CheckExecutionResult() {
    }

    public CheckExecutionResult(List<CheckResultWrapper> itemCheckResultList) {
        this.itemCheckResultList = itemCheckResultList;
    }

    @Transient
    @JSONField(serialize=false)
    @JsonIgnore
    public boolean isFinalApproval() {
        return CollectionUtils.isEmpty(this.itemCheckResultList) || this.itemCheckResultList.stream().noneMatch(x -> CheckItemDetail.SUGGEST_TYPE_ERR.equals(x.getCheckItem().getSuggestType()) && (ExecuteStatus.ERROR == ((CheckResultWrapper)x).executeStatus || ExecuteStatus.FAIL == ((CheckResultWrapper)x).executeStatus));
    }

    public List<CheckResultWrapper> getItemCheckResultList() {
        return this.itemCheckResultList;
    }

    public void setItemCheckResultList(List<CheckResultWrapper> itemCheckResultList) {
        this.itemCheckResultList = itemCheckResultList;
    }

    public String toString() {
        return String.format("final decision: %s, details: %s", this.isFinalApproval(), org.apache.commons.lang3.StringUtils.join((Object[])new List[]{this.itemCheckResultList}));
    }

    public static class CheckResultWrapper
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private CheckItemDetail checkItem;
        private String onlineViewId;
        @JSONField(serialize=false)
        @JsonIgnore
        private QFilter[] billFilters;
        private ExecuteStatus executeStatus;
        private String errMsg;
        private String executionTraceId;

        public CheckResultWrapper() {
        }

        @Transient
        @JsonIgnore
        @Deprecated
        public final boolean isOnlineViewExternal() {
            return StringUtils.isNotEmpty((CharSequence)this.getOnlineViewId()) && (this.getOnlineViewId().startsWith("https://") || this.getOnlineViewId().startsWith("http://"));
        }

        public CheckResultWrapper(CheckItemDetail checkItem, ExecuteStatus executeStatus) {
            this.checkItem = checkItem;
            this.executeStatus = executeStatus;
        }

        public CheckResultWrapper(CheckItemDetail checkItem, ExecuteStatus executeStatus, String msg) {
            this(checkItem, executeStatus);
            this.errMsg = msg;
        }

        public static CheckResultWrapper error(CheckItemDetail checkItem, String errMsg) {
            CheckResultWrapper wrapper = new CheckResultWrapper(checkItem, ExecuteStatus.ERROR);
            wrapper.errMsg = errMsg;
            return wrapper;
        }

        public CheckItemDetail getCheckItem() {
            return this.checkItem;
        }

        public void setCheckItem(CheckItemDetail checkItem) {
            this.checkItem = checkItem;
        }

        public ExecuteStatus getExecuteStatus() {
            return this.executeStatus;
        }

        public void setExecuteStatus(ExecuteStatus executeStatus) {
            this.executeStatus = executeStatus;
        }

        public QFilter[] getBillFilters() {
            return this.billFilters;
        }

        public void setBillFilters(QFilter[] billFilters) {
            this.billFilters = billFilters;
        }

        public String getOnlineViewId() {
            return this.onlineViewId;
        }

        public void setOnlineViewId(String onlineViewId) {
            this.onlineViewId = onlineViewId;
        }

        public String toString() {
            return "CheckResultWrapper{checkItem=" + this.checkItem + ", onlineViewId='" + this.onlineViewId + '\'' + ", billFilters=" + Arrays.toString(this.billFilters) + ", executeStatus=" + (Object)((Object)this.executeStatus) + ", errMsg='" + this.errMsg + '\'' + ", executionTraceId='" + this.executionTraceId + '\'' + '}';
        }

        public String getErrMsg() {
            return this.errMsg;
        }

        public void setErrMsg(String errMsg) {
            this.errMsg = errMsg;
        }

        public String getExecutionTraceId() {
            return this.executionTraceId;
        }

        public void setExecutionTraceId(String executionTraceId) {
            this.executionTraceId = executionTraceId;
        }
    }
}

