/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.operation.bizrule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.ext.fi.ai.DapBuildVoucherCommonUtil;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class DapBusinessNeedDeleteVoucherOpAction
extends AbstractOpBizRuleAction {
    private static final String QUERY_SQL = "select fid,fsourcebillid,fglvoucherid from t_ai_bizvoucher where";

    public void onAddValidators(final AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                if (null != e.getValidators() && !e.getValidators().isEmpty() && DapBuildVoucherCommonUtil.getEnableBizVoucherSystemParam().booleanValue()) {
                    OperationResult result;
                    Object dyo;
                    ExtendedDataEntity[] entities = ((AbstractValidator)e.getValidators().get(0)).getDataEntities();
                    int length = entities.length;
                    ArrayList<Object> allbillids = new ArrayList<Object>(length);
                    for (ExtendedDataEntity entity : entities) {
                        dyo = entity.getDataEntity();
                        allbillids.add(dyo.get("id"));
                    }
                    ArrayList<Long> bizVoucherIIds = new ArrayList<Long>(allbillids.size());
                    HashMap<Long, Long> map = new HashMap<Long, Long>(allbillids.size());
                    SqlBuilder sqlBuilder = new SqlBuilder();
                    sqlBuilder.append(DapBusinessNeedDeleteVoucherOpAction.QUERY_SQL, new Object[0]).appendIn("fsourcebillid", allbillids);
                    DataSet queryDataSet = DB.queryDataSet((String)DapBusinessNeedDeleteVoucherOpAction.class.getName(), (DBRoute)DBRoute.of((String)"ai"), (SqlBuilder)sqlBuilder);
                    dyo = null;
                    try {
                        for (Row row : queryDataSet) {
                            Long glvoucherId = row.getLong("fglvoucherid");
                            if (glvoucherId.compareTo(0L) != 0) continue;
                            bizVoucherIIds.add(row.getLong("fid"));
                            map.put(row.getLong("fid"), row.getLong("fsourcebillid"));
                        }
                    }
                    catch (Throwable throwable) {
                        dyo = throwable;
                        throw throwable;
                    }
                    finally {
                        if (queryDataSet != null) {
                            if (dyo != null) {
                                try {
                                    queryDataSet.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)dyo).addSuppressed(throwable);
                                }
                            } else {
                                queryDataSet.close();
                            }
                        }
                    }
                    if (!bizVoucherIIds.isEmpty() && !(result = OperationServiceHelper.executeOperate((String)"delete", (String)"ai_bizvoucher", (Object[])bizVoucherIIds.toArray(), (OperateOption)OperateOption.create())).isSuccess()) {
                        List allInfo = result.getAllErrorOrValidateInfo();
                        for (IOperateInfo info : allInfo) {
                            Long bizId = (Long)info.getPkValue();
                            Long billId = (Long)map.get(bizId);
                            for (ExtendedDataEntity entity : entities) {
                                Long souceId = entity.getDataEntity().getLong("id");
                                if (billId.compareTo(souceId) != 0) continue;
                                this.addErrorMessage(entity, info.getMessage());
                            }
                        }
                    }
                }
            }
        });
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        if (e.getDataEntities().length > 0) {
            String oper = e.getOperationKey();
            HashMap<Long, Long> billAndMainOrgId = new HashMap(16);
            if (!StringUtils.isBlank((CharSequence)EntityMetadataCache.getDataEntityType((String)this.billEntityType.getName()).getMainOrg())) {
                String mainOrg = EntityMetadataCache.getDataEntityType((String)this.billEntityType.getName()).getMainOrg() + "_id";
                billAndMainOrgId = Arrays.asList(e.getDataEntities()).stream().collect(Collectors.toMap(k -> Long.parseLong(k.getString("id")), v -> v.getLong(mainOrg)));
            }
            Map<String, String> result = DapBuildVoucherCommonUtil.getBuildVoucherOptFromBill(this.billEntityType.getName());
            List<Long> allbillids = Arrays.asList(e.getDataEntities()).stream().map(v -> Long.parseLong(v.getString("id"))).collect(Collectors.toList());
            if (oper.equals("delete") || result.isEmpty()) {
                if (result.isEmpty()) {
                    DapBuildVoucherCommonUtil.executeWriteBillDBOperation(this.billEntityType.getName(), "audit", allbillids, billAndMainOrgId, DapBuildVoucherCommonUtil.executeType.DELETEWRITE);
                } else {
                    for (String op : result.keySet()) {
                        DapBuildVoucherCommonUtil.executeWriteBillDBOperation(this.billEntityType.getName(), op, allbillids, billAndMainOrgId, DapBuildVoucherCommonUtil.executeType.DELETEWRITE);
                    }
                }
            } else {
                Map<String, String> collect = result.entrySet().stream().filter(f -> f.getValue() != null).collect(Collectors.toMap(v -> (String)v.getValue(), v -> (String)v.getKey()));
                oper = collect.get(oper) != null ? collect.get(oper) : "audit";
                DapBuildVoucherCommonUtil.executeWriteBillDBOperation(this.billEntityType.getName(), oper, allbillids, billAndMainOrgId, DapBuildVoucherCommonUtil.executeType.DELETEWRITE);
            }
        }
    }
}

