/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.operation.closeperiod;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Table;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ValidateContext;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.ext.fi.gl.closeperiod.BookRegisterInfo;
import kd.bos.ext.fi.gl.closeperiod.BookRegisterService;
import kd.bos.ext.fi.gl.vo.BookVO;
import kd.bos.ext.fi.operation.closeperiod.ClosePeriodContext;
import kd.bos.ext.fi.operation.closeperiod.option.ClosePeriodOption;
import kd.bos.ext.fi.operation.closeperiod.result.ClosePeriodResultServiceHelper;
import kd.bos.ext.fi.operation.closeperiod.validator.AbstractClosePeriodValidator;
import kd.bos.ext.fi.operation.closeperiod.validator.BookInitialize;
import kd.bos.ext.fi.operation.closeperiod.validator.ClosePeriodCheckItemValidator;
import kd.bos.ext.fi.operation.closeperiod.validator.ClosePeriodLockValidator;
import kd.bos.ext.fi.operation.closeperiod.validator.IntellCheckValidator;
import kd.bos.ext.fi.operation.closeperiod.validator.ReachPeriodValidator;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.service.ServiceFactory;
import kd.bos.service.operation.EntityOperateService;
import kd.bos.service.operation.validate.ValidationService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class ClosePeriodService
extends EntityOperateService {
    private static final Log LOG = LogFactory.getLog(ClosePeriodService.class);
    private BookRegisterInfo bookRegisterInfo;
    private List<String> lockedDataList;
    private Table<Long, Long, CloseData> closeDataTable;
    private static final Set<String> UPDATE_PERIOD_APPS = ImmutableSet.of((Object)"gl", (Object)"fa", (Object)"ar", (Object)"ap");

    public void initialize(MainEntityType entityType, String operationKey, DynamicObject[] dataEntities) {
        super.initialize(entityType, operationKey, dataEntities);
        this.bookRegisterInfo = BookRegisterService.queryByBizApp(ClosePeriodOption.getBizAppNumber(this.getOption(), this.billEntityType.getBizAppNumber()));
        this.lockedDataList = new ArrayList<String>(10);
        this.closeDataTable = HashBasedTable.create();
        String closeCacheKey = this.getOption().getVariableValue("closeCacheKey", "");
        if (StringUtils.isNotEmpty((String)closeCacheKey)) {
            ClosePeriodResultServiceHelper.clear(closeCacheKey);
        }
    }

    protected void preparePropertys(List<String> fieldKeys) {
        super.preparePropertys(fieldKeys);
        fieldKeys.add(this.bookRegisterInfo.getOrgFieldOnCloseEntity());
        String bookTypeFieldOnBookMetaData = this.bookRegisterInfo.getBookTypeFieldOnCloseEntity();
        if (StringUtils.isNotEmpty((String)bookTypeFieldOnBookMetaData)) {
            fieldKeys.add(this.bookRegisterInfo.getBookTypeFieldOnCloseEntity());
        }
    }

    protected void addDefaultValidator(List<AbstractValidator> validators) {
        super.addDefaultValidator(validators);
        validators.add(new ClosePeriodLockValidator(this.lockedDataList));
        validators.add(new BookInitialize(this.closeDataTable));
        validators.add(new ReachPeriodValidator(this.closeDataTable));
        List<AbstractClosePeriodValidator> nonBlockingValidators = Arrays.asList(new AbstractClosePeriodValidator[]{new IntellCheckValidator(this.closeDataTable), new ClosePeriodCheckItemValidator(this.closeDataTable)});
        if (!this.bookRegisterInfo.isValidateBeforeTX()) {
            nonBlockingValidators.forEach(x -> x.setRunInTX(true));
        }
        validators.addAll(nonBlockingValidators);
        LOG.info("ClosePeriodService validate run before TX: {}, validators: {}. ", (Object)this.bookRegisterInfo.isValidateBeforeTX(), (Object)validators.stream().map(x -> ((Object)((Object)this)).getClass().getSimpleName()).collect(Collectors.joining(",")));
    }

    protected void callOperationTransaction(DynamicObject[] books) throws Exception {
        try (TXHandle h = TX.required((String)(this.billEntityType.getName() + "." + this.operationKey));){
            try {
                TX.addCommitListener((CommitListener)new CommitListener(){

                    public void onEnded(boolean rollbacked) {
                        if ("gl".equalsIgnoreCase(ClosePeriodService.this.bookRegisterInfo.getBizApp())) {
                            BusinessDataServiceHelper.removeCache((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"gl_openedperiod"));
                            BusinessDataServiceHelper.removeCache((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"gl_accountbook"));
                        }
                    }
                });
                super.callOperationTransaction(books);
                this.updateCurPeriodIdToNext(books);
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private Set<Object> getFailedIds() {
        return this.getOperationResult().getAllErrorOrValidateInfo().stream().filter(x -> !(x instanceof OperateErrorInfo) || !AbstractClosePeriodValidator.ClosePeriodErrorCode.SUGGESTION_0001.name().equalsIgnoreCase(((OperateErrorInfo)x).getErrorCode())).map(IOperateInfo::getPkValue).collect(Collectors.toSet());
    }

    private void updateCurPeriodIdToNext(DynamicObject[] books) {
        String bizApp;
        Set<Object> failedIds = this.getFailedIds();
        if (!failedIds.isEmpty()) {
            this.getOperationResult().setSuccess(false);
        }
        if (!UPDATE_PERIOD_APPS.contains(bizApp = this.bookRegisterInfo.getBizApp())) {
            return;
        }
        String orgProp = this.bookRegisterInfo.getOrgFieldOnCloseEntity();
        String bookTypeProp = this.bookRegisterInfo.getBookTypeFieldOnCloseEntity();
        ArrayList<Object[]> openedPeriodDeleteParams = new ArrayList<Object[]>(books.length);
        HashMap<Long, Long> curPeriodIdUpdateMap = new HashMap<Long, Long>(books.length);
        for (DynamicObject book : books) {
            if (failedIds.contains(book.getPkValue())) continue;
            long orgId = book.getLong(orgProp + ".id");
            long bookTypeId = StringUtils.isNotEmpty((String)bookTypeProp) ? book.getLong(bookTypeProp + ".id") : 0L;
            CloseData closeData = (CloseData)this.closeDataTable.get((Object)orgId, (Object)bookTypeId);
            if (Objects.requireNonNull(closeData).isGLOpenedPeriod) {
                openedPeriodDeleteParams.add(new Object[]{orgId, bookTypeId, closeData.getClosePeriodId()});
                continue;
            }
            curPeriodIdUpdateMap.put(book.getLong("id"), closeData.getNextPeriodId());
        }
        if (CollectionUtils.isNotEmpty(openedPeriodDeleteParams)) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"fi"), (String)"delete from t_gl_openedperiod where forgid = ? and fbooktypeid = ? and fperiodid = ?", openedPeriodDeleteParams);
        }
        if (!curPeriodIdUpdateMap.isEmpty()) {
            DynamicObject[] bookDyns;
            for (DynamicObject bookDyn : bookDyns = BusinessDataServiceHelper.load((Object[])curPeriodIdUpdateMap.keySet().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.bookRegisterInfo.getCloseEntityOfCloseOp()))) {
                bookDyn.set("curperiod", curPeriodIdUpdateMap.get(bookDyn.getLong("id")));
            }
            SaveServiceHelper.save((DynamicObject[])bookDyns);
        }
    }

    protected void executeOperate(DynamicObject[] books) {
        this.validateInTx(books);
    }

    private void validateInTx(DynamicObject[] books) {
        if (!this.bookRegisterInfo.isValidateBeforeTX()) {
            try (ClosePeriodContext closePeriodContext = ClosePeriodContext.create();){
                closePeriodContext.setValidateInTX(true);
                this.setDataEntities(books);
                super.validate();
            }
        }
    }

    protected ValidationService createValidationService() {
        return new ClosePeriodValidationService(this.getOperationResult());
    }

    protected void release() {
        try {
            this.releaseCloseLock();
        }
        finally {
            super.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseCloseLock() {
        if (CollectionUtils.isEmpty(this.lockedDataList)) {
            return;
        }
        List releaseParamList = this.lockedDataList.stream().map(this::buildReleaseParam).collect(Collectors.toList());
        try (DataMutex dataMutex = DataMutex.create();){
            Map releaseResults = dataMutex.batchRelease(releaseParamList);
            String failedIds = releaseResults.entrySet().stream().filter(x -> (Boolean)x.getValue() == false).map(Map.Entry::getKey).collect(Collectors.joining(","));
            if (StringUtils.isNotEmpty((String)failedIds)) {
                LOG.error("ClosePeriod release lock failed, failedIds: {}.", (Object)failedIds);
            }
        }
        catch (IOException e) {
            LOG.error("ClosePeriod release lock failed.", (Throwable)e);
        }
        finally {
            this.lockedDataList.clear();
        }
    }

    private Map<String, Object> buildReleaseParam(Object bookId) {
        HashMap<String, Object> requireParam = new HashMap<String, Object>(16);
        requireParam.put("dataObjId", bookId.toString());
        requireParam.put("dataObjNumber", bookId.toString());
        requireParam.put("groupId", this.bookRegisterInfo.getBizApp() + "_closeperiod");
        requireParam.put("entityKey", this.bookRegisterInfo.getCloseEntityOfCloseOp());
        requireParam.put("operationKey", this.bookRegisterInfo.getCloseOperationKey());
        return requireParam;
    }

    protected void writeLog(OperationResult opResult) {
        String msg;
        if (opResult.isCancelWriteLog()) {
            this.getOperateLog().info("EntityOperateService.writeLog: isCancelWriteLog");
            return;
        }
        this.getOperateLog().info("EntityOperateService.writeLog: begin");
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        IDataEntityProperty billNoProp = null;
        MainOrgProp mainOrgProp = null;
        if (this.subEntityType instanceof BasedataEntityType) {
            BasedataEntityType bdType = (BasedataEntityType)this.subEntityType;
            if (StringUtils.isNotEmpty((String)bdType.getNumberProperty())) {
                billNoProp = this.subEntityType.findProperty(bdType.getNumberProperty());
            }
            mainOrgProp = bdType.getMainOrgProperty();
        } else if (this.subEntityType instanceof BillEntityType) {
            billNoProp = this.subEntityType.findProperty(((BillEntityType)this.subEntityType).getBillNo());
            mainOrgProp = ((BillEntityType)this.subEntityType).getMainOrgProperty();
        }
        List errorInfos = opResult.getAllErrorOrValidateInfo();
        ArrayList<AppLogInfo> appLogInfoList = new ArrayList<AppLogInfo>(10);
        HashSet<Long> errorIds = new HashSet<Long>();
        if (!errorInfos.isEmpty()) {
            ExtendedDataEntity[] billDataEntitys = this.getExtendDataEntitySet().FindByEntityKey(this.subEntityType.getName());
            HashMap<Object, DynamicObject> map = new HashMap<Object, DynamicObject>(billDataEntitys.length);
            for (ExtendedDataEntity dataEntity : billDataEntitys) {
                map.put(dataEntity.getDataEntity().get("id"), dataEntity.getDataEntity());
            }
            for (IOperateInfo errorInfo : errorInfos) {
                Object value;
                Long mainOrgId = 0L;
                DynamicObject billObj = (DynamicObject)map.get(errorInfo.getPkValue());
                if (mainOrgProp != null && (value = mainOrgProp.getValue((Object)billObj)) instanceof DynamicObject) {
                    DynamicObject mainOrg = (DynamicObject)value;
                    mainOrgId = (Long)mainOrg.getPkValue();
                }
                if (StringUtils.isEmpty((String)(msg = errorInfo.getMessage()))) continue;
                String message = this.appendBookTypeName(msg, billObj);
                AppLogInfo logInfo = this.buildLogInfo(message, mainOrgId);
                appLogInfoList.add(logInfo);
                errorIds.add(billObj.getLong("id"));
            }
        }
        String orgProp = this.bookRegisterInfo.getOrgFieldOnCloseEntity();
        String bookTypeProp = this.bookRegisterInfo.getBookTypeFieldOnCloseEntity();
        Object[] periodIds = this.closeDataTable.values().stream().flatMap(x -> Stream.of(x.getClosePeriodId(), x.getNextPeriodId())).filter(Objects::nonNull).distinct().toArray();
        Map periodMap = BusinessDataServiceHelper.loadFromCache((Object[])periodIds, (String)"bd_period");
        for (DynamicObject successObj : this.getSuccessDataEntities()) {
            Object value;
            String nextPeriodName;
            if (errorIds.contains(successObj.getLong("id"))) continue;
            long orgId = successObj.getLong(orgProp + ".id");
            long bookTypeId = StringUtils.isNotEmpty((String)bookTypeProp) ? successObj.getLong(bookTypeProp + ".id") : 0L;
            CloseData closeData = (CloseData)this.closeDataTable.get((Object)orgId, (Object)bookTypeId);
            Long closePeriodId = Objects.requireNonNull(closeData).getClosePeriodId();
            Long nextPeriodId = closeData.getNextPeriodId();
            DynamicObject closePeriod = (DynamicObject)periodMap.get(closePeriodId);
            DynamicObject nextPeriod = (DynamicObject)periodMap.get(nextPeriodId);
            String closePeriodName = closePeriod == null ? "" : closePeriod.getString("name");
            String string = nextPeriodName = nextPeriod == null ? "" : nextPeriod.getString("name");
            if (opResult.isSuccess()) {
                String billNo;
                String string2 = billNo = billNoProp == null ? "" : (String)billNoProp.getValue((Object)successObj);
                msg = StringUtils.isBlank((String)billNo) ? String.format(ResManager.loadKDString((String)"%1$s\u6210\u529f\uff0c\u64cd\u4f5c\u524d\u671f\u95f4: %2$s\uff0c\u64cd\u4f5c\u540e\u671f\u95f4: %3$s", (String)"ClosePeriodService_0", (String)"bos-ext-fi", (Object[])new Object[0]), this.getOpName(), closePeriodName, nextPeriodName) : String.format(ResManager.loadKDString((String)"\u7f16\u53f7%1$s\uff0c%2$s\u6210\u529f\uff0c\u64cd\u4f5c\u524d\u671f\u95f4: %3$s\uff0c\u64cd\u4f5c\u540e\u671f\u95f4: %4$s", (String)"ClosePeriodService_1", (String)"bos-ext-fi", (Object[])new Object[0]), billNo, this.getOpName(), closePeriodName, nextPeriodName);
            } else {
                msg = String.format(ResManager.loadKDString((String)"%s\u5931\u8d25", (String)"ClosePeriodService_2", (String)"bos-ext-fi", (Object[])new Object[0]), this.getOpName());
            }
            Long mainOrgId = 0L;
            if (mainOrgProp != null && (value = mainOrgProp.getValue((Object)successObj)) instanceof DynamicObject) {
                DynamicObject mainOrg = (DynamicObject)value;
                mainOrgId = (Long)mainOrg.getPkValue();
            }
            AppLogInfo logInfo = this.buildLogInfo(msg, mainOrgId);
            appLogInfoList.add(logInfo);
        }
        if (!appLogInfoList.isEmpty()) {
            logService.addBatchLog(appLogInfoList);
        }
        opResult.setCancelWriteLog(true);
        this.getOperateLog().info("EntityOperateService.writeLog: end");
    }

    private String appendBookTypeName(String message, DynamicObject billObj) {
        if (StringUtils.isNotEmpty((String)this.bookRegisterInfo.getBookTypeFieldOnCloseEntity())) {
            return billObj.getString(this.bookRegisterInfo.getBookTypeFieldOnCloseEntity() + ".name") + ": " + message;
        }
        return message;
    }

    public static class CloseData {
        private final BookVO bookVO;
        private Long closePeriodId;
        private Long nextPeriodId;
        private boolean isGLOpenedPeriod = false;

        public CloseData(BookVO bookVO) {
            this.bookVO = bookVO;
            this.closePeriodId = bookVO.getCurPeriodId();
        }

        public BookVO getBookVO() {
            return this.bookVO;
        }

        public Long getClosePeriodId() {
            return this.closePeriodId;
        }

        public void setClosePeriodId(Long closePeriodId) {
            this.closePeriodId = closePeriodId;
        }

        public Long getNextPeriodId() {
            return this.nextPeriodId;
        }

        public void setNextPeriodId(Long nextPeriodId) {
            this.nextPeriodId = nextPeriodId;
        }

        public boolean isGLOpenedPeriod() {
            return this.isGLOpenedPeriod;
        }

        public void setGLOpenedPeriod(boolean GLOpenedPeriod) {
            this.isGLOpenedPeriod = GLOpenedPeriod;
        }
    }

    private static class ClosePeriodValidationService
    extends ValidationService {
        private final OperationResult operationResult;

        private ClosePeriodValidationService(OperationResult operationResult) {
            this.operationResult = operationResult;
        }

        public ValidateResultCollection validate(ValidateContext validateContext) {
            boolean validateInTX;
            List validators = this.getValidators();
            ArrayList originalValidators = new ArrayList(validators);
            ClosePeriodContext closePeriodContext = ClosePeriodContext.get();
            boolean bl = validateInTX = closePeriodContext != null && closePeriodContext.isValidateInTX();
            if (validateInTX) {
                validators.removeIf(x -> !(x instanceof AbstractClosePeriodValidator) || !((AbstractClosePeriodValidator)((Object)x)).isRunInTX());
            } else {
                validators.removeIf(x -> x instanceof AbstractClosePeriodValidator && ((AbstractClosePeriodValidator)((Object)x)).isRunInTX());
            }
            ValidateResultCollection validateResultCollection = super.validate(validateContext);
            for (AbstractValidator validator : validators) {
                if (!(validator instanceof AbstractClosePeriodValidator)) continue;
                ((AbstractClosePeriodValidator)validator).getSuggestions().forEach(x -> this.operationResult.getAllErrorInfo().add(x));
            }
            this.getValidators().clear();
            this.getValidators().addAll(originalValidators);
            return validateResultCollection;
        }
    }
}

