/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.plugin.ArApConvert;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.InitVariableEventArgs;
import kd.bos.ext.fi.plugin.ArApConvert.ArApConvertHelper;
import kd.bos.ext.fi.plugin.ArApConvert.AsstactConvertHelper;
import kd.bos.ext.fi.plugin.ArApConvert.BookDateHelper;
import kd.bos.ext.fi.plugin.ArApConvert.InitConvertHelper;
import kd.bos.ext.fi.plugin.ArApConvert.InitServiceHelper;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.ArPlanSplitAndBuilder;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.PlanSplitSchemeServiceHelper;
import kd.bos.ext.fi.plugin.ArApConvert.TaxCodeConvertHelper;
import kd.bos.ext.fi.plugin.ArApConvert.helper.BOTPHelper;
import kd.bos.ext.fi.util.QueryUtil;
import kd.bos.ext.fi.util.price.AbstractPriceCalculator;
import kd.bos.ext.fi.util.price.PriceLocalCalculator;
import kd.bos.ext.fi.util.price.PriceTaxTotalCalculator;
import kd.bos.ext.fi.util.price.PriceTotalCalculator;
import kd.bos.ext.fi.util.price.TaxUnitPriceCalculator;
import kd.bos.ext.fi.util.price.UnitPriceCalculator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class BillToFinArConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log logger = LogFactory.getLog(BillToFinArConvertPlugin.class);
    private Map<Long, DynamicObject> orgInitMap;
    private DynamicObject[] needMatchSplitSchemes;
    private final Map<Long, Boolean> orgIsTaxMap = new HashMap<Long, Boolean>(1);
    private final List<Object> bizPartnerIds = new ArrayList<Object>(8);
    private final QueryUtil queryUtil = new QueryUtil();
    private final Map<Long, List<DynamicObject>> detailEntriesCache = new HashMap<Long, List<DynamicObject>>(1);
    private final Set<String> noRecalculateFieldKeys = Stream.of("e_unitprice", "e_taxunitprice", "e_actunitprice", "e_acttaxunitprice", "e_amount", "e_localamt", "e_tax", "e_taxlocalamt", "e_recamount", "e_reclocalamt", "e_discountamount", "e_discountlocalamt", "e_adjustamount", "e_adjustlocalamt").collect(Collectors.toSet());
    private Map<String, Boolean> ruleIsSettingMap = new HashMap<String, Boolean>(8);
    private final Map<Long, String> noRecalculateSrcEntryIdMap = new HashMap<Long, String>(8);

    public void initVariable(InitVariableEventArgs e) {
    }

    public void afterConvert(AfterConvertEventArgs e) {
        logger.info("BillToFinArConvertPlugin.afterConvert start");
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] extendEntites = entitySet.FindByEntityKey(this.getTgtMainType().getExtendName());
        ArrayList<DynamicObject> entities = new ArrayList<DynamicObject>(extendEntites.length);
        for (ExtendedDataEntity extendEntity : extendEntites) {
            entities.add(extendEntity.getDataEntity());
        }
        this.prepareData(entities);
        for (DynamicObject finArBill : entities) {
            DynamicObject org = finArBill.getDynamicObject("org");
            if (ObjectUtils.isEmpty((Object)org)) {
                return;
            }
            InitServiceHelper.checkOrgInit(org, this.orgInitMap, true);
            this.setHeadValue(finArBill);
            this.setDetailEntryValue(finArBill);
        }
        for (DynamicObject finArBill : entities) {
            this.setHeadAmtValue(finArBill);
            this.setPlanEntryValue(finArBill);
        }
        BookDateHelper.setBookDate(entities.toArray(new DynamicObject[0]), true);
        logger.info("BillToFinArConvertPlugin.afterConvert end");
    }

    private void prepareData(List<DynamicObject> entities) {
        logger.info("BillToFinArConvertPlugin.prepareData start");
        HashSet<Long> orgIds = new HashSet<Long>(1);
        HashMap<String, List> asstactTypeToAsstactIdMap = new HashMap<String, List>(8);
        AsstactConvertHelper.checkAsstactType(entities);
        for (DynamicObject dynamicObject : entities) {
            List asstactIds = asstactTypeToAsstactIdMap.computeIfAbsent(dynamicObject.getString("asstacttype"), c -> new ArrayList(8));
            asstactIds.add(dynamicObject.getLong("asstact.id"));
            long orgId = dynamicObject.getLong("org.id");
            if (orgId == 0L) continue;
            orgIds.add(orgId);
        }
        this.orgInitMap = InitServiceHelper.loadInitInfos(orgIds, true);
        for (Long l : orgIds) {
            this.orgIsTaxMap.put(l, TaxCodeConvertHelper.isNeedTax(l, true));
        }
        for (Map.Entry entry : asstactTypeToAsstactIdMap.entrySet()) {
            this.bizPartnerIds.addAll(ArApConvertHelper.getBizPartnerIds((String)entry.getKey(), (List)entry.getValue()));
        }
        this.needMatchSplitSchemes = PlanSplitSchemeServiceHelper.getMatchSchemes("ar_finarbill");
        this.buildNoRecalculateInfo();
        logger.info("BillToFinArConvertPlugin.prepareData end");
    }

    private void setHeadValue(DynamicObject finArBill) {
        logger.info("BillToFinArConvertPlugin.setHeadValue start");
        DynamicObject org = finArBill.getDynamicObject("org");
        InitServiceHelper.setBizDate(finArBill, this.orgInitMap.get(org.getLong("id")), this.getRule());
        boolean isSettingForExchange = BOTPHelper.ruleIsSetting(this.getRule(), true, "exchangerate");
        InitServiceHelper.setInitValue(finArBill, this.orgInitMap.get(org.getLong("id")), isSettingForExchange);
        DynamicObject recorg = finArBill.getDynamicObject("recorg");
        if (ObjectUtils.isEmpty((Object)recorg) || !recorg.getBoolean("fisbankroll")) {
            finArBill.set("recorg", (Object)org);
            recorg = org;
        }
        if (!ObjectUtils.isEmpty((Object)recorg) && !recorg.getBoolean("fisbankroll")) {
            finArBill.set("recorg", null);
        }
        finArBill.set("relationpay", (Object)this.bizPartnerIds.contains(finArBill.getLong("asstact.id")));
        logger.info("BillToFinArConvertPlugin.setHeadValue end");
    }

    private void setDetailEntryValue(DynamicObject finArBill) {
        logger.info("BillToFinArConvertPlugin.setDetailEntryValue start");
        boolean needTax = this.orgIsTaxMap.get(finArBill.getLong("org.id"));
        this.calculateDetailEntry(finArBill);
        if (needTax) {
            logger.info("BillToFinArConvertPlugin.setDetailEntryValue needTax");
            TaxCodeConvertHelper.setDetailEntryTax(finArBill);
            this.calculateDetailEntry(finArBill);
        }
        if (this.isPushAndSave(finArBill)) {
            List<DynamicObject> detailEntries = this.detailEntriesCache.get(finArBill.getLong("id"));
            if (detailEntries == null) {
                ArrayList finArDetailEntries = new ArrayList(8);
                finArDetailEntries.addAll(finArBill.getDynamicObjectCollection("entry"));
                this.detailEntriesCache.put(finArBill.getLong("id"), finArDetailEntries);
            } else {
                detailEntries.addAll((Collection<DynamicObject>)finArBill.getDynamicObjectCollection("entry"));
            }
        }
        logger.info("BillToFinArConvertPlugin.setDetailEntryValue end");
    }

    private void setHeadAmtValue(DynamicObject finArBill) {
        logger.info("BillToFinArConvertPlugin.setHeadAmtValue start");
        BigDecimal priceTaxTotal = BigDecimal.ZERO;
        BigDecimal priceTaxTotalBase = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal amountBase = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal taxLocAmt = BigDecimal.ZERO;
        BigDecimal adjustamt = BigDecimal.ZERO;
        BigDecimal adjustamtlocal = BigDecimal.ZERO;
        Object detailEntries = this.isPushAndSave(finArBill) ? this.detailEntriesCache.get(finArBill.getLong("id")) : finArBill.getDynamicObjectCollection("entry");
        for (DynamicObject detailEntry : detailEntries) {
            priceTaxTotal = priceTaxTotal.add(detailEntry.getBigDecimal("e_recamount"));
            priceTaxTotalBase = priceTaxTotalBase.add(detailEntry.getBigDecimal("e_reclocalamt"));
            amount = amount.add(detailEntry.getBigDecimal("e_amount"));
            amountBase = amountBase.add(detailEntry.getBigDecimal("e_localamt"));
            tax = tax.add(detailEntry.getBigDecimal("e_tax"));
            taxLocAmt = taxLocAmt.add(detailEntry.getBigDecimal("e_taxlocalamt"));
            adjustamt = adjustamt.add(detailEntry.getBigDecimal("e_adjustamount"));
            adjustamtlocal = adjustamtlocal.add(detailEntry.getBigDecimal("e_adjustlocalamt"));
        }
        finArBill.set("recamount", (Object)priceTaxTotal);
        finArBill.set("reclocalamt", (Object)priceTaxTotalBase);
        finArBill.set("amount", (Object)amount);
        finArBill.set("localamt", (Object)amountBase);
        finArBill.set("tax", (Object)tax);
        finArBill.set("taxlocamt", (Object)taxLocAmt);
        finArBill.set("unverifyamount", (Object)amount);
        finArBill.set("unsettleamount", (Object)priceTaxTotal);
        finArBill.set("unsettlelocalamt", (Object)priceTaxTotalBase);
        finArBill.set("adjustamount", (Object)adjustamt);
        finArBill.set("adjustlocalamt", (Object)adjustamtlocal);
        finArBill.set("uninvoicedamt", (Object)priceTaxTotal);
        finArBill.set("uninvoicedlocalamt", (Object)priceTaxTotalBase);
        logger.info("BillToFinArConvertPlugin.setHeadAmtValue end");
    }

    private void setPlanEntryValue(DynamicObject finArBill) {
        logger.info("BillToFinArConvertPlugin.setPlanEntryValue start");
        DynamicObject matchSplitScheme = PlanSplitSchemeServiceHelper.matchSingleScheme(finArBill, this.needMatchSplitSchemes);
        finArBill.set("splitscheme", (Object)matchSplitScheme);
        if (this.isPushAndSave(finArBill)) {
            this.calculatePlanEntryByPushAndSave(finArBill, matchSplitScheme);
        } else {
            ArPlanSplitAndBuilder.splitAndBuild(finArBill, matchSplitScheme);
        }
        this.setHeadDueDate(finArBill);
        logger.info("BillToFinArConvertPlugin.setPlanEntryValue end");
    }

    private void calculatePlanEntryByPushAndSave(DynamicObject finArBill, DynamicObject matchSplitScheme) {
        DynamicObject[] dbFinArBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"e_splitdimensionid,planentity.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)finArBill.getLong("id"))});
        if (dbFinArBills == null || dbFinArBills.length == 0) {
            ArPlanSplitAndBuilder.splitAndBuild(finArBill, matchSplitScheme);
        } else {
            DynamicObject dbFinArBill = dbFinArBills[0];
            List<DynamicObject> detailEntries = this.detailEntriesCache.get(finArBill.getLong("id"));
            Map<Integer, Integer> detailEntryIndexToSplitDimensionId = ArPlanSplitAndBuilder.splitAndBuildByPushAndSave(finArBill, detailEntries, matchSplitScheme);
            DynamicObjectCollection dbDetailEntries = dbFinArBill.getDynamicObjectCollection("entry");
            DynamicObjectCollection curDetailEntries = finArBill.getDynamicObjectCollection("entry");
            int dbDetailEntrySize = dbDetailEntries.size();
            for (int i = 0; i < dbDetailEntrySize; ++i) {
                DynamicObject dbDetailEntry = (DynamicObject)dbDetailEntries.get(i);
                dbDetailEntry.set("e_splitdimensionid", (Object)detailEntryIndexToSplitDimensionId.get(i));
            }
            int curDetailEntrySize = curDetailEntries.size();
            for (int i = 0; i < curDetailEntrySize; ++i) {
                DynamicObject curDetailEntry = (DynamicObject)curDetailEntries.get(i);
                curDetailEntry.set("e_splitdimensionid", (Object)detailEntryIndexToSplitDimensionId.get(i + dbDetailEntrySize));
            }
            DynamicObjectCollection dbPlanEntries = dbFinArBill.getDynamicObjectCollection("planentity");
            dbPlanEntries.clear();
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dbFinArBill});
        }
    }

    private void setHeadDueDate(DynamicObject finArBill) {
        Date planMaxDuedate = finArBill.getDate("duedate");
        DynamicObjectCollection planEntries = finArBill.getDynamicObjectCollection("planentity");
        for (DynamicObject planEntry : planEntries) {
            Date planEntryDueDate = planEntry.getDate("planduedate");
            if (planMaxDuedate == null) {
                planMaxDuedate = planEntryDueDate;
                continue;
            }
            if (planEntryDueDate == null) continue;
            planMaxDuedate = planEntryDueDate.after(planMaxDuedate) ? planEntryDueDate : planMaxDuedate;
        }
        finArBill.set("duedate", (Object)planMaxDuedate);
    }

    private boolean isPushAndSave(DynamicObject finArBill) {
        return BOTPHelper.isPushAndSave(this.getRule(), finArBill);
    }

    private void calculateDetailEntry(DynamicObject finArBill) {
        boolean isbasedonamt = finArBill.getBoolean("payproperty.isbasedonamt");
        DynamicObject bascur = finArBill.getDynamicObject("basecurrency");
        int baseprecision = bascur.getInt("amtprecision");
        int precision = finArBill.getInt("currency.amtprecision");
        boolean includeTax = finArBill.getBoolean("isincludetax");
        boolean ispricetotal = finArBill.getBoolean("ispricetotal");
        String quotation = finArBill.getString("quotation");
        BigDecimal exchangeRate = finArBill.getBigDecimal("exchangerate");
        if (exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
            quotation = "0";
        }
        String srcMainTypeName = this.getSrcMainType().getExtendName();
        boolean srcBillIsBusAr = "ar_busbill".equals(srcMainTypeName);
        DynamicObjectCollection detailEntries = finArBill.getDynamicObjectCollection("entry");
        for (DynamicObject detailEntry : detailEntries) {
            BigDecimal e_baseunitqty;
            BigDecimal covertRate;
            AbstractPriceCalculator calculator;
            BigDecimal discountAmt;
            boolean isPresent = detailEntry.getBoolean("e_ispresent");
            BigDecimal price = detailEntry.getBigDecimal("e_unitprice");
            BigDecimal priceTax = detailEntry.getBigDecimal("e_taxunitprice");
            if (isbasedonamt && isPresent || ispricetotal && isPresent && (BigDecimal.ZERO.compareTo(price) != 0 || BigDecimal.ZERO.compareTo(priceTax) != 0)) {
                BigDecimal e_baseunitqty2;
                BigDecimal covertRate2;
                BigDecimal quantity = detailEntry.getBigDecimal("e_quantity");
                if (quantity == null) {
                    quantity = BigDecimal.ZERO;
                }
                boolean covertRateIsEmpty = (covertRate2 = detailEntry.getBigDecimal("e_unitcoefficient")) == null || covertRate2.compareTo(BigDecimal.ZERO) == 0;
                DynamicObject material = detailEntry.getDynamicObject("e_material");
                DynamicObject measureUnit = detailEntry.getDynamicObject("e_measureunit");
                DynamicObject baseUnit = detailEntry.getDynamicObject("e_baseunit");
                if (!ObjectUtils.isEmpty((Object)material)) {
                    if (ObjectUtils.isEmpty((Object)baseUnit)) {
                        baseUnit = material.getDynamicObject("baseunit");
                        detailEntry.set("e_baseunit", (Object)baseUnit);
                    }
                    if (measureUnit == null) {
                        measureUnit = baseUnit;
                    }
                    if (covertRateIsEmpty) {
                        covertRate2 = this.queryUtil.getConvertRate(material.getLong("id"), measureUnit.getLong("id"), baseUnit.getLong("id"));
                    }
                } else if (covertRateIsEmpty) {
                    covertRate2 = BigDecimal.ONE;
                }
                if (covertRateIsEmpty) {
                    detailEntry.set("e_unitcoefficient", (Object)covertRate2);
                }
                if ((e_baseunitqty2 = detailEntry.getBigDecimal("e_baseunitqty")) == null || e_baseunitqty2.compareTo(BigDecimal.ZERO) == 0) {
                    e_baseunitqty2 = InitConvertHelper.getBaseunitqty(quantity, covertRate2, baseUnit);
                    detailEntry.set("e_baseunitqty", (Object)e_baseunitqty2);
                }
                detailEntry.set("e_unconfirmqty", (Object)quantity);
                detailEntry.set("e_unconfirmbaseqty", (Object)e_baseunitqty2);
                detailEntry.set("e_unverifyqty", (Object)quantity);
                detailEntry.set("e_uninvoicedqty", (Object)quantity);
                BigDecimal e_unverifybaseqty = detailEntry.getBigDecimal("e_unverifybaseqty");
                if (e_unverifybaseqty == null || e_unverifybaseqty.compareTo(BigDecimal.ZERO) == 0) {
                    detailEntry.set("e_unverifybaseqty", (Object)InitConvertHelper.getBaseunitqty(detailEntry.getBigDecimal("e_unverifyqty"), covertRate2, baseUnit));
                }
                BigDecimal e_discountamount = detailEntry.getBigDecimal("e_discountamount");
                BigDecimal e_discountlocalamt = this.getLocalAmt(e_discountamount, quotation, exchangeRate, baseprecision);
                detailEntry.set("e_discountlocalamt", (Object)e_discountlocalamt);
                this.reSetPresentAmountField(detailEntry, isPresent);
                continue;
            }
            Long e_sourcebillentryid = detailEntry.getLong("e_srcentryid");
            String noRecalculate = this.noRecalculateSrcEntryIdMap.getOrDefault(e_sourcebillentryid, "false");
            BigDecimal qty = detailEntry.getBigDecimal("e_quantity");
            BigDecimal taxRate = detailEntry.getBigDecimal("e_taxrate");
            String discountMode = detailEntry.getString("e_discountmode");
            BigDecimal discountRate = detailEntry.getBigDecimal("e_discountrate");
            BigDecimal eAdjustamount = detailEntry.getBigDecimal("e_adjustamount");
            if (isbasedonamt && srcBillIsBusAr) {
                if ("PERUNIT".equals(discountMode) && BigDecimal.ZERO.compareTo(detailEntry.getBigDecimal("e_taxunitprice")) != 0) {
                    discountMode = "PERCENT";
                    detailEntry.set("e_discountmode", (Object)discountMode);
                    discountRate = includeTax ? discountRate.multiply(new BigDecimal(100)).divide(detailEntry.getBigDecimal("e_taxunitprice"), 4, RoundingMode.HALF_UP) : detailEntry.getBigDecimal("e_discountamount").multiply(new BigDecimal(100)).divide(detailEntry.getBigDecimal("e_taxunitprice"), 4, RoundingMode.HALF_UP);
                    if (BigDecimal.ZERO.compareTo(discountRate) > 0) {
                        discountRate = discountRate.negate();
                    }
                    detailEntry.set("e_discountrate", (Object)discountRate);
                }
                if (includeTax) {
                    if ("TOTAL".equals(discountMode) && discountRate.compareTo(BigDecimal.ZERO) != 0) {
                        if ("true".equals(noRecalculate)) {
                            if (!this.ruleIsSettingMap.getOrDefault("e_discountamount", false).booleanValue()) {
                                detailEntry.set("e_discountamount", (Object)discountRate.multiply(qty).setScale(precision, RoundingMode.HALF_UP));
                            }
                        } else {
                            detailEntry.set("e_discountamount", (Object)discountRate.multiply(qty).setScale(precision, RoundingMode.HALF_UP));
                        }
                    }
                    discountAmt = detailEntry.getBigDecimal("e_discountamount");
                    BigDecimal e_pricetaxtotal = detailEntry.getBigDecimal("e_recamount");
                    calculator = new PriceTaxTotalCalculator(qty, e_pricetaxtotal, taxRate, discountMode, discountRate, precision, eAdjustamount, includeTax, discountAmt);
                } else {
                    if ("TOTAL".equals(discountMode) && discountRate.compareTo(BigDecimal.ZERO) != 0) {
                        if ("true".equals(noRecalculate)) {
                            if (!this.ruleIsSettingMap.getOrDefault("e_discountamount", false).booleanValue()) {
                                detailEntry.set("e_discountamount", (Object)discountRate.multiply(qty).multiply(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L)))).setScale(precision, RoundingMode.HALF_UP));
                            }
                        } else {
                            detailEntry.set("e_discountamount", (Object)discountRate.multiply(qty).multiply(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L)))).setScale(precision, RoundingMode.HALF_UP));
                        }
                    }
                    discountAmt = detailEntry.getBigDecimal("e_discountamount");
                    BigDecimal e_amount = detailEntry.getBigDecimal("e_amount");
                    calculator = new PriceTotalCalculator(qty, e_amount, taxRate, discountMode, discountRate, precision, eAdjustamount, discountAmt);
                }
            } else if (includeTax) {
                if ("TOTAL".equals(discountMode) && discountRate.compareTo(BigDecimal.ZERO) != 0) {
                    if ("true".equals(noRecalculate)) {
                        if (!this.ruleIsSettingMap.getOrDefault("e_discountamount", false).booleanValue()) {
                            detailEntry.set("e_discountamount", (Object)discountRate.multiply(qty).setScale(precision, RoundingMode.HALF_UP));
                        }
                    } else {
                        detailEntry.set("e_discountamount", (Object)discountRate.multiply(qty).setScale(precision, RoundingMode.HALF_UP));
                    }
                }
                discountAmt = detailEntry.getBigDecimal("e_discountamount");
                if (ispricetotal) {
                    BigDecimal entryRecamount = detailEntry.getBigDecimal("e_recamount");
                    calculator = new PriceTaxTotalCalculator(qty, entryRecamount, taxRate, discountMode, discountRate, precision, eAdjustamount, discountAmt);
                } else {
                    BigDecimal taxUnitPrice = detailEntry.getBigDecimal("e_taxunitprice");
                    calculator = new TaxUnitPriceCalculator(qty, taxUnitPrice, taxRate, discountMode, discountRate, precision, eAdjustamount, discountAmt);
                }
            } else {
                if ("TOTAL".equals(discountMode) && discountRate.compareTo(BigDecimal.ZERO) != 0) {
                    if ("true".equals(noRecalculate)) {
                        if (!this.ruleIsSettingMap.getOrDefault("e_discountamount", false).booleanValue()) {
                            detailEntry.set("e_discountamount", (Object)discountRate.multiply(qty).multiply(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L)))).setScale(precision, RoundingMode.HALF_UP));
                        }
                    } else {
                        detailEntry.set("e_discountamount", (Object)discountRate.multiply(qty).multiply(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L)))).setScale(precision, RoundingMode.HALF_UP));
                    }
                }
                discountAmt = detailEntry.getBigDecimal("e_discountamount");
                if (ispricetotal) {
                    BigDecimal entryAmount = detailEntry.getBigDecimal("e_amount");
                    calculator = new PriceTotalCalculator(qty, entryAmount, taxRate, discountMode, discountRate, precision, eAdjustamount, discountAmt);
                } else {
                    BigDecimal unitPrice = detailEntry.getBigDecimal("e_unitprice");
                    calculator = new UnitPriceCalculator(qty, unitPrice, taxRate, discountMode, discountRate, precision, eAdjustamount, discountAmt);
                }
            }
            PriceLocalCalculator localCalculator = new PriceLocalCalculator(calculator, exchangeRate, baseprecision, quotation);
            localCalculator.calculate();
            BigDecimal quantity = detailEntry.getBigDecimal("e_quantity");
            if (quantity == null) {
                quantity = BigDecimal.ZERO;
            }
            boolean covertRateIsEmpty = (covertRate = detailEntry.getBigDecimal("e_unitcoefficient")) == null || covertRate.compareTo(BigDecimal.ZERO) == 0;
            DynamicObject material = detailEntry.getDynamicObject("e_material");
            DynamicObject measureUnit = detailEntry.getDynamicObject("e_measureunit");
            DynamicObject baseUnit = detailEntry.getDynamicObject("e_baseunit");
            if (!ObjectUtils.isEmpty((Object)material)) {
                if (ObjectUtils.isEmpty((Object)baseUnit)) {
                    baseUnit = material.getDynamicObject("baseunit");
                    detailEntry.set("e_baseunit", (Object)baseUnit);
                }
                if (measureUnit == null) {
                    measureUnit = baseUnit;
                }
                if (covertRateIsEmpty) {
                    covertRate = this.queryUtil.getConvertRate(material.getLong("id"), measureUnit.getLong("id"), baseUnit.getLong("id"));
                }
            } else if (covertRateIsEmpty) {
                covertRate = BigDecimal.ONE;
            }
            if (covertRateIsEmpty) {
                detailEntry.set("e_unitcoefficient", (Object)covertRate);
            }
            if ((e_baseunitqty = detailEntry.getBigDecimal("e_baseunitqty")) == null || e_baseunitqty.compareTo(BigDecimal.ZERO) == 0) {
                e_baseunitqty = InitConvertHelper.getBaseunitqty(quantity, covertRate, baseUnit);
                detailEntry.set("e_baseunitqty", (Object)e_baseunitqty);
            }
            if ("true".equals(noRecalculate)) {
                if (!this.ruleIsSettingMap.getOrDefault("e_unitprice", false).booleanValue()) {
                    detailEntry.set("e_unitprice", (Object)localCalculator.getUnitprice());
                }
                if (!this.ruleIsSettingMap.getOrDefault("e_taxunitprice", false).booleanValue()) {
                    detailEntry.set("e_taxunitprice", (Object)localCalculator.getTaxunitprice());
                }
                if (!this.ruleIsSettingMap.getOrDefault("e_actunitprice", false).booleanValue()) {
                    detailEntry.set("e_actunitprice", (Object)localCalculator.getActunitprice());
                }
                if (!this.ruleIsSettingMap.getOrDefault("e_acttaxunitprice", false).booleanValue()) {
                    detailEntry.set("e_acttaxunitprice", (Object)localCalculator.getActtaxunitprice());
                }
                if (!this.ruleIsSettingMap.getOrDefault("e_amount", false).booleanValue()) {
                    detailEntry.set("e_amount", (Object)localCalculator.getAmount());
                }
                if (!this.ruleIsSettingMap.getOrDefault("e_localamt", false).booleanValue()) {
                    detailEntry.set("e_localamt", (Object)localCalculator.getAmountlocal());
                }
                if (!this.ruleIsSettingMap.getOrDefault("e_tax", false).booleanValue()) {
                    detailEntry.set("e_tax", (Object)localCalculator.getTax());
                }
                if (!this.ruleIsSettingMap.getOrDefault("e_taxlocalamt", false).booleanValue()) {
                    detailEntry.set("e_taxlocalamt", (Object)localCalculator.getTaxlocal());
                }
                if (!this.ruleIsSettingMap.getOrDefault("e_recamount", false).booleanValue()) {
                    detailEntry.set("e_recamount", (Object)localCalculator.getPricetaxtotal());
                }
                if (!this.ruleIsSettingMap.getOrDefault("e_reclocalamt", false).booleanValue()) {
                    detailEntry.set("e_reclocalamt", (Object)localCalculator.getPricetaxtotallocal());
                }
                if (!this.ruleIsSettingMap.getOrDefault("e_discountamount", false).booleanValue()) {
                    detailEntry.set("e_discountamount", (Object)localCalculator.getDiscountamount());
                }
                if (!this.ruleIsSettingMap.getOrDefault("e_discountlocalamt", false).booleanValue()) {
                    detailEntry.set("e_discountlocalamt", (Object)localCalculator.getDiscountamountlocal());
                }
                if (!this.ruleIsSettingMap.getOrDefault("e_adjustamount", false).booleanValue()) {
                    detailEntry.set("e_adjustamount", (Object)localCalculator.getAdjustamt());
                }
                if (!this.ruleIsSettingMap.getOrDefault("e_adjustlocalamt", false).booleanValue()) {
                    detailEntry.set("e_adjustlocalamt", (Object)localCalculator.getAdjustamtlocal());
                }
            } else {
                detailEntry.set("e_unitprice", (Object)localCalculator.getUnitprice());
                detailEntry.set("e_taxunitprice", (Object)localCalculator.getTaxunitprice());
                detailEntry.set("e_actunitprice", (Object)localCalculator.getActunitprice());
                detailEntry.set("e_acttaxunitprice", (Object)localCalculator.getActtaxunitprice());
                detailEntry.set("e_amount", (Object)localCalculator.getAmount());
                detailEntry.set("e_localamt", (Object)localCalculator.getAmountlocal());
                detailEntry.set("e_tax", (Object)localCalculator.getTax());
                detailEntry.set("e_taxlocalamt", (Object)localCalculator.getTaxlocal());
                detailEntry.set("e_recamount", (Object)localCalculator.getPricetaxtotal());
                detailEntry.set("e_reclocalamt", (Object)localCalculator.getPricetaxtotallocal());
                detailEntry.set("e_discountamount", (Object)localCalculator.getDiscountamount());
                detailEntry.set("e_discountlocalamt", (Object)localCalculator.getDiscountamountlocal());
                detailEntry.set("e_adjustamount", (Object)localCalculator.getAdjustamt());
                detailEntry.set("e_adjustlocalamt", (Object)localCalculator.getAdjustamtlocal());
            }
            this.reSetPresentAmountField(detailEntry, isPresent);
            BigDecimal e_recAmount = detailEntry.getBigDecimal("e_recamount");
            BigDecimal e_reclocalamt = detailEntry.getBigDecimal("e_reclocalamt");
            BigDecimal e_amount = detailEntry.getBigDecimal("e_amount");
            detailEntry.set("e_unverifyamt", (Object)e_amount);
            detailEntry.set("e_unlockamt", (Object)e_recAmount);
            detailEntry.set("e_unsettleamt", (Object)e_recAmount);
            detailEntry.set("e_unsettlelocalamt", (Object)e_reclocalamt);
            detailEntry.set("e_unconfirmamt", (Object)e_amount);
            detailEntry.set("e_uninvoicedamt", (Object)e_recAmount);
            detailEntry.set("e_uninvoicedlocalamt", (Object)e_reclocalamt);
            detailEntry.set("e_unconfirmqty", (Object)quantity);
            detailEntry.set("e_unconfirmbaseqty", (Object)e_baseunitqty);
            detailEntry.set("e_unverifyqty", (Object)quantity);
            detailEntry.set("e_uninvoicedqty", (Object)quantity);
            BigDecimal e_unverifybaseqty = detailEntry.getBigDecimal("e_unverifybaseqty");
            if (e_unverifybaseqty != null && e_unverifybaseqty.compareTo(BigDecimal.ZERO) != 0) continue;
            detailEntry.set("e_unverifybaseqty", (Object)InitConvertHelper.getBaseunitqty(detailEntry.getBigDecimal("e_unverifyqty"), covertRate, baseUnit));
        }
    }

    private void reSetPresentAmountField(DynamicObject detailEntry, boolean isPresent) {
        if (isPresent) {
            detailEntry.set("e_actunitprice", (Object)BigDecimal.ZERO);
            detailEntry.set("e_acttaxunitprice", (Object)BigDecimal.ZERO);
            detailEntry.set("e_amount", (Object)BigDecimal.ZERO);
            detailEntry.set("e_localamt", (Object)BigDecimal.ZERO);
            detailEntry.set("e_tax", (Object)BigDecimal.ZERO);
            detailEntry.set("e_taxlocalamt", (Object)BigDecimal.ZERO);
            detailEntry.set("e_recamount", (Object)BigDecimal.ZERO);
            detailEntry.set("e_reclocalamt", (Object)BigDecimal.ZERO);
            detailEntry.set("e_adjustamount", (Object)BigDecimal.ZERO);
            detailEntry.set("e_adjustlocalamt", (Object)BigDecimal.ZERO);
            detailEntry.set("e_unverifyamt", (Object)BigDecimal.ZERO);
            detailEntry.set("e_unlockamt", (Object)BigDecimal.ZERO);
            detailEntry.set("e_unsettleamt", (Object)BigDecimal.ZERO);
            detailEntry.set("e_unsettlelocalamt", (Object)BigDecimal.ZERO);
            detailEntry.set("e_unconfirmamt", (Object)BigDecimal.ZERO);
            detailEntry.set("e_uninvoicedamt", (Object)BigDecimal.ZERO);
            detailEntry.set("e_uninvoicedlocalamt", (Object)BigDecimal.ZERO);
        }
    }

    private BigDecimal getLocalAmt(BigDecimal amount, String quotation, BigDecimal exchange, int precision) {
        if ("1".equals(quotation)) {
            return amount.divide(exchange, precision, RoundingMode.HALF_UP);
        }
        return amount.multiply(exchange).setScale(precision, RoundingMode.HALF_UP);
    }

    private void buildNoRecalculateInfo() {
        Map variables = this.getOption().getVariables();
        String noRecalculateSrcEntryIds = (String)variables.get("noRecalculateSrcEntryIds");
        if (!ObjectUtils.isEmpty((Object)noRecalculateSrcEntryIds)) {
            List noRecalculateSrcEntryIdList = (List)SerializationUtils.fromJsonString((String)noRecalculateSrcEntryIds, List.class);
            for (Long entryId : noRecalculateSrcEntryIdList) {
                this.noRecalculateSrcEntryIdMap.put(entryId, "true");
            }
            this.ruleIsSettingMap = BOTPHelper.ruleIsSetting(this.getRule(), false, this.noRecalculateFieldKeys);
            logger.info("ruleIsSettingMap\uff1a" + this.ruleIsSettingMap.toString());
        }
    }
}

