/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.plugin.ArApConvert;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.ext.fi.plugin.ArApConvert.InitConvertHelper;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.FinPlanRowService;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.PlanRow;
import kd.bos.ext.fi.util.price.AbstractPriceCalculator;
import kd.bos.ext.fi.util.price.PriceLocalCalculator;
import kd.bos.ext.fi.util.price.TaxUnitPriceCalculator;
import kd.bos.ext.fi.util.price.UnitPriceCalculator;
import kd.bos.util.StringUtils;

@Deprecated
public class FinArDisposeDuePlanPlugin
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] entities;
        BillEntityType srcMainType = this.getSrcMainType();
        String srcMainTypeName = srcMainType.getExtendName();
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        for (ExtendedDataEntity entity : entities = entitySet.FindByEntityKey("ar_finarbill")) {
            DynamicObject finArBill = entity.getDataEntity();
            DynamicObject org = finArBill.getDynamicObject("org");
            finArBill.set("recorg", (Object)org);
            DynamicObject recorg = finArBill.getDynamicObject("recorg");
            if (!ObjectUtils.isEmpty((Object)recorg) && !recorg.getBoolean("fisbankroll")) {
                finArBill.set("recorg", null);
            }
            if (ObjectUtils.isEmpty((Object)org)) {
                return;
            }
            InitConvertHelper.checkExRate(this.getRule(), finArBill);
            new InitConvertHelper(org, "ar_init", finArBill, srcMainTypeName);
            DynamicObject bascur = finArBill.getDynamicObject("basecurrency");
            int baseprecision = bascur.getInt("amtprecision");
            int precision = finArBill.getInt("currency.amtprecision");
            if (StringUtils.isEmpty((String)finArBill.getString("duedate"))) {
                finArBill.set("duedate", (Object)new Date());
            }
            BigDecimal recAmount = BigDecimal.ZERO;
            BigDecimal localamt = BigDecimal.ZERO;
            BigDecimal reclocalamt = BigDecimal.ZERO;
            BigDecimal unsettlelocalamt = BigDecimal.ZERO;
            BigDecimal amount = BigDecimal.ZERO;
            BigDecimal tax = BigDecimal.ZERO;
            BigDecimal unVerifyAmount = BigDecimal.ZERO;
            BigDecimal unSettleAmount = BigDecimal.ZERO;
            DynamicObjectCollection entries = finArBill.getDynamicObjectCollection("entry");
            boolean includeTax = finArBill.getBoolean("isincludetax");
            BigDecimal exchangeRate = finArBill.getBigDecimal("exchangerate");
            for (DynamicObject entry : entries) {
                BigDecimal e_baseunitqty;
                PriceLocalCalculator localCalculator = null;
                AbstractPriceCalculator calculator = null;
                BigDecimal qty = entry.getBigDecimal("e_quantity");
                BigDecimal taxRate = entry.getBigDecimal("e_taxrate");
                String discountMode = entry.getString("e_discountmode");
                BigDecimal discountRate = entry.getBigDecimal("e_discountrate");
                if (includeTax) {
                    BigDecimal taxUnitPrice = entry.getBigDecimal("e_taxunitprice");
                    calculator = new TaxUnitPriceCalculator(qty, taxUnitPrice, taxRate, discountMode, discountRate, precision);
                } else {
                    BigDecimal unitPrice = entry.getBigDecimal("e_unitprice");
                    calculator = new UnitPriceCalculator(qty, unitPrice, taxRate, discountMode, discountRate, precision);
                }
                localCalculator = new PriceLocalCalculator(calculator, exchangeRate, baseprecision);
                localCalculator.calculate();
                BigDecimal e_recAmount = localCalculator.getPricetaxtotal();
                BigDecimal e_localamt = localCalculator.getAmountlocal();
                BigDecimal e_reclocalamt = localCalculator.getPricetaxtotallocal();
                BigDecimal e_amount = localCalculator.getAmount();
                BigDecimal e_tax = localCalculator.getTax();
                BigDecimal e_unVerifyAmount = localCalculator.getAmount();
                BigDecimal e_unSettleAmount = localCalculator.getPricetaxtotal();
                recAmount = recAmount.add(e_recAmount);
                localamt = localamt.add(e_localamt);
                reclocalamt = reclocalamt.add(e_reclocalamt);
                unsettlelocalamt = unsettlelocalamt.add(e_reclocalamt);
                amount = amount.add(e_amount);
                tax = tax.add(e_tax);
                unVerifyAmount = unVerifyAmount.add(e_unVerifyAmount);
                unSettleAmount = unSettleAmount.add(e_unSettleAmount);
                BigDecimal quantity = entry.getBigDecimal("e_quantity");
                if (quantity == null) {
                    quantity = BigDecimal.ZERO;
                }
                BigDecimal covertRate = entry.getBigDecimal("e_unitcoefficient");
                DynamicObject material = entry.getDynamicObject("e_material");
                DynamicObject measureUnit = entry.getDynamicObject("e_measureunit");
                DynamicObject baseUnit = null;
                if (!ObjectUtils.isEmpty((Object)material)) {
                    baseUnit = material.getDynamicObject("baseunit");
                    entry.set("e_baseunit", (Object)baseUnit);
                    if (measureUnit == null) {
                        measureUnit = baseUnit;
                    }
                    covertRate = (covertRate = InitConvertHelper.getUnitRateConv(material.getLong("id"), measureUnit.getLong("id"), baseUnit.getLong("id"))) == null ? BigDecimal.ONE : covertRate;
                } else {
                    covertRate = BigDecimal.ONE;
                }
                BigDecimal e_unitcoefficient = entry.getBigDecimal("e_unitcoefficient");
                if (e_unitcoefficient == null || e_unitcoefficient.compareTo(BigDecimal.ZERO) == 0) {
                    entry.set("e_unitcoefficient", (Object)covertRate);
                }
                if ((e_baseunitqty = entry.getBigDecimal("e_baseunitqty")) == null || e_baseunitqty.compareTo(BigDecimal.ZERO) == 0) {
                    entry.set("e_baseunitqty", (Object)InitConvertHelper.getBaseunitqty(quantity, covertRate, baseUnit));
                }
                entry.set("e_taxunitprice", (Object)localCalculator.getTaxunitprice());
                entry.set("e_actunitprice", (Object)localCalculator.getActunitprice());
                entry.set("e_acttaxunitprice", (Object)localCalculator.getActtaxunitprice());
                entry.set("e_amount", (Object)e_amount);
                entry.set("e_localamt", (Object)localCalculator.getAmountlocal());
                entry.set("e_tax", (Object)localCalculator.getTax());
                entry.set("e_discountamount", (Object)localCalculator.getDiscountamount());
                entry.set("e_recamount", (Object)e_recAmount);
                entry.set("e_reclocalamt", (Object)e_reclocalamt);
                entry.set("e_unverifyamt", (Object)e_amount);
                entry.set("e_unlockamt", (Object)e_recAmount);
                entry.set("e_unsettleamt", (Object)e_recAmount);
                entry.set("e_unsettlelocalamt", (Object)e_reclocalamt);
                entry.set("e_unitprice", (Object)localCalculator.getUnitprice());
                entry.set("e_unconfirmamt", (Object)e_amount);
                entry.set("e_discountlocalamt", (Object)localCalculator.getDiscountamountlocal());
                entry.set("e_unverifyqty", (Object)quantity);
                entry.set("e_uninvoicedamt", (Object)e_recAmount);
            }
            finArBill.set("recamount", (Object)recAmount);
            finArBill.set("reclocalamt", (Object)reclocalamt);
            finArBill.set("amount", (Object)amount);
            finArBill.set("localamt", (Object)localamt);
            finArBill.set("tax", (Object)tax);
            finArBill.set("unverifyamount", (Object)unVerifyAmount);
            finArBill.set("unsettleamount", (Object)unSettleAmount);
            finArBill.set("unsettlelocalamt", (Object)reclocalamt);
            DynamicObjectCollection planentitys = finArBill.getDynamicObjectCollection("planentity");
            if (planentitys.size() > 0) continue;
            FinPlanRowService planRowService = new FinPlanRowService();
            List<PlanRow> planList = planRowService.calculatePlanRows(finArBill);
            this.updateFinBillPlanEntity(planList, finArBill, baseprecision, precision);
        }
    }

    private void updateFinBillPlanEntity(List<PlanRow> planRows, DynamicObject finAPBill, int baseprecision, int amtprecision) {
        Date planMaxDuedate = null;
        DynamicObject settlementType = finAPBill.getDynamicObject("settlementtype");
        BigDecimal amt = BigDecimal.ZERO;
        BigDecimal amtLoc = BigDecimal.ZERO;
        BigDecimal rate = finAPBill.getBigDecimal("exchangerate");
        for (int i = 0; i < planRows.size(); ++i) {
            EntryProp prop = (EntryProp)EntityMetadataCache.getDataEntityType((String)"ar_finarbill").findProperty("planentity");
            DynamicObjectType dt = prop.getDynamicCollectionItemPropertyType();
            DynamicObject planEntry = new DynamicObject(dt);
            PlanRow planRow = planRows.get(i);
            Date palnDuedate = planRow.getDueDate();
            BigDecimal planAmt = planRow.getPlanAmt().setScale(amtprecision, RoundingMode.HALF_UP);
            BigDecimal planAmtLoc = planAmt.multiply(rate).setScale(baseprecision, RoundingMode.HALF_UP);
            amt = amt.add(planAmt.setScale(amtprecision, 4));
            amtLoc = amtLoc.add(planAmtLoc.setScale(baseprecision, 4));
            if (i == planRows.size() - 1) {
                BigDecimal priceLoc;
                BigDecimal price;
                BigDecimal pricetaxtotal = finAPBill.getBigDecimal("recamount");
                BigDecimal planpricetaxloc = finAPBill.getBigDecimal("reclocalamt");
                if (amt.compareTo(pricetaxtotal) > 0) {
                    price = amt.subtract(pricetaxtotal);
                    planAmt = planAmt.subtract(price);
                } else if (amt.compareTo(pricetaxtotal) < 0) {
                    price = pricetaxtotal.subtract(amt);
                    planAmt = planAmt.add(price);
                }
                if (amtLoc.compareTo(planpricetaxloc) > 0) {
                    priceLoc = amtLoc.subtract(planpricetaxloc);
                    planAmtLoc = planAmtLoc.subtract(priceLoc);
                } else if (amtLoc.compareTo(planpricetaxloc) < 0) {
                    priceLoc = planpricetaxloc.subtract(amtLoc);
                    planAmtLoc = planAmtLoc.add(priceLoc);
                }
            }
            planEntry.set("seq", (Object)(i + 1));
            planEntry.set("planpricetax", (Object)planAmt);
            planEntry.set("unplanlockamt", (Object)planAmt);
            planEntry.set("unplansettleamt", (Object)planAmt);
            planEntry.set("planpricetaxloc", (Object)planAmtLoc);
            planEntry.set("unplansettlelocamt", (Object)planAmtLoc);
            planEntry.set("planduedate", (Object)palnDuedate);
            planEntry.set("plansettletype", (Object)settlementType);
            planEntry.getDataEntityState().setPushChanged(true);
            if (planMaxDuedate == null) {
                planMaxDuedate = palnDuedate;
            } else if (palnDuedate != null) {
                planMaxDuedate = palnDuedate.after(planMaxDuedate) ? palnDuedate : planMaxDuedate;
            }
            finAPBill.getDynamicObjectCollection("planentity").add((Object)planEntry);
        }
        if (planMaxDuedate != null) {
            finAPBill.set("duedate", planMaxDuedate);
        }
    }
}

