/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.plugin.ArApConvert.Plan;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.ApPlanSplitService;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.DetailGroupData;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.PlanRowData;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.PlanSplitSchemeServiceHelper;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.PlanSplitServiceHelper;
import kd.bos.ext.fi.plugin.ArApConvert.helper.SystemParameterHelper;

public class ApPlanSplitAndBuilder {
    public static void splitAndBuild(DynamicObject finBill, DynamicObject matchScheme) {
        String entityName = finBill.getDataEntityType().getName();
        boolean isPlanSettle = SystemParameterHelper.isPlanSettle(finBill.getLong("org.id"), "ar_finarbill".equals(entityName));
        boolean allowMaterialSplitPlanEntry = PlanSplitServiceHelper.allowMaterialSplitPlanEntry();
        HashMap<String, String> dimensionMappings = new HashMap<String, String>(8);
        if (!isPlanSettle) {
            if (allowMaterialSplitPlanEntry) {
                if (PlanSplitServiceHelper.isSplitByCoreBill()) {
                    dimensionMappings.put("corebillno", "plancorebillno");
                    dimensionMappings.put("corebillid", "plancorebillid");
                }
                if (matchScheme != null) {
                    dimensionMappings.putAll(PlanSplitSchemeServiceHelper.getDimensionMapByScheme(matchScheme));
                }
            } else {
                finBill.set("splitscheme", null);
                matchScheme = null;
            }
        } else {
            if (PlanSplitServiceHelper.isSplitByCoreBill()) {
                dimensionMappings.put("corebillno", "plancorebillno");
                dimensionMappings.put("corebillid", "plancorebillid");
            }
            if (matchScheme != null) {
                dimensionMappings.putAll(PlanSplitSchemeServiceHelper.getDimensionMapByScheme(matchScheme));
            }
        }
        ApPlanSplitService splitService = new ApPlanSplitService(finBill, matchScheme);
        List<PlanRowData> planRowDatas = splitService.execute();
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
        planEntries.clear();
        DynamicObject settlementType = finBill.getDynamicObject("settlementtype");
        DynamicObjectType planEntryType = planEntries.getDynamicObjectType();
        for (int i = 0; i < planRowDatas.size(); ++i) {
            PlanRowData planRowData = planRowDatas.get(i);
            DetailGroupData groupData = planRowData.getGroupData();
            Map<String, Object> dimensionMap = groupData.getDimensionMap();
            DynamicObject planEntry = new DynamicObject(planEntryType);
            planEntry.set("seq", (Object)(i + 1));
            for (Map.Entry dimensionMapping : dimensionMappings.entrySet()) {
                String detailKey = (String)dimensionMapping.getKey();
                String planKey = (String)dimensionMapping.getValue();
                Object dimensionValue = dimensionMap.get(detailKey);
                planEntry.set(planKey, dimensionValue);
            }
            BigDecimal priceTaxTotal = groupData.getPriceTaxTotal();
            planEntry.set("planpricetax", (Object)priceTaxTotal);
            planEntry.set("unplanlockamt", (Object)priceTaxTotal);
            planEntry.set("unplansettleamt", (Object)priceTaxTotal);
            BigDecimal priceTaxTotalLocal = groupData.getPriceTaxTotalLocal();
            planEntry.set("planpricetaxloc", (Object)priceTaxTotalLocal);
            planEntry.set("unplansettlelocamt", (Object)priceTaxTotalLocal);
            planEntry.set("planduedate", (Object)planRowData.getDueDate());
            planEntry.set("plansettletype", (Object)settlementType);
            planEntry.set("e_freezestate", (Object)"unfreeze");
            planEntry.set("p_payrate", (Object)planRowData.getRate());
            planEntry.set("p_splitdimensionid", (Object)groupData.getSplitDimensionId());
            planEntries.add((Object)planEntry);
        }
        Map<Integer, Integer> detailEntryToSplitDimensionId = PlanRowData.convertDetailSplitDimension(planRowDatas);
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("detailentry");
        int detailEntrySize = detailEntries.size();
        for (int i = 0; i < detailEntrySize; ++i) {
            DynamicObject detailEntry = (DynamicObject)detailEntries.get(i);
            detailEntry.set("e_splitdimensionid", (Object)detailEntryToSplitDimensionId.get(i));
        }
    }

    public static Map<Integer, Integer> splitAndBuildByPushAndSave(DynamicObject finBill, List<DynamicObject> detailEntries, DynamicObject matchScheme) {
        String entityName = finBill.getDataEntityType().getName();
        boolean isPlanSettle = SystemParameterHelper.isPlanSettle(finBill.getLong("org.id"), "ar_finarbill".equals(entityName));
        boolean allowMaterialSplitPlanEntry = PlanSplitServiceHelper.allowMaterialSplitPlanEntry();
        HashMap<String, String> dimensionMappings = new HashMap<String, String>(8);
        if (!isPlanSettle) {
            if (allowMaterialSplitPlanEntry) {
                if (PlanSplitServiceHelper.isSplitByCoreBill()) {
                    dimensionMappings.put("corebillno", "plancorebillno");
                    dimensionMappings.put("corebillid", "plancorebillid");
                }
                if (matchScheme != null) {
                    dimensionMappings.putAll(PlanSplitSchemeServiceHelper.getDimensionMapByScheme(matchScheme));
                }
            } else {
                finBill.set("splitscheme", null);
                matchScheme = null;
            }
        } else {
            if (PlanSplitServiceHelper.isSplitByCoreBill()) {
                dimensionMappings.put("corebillno", "plancorebillno");
                dimensionMappings.put("corebillid", "plancorebillid");
            }
            if (matchScheme != null) {
                dimensionMappings.putAll(PlanSplitSchemeServiceHelper.getDimensionMapByScheme(matchScheme));
            }
        }
        ApPlanSplitService planSplitService = new ApPlanSplitService(finBill, detailEntries, matchScheme);
        List<PlanRowData> planRowDatas = planSplitService.execute();
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
        planEntries.clear();
        DynamicObject settlementType = finBill.getDynamicObject("settlementtype");
        DynamicObjectType planEntryType = planEntries.getDynamicObjectType();
        for (int i = 0; i < planRowDatas.size(); ++i) {
            PlanRowData planRowData = planRowDatas.get(i);
            DetailGroupData groupData = planRowData.getGroupData();
            Map<String, Object> dimensionMap = groupData.getDimensionMap();
            DynamicObject planEntry = new DynamicObject(planEntryType);
            planEntry.set("seq", (Object)(i + 1));
            for (Map.Entry dimensionMapping : dimensionMappings.entrySet()) {
                String detailKey = (String)dimensionMapping.getKey();
                String planKey = (String)dimensionMapping.getValue();
                Object dimensionValue = dimensionMap.get(detailKey);
                planEntry.set(planKey, dimensionValue);
            }
            BigDecimal priceTaxTotal = groupData.getPriceTaxTotal();
            planEntry.set("planpricetax", (Object)priceTaxTotal);
            planEntry.set("unplanlockamt", (Object)priceTaxTotal);
            planEntry.set("unplansettleamt", (Object)priceTaxTotal);
            BigDecimal priceTaxTotalLocal = groupData.getPriceTaxTotalLocal();
            planEntry.set("planpricetaxloc", (Object)priceTaxTotalLocal);
            planEntry.set("unplansettlelocamt", (Object)priceTaxTotalLocal);
            planEntry.set("planduedate", (Object)planRowData.getDueDate());
            planEntry.set("plansettletype", (Object)settlementType);
            planEntry.set("e_freezestate", (Object)"unfreeze");
            planEntry.set("p_payrate", (Object)planRowData.getRate());
            planEntry.set("p_splitdimensionid", (Object)groupData.getSplitDimensionId());
            planEntries.add((Object)planEntry);
        }
        return PlanRowData.convertDetailSplitDimension(planRowDatas);
    }
}

