/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.plugin;

import com.alibaba.fastjson.JSONObject;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.entity.fielddefvalue.AbstractDefValueParamPlugIn;
import kd.bos.mvc.SessionManager;

public class DefValueEditPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String CONTEXT = "context";
    private static final String TYPE = "_Type_";
    private static final String FUNC_LIST = "funclist";
    private static final String DEF_VALUE_DESIGN = "DefValueDesign";
    private static final String FUNC_TYPE = "FuncType";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String FUNCPANEL_PAGE_ID = "funcpanel_PageId";
    private boolean checkPass = true;
    private static Map<String, String> funcFormIds = new HashMap<String, String>();
    private static final String GET_TODAY = "getToday";
    private static final String GET_NOW = "getNow";
    private static final String TO_DATE = "toDate";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        List context = (List)this.getView().getFormShowParameter().getCustomParam(CONTEXT);
        JSONObject value = (JSONObject)this.getView().getFormShowParameter().getCustomParam("value");
        ArrayList<Map<String, Object>> newContext = new ArrayList<Map<String, Object>>();
        JSONObject newValue = new JSONObject();
        String funcTypeId = new String();
        Map defValueDesign = new HashMap();
        if (context == null) {
            return;
        }
        String fieldType = (String)((Map)context.get(0)).get(TYPE);
        List<ComboItem> funclist = this.createFuncList(fieldType);
        if (!funclist.isEmpty()) {
            ((ComboEdit)this.getControl(FUNC_LIST)).setComboItems(funclist);
            this.getPageCache().put("funcList", SerializationUtils.toJsonString(funclist));
            if (value != null) {
                newValue.put(TYPE, (Object)fieldType);
                newValue.put(DEF_VALUE_DESIGN, (Object)value);
                newContext.add((Map<String, Object>)newValue);
                defValueDesign = (Map)((Map)newContext.get(0)).get(DEF_VALUE_DESIGN);
                funcTypeId = defValueDesign != null ? (String)defValueDesign.get(FUNC_TYPE) : null;
            } else {
                defValueDesign = (Map)((Map)context.get(0)).get(DEF_VALUE_DESIGN);
                String string = funcTypeId = defValueDesign != null ? (String)defValueDesign.get(FUNC_TYPE) : null;
            }
            if (!funclist.isEmpty()) {
                if (StringUtils.isBlank((CharSequence)funcTypeId)) {
                    funcTypeId = funclist.get(0).getValue();
                }
                this.getModel().setValue(FUNC_LIST, (Object)funcTypeId);
                this.showFuncPanel(funcTypeId, newContext);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (FUNC_LIST.equals(e.getProperty().getName())) {
            List context = (List)this.getView().getFormShowParameter().getCustomParam(CONTEXT);
            this.showFuncPanel((String)this.getModel().getValue(FUNC_LIST), context);
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.equalsIgnoreCase("btnok")) {
            this.returnDefValue();
        }
    }

    private List<ComboItem> createFuncList(String fieldType) {
        ArrayList<ComboItem> funclist = new ArrayList<ComboItem>();
        switch (fieldType) {
            case "BookdateField": 
            case "DateField": {
                funclist.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u83b7\u53d6\u5f53\u524d\u65e5\u671f", (String)"DefaultValueEditPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), GET_TODAY));
                funclist.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u83b7\u53d6\u6307\u5b9a\u65e5\u671f", (String)"DefaultValueEditPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), TO_DATE));
                break;
            }
            case "DateTimeField": {
                funclist.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u83b7\u53d6\u5f53\u524d\u65e5\u671f\u65f6\u95f4", (String)"DefaultValueEditPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), GET_NOW));
                funclist.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u83b7\u53d6\u65e5\u671f\u65f6\u95f4", (String)"DefaultValueEditPlugin_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), TO_DATE));
                break;
            }
            case "CityField": {
                funclist.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6307\u5b9a\u57ce\u5e02", (String)"DefaultValueEditPlugin_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), "getCity"));
                break;
            }
            case "BasedataField": 
            case "MaterielField": 
            case "CurrencyField": 
            case "GroupField": 
            case "UnitField": 
            case "AssistantField": {
                funclist.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u83b7\u53d6\u57fa\u7840\u8d44\u6599", (String)"DefaultValueEditPlugin_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), "getBasedata"));
                break;
            }
            case "OrgField": {
                funclist.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u83b7\u53d6\u5f53\u524d\u7ec4\u7ec7", (String)"DefaultValueEditPlugin_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), "getCurrentOrg"));
                funclist.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u83b7\u53d6\u6307\u5b9a\u7ec4\u7ec7", (String)"DefaultValueEditPlugin_7", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), "getOrg"));
                break;
            }
            case "UserField": {
                funclist.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u83b7\u53d6\u5f53\u524d\u7528\u6237", (String)"DefaultValueEditPlugin_8", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), "getCurrentUser"));
                break;
            }
            case "ComboField": 
            case "BillStatusField": 
            case "RadioGroupField": {
                funclist.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u83b7\u53d6\u679a\u4e3e\u503c", (String)"DefaultValueEditPlugin_9", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), "getEnum"));
                break;
            }
            case "MulBasedataField": {
                funclist.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u83b7\u53d6\u591a\u9009\u57fa\u7840\u8d44\u6599", (String)"DefaultValueEditPlugin_10", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), "getMulBasedata"));
                break;
            }
            case "AdminDivisionField": {
                funclist.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u83b7\u53d6\u884c\u653f\u533a\u5212", (String)"DefaultValueEditPlugin_11", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), "getAdminvidision"));
                break;
            }
            case "MulComboField": {
                funclist.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u83b7\u53d6\u591a\u9009\u4e0b\u62c9\u5217\u8868", (String)"DefaultValueEditPlugin_12", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), "getMulEnum"));
                break;
            }
            case "CheckBoxField": {
                funclist.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u83b7\u53d6\u590d\u9009\u6846\u9ed8\u8ba4\u503c", (String)"DefaultValueEditPlugin_13", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), "getBoolean"));
                break;
            }
        }
        return funclist;
    }

    private void showFuncPanel(String funcType, List<Map<String, Object>> context) {
        String pageId = this.getPageCache().get(FUNCPANEL_PAGE_ID);
        if (pageId != null) {
            HashMap<String, String> arg = new HashMap<String, String>();
            arg.put("pageId", pageId);
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("closeWindow", arg);
            this.getPageCache().remove(FUNCPANEL_PAGE_ID);
        }
        if (!StringUtils.isBlank((CharSequence)funcType)) {
            FormShowParameter paraSettings = new FormShowParameter();
            paraSettings.getOpenStyle().setShowType(ShowType.InContainer);
            paraSettings.getOpenStyle().setTargetKey("funcpanel");
            paraSettings.setFormId(funcFormIds.containsKey(funcType) ? funcFormIds.get(funcType) : funcType);
            paraSettings.setCustomParam("Context", context);
            paraSettings.setCustomParam(FUNC_TYPE, (Object)funcType);
            paraSettings.setCustomParam("formLayoutScheme", this.getView().getFormShowParameter().getCustomParam("formLayoutScheme"));
            if (StringUtils.equals((CharSequence)funcType, (CharSequence)TO_DATE)) {
                paraSettings.addCustPlugin("kd.bos.designer.func.DateTimeDefValueParamPlugIn");
            }
            this.getView().showForm(paraSettings);
            this.getPageCache().put(FUNCPANEL_PAGE_ID, paraSettings.getPageId());
        }
    }

    private void returnDefValue() {
        String propertyName = (String)this.getView().getFormShowParameter().getCustomParams().get("propertyName");
        HashMap<String, Object> para = new HashMap<String, Object>();
        para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
        para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        para.put("propertyName", propertyName);
        if (!StringUtils.equals((CharSequence)DEF_VALUE_DESIGN, (CharSequence)propertyName)) {
            para.put("value", this.getDefValue());
        } else {
            para.put("value", this.getDefValueDesign());
            Object funcType = this.getModel().getValue(FUNC_LIST);
            if (funcType instanceof String && (funcType.toString().equals(GET_TODAY) || funcType.toString().equals(GET_NOW) || funcType.equals(TO_DATE))) {
                List funclist = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("funcList"), ComboItem.class);
                for (ComboItem comboItem : funclist) {
                    if (!comboItem.getValue().equals(funcType.toString())) continue;
                    para.put("alias", comboItem.getCaption().getDefaultItem());
                }
            }
        }
        if (this.checkPass) {
            this.getView().returnDataToParent(para);
            this.getView().close();
        }
    }

    private Object getDefValue() {
        String pageId = this.getPageCache().get(FUNCPANEL_PAGE_ID);
        IFormView funcFormView = SessionManager.getCurrent().getView(pageId);
        if (funcFormView != null) {
            IDataModel funcModel = (IDataModel)funcFormView.getService(IDataModel.class);
            Object defaultValue = funcModel.getValue("defaultvalue");
            List context = (List)this.getView().getFormShowParameter().getCustomParam(CONTEXT);
            String fieldType = (String)((Map)context.get(0)).get(TYPE);
            if ("AccountField".equals(fieldType) && defaultValue instanceof Date) {
                DateFormat mediumDateFormat = DateFormat.getDateTimeInstance(2, 2);
                return mediumDateFormat.format((Date)defaultValue);
            }
            if (("DateField".equals(fieldType) || "DateTimeField".equals(fieldType)) && defaultValue instanceof Date) {
                DateFormat mediumDateFormat = DateFormat.getDateTimeInstance(2, 2);
                return mediumDateFormat.format((Date)defaultValue);
            }
            return defaultValue;
        }
        return null;
    }

    private Map<String, Object> getDefValueDesign() {
        String pageId = this.getPageCache().get(FUNCPANEL_PAGE_ID);
        if (StringUtils.isBlank((CharSequence)pageId)) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(TYPE, DEF_VALUE_DESIGN);
        IFormView funcFormView = SessionManager.getCurrent().getView(pageId);
        FormViewPluginProxy proxy = (FormViewPluginProxy)funcFormView.getService(FormViewPluginProxy.class);
        AbstractDefValueParamPlugIn plugIn = null;
        if (proxy != null) {
            for (IFormPlugin p : proxy.getPlugIns()) {
                if (!(p instanceof AbstractDefValueParamPlugIn)) continue;
                plugIn = (AbstractDefValueParamPlugIn)p;
                break;
            }
        }
        data.put(FUNC_TYPE, this.getModel().getValue(FUNC_LIST));
        if (plugIn == null) {
            data.put("FuncParameter", String.valueOf(this.getDefValue()));
        } else {
            StringBuilder sBuilder = new StringBuilder();
            if (!plugIn.check(sBuilder)) {
                this.getView().showTipNotification(sBuilder.toString());
                this.checkPass = false;
                return null;
            }
            data.put("FuncParameter", plugIn.returnParameter());
        }
        return data;
    }

    static {
        funcFormIds.put(GET_TODAY, "ide_gettodayedit");
        funcFormIds.put(GET_NOW, "ide_getnowedit");
        funcFormIds.put(TO_DATE, "bos_func_todate");
        funcFormIds.put("getCurrentCity", "ide_currentcity");
        funcFormIds.put("getCity", "ide_city_default");
        funcFormIds.put("getBasedata", "ide_getbasedataedit");
        funcFormIds.put("getCurrentOrg", "ide_getcurrentorgedit");
        funcFormIds.put("getOrg", "ide_getorgedit");
        funcFormIds.put("getCurrentUser", "ide_getcurrentuseredit");
        funcFormIds.put("getMulBasedata", "ide_getmulbasedataedit");
        funcFormIds.put("getAdminvidision", "ide_getadmindivisionedit");
        funcFormIds.put("getEnum", "ide_getenumedit");
        funcFormIds.put("getBoolean", "ide_getcheckboxedit");
        funcFormIds.put("getMulEnum", "ide_getmulenumedit");
    }
}

