/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.operation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.ai.DapBuildVoucherCommonUtil;
import kd.bos.ext.fi.ai.dap.cache.CacheHelper;
import kd.bos.ext.fi.ai.dap.cache.CacheModule;
import kd.bos.ext.fi.ai.dap.cache.DistributeCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.operation.EntityOperateService;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.ExceptionUtils;

public abstract class BuildAcctJEAndGLOperateService
extends EntityOperateService {
    private static final String EXCUTE_IDS = "excute(ids)";
    private DynamicObject[] dataEntities;
    private static final Log logger = LogFactory.getLog(BuildAcctJEAndGLOperateService.class);
    private static final DistributeCache cache = CacheHelper.getDistributeCache(CacheModule.GenerateVoucherTaskProcess);
    public static final String ENTITYNAME = "ai_sysparam";
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final String NULL = "NULL";
    private static final Integer loadBatchSize = 500;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResult excute(Object[] ids) throws Exception {
        try (TraceSpan span = Tracer.create((String)"opservice", (String)String.format("EntityOperationService.excute.%s.size(%s)", this.operationKey, ids.length));){
            this.getOperateLog().beginMothed(EXCUTE_IDS, null);
            this.getOperationResult().setBillCount(ids.length);
            logger.info("buildEventData_excute:ids: {}, option: {}", (Object)ids.length, (Object)this.getOption().getVariables());
            Object[] exeIds = ids;
            try {
                ArrayList<String> fieldKeys = new ArrayList<String>();
                this.preparePropertys(fieldKeys);
                this.preparePropertys(exeIds, fieldKeys);
                this.getOperateLog().beginMothed("firePreparePropertys()", null);
                PreparePropertysEventArgs args = new PreparePropertysEventArgs();
                args.setFieldKeys(fieldKeys);
                this.getPlugInProxy().firePreparePropertys(args);
                this.firePreparePropertys(args);
                this.getOperateLog().endMothed("firePreparePropertys()", null);
                logger.info("buildEventData_excute_this.billEntityType.getName():" + this.billEntityType.getName() + ";fieldKeys:" + fieldKeys);
                this.subEntityType = (MainEntityType)EntityMetadataCache.getSubDataEntityType((String)this.billEntityType.getName(), fieldKeys);
                DynamicObject[] objs = this.loadBySplitBatch(exeIds);
                logger.info("buildEventData_excute_objs:" + objs.length);
                this.writeLog(exeIds, objs, fieldKeys);
                if (this.notCustom()) {
                    this.checkDataExists(objs);
                }
                logger.info("buildEventData_excute_this.dataEntities111111:" + this.dataEntities);
                super.setDataEntities(objs);
                this.dataEntities = objs;
                logger.info("buildEventData_excute_this.dataEntities222222:" + this.dataEntities);
                this.getOperationContext().setDataEntities(this.dataEntities);
                super.excute(this.dataEntities);
            }
            catch (Exception e) {
                logger.info("buildEventData_excute_exception:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                this.getOperationResult().setSuccess(false);
                this.getOperationResult().setMessage(e.getMessage());
                OperateErrorInfo errorInfo = new OperateErrorInfo();
                errorInfo.setLevel(ErrorLevel.Warning);
                errorInfo.setMessage(e.getMessage());
                errorInfo.setTitle(this.getOpName());
                this.getOperationResult().addErrorInfo(errorInfo);
                this.getOperationResult().setShowMessage(true);
                this.getOperationResult().getSuccessPkIds().clear();
            }
            finally {
                this.release();
            }
            if (this.notCustom()) {
                this.notExistRecords(exeIds, this.dataEntities);
            }
            OperationResult operationResult = this.getOperationResult();
            return operationResult;
        }
    }

    private boolean notCustom() {
        return "0".equals(this.getOption().getVariables().get("iscustom"));
    }

    private DynamicObject[] loadBySplitBatch(Object[] exeIds) {
        List<Object> asList = Arrays.asList(exeIds);
        List<List<Object>> splitbatch = DapBuildVoucherCommonUtil.splitbatch(asList, loadBatchSize);
        ArrayList<DynamicObject> alldata = new ArrayList<DynamicObject>(exeIds.length);
        logger.info("buildEventData_excute_splitbatch:" + splitbatch.size());
        for (List<Object> spb : splitbatch) {
            DynamicObject[] load = BusinessDataReader.load((Object[])spb.toArray(), (DynamicObjectType)this.subEntityType, (Boolean)Boolean.TRUE);
            alldata.addAll(Arrays.asList(load));
        }
        DynamicObject[] objs = alldata.toArray(new DynamicObject[0]);
        return objs;
    }

    private void writeLog(Object[] exeIds, DynamicObject[] objs, List<String> fieldKeys) {
        if (this.getOperateLog().isWriteLog()) {
            StringBuilder sb = new StringBuilder();
            sb.append("EntityOperateService.excute(ids[");
            for (int i = 0; i < exeIds.length && i <= 5; ++i) {
                if (i >= 5) {
                    sb.append("... total ").append(exeIds.length).append(" bills");
                    break;
                }
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(String.valueOf(exeIds[i]));
            }
            sb.append("]): ");
            sb.append("get ").append(objs == null ? "0" : String.valueOf(objs.length)).append(" bills, ");
            sb.append("fields: ").append(String.join((CharSequence)",", new HashSet<String>(fieldKeys)));
            this.getOperateLog().endMothed(EXCUTE_IDS, sb.toString());
        }
    }

    private void checkDataExists(DynamicObject[] objs) {
        if (objs == null || objs.length == 0) {
            this.getOperateLog().endMothed(EXCUTE_IDS, "EntityOperateService.excute(ids): load bill failed, return");
            throw new KDBizException(BosErrorCode.operationFailed, new Object[]{ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"EntityOperateService_19", (String)"bos-ext-fi", (Object[])new Object[0])});
        }
    }

    protected void addDefaultValidator(List<AbstractValidator> validators) {
        super.addDefaultValidator(validators);
    }

    private void notExistRecords(Object[] ids, DynamicObject[] objs) {
        if (objs.length < ids.length) {
            HashSet<String> objIds = new HashSet<String>(objs.length);
            for (DynamicObject obj : objs) {
                objIds.add(String.valueOf(obj.getPkValue()));
            }
            ArrayList<String> notExistIds = new ArrayList<String>(ids.length);
            for (Object id : ids) {
                String idString = String.valueOf(id);
                if (StringUtils.isBlank((CharSequence)idString) || StringUtils.equals((CharSequence)"0", (CharSequence)idString) || objIds.contains(idString)) continue;
                notExistIds.add(idString);
                String message = ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728", (String)"DapEntityOperateService2_1", (String)"bos-ext-fi", (Object[])new Object[0]);
                this.getOperationResult().addErrorInfo((OperateErrorInfo)new ValidationErrorInfo("", id, 0, 0, "notExistRecords", "", message, ErrorLevel.Error));
            }
            if (!notExistIds.isEmpty()) {
                this.getOperateLog().info("not exist ids:" + String.join((CharSequence)",", notExistIds));
            }
        }
    }

    protected void firePreparePropertys(PreparePropertysEventArgs args) {
        this.opBizRuleService.firePreparePropertys(args);
    }
}

