/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.operation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.ai.DapBuildVoucherCommonUtil;
import kd.bos.ext.fi.ai.DapVoucherUtil;
import kd.bos.ext.fi.ai.dap.cache.CacheHelper;
import kd.bos.ext.fi.ai.dap.cache.CacheModule;
import kd.bos.ext.fi.ai.dap.cache.DistributeCache;
import kd.bos.ext.fi.ai.v2.fah.BuildXLAAndGLUtils;
import kd.bos.ext.fi.ai.v2.fah.constant.CreateXlaMode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.EntityOperateService;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.ExceptionUtils;

public abstract class DapEntityOperateService
extends EntityOperateService {
    private static final String EXCUTE_IDS = "excute(ids)";
    private DynamicObject[] dataEntities;
    private static final Log logger = LogFactory.getLog(DapEntityOperateService.class);
    private static final DistributeCache cache = CacheHelper.getDistributeCache(CacheModule.GenerateVoucherTaskProcess);
    public static final String ENTITYNAME = "ai_sysparam";
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final String NULL = "NULL";

    public OperationResult excute(Object[] ids) throws Exception {
        String buildMode = this.getOption().getVariableValue("build_mode", null);
        if ("false".equalsIgnoreCase(buildMode)) {
            return this.getVoucherOperationResult(ids);
        }
        if ("true".equalsIgnoreCase(buildMode)) {
            return this.buildXlaAndGlOpeRssult(ids);
        }
        String mode = BuildXLAAndGLUtils.createXlaMode();
        if (CreateXlaMode.DAP_NEW_CUS.getCode().equals(mode) || (CreateXlaMode.DAP_REG_NEW.getCode().equals(mode) || CreateXlaMode.DAP_REG_OPTION.getCode().equals(mode)) && BuildXLAAndGLUtils.checkHasRegBillWithData(this.getOperationContext().getEntityTypeId(), BuildXLAAndGLUtils.buildSetData(ids))) {
            return this.buildXlaAndGlOpeRssult(ids);
        }
        return this.getVoucherOperationResult(ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationResult getVoucherOperationResult(Object[] ids) {
        try (TraceSpan span = Tracer.create((String)"opservice", (String)String.format("EntityOperationService.excute.%s.size(%s)", this.operationKey, ids.length));){
            this.getOperateLog().beginMothed(EXCUTE_IDS, null);
            this.getOperationResult().setBillCount(ids.length);
            logger.info("--DAP--excute:ids:" + ids.length);
            Object[] exeIds = ids;
            try {
                ArrayList fieldKeys = new ArrayList();
                this.preparePropertys(fieldKeys);
                this.preparePropertys(exeIds, fieldKeys);
                this.getOperateLog().beginMothed("firePreparePropertys()", null);
                PreparePropertysEventArgs args = new PreparePropertysEventArgs();
                args.setFieldKeys(fieldKeys);
                this.getPlugInProxy().firePreparePropertys(args);
                this.firePreparePropertys(args);
                this.getOperateLog().endMothed("firePreparePropertys()", null);
                logger.info("--DAP--this.billEntityType.getName():" + this.billEntityType.getName() + ";fieldKeys:" + fieldKeys);
                this.subEntityType = (MainEntityType)EntityMetadataCache.getSubDataEntityType((String)this.billEntityType.getName(), fieldKeys);
                List<Object> asList = Arrays.asList(exeIds);
                List<List<Object>> splitbatch = DapBuildVoucherCommonUtil.splitbatch(asList, 500);
                ArrayList<DynamicObject> alldata = new ArrayList<DynamicObject>(8);
                logger.info("--DAP--splitbatch:" + splitbatch.size());
                for (List<Object> spb : splitbatch) {
                    DynamicObject[] load = BusinessDataReader.load((Object[])spb.toArray(), (DynamicObjectType)this.subEntityType, (Boolean)Boolean.TRUE);
                    alldata.addAll(Arrays.asList(load));
                }
                DynamicObject[] objs = alldata.toArray(new DynamicObject[0]);
                logger.info("--DAP--objs:" + objs.length);
                if (this.getOperateLog().isWriteLog()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("EntityOperateService.excute(ids[");
                    for (int i = 0; i < exeIds.length && i <= 5; ++i) {
                        if (i >= 5) {
                            sb.append("... total ").append(exeIds.length).append(" bills");
                            break;
                        }
                        if (i > 0) {
                            sb.append(",");
                        }
                        sb.append(String.valueOf(exeIds[i]));
                    }
                    sb.append("]): ");
                    sb.append("get ").append(objs == null ? "0" : String.valueOf(objs.length)).append(" bills, ");
                    sb.append("fields: ").append(String.join((CharSequence)",", new HashSet(fieldKeys)));
                    this.getOperateLog().endMothed(EXCUTE_IDS, sb.toString());
                }
                if (objs == null || objs.length == 0) {
                    this.getOperateLog().endMothed(EXCUTE_IDS, "EntityOperateService.excute(ids): load bill failed, return");
                    throw new KDBizException(BosErrorCode.operationFailed, new Object[]{ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"EntityOperateService_19", (String)"bos-ext-fi", (Object[])new Object[0])});
                }
                logger.info("--DAP--this.dataEntities111111:" + this.dataEntities);
                this.setDataEntities(objs);
                this.dataEntities = objs;
                logger.info("--DAP--this.dataEntities222222:" + this.dataEntities);
                this.getOperationContext().setDataEntities(this.dataEntities);
                this.excute(this.dataEntities);
            }
            catch (Exception e) {
                logger.info("--DAP--exception:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                try (TXHandle x = TX.requiresNew();){
                    try {
                        DapVoucherUtil.generateNewExceptionReport(e, this.billEntityType.getName(), e.getMessage(), null);
                    }
                    catch (Throwable t) {
                        x.markRollback();
                    }
                }
                this.getOperationResult().setSuccess(false);
                this.getOperationResult().setMessage(e.getMessage());
                OperateErrorInfo errorInfo = new OperateErrorInfo();
                errorInfo.setLevel(ErrorLevel.Warning);
                errorInfo.setMessage(e.getMessage());
                errorInfo.setTitle(ResManager.loadKDString((String)"\u751f\u6210\u51ed\u8bc1", (String)"DapOperationResultHelper_0", (String)"bos-ext-fi", (Object[])new Object[0]));
                this.getOperationResult().addErrorInfo(errorInfo);
                this.getOperationResult().setShowMessage(true);
                this.getOperationResult().getSuccessPkIds().clear();
                DistributeCache distributeCache = CacheHelper.getDistributeCache(CacheModule.GenerateVoucherTaskProcess);
                String cacheData = distributeCache.get(this.getGenerateProcessKey());
                Map<String, String> cacheDataMap = new HashMap<String, Integer>(8);
                if (cacheData != null) {
                    cacheDataMap = (Map)SerializationUtils.fromJsonString((String)cacheData, Map.class);
                }
                String currTaskKey = "currProgress";
                cacheDataMap.put(currTaskKey, (String)((Object)Integer.valueOf(100)));
                cacheDataMap.put(currTaskKey + "_error", ResManager.loadKDString((String)"\u51ed\u8bc1\u751f\u6210\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u751f\u6210\u62a5\u544a\u3002", (String)"DapEntityOperateService_11", (String)"bos-ext-fi", (Object[])new Object[0]));
                distributeCache.put(this.getGenerateProcessKey(), SerializationUtils.toJsonString(cacheDataMap));
            }
            finally {
                this.release();
            }
            this.notExistRecords(exeIds, this.dataEntities);
            OperationResult operationResult = this.getOperationResult();
            return operationResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationResult buildXlaAndGlOpeRssult(Object[] ids) {
        try (TraceSpan span = Tracer.create((String)"opservice", (String)String.format("EntityOperationService.excute.%s.size(%s)", this.operationKey, ids.length));){
            this.getOperateLog().beginMothed(EXCUTE_IDS, null);
            this.getOperationResult().setBillCount(ids.length);
            Object[] exeIds = ids;
            try {
                ArrayList fieldKeys = new ArrayList();
                this.preparePropertys(fieldKeys);
                this.preparePropertys(exeIds, fieldKeys);
                this.getOperateLog().beginMothed("firePreparePropertys()", null);
                PreparePropertysEventArgs args = new PreparePropertysEventArgs();
                args.setFieldKeys(fieldKeys);
                this.getPlugInProxy().firePreparePropertys(args);
                this.firePreparePropertys(args);
                this.getOperateLog().endMothed("firePreparePropertys()", null);
                this.subEntityType = (MainEntityType)EntityMetadataCache.getSubDataEntityType((String)this.billEntityType.getName(), fieldKeys);
                List<Object> asList = Arrays.asList(exeIds);
                List<List<Object>> splitBatch = DapBuildVoucherCommonUtil.splitbatch(asList, 500);
                ArrayList<DynamicObject> alldata = new ArrayList<DynamicObject>(8);
                for (List<Object> spb : splitBatch) {
                    DynamicObject[] load = BusinessDataReader.load((Object[])spb.toArray(), (DynamicObjectType)this.subEntityType, (Boolean)Boolean.TRUE);
                    alldata.addAll(Arrays.asList(load));
                }
                DynamicObject[] objs = alldata.toArray(new DynamicObject[0]);
                if (this.getOperateLog().isWriteLog()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("EntityOperateService.excute(ids[");
                    for (int i = 0; i < exeIds.length && i <= 5; ++i) {
                        if (i >= 5) {
                            sb.append("... total ").append(exeIds.length).append(" bills");
                            break;
                        }
                        if (i > 0) {
                            sb.append(",");
                        }
                        sb.append(exeIds[i]);
                    }
                    sb.append("]): ");
                    sb.append("get ").append(objs.length).append(" bills, ");
                    sb.append("fields: ").append(String.join((CharSequence)",", new HashSet(fieldKeys)));
                    this.getOperateLog().endMothed(EXCUTE_IDS, sb.toString());
                }
                if (objs.length == 0) {
                    this.getOperateLog().endMothed(EXCUTE_IDS, "EntityOperateService.excute(ids): load bill failed, return");
                    throw new KDBizException(BosErrorCode.operationFailed, new Object[]{ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"EntityOperateService_19", (String)"bos-ext-fi", (Object[])new Object[0])});
                }
                this.setDataEntities(objs);
                this.dataEntities = objs;
                this.getOperationContext().setDataEntities(this.dataEntities);
                this.excute(this.dataEntities);
            }
            catch (Exception e) {
                logger.info("--XlaAndGl--exception:{}", (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                this.getOperationResult().setSuccess(false);
                this.getOperationResult().setMessage(e.getMessage());
                OperateErrorInfo errorInfo = new OperateErrorInfo();
                errorInfo.setLevel(ErrorLevel.Warning);
                errorInfo.setMessage(e.getMessage());
                errorInfo.setTitle(ResManager.loadKDString((String)"\u521b\u5efa\u5b50\u5206\u7c7b\u8d26\u548c\u603b\u8d26", (String)"DapOperationResultHelper_4", (String)"bos-ext-fi", (Object[])new Object[0]));
                this.getOperationResult().addErrorInfo(errorInfo);
                this.getOperationResult().setShowMessage(true);
                this.getOperationResult().getSuccessPkIds().clear();
                DistributeCache distributeCache = CacheHelper.getDistributeCache(CacheModule.GenerateVoucherTaskProcess);
                String cacheData = distributeCache.get(this.getGenerateProcessKey());
                Map<String, String> cacheDataMap = new HashMap<String, Integer>(8);
                if (cacheData != null) {
                    cacheDataMap = (Map)SerializationUtils.fromJsonString((String)cacheData, Map.class);
                }
                String currTaskKey = "currProgress";
                cacheDataMap.put(currTaskKey, (String)((Object)Integer.valueOf(100)));
                cacheDataMap.put(currTaskKey + "_error", ResManager.loadKDString((String)"\u521b\u5efa\u5b50\u5206\u7c7b\u8d26\u548c\u603b\u8d26\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u6267\u884c\u65e5\u5fd7\u3002", (String)"DapEntityOperateService_11", (String)"fi-ai-mservice", (Object[])new Object[0]));
                distributeCache.put(this.getGenerateProcessKey(), SerializationUtils.toJsonString(cacheDataMap));
            }
            finally {
                this.release();
            }
            this.notExistRecords(exeIds, this.dataEntities);
            OperationResult operationResult = this.getOperationResult();
            return operationResult;
        }
    }

    protected void addDefaultValidator(List<AbstractValidator> validators) {
        super.addDefaultValidator(validators);
        String plugin = DapEntityOperateService.get("generatevouchervalidatorplugin");
        if (plugin != null) {
            AbstractValidator attValidator = (AbstractValidator)TypesContainer.createInstance((String)plugin);
            validators.add(attValidator);
        }
    }

    private void notExistRecords(Object[] ids, DynamicObject[] objs) {
        if (objs.length < ids.length) {
            HashSet<String> objIds = new HashSet<String>(objs.length);
            for (DynamicObject obj : objs) {
                objIds.add(String.valueOf(obj.getPkValue()));
            }
            ArrayList<String> notExistIds = new ArrayList<String>(ids.length);
            for (Object id : ids) {
                String idString = String.valueOf(id);
                if (StringUtils.isBlank((CharSequence)idString) || StringUtils.equals((CharSequence)"0", (CharSequence)idString) || objIds.contains(idString)) continue;
                notExistIds.add(idString);
                String message = ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728", (String)"DapEntityOperateService2_1", (String)"bos-ext-fi", (Object[])new Object[0]);
                this.getOperationResult().addErrorInfo((OperateErrorInfo)new ValidationErrorInfo("", id, 0, 0, "notExistRecords", "", message, ErrorLevel.Error));
            }
            if (!notExistIds.isEmpty()) {
                this.getOperateLog().info("not exist ids:" + String.join((CharSequence)",", notExistIds));
            }
        }
    }

    protected void firePreparePropertys(PreparePropertysEventArgs args) {
        this.opBizRuleService.firePreparePropertys(args);
    }

    public static String get(String key) {
        String value = cache.get(key);
        if (null == value) {
            DynamicObject obj = QueryServiceHelper.queryOne((String)ENTITYNAME, (String)VALUE, (QFilter[])new QFilter[]{new QFilter(KEY, "=", (Object)key)});
            if (null != obj) {
                value = obj.getString(VALUE);
                cache.put(key, value);
            } else {
                cache.put(key, NULL);
            }
        }
        if (NULL.equals(value)) {
            return null;
        }
        return value;
    }

    public abstract String getGenerateProcessKey();
}

