/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.function;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.function.BOSBatchFunction;
import kd.bos.entity.function.FunctionType;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.fi.ai.function.DapFunctionTypes;
import kd.fi.ai.function.IBatchFunctionHandler;

public class Function
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -1744406596315790215L;
    private static Map<String, String> batchFuns = new HashMap<String, String>(4);
    private static Map<String, String> bosBatchFuns = new HashMap<String, String>(4);
    private String name;
    private List<Object> params;
    private boolean hasInnerFunction = false;
    private boolean innerFunctionBatch = false;
    private Function calObject;

    public boolean isHasInnerFunction() {
        return this.hasInnerFunction;
    }

    public void setHasInnerFunction(boolean hasInnerFunction) {
        this.hasInnerFunction = hasInnerFunction;
    }

    public Function(String name, List<Object> params) {
        this.name = name;
        this.params = params;
    }

    public Function() {
    }

    public String getName() {
        return this.name;
    }

    public List<Object> getParams() {
        return this.params;
    }

    public static boolean isBatchFunction(String functionName) {
        return batchFuns.containsKey(functionName);
    }

    public static boolean isBosBatchFunction(String functionName) {
        return bosBatchFuns.containsKey(functionName);
    }

    public static IBatchFunctionHandler getBatchFunctionHandler(String functionName) {
        String handlerName = batchFuns.get(functionName);
        if (handlerName != null) {
            try {
                return (IBatchFunctionHandler)Class.forName(handlerName).newInstance();
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
            }
        }
        return null;
    }

    public String toString() {
        return "Function [name=" + this.name + ", params=" + this.params + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.params == null ? 0 : this.params.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Function other = (Function)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.params == null ? other.params != null : !this.params.equals(other.params));
    }

    public Function clone() {
        return new Function(this.name, this.params);
    }

    public Function deepClone() {
        byte[] json = SerializationUtils.toByte((Object)this);
        return (Function)SerializationUtils.fromByte((byte[])json);
    }

    public Function getCalObject() {
        return this.calObject;
    }

    public void setCalObject(Function calObject) {
        this.calObject = calObject;
    }

    public boolean isInnerFunctionBatch() {
        return this.innerFunctionBatch;
    }

    public void setInnerFunctionBatch(boolean innerFunctionBatch) {
        this.innerFunctionBatch = innerFunctionBatch;
    }

    static {
        batchFuns.put("GetAccEvent", "kd.fi.ai.mservice.builder.singletaskaction.GetAccEventFun");
        batchFuns.put("GetAccEventVoucher", "kd.fi.ai.mservice.builder.singletaskaction.GetAccEventVoucherFun");
        batchFuns.put("GetMasterGroupData", "kd.bos.ext.bd.func.GetMasterGroupData");
        batchFuns.put("GetSourceBillVCPropertyValue", "kd.fi.ai.function.GetSourceBillVCPropertyValue");
        FunctionTypes f = DapFunctionTypes.get();
        List gp = f.getFunctionTypes();
        block2: for (FunctionType tp : gp) {
            try {
                Class<?>[] interfaces;
                Class<?> c = Class.forName(tp.getRunClass());
                for (Class<?> ifc : interfaces = c.getInterfaces()) {
                    if (IBatchFunctionHandler.class.equals(ifc)) {
                        batchFuns.put(c.getSimpleName(), c.getName());
                        continue block2;
                    }
                    if (!BOSBatchFunction.class.equals(ifc)) continue;
                    bosBatchFuns.put(c.getSimpleName(), c.getName());
                    continue block2;
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }
}

