/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.plugin;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.tmc.utils.commitToBe.helper.EmptyUtil;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class BankInputPasswordPlugin
extends AbstractFormPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Set opKeys;
        String entityName;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        OperateOption option = operate.getOption();
        String operateKey = operate.getOperateKey();
        IFormView view = this.getView();
        if (view instanceof BillView) {
            entityName = view.getModel().getDataEntityType().getName();
        } else {
            BillList billList = (BillList)view.getControl("billlistap");
            entityName = billList.getEntityId();
        }
        Map config = BusinessDataServiceHelper.loadFromCache((String)"cas_showppwdconfig", (QFilter[])new QFilter[0]);
        Map<String, String> data = config.values().stream().collect(Collectors.groupingBy(s -> s.getString("billtype.number"), Collectors.mapping(s -> s.getString("opkey"), Collectors.joining())));
        if (this.isNeedPassword().booleanValue() && !option.containsVariable("isValidated") && data.containsKey(entityName) && data.get(entityName).contains(operateKey) && (opKeys = Arrays.stream(data.get(entityName).split(",")).collect(Collectors.toSet())).contains(operateKey)) {
            args.setCancel(true);
            Long userPK = RequestContext.get().getCurrUserId();
            QFilter[] qFilters = new QFilter[]{new QFilter("user", "=", (Object)userPK)};
            DynamicObjectCollection bankPassword = QueryServiceHelper.query((String)"cas_banketppwd", (String)"id,user,password", (QFilter[])qFilters);
            if (bankPassword != null && bankPassword.size() > 0) {
                this.showPwdForm(operate, Boolean.FALSE);
            } else {
                this.showPwdForm(operate, Boolean.TRUE);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Map data;
        if (StringUtils.equals((CharSequence)evt.getActionId(), (CharSequence)"KEY_PWD_CALLBACK")) {
            Map data2 = (Map)evt.getReturnData();
            String randomIdx = this.getView().getPageCache().get("randomIdx");
            String opkey = this.getView().getPageCache().get("realopkey");
            if (data2 != null && "1".equals(data2.get("loginpass")) && randomIdx.equals(data2.get("randomIdx"))) {
                OperateOption option = EmptyUtil.isEmpty(this.getView().getPageCache().get("oldoption")) ? OperateOption.create() : (OperateOption)SerializationUtils.deSerializeFromBase64((String)this.getView().getPageCache().get("oldoption"));
                option.setVariableValue("isCheckPassCA", "isCheckPassCA");
                option.setVariableValue("isValidated", "1");
                this.getView().invokeOperation(opkey, option);
            }
        } else if (StringUtils.equals((CharSequence)evt.getActionId(), (CharSequence)"KEY_NEWPWD_CALLBACK") && (data = (Map)evt.getReturnData()) != null && "1".equals(data.get("initpass"))) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u5bc6\u7801\u6210\u529f\uff01", (String)"CommitToBe_1", (String)"bos-ext-tmc", (Object[])new Object[0]), Integer.valueOf(2000));
        }
    }

    private void showPwdForm(FormOperate operate, Boolean isNew) {
        String callbackId;
        String formId;
        long currentTimeMillis = System.currentTimeMillis();
        if (isNew.booleanValue()) {
            formId = "cas_bankpwdsetting";
            callbackId = "KEY_NEWPWD_CALLBACK";
        } else {
            formId = "cas_bankinputpwd";
            callbackId = "KEY_PWD_CALLBACK";
            this.getView().getPageCache().put("randomIdx", String.valueOf(currentTimeMillis));
            this.getView().getPageCache().put("realopkey", operate.getOperateKey());
            this.getView().getPageCache().put("oldoption", SerializationUtils.serializeToBase64((Object)operate.getOption()));
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setAppId("cas");
        parameter.setFormId(formId);
        parameter.setCustomParam("randomIdx", (Object)String.valueOf(currentTimeMillis));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callbackId));
        this.getView().showForm(parameter);
    }

    protected Boolean isNeedPassword() {
        Boolean isNeedPassWord = Boolean.FALSE;
        QFilter payWriteNumber = new QFilter("number", "=", (Object)"fi.cas.pass.ca");
        DynamicObject payWriteConfig = BusinessDataServiceHelper.loadSingleFromCache((String)"cas_extend_config", (String)"configvalue", (QFilter[])new QFilter[]{payWriteNumber});
        if (payWriteConfig != null && "true".equals(payWriteConfig.getString("configvalue"))) {
            isNeedPassWord = Boolean.TRUE;
        }
        return isNeedPassWord;
    }
}

