/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.plugin;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.tmc.utils.commitToBe.helper.EmptyUtil;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class SuspectConfirmPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(SuspectConfirmPlugin.class);
    private static final String SUSPECT_TABAP = "suspect_tabap";
    private static final String CURRENTDATA_FLEXPANELAP = "currentdata_flexpanelap";
    private static final String FCS_INCONTAINER_LIST = "fcs_incontainer_list";
    private static final String SELECTFIELDS = "billid,suspectentry.suspectbillentity suspectbillentity,suspectentry.suspectbillid suspectbillid,suspectset.number,destdescribe";
    private static final String SUSPECTRESULTDATA = "suspectResultData";
    private static final String SUSPECTDATA = "suspectData";

    public void afterCreateNewData(EventObject e) {
        String billentity = (String)this.getView().getFormShowParameter().getCustomParam("billentity");
        JSONArray billIds = (JSONArray)this.getView().getFormShowParameter().getCustomParam("billid");
        if (EmptyUtil.isNoEmpty(billentity) && billIds != null) {
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setBillFormId(billentity);
            listShowParameter.setFormId(FCS_INCONTAINER_LIST);
            listShowParameter.setMultiSelect(true);
            listShowParameter.setSelectedRows(billIds.toArray());
            listShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            listShowParameter.getOpenStyle().setTargetKey(CURRENTDATA_FLEXPANELAP);
            listShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)billIds));
            listShowParameter.addCustPlugin("kd.bos.ext.tmc.plugin.IncontainerListPlugin");
            listShowParameter.getCustomParams().put("flexType", "currentdata");
            listShowParameter.setPageId(billentity + "_currentdata_" + listShowParameter.getPageId());
            this.getView().showForm((FormShowParameter)listShowParameter);
            this.getModel().setValue("selectdataid", (Object)billIds.stream().map(Object::toString).collect(Collectors.joining(",")));
            Set<Long> billIdSet = billIds.stream().mapToLong(s -> Long.valueOf(s.toString())).boxed().collect(Collectors.toSet());
            DynamicObjectCollection suspectBills = this.getRealSuspectDatas(billentity, billIdSet);
            Map billIdFoundSuspectBillIdMap = suspectBills.stream().collect(Collectors.groupingBy(s -> s.getLong("billid"), Collectors.mapping(s -> s.getLong("suspectbillid"), Collectors.toSet())));
            for (Map.Entry entry : billIdFoundSuspectBillIdMap.entrySet()) {
                billIdFoundSuspectBillIdMap.get(entry.getKey()).add(entry.getKey());
            }
            HashMap<Long, String> billIdFoundEntityNumber = new HashMap<Long, String>(suspectBills.size());
            for (DynamicObject row : suspectBills) {
                billIdFoundEntityNumber.put(row.getLong("billid"), billentity);
                billIdFoundEntityNumber.put(row.getLong("suspectbillid"), row.getString("suspectbillentity"));
            }
            Map map = suspectBills.stream().filter(s -> billIdSet.contains(s.getLong("billid"))).collect(Collectors.groupingBy(s -> s.getLong("billid"), Collectors.groupingBy(s -> s.getString("suspectbillentity"), Collectors.mapping(s -> s.getLong("suspectbillid"), Collectors.toSet()))));
            HashMap tempMap = new HashMap(billIdFoundSuspectBillIdMap);
            for (Long billId : billIdSet) {
                for (Map.Entry entry : billIdFoundSuspectBillIdMap.entrySet()) {
                    if (!entry.getValue().contains(billId)) continue;
                    ((Set)tempMap.get(billId)).addAll(entry.getValue());
                }
                Map suspectDatas = map.get(billId);
                Set suspectIds = (Set)tempMap.get(billId);
                for (Long id : suspectIds) {
                    if (billId.equals(id)) continue;
                    String entityNumber = (String)billIdFoundEntityNumber.get(id);
                    if (!suspectDatas.containsKey(entityNumber)) {
                        suspectDatas.put(entityNumber, new HashSet(16));
                    }
                    suspectDatas.get(entityNumber).add(id);
                }
            }
            this.getView().getPageCache().put(SUSPECTDATA, SerializationUtils.serializeToBase64((Object)suspectBills));
            this.getView().getPageCache().put(SUSPECTRESULTDATA, SerializationUtils.serializeToBase64(map));
            this.showSuspectDataForm(billIdSet);
        }
    }

    private DynamicObjectCollection getRealSuspectDatas(String billentity, Set<Long> billIdSet) {
        QFilter qFilter = new QFilter("ctrltype", "=", (Object)"landing").and("billentity", "=", (Object)billentity);
        QFilter qFilter1 = new QFilter("billid", "in", billIdSet).and("confirm", "=", (Object)false);
        DynamicObjectCollection suspectBills1 = QueryServiceHelper.query((String)"fcs_suspectbill", (String)"suspectentry.suspectbillid suspectbillid", (QFilter[])new QFilter[]{qFilter, qFilter1});
        Set suspectBillIds = suspectBills1.stream().map(s -> s.getLong("suspectbillid")).collect(Collectors.toSet());
        suspectBillIds.addAll(billIdSet);
        QFilter qFilter2 = new QFilter("suspectentry.suspectbillid", "in", suspectBillIds).or("billid", "in", billIdSet);
        return QueryServiceHelper.query((String)"fcs_suspectbill", (String)SELECTFIELDS, (QFilter[])new QFilter[]{qFilter, qFilter2});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String selectDataIdStr;
        String propName = e.getProperty().getName();
        if ("selectdataid".equals(propName) && EmptyUtil.isNoEmpty(selectDataIdStr = (String)this.getModel().getValue("selectdataid"))) {
            Set<Long> selectDataIds = Arrays.stream(selectDataIdStr.split(",")).map(Long::parseLong).collect(Collectors.toSet());
            this.showSuspectDataForm(selectDataIds);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        HashMap<String, Object> returnData = new HashMap<String, Object>(16);
        returnData.put("executeOperate", this.getView().getFormShowParameter().getCustomParam("executeOperate"));
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("billentity");
        returnData.put("billentity", entityNumber);
        JSONArray billIds = (JSONArray)this.getView().getFormShowParameter().getCustomParam("billid");
        Set notConfirmBilllIds = billIds.stream().map(s -> Long.parseLong(s.toString())).collect(Collectors.toSet());
        if ("confirm".equals(formOperate.getOperateKey())) {
            returnData.put("operate", "confirm");
            String selectDataIdStr = (String)this.getModel().getValue("selectdataid");
            if (EmptyUtil.isNoEmpty(selectDataIdStr)) {
                Set confirmBilllIds = Arrays.stream(selectDataIdStr.split(",")).map(Long::parseLong).collect(Collectors.toSet());
                notConfirmBilllIds.removeAll(confirmBilllIds);
                returnData.put("notConfirmBilllIds", notConfirmBilllIds);
                logger.info("\u8fd4\u56de\u7684\u7591\u4f3c\u91cd\u590ddata\uff1a" + ((Object)returnData).toString());
                QFilter qFilter = new QFilter("billid", "in", confirmBilllIds);
                qFilter.and("ctrltype", "=", (Object)"landing");
                qFilter.and("confirm", "=", (Object)false);
                List selectedBillIds = QueryServiceHelper.query((String)"fcs_suspectbill", (String)"id", (QFilter[])qFilter.toArray()).stream().map(s -> s.getLong("id")).collect(Collectors.toList());
                HashMap writeBackIds = new HashMap(4);
                writeBackIds.put(entityNumber, confirmBilllIds);
                DispatchServiceHelper.invokeBizService((String)"tmc", (String)"fcs", (String)"suspectRepeatService", (String)"updateSuspectRepeatInfo", (Object[])new Object[]{selectedBillIds, writeBackIds, "1"});
                this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(returnData));
                this.getView().getPageCache().put("operate", "confirm");
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u5f53\u524d\u4e1a\u52a1\u6570\u636e\u540e\uff0c\u518d\u64cd\u4f5c\u3010\u786e\u8ba4\u4ed8\u6b3e\u3011\u3002", (String)"SuspectBillListPlugin_3", (String)"bos-ext-tmc", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if ("close".equals(formOperate.getOperateKey())) {
            this.getView().getPageCache().put("operate", "close");
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String operate = this.getView().getPageCache().get("operate");
        if (!"confirm".equals(operate)) {
            this.executeOperate();
        }
    }

    private void executeOperate() {
        HashMap<String, Object> returnData = new HashMap<String, Object>(16);
        returnData.put("executeOperate", this.getView().getFormShowParameter().getCustomParam("executeOperate"));
        returnData.put("billentity", this.getView().getFormShowParameter().getCustomParam("billentity"));
        returnData.put("notConfirmBilllIds", this.getView().getFormShowParameter().getCustomParam("billid"));
        this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(returnData));
    }

    private void showSuspectDataForm(Set<Long> selectDataIds) {
        Map suspectResultData = (Map)SerializationUtils.deSerializeFromBase64((String)this.getView().getPageCache().get(SUSPECTRESULTDATA));
        Map<Object, Object> SuspectIdsOfEntity = new HashMap(16);
        for (Long id : selectDataIds) {
            if (SuspectIdsOfEntity.isEmpty()) {
                SuspectIdsOfEntity = (Map)suspectResultData.get(id);
                continue;
            }
            SuspectIdsOfEntity = Stream.of(SuspectIdsOfEntity, (Map)suspectResultData.get(id)).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (set1, set2) -> {
                HashSet mergeSet = new HashSet(set1);
                mergeSet.addAll(set2);
                return mergeSet;
            }));
        }
        String openPageIds = this.getView().getPageCache().get("openPageIds");
        if (EmptyUtil.isNoEmpty(openPageIds)) {
            ArrayList<Map<String, String>> tabListClose = new ArrayList<Map<String, String>>(10);
            List pageIDs = SerializationUtils.fromJsonStringToList((String)openPageIds, String.class);
            for (String tabKey : pageIDs) {
                IFormView formView = SessionManager.getCurrent().getViewNoPlugin(tabKey);
                if (formView == null) continue;
                formView.close();
                tabListClose.add(Collections.singletonMap("pageId", tabKey));
            }
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.addAction("closeWindow", tabListClose);
        }
        ArrayList<String> pageIDs = new ArrayList<String>(10);
        for (Map.Entry entry : SuspectIdsOfEntity.entrySet()) {
            String entityNumber = (String)entry.getKey();
            List suspectIds = QueryServiceHelper.query((String)entityNumber, (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", entry.getValue())}).stream().map(s -> s.getLong("id")).collect(Collectors.toList());
            LocaleString displayName = MetadataServiceHelper.getDataEntityType((String)entityNumber).getDisplayName();
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setBillFormId(entityNumber);
            listShowParameter.setFormId(FCS_INCONTAINER_LIST);
            listShowParameter.getOpenStyle().setShowType(ShowType.NewTabPage);
            listShowParameter.getOpenStyle().setTargetKey(SUSPECT_TABAP);
            listShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", suspectIds));
            listShowParameter.getCustomParams().put("suspectIds", suspectIds);
            listShowParameter.getCustomParams().put("entityNumber", entityNumber);
            listShowParameter.getCustomParams().put("flexType", "susdata");
            listShowParameter.setCaption(ResManager.loadKDString((String)"\uff08%s\u6761\uff09", (String)"SuspectBillListPlugin_4", (String)"bos-ext-tmc", (Object[])new Object[]{suspectIds.size()}) + displayName);
            listShowParameter.addCustPlugin("kd.bos.ext.tmc.plugin.IncontainerListPlugin");
            listShowParameter.setPageId(entityNumber + "_susdata_" + listShowParameter.getPageId());
            pageIDs.add(listShowParameter.getPageId());
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
        this.getView().getPageCache().put("openPageIds", SerializationUtils.toJsonString(pageIDs));
    }
}

