/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.plugin.fbd;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.Submit;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.tmc.utils.commitToBe.helper.EmptyUtil;
import kd.bos.ext.tmc.utils.helper.fbd.AttachTypeHelper;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class BusinessAttachTypePanelEdit
extends AbstractFormPlugin {
    private static final String DEFAULT_ATTACHMENT_PANEL_KEY = "attachmentpanel";

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        this.initAttachTypePanel();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String attachPageId;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        Object source = args.getSource();
        IPageCache pageCache = this.getView().getPageCache();
        HashSet opKeySet = new HashSet(10);
        ArrayList<String> mustUploadAttachTypeName = new ArrayList<String>(10);
        DynamicObject bill = this.getModel().getDataEntity(true);
        DynamicObject setting = AttachTypeHelper.getInstance().getMatchAttachment(bill);
        DynamicObject dynamicObject = setting = EmptyUtil.isNoEmpty(setting) ? BusinessDataServiceHelper.loadSingle((Object)setting.getLong("id"), (String)"fbd_attachmenttype") : null;
        if (EmptyUtil.isNoEmpty(setting)) {
            DynamicObjectCollection entries = setting.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entries) {
                String operateNode;
                String condition = entry.getString("atsavecondition_tag");
                String attachName = entry.getString("attachname");
                if (entry.getBoolean("ismustupload") && AttachTypeHelper.getInstance().isFilterBill(condition, bill)) {
                    mustUploadAttachTypeName.add("\u201d" + attachName + "\u201d");
                }
                if (!EmptyUtil.isNoEmpty(operateNode = entry.getString("atoperatenode"))) continue;
                opKeySet.addAll(Arrays.stream(operateNode.split(",")).collect(Collectors.toSet()));
            }
        }
        pageCache.put("opKeySet", SerializationUtils.toJsonString(opKeySet));
        String initAttachPageId = pageCache.get("initPanelChildPageId");
        if (EmptyUtil.isNoEmpty(initAttachPageId)) {
            if (source instanceof Save || source instanceof Submit) {
                IFormView childView = this.getView().getView(initAttachPageId);
                if (childView != null) {
                    childView.invokeOperation("close");
                }
                this.showAttachTypePanelForm("fbd_attachtype_panel");
                pageCache.remove("initPanelChildPageId");
            }
            if (opKeySet.contains(operateKey) && EmptyUtil.isNoEmpty(mustUploadAttachTypeName)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u8bbe\u7f6e\u4e86\u9644\u4ef6\u5206\u7c7b{0}\u5fc5\u987b\u4e0a\u4f20\uff0c\u8bf7\u5148\u4e0a\u4f20\u76f8\u5e94\u9644\u4ef6\u3002", (String)"BusinessAttachTypePanelEdit_1", (String)"bos-ext-tmc", (Object[])new Object[]{String.join((CharSequence)"\u3001", mustUploadAttachTypeName)}));
                args.setCancel(true);
            }
        }
        if (EmptyUtil.isNoEmpty(attachPageId = pageCache.get("childPageId"))) {
            IFormView childView = this.getView().getView(attachPageId);
            if (source instanceof Save || source instanceof Submit || opKeySet.contains(operateKey)) {
                OperateOption option = OperateOption.create();
                option.setVariableValue("operateType", source instanceof Save ? "save" : "");
                option.setVariableValue("operateKey", operateKey);
                OperationResult operationResult = childView.invokeOperation("save", option);
                if (!operationResult.isSuccess()) {
                    childView.updateView("entryentity");
                    this.getView().sendFormAction(childView);
                    args.setCancel(true);
                    args.setCancelMessage(ResManager.loadKDString((String)"\u4fdd\u5b58\u9644\u4ef6\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{0}\u3002", (String)"BusinessAttachTypePanelEdit_0", (String)"bos-ext-tmc", (Object[])new Object[]{operationResult.getAllErrorOrValidateInfo()}));
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        Object source = args.getSource();
        args.getOperationResult();
        IPageCache pageCache = this.getView().getPageCache();
        String opKeyJson = pageCache.get("opKeySet");
        Set opKeySet = EmptyUtil.isBlank((CharSequence)opKeyJson) ? new HashSet(16) : (Set)SerializationUtils.fromJsonString((String)opKeyJson, Set.class);
        String attachPageId = pageCache.get("childPageId");
        if (EmptyUtil.isNoEmpty(attachPageId)) {
            IFormView childView = this.getView().getView(attachPageId);
            if (source instanceof Save || source instanceof Submit || opKeySet.contains(operateKey)) {
                OperationResult operationResult = args.getOperationResult();
                if (operationResult.isSuccess()) {
                    childView.invokeOperation("close");
                    this.showAttachTypePanelForm("fbd_attachtype_panel");
                    this.uploadAttachToPanel();
                }
            } else {
                childView.invokeOperation("close");
                this.showAttachTypePanelForm("fbd_attachtype_panel");
            }
        }
    }

    private void uploadAttachToPanel() {
        IPageCache pageCache = this.getView().getPageCache();
        String attachPageId = pageCache.get("childPageId");
        String entityId = this.getView().getEntityId();
        Object pkId = this.getModel().getValue("id");
        AttachmentServiceHelper.remove((String)entityId, (Object)pkId);
        IDataModel childModel = this.getView().getView(attachPageId).getModel();
        Object childDataId = childModel.getValue("id");
        DynamicObject attachPanel = BusinessDataServiceHelper.loadSingle((Object)childDataId, (String)"fbd_attachtype_panel", (String)"id,entryentity,entryentity.attach");
        if (EmptyUtil.isEmpty(attachPanel)) {
            return;
        }
        DynamicObjectCollection entries = attachPanel.getDynamicObjectCollection("entryentity");
        if (EmptyUtil.isEmpty(entries)) {
            return;
        }
        HashMap attachments = new HashMap(8);
        ArrayList attachDataList = new ArrayList(10);
        entries.stream().filter(e -> EmptyUtil.isNoEmpty(e.getDynamicObject("attach"))).map(e -> e.getDynamicObject("attach")).forEach(attachObj -> {
            HashMap<String, Object> attachMap = new HashMap<String, Object>(16);
            attachMap.put("description", attachObj.getString("description"));
            attachMap.put("type", attachObj.getString("type"));
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            InputStream inputStream = fileService.getInputStream(attachObj.getString("url"));
            String saveUrl = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsFullUrl(attachObj.getString("name"), (InputStream)new BufferedInputStream(inputStream), 7200);
            attachMap.put("url", saveUrl);
            attachMap.put("uid", AttachTypeHelper.getInstance().getUid());
            attachMap.put("name", attachObj.getString("name"));
            attachMap.put("size", attachObj.get("size"));
            attachMap.put("fattachmentpanel", this.getAttachmentPanelKey());
            attachMap.put("entityNum", entityId);
            attachMap.put("billPkId", String.valueOf(pkId));
            attachMap.put("lastModified", new Date().getTime());
            attachMap.put("status", "success");
            attachMap.put("client", null);
            attachDataList.add(attachMap);
        });
        attachments.put(this.getAttachmentPanelKey(), attachDataList);
        String appId = this.getModel().getDataEntityType().getAppId();
        AttachmentServiceHelper.saveTempAttachments((String)entityId, (Object)pkId, (String)appId, attachments);
        this.getView().updateView(this.getAttachmentPanelKey());
    }

    private void initAttachTypePanel() {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        Object id = dataEntity.getPkValue();
        if (EmptyUtil.isEmpty(id)) {
            id = DB.genLongId((String)dataEntity.getDataEntityType().getAlias());
            dataEntity.set("id", id);
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{this.getAttachmentPanelKey()});
        if (dataEntity.getDataEntityState().getFromDatabase()) {
            this.showAttachTypePanelForm("fbd_attachtype_panel");
        } else {
            this.showAttachTypePanelForm("fbd_attachtype_init_panel");
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        switch (actionId = evt.getActionId()) {
            case "fbd_attachtype_init_panel": {
                IPageCache pageCache = this.getView().getPageCache();
                pageCache.remove("initPanelChildPageId");
                this.showAttachTypePanelForm("fbd_attachtype_panel");
            }
        }
    }

    private void showAttachTypePanelForm(String fromId) {
        IFormView view = this.getView();
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey("attachtypeflexcontainer");
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.setFormId(fromId);
        formShowParameter.setCustomParam("businessAttachPanelKey", (Object)this.getAttachmentPanelKey());
        formShowParameter.setCustomParam("parentPageId", (Object)view.getPageId());
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, fromId));
        view.showForm(formShowParameter);
    }

    public String getAttachmentPanelKey() {
        return DEFAULT_ATTACHMENT_PANEL_KEY;
    }
}

