/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.utils.commitToBe.ctbservice;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.ext.tmc.utils.commitToBe.AbstractCommitToBeService;
import kd.bos.ext.tmc.utils.commitToBe.enums.BillStatusEnum;
import kd.bos.ext.tmc.utils.commitToBe.enums.FcaTransDetailStatusEnum;
import kd.bos.ext.tmc.utils.commitToBe.enums.FcaTransPayChanEnum;
import kd.bos.ext.tmc.utils.commitToBe.enums.FcaTransPayStatusEnum;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.tuple.Pair;

public class TransUpBillCTBService
extends AbstractCommitToBeService {
    @Override
    protected String getOrgProp() {
        return null;
    }

    @Override
    protected String getEntityTable() {
        return "T_FCA_TRANSUPBILL";
    }

    @Override
    protected String getBillEntity() {
        return "fca_transupbill";
    }

    @Override
    protected String getBankBillEntity() {
        return "bei_banktransupbill";
    }

    @Override
    protected String selectField() {
        return "entrys.payuser,entrys.state,entrys.paystatus,entrys.paychanel,entrys.submitpaytime,entrys.paystatus,billstatus";
    }

    @Override
    public void splitBankBill() {
        ArrayList auditList = new ArrayList();
        this.bankOpCol.put("audit", auditList);
        for (Map.Entry one : this.payBillToBankBillMap.entrySet()) {
            auditList.add(one.getValue());
            this.commitBeBankBillCol.add(one.getValue());
        }
    }

    @Override
    protected void doSignSuccess(List<Object> successIdList) {
    }

    @Override
    protected void rollback(List<Pair<Long, String>> rollbackPayBillIdList) {
        ArrayList<DynamicObject> rollbackPayBillList = new ArrayList<DynamicObject>(rollbackPayBillIdList.size());
        for (Pair<Long, String> result : rollbackPayBillIdList) {
            DynamicObject transBill = this.payBillList.stream().filter(o -> o.getPkValue().equals(result.getLeft())).findFirst().orElse(null);
            if (transBill == null) continue;
            DynamicObjectCollection entries = transBill.getDynamicObjectCollection("entrys");
            for (DynamicObject entry : entries) {
                String state = (String)entry.get("state");
                String payStatus = (String)entry.get("paystatus");
                String paychanel = (String)entry.get("paychanel");
                if (!FcaTransDetailStatusEnum.NORMAL.getValue().equals(state) || !FcaTransPayStatusEnum.BEIPROC.getValue().equals(payStatus) || !FcaTransPayChanEnum.BEI.getValue().equals(paychanel)) continue;
                entry.set("submitpaytime", null);
                entry.set("payuser", (Object)0L);
                entry.set("paystatus", (Object)FcaTransPayStatusEnum.INIT.getValue());
            }
            transBill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
            rollbackPayBillList.add(transBill);
        }
        if (rollbackPayBillList.size() > 0) {
            try (TXHandle handle = TX.requiresNew();){
                try {
                    SaveServiceHelper.update((DynamicObject[])rollbackPayBillList.toArray(new DynamicObject[0]));
                }
                catch (Exception e) {
                    handle.markRollback();
                    throw e;
                }
            }
        }
    }
}

