/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.bd.operation;

import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.operate.DefaultDynamicFormOperate;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class BarcodeGenerate
extends DefaultDynamicFormOperate {
    private static final String MODULE = "bos-ext-bd";
    private static final Log LOGGER = LogFactory.getLog(BarcodeGenerate.class);

    public boolean needSelectData() {
        return false;
    }

    protected boolean beforeInvokeOperation(OperationResult operationResult) {
        if (!super.beforeInvokeOperation(operationResult)) {
            return false;
        }
        IFormView view = this.getView();
        boolean fBillView = view instanceof IBillView;
        String baseStatus = "status";
        String billStauts = "billstatus";
        boolean fInfoSave = false;
        if (fBillView) {
            DynamicObject bizObj = view.getModel().getDataEntity();
            MainEntityType dataEntityType = view.getModel().getDataEntityType();
            if (dataEntityType.findProperty(billStauts) != null) {
                String billStatus = bizObj.getString(billStauts);
                fInfoSave = "A".equals(billStatus);
            }
            if (!fInfoSave && dataEntityType.findProperty(baseStatus) != null) {
                String status = bizObj.getString(baseStatus);
                fInfoSave = "A".equals(status);
            }
        }
        if (fInfoSave) {
            String msg = ResManager.loadKDString((String)"\u6761\u7801\u751f\u6210\u4ec5\u9002\u7528\u4e8e\u4fdd\u5b58\u540e\u7684\u6570\u636e\uff01", (String)"NOT_EDITABLE_OR_LIST", (String)MODULE, (Object[])new Object[0]);
            view.showTipNotification(msg);
            return false;
        }
        return true;
    }

    public OperationResult invokeOperation() {
        IFormView view = this.getView();
        String viewPageId = view.getPageId();
        String pageId = "barcodegen_" + viewPageId;
        IFormView parseView = view.getViewNoPlugin(pageId);
        if (null != parseView) {
            parseView.activate();
        } else {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("barcode_generate");
            parameter.setPageId(pageId);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            HashMap<String, String> custParam = new HashMap<String, String>();
            custParam.put("width", "600px");
            custParam.put("hight", "600px");
            parameter.getOpenStyle().setCustParam(custParam);
            IFormView billView = this.getView();
            String entityKey = this.getEntityId();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("entityKey", entityKey);
            ArrayList<Object> ids = new ArrayList<Object>();
            if (billView instanceof IListView) {
                params.put("viewBillFormId", entityKey);
                params.put("permissionEntityId", this.getPermissionEntityId());
                ListSelectedRowCollection selectedRows = ((IListView)billView).getSelectedRows();
                selectedRows.forEach(e -> ids.add(e.getPrimaryKeyValue()));
            } else {
                ids.add(billView.getModel().getValue("id"));
            }
            params.put("ids", ids);
            parameter.setCustomParams(params);
            view.showForm(parameter);
        }
        return super.invokeOperation();
    }
}

