/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.bd.operation.bizrule;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IEntryType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.ext.bd.common.vo.BarcodeBillEntryData;
import kd.bos.ext.bd.common.vo.BarcodeGenerateOption;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class BarcodeGenOpAction
extends AbstractOpBizRuleAction {
    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        Object[] entities = e.getDataEntities();
        if (ArrayUtils.isEmpty((Object[])entities)) {
            return;
        }
        String ruleNumber = entities[0].getDataEntityType().getName();
        QFilter[] autoFilter = new QFilter[]{new QFilter("isautogenerate", "=", (Object)true), new QFilter("bizobj", "=", (Object)ruleNumber)};
        DynamicObject barcoderule = BusinessDataServiceHelper.loadSingleFromCache((String)"barcode_rule", (QFilter[])autoFilter);
        if (barcoderule == null) {
            return;
        }
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<String> entryIds = new ArrayList<String>();
        HashSet<String> selectFields = new HashSet<String>();
        selectFields.add("id");
        String qtyProp = null;
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)ruleNumber);
        for (Object[] data : barcoderule.getDynamicObjectCollection("entry")) {
            String key = data.getString("objprop");
            if (StringUtils.isBlank((String)key)) continue;
            String pname = this.getPropName(key);
            String entryName = this.getEntryName(pname, dt);
            if (StringUtils.isNotBlank((String)entryName)) {
                keys.add(entryName + "." + key);
                selectFields.add(entryName + "." + key);
                selectFields.add(entryName + ".id");
                entryIds.add(entryName + ".id");
            } else {
                keys.add(key);
                selectFields.add(key);
            }
            if (!data.getBoolean("isqtyprop")) continue;
            qtyProp = key;
            if (!StringUtils.isNotBlank((String)entryName)) continue;
            qtyProp = entryName + "." + key;
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        for (Object data : entities) {
            ids.add(data.getLong("id"));
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)ruleNumber, (String)StringUtils.join(selectFields, (String)","), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids.toArray())});
        ArrayList<BarcodeGenerateOption> options = new ArrayList<BarcodeGenerateOption>();
        for (int i = 0; i < query.size(); ++i) {
            BarcodeGenerateOption option = new BarcodeGenerateOption();
            DynamicObject data = (DynamicObject)query.get(i);
            if (barcoderule.getBoolean("isperitem")) {
                BigDecimal quantity = new BigDecimal(data.get(qtyProp).toString()).setScale(0, 1);
                option.setCount(quantity.intValue());
            }
            ArrayList<BarcodeBillEntryData> entries = new ArrayList<BarcodeBillEntryData>();
            for (String entryId : entryIds) {
                String[] split = entryId.replace(".id", "").split("\\.");
                String entryName = split[split.length - 1];
                Long id = data.getLong(entryId);
                if (StringUtils.isEmpty((String)entryName) || id == null || id <= 0L) continue;
                BarcodeBillEntryData entryInfo = new BarcodeBillEntryData();
                entryInfo.setEntryName(entryName);
                entryInfo.setEntryId(id);
                entries.add(entryInfo);
            }
            option.setEntryNameIds(entries);
            option.setBillId(data.getLong("id"));
            options.add(option);
        }
        DispatchServiceHelper.invokeBizService((String)"bd", (String)"barcode", (String)"BarcodeGenerateService", (String)"generateSaveBarcodes", (Object[])new Object[]{barcoderule.getLong("id"), RequestContext.get().getOrgId(), JSON.toJSONString(options)});
    }

    private String getEntryName(String pname, MainEntityType dt) {
        String sup;
        String entryName = this.getBarcodeMetadataEntryName(pname, (DynamicObjectType)dt);
        if (StringUtils.isNotBlank((String)entryName) && StringUtils.isNotBlank((String)(sup = this.getEntryName(entryName, dt)))) {
            entryName = sup + "." + entryName;
        }
        return entryName;
    }

    private String getBarcodeMetadataEntryName(String pname, DynamicObjectType objType) {
        IDataEntityType parentType;
        DynamicProperty pType = this.getPropertyMeta(pname, objType);
        String ename = null;
        if (pType != null && (parentType = pType.getParent()) instanceof IEntryType) {
            ename = parentType.getName();
        }
        return ename;
    }

    public DynamicProperty getPropertyMeta(String pname, DynamicObjectType objType) {
        DynamicProperty propMeta = objType.getProperty(pname);
        if (propMeta == null && objType instanceof MainEntityType) {
            propMeta = (DynamicProperty)((MainEntityType)objType).findProperty(pname);
        }
        return propMeta;
    }

    public String getPropName(String prop) {
        int indexDot;
        String pName = prop;
        if (prop != null && (indexDot = prop.indexOf(46)) > 0) {
            pName = prop.substring(0, indexDot);
        }
        return pName;
    }
}

