/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.imsc.dmw.form.formext;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.formula.FormulaEngine;

public class FormulaFormPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static final String KEY_TREEVIEW = "tv_fields";
    private static final String KEY_FEXPRESSION = "fexpression";
    private static final String CUSTPARAMKEY_TREENODES = "treenodes";
    private static final String KEY_BTNOK = "btnok";
    private static final String KEY_BTNCANCEL = "btncancel";
    private static final String CLOSEFCANCEL = "closeflag";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BTNOK, KEY_BTNCANCEL});
        TreeView tv = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if (KEY_BTNOK.equalsIgnoreCase(ctlSource.getKey()) && "2".equals(this.getView().getPageCache().get(CLOSEFCANCEL))) {
            String expression = (String)this.getModel().getValue(KEY_FEXPRESSION);
            HashSet<String> varSet = new HashSet<String>(16);
            if (StringUtils.isNotBlank((CharSequence)expression)) {
                String[] vars = FormulaEngine.extractVariables((String)expression);
                String strJson = (String)this.getView().getFormShowParameter().getCustomParam(CUSTPARAMKEY_TREENODES);
                List<Object> childrenList = new ArrayList(16);
                if (StringUtils.isNotBlank((CharSequence)strJson)) {
                    TreeNode treeNode = (TreeNode)SerializationUtils.fromJsonString((String)strJson, TreeNode.class);
                    childrenList = treeNode.getChildren().stream().flatMap(t -> t.getChildren().stream()).collect(Collectors.toList());
                }
                for (String var : vars) {
                    long count = childrenList.stream().filter(o -> var.equals(o.getId())).count();
                    if (count != 0L) continue;
                    varSet.add(var);
                }
            }
            if (!varSet.isEmpty()) {
                String errMessage = String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f%1$s\uff0c\u5305\u542b\u4e86\u672a\u77e5\u53d8\u91cf%2$s\uff0c\u8bf7\u5148\u4fee\u8ba2\u540e\u4fdd\u5b58\u3002", (String)"FormulaFormPlugin_0", (String)"bos-ext-imsc", (Object[])new Object[0]), expression, StringUtils.join((Object[])varSet.toArray(), (char)','));
                this.getView().showTipNotification(errMessage);
            } else {
                this.getView().getPageCache().put(CLOSEFCANCEL, "1");
                this.getView().close();
            }
        } else if (KEY_BTNCANCEL.equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().getPageCache().put(CLOSEFCANCEL, "1");
            this.getView().close();
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        if (StringUtils.isEmpty((CharSequence)((String)e.getParentNodeId())) || "billhead".equals(e.getParentNodeId())) {
            this.getModel().beginInit();
            this.getModel().setValue(KEY_FEXPRESSION, (Object)this.getView().getPageCache().get(KEY_FEXPRESSION));
            this.getModel().endInit();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCancel(true);
        if ("1".equals(this.getView().getPageCache().get(CLOSEFCANCEL))) {
            e.setCancel(false);
        }
        this.getView().getPageCache().put(CLOSEFCANCEL, "2");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (KEY_FEXPRESSION.equalsIgnoreCase(e.getProperty().getName())) {
            ChangeData[] changeSet = e.getChangeSet();
            if (changeSet == null || changeSet.length <= 0) {
                return;
            }
            ChangeData changeData = changeSet[0];
            String oldValue = (String)changeData.getOldValue();
            this.getView().getPageCache().put(KEY_FEXPRESSION, oldValue);
        }
    }
}

