/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.occ.action.oeoms.operation;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.exception.KDBizException;
import kd.bos.ext.occ.action.common.ActionResult;
import kd.bos.ext.occ.action.common.BaseAction;
import kd.bos.ext.occ.action.oeoms.dto.OperationInfoDTO;
import kd.bos.ext.occ.action.oeoms.vo.ItemSearchVO;
import kd.bos.ext.occ.action.oeoms.vo.SaleOrderItemListVO;
import kd.bos.ext.occ.help.OccExtServiceHelper;

public class SaleOrderItemOperationAction
extends BaseAction {
    public ActionResult orderOperation(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return this.actionHandler(OperationInfoDTO.class, this::getItemListByOid, request, response);
    }

    public List<SaleOrderItemListVO> getItemListByOid(OperationInfoDTO operationInfoDTO) {
        List<JSONObject> mapList = this.getOrdersData(operationInfoDTO);
        JSONObject order = mapList.get(0);
        if (order == null) {
            throw new KDBizException("\u8ba2\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long orderId = order.getLong("id");
        return (List)OccExtServiceHelper.oeoms("SaleOrderItemOperationService", "getItemListByOid", orderId);
    }

    public List<JSONObject> getOrdersData(OperationInfoDTO operationInfoDTO) {
        JSONObject data = JSON.parseObject((String)JSON.toJSONString(operationInfoDTO.getData()));
        return JSON.parseArray((String)JSON.toJSONString((Object)data.get((Object)"orders")), JSONObject.class);
    }

    public ActionResult commodityFunction(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return this.actionHandler(String.class, requestJson -> OccExtServiceHelper.oeoms("SaleOrderItemOperationService", "doItemOperation", requestJson), request, response);
    }

    public ActionResult itemList(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return this.actionHandler(() -> OccExtServiceHelper.oeoms("SaleOrderItemService", "itemList", new Object[0]), response);
    }

    public ActionResult ownerList(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return this.actionHandler(String.class, requestJson -> OccExtServiceHelper.oeoms("SaleOrderItemService", "ownerList", requestJson), request, response);
    }

    public ActionResult queryItemBySearch(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return this.actionHandler(ItemSearchVO.class, searchVO -> OccExtServiceHelper.oeoms("SaleOrderItemService", "queryItemBySearch", searchVO), request, response);
    }

    public ActionResult queryStockInfoBySkuId(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return this.actionHandler(String.class, "sku", sku -> OccExtServiceHelper.oeoms("SaleOrderItemService", "queryStockInfoBySkuId", sku), request, response);
    }
}

