/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.bizrule.asyncop;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.bizrule.asyncbizrule.enums.AsyncStatusEnum;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class AsyncServiceMarkSuccessOp
extends AbstractOperationServicePlugIn {
    private static final String ASYNC_STATUS = "asyncstatus";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("entity");
        e.getFieldKeys().add("billid");
        e.getFieldKeys().add("operator");
        e.getFieldKeys().add("param_tag");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] logDycs = e.getDataEntities();
        if (logDycs == null || logDycs.length < 1) {
            return;
        }
        this.markBillAsyncStatusAndAsyncLogSuccess(logDycs);
    }

    private void markBillAsyncStatusAndAsyncLogSuccess(DynamicObject[] logDycs) {
        HashMap<String, Set> entityBillIdsMap = new HashMap<String, Set>(16);
        HashSet<Object> logBillIds = new HashSet<Object>(logDycs.length);
        HashSet<String> entityOperatorBillIdDimStrs = new HashSet<String>(logDycs.length);
        for (DynamicObject logDyc : logDycs) {
            String entity = logDyc.getString("entity.number");
            String billIdStr = logDyc.getString("billid");
            String entityOperatorBillIdDimStr = entity + "|" + logDyc.getString("operator") + "|" + billIdStr;
            Object billID = this.getBillID(billIdStr, entity);
            Set billIds = entityBillIdsMap.computeIfAbsent(entity, k -> new HashSet(16));
            billIds.add(billID);
            logBillIds.add(billIdStr);
            entityOperatorBillIdDimStrs.add(entityOperatorBillIdDimStr);
        }
        for (Map.Entry entry : entityBillIdsMap.entrySet()) {
            this.markBillAsyncStatusSuccessByEntity((String)entry.getKey(), (Set)entry.getValue());
        }
        this.markAsyncLogSuccess(logBillIds, entityOperatorBillIdDimStrs);
    }

    private void markBillAsyncStatusSuccessByEntity(String entity, Set<Object> billIds) {
        DynamicObject[] billDycs;
        QFilter billIdf = new QFilter("id", "in", billIds);
        for (DynamicObject billDyc : billDycs = BusinessDataServiceHelper.load((String)entity, (String)ASYNC_STATUS, (QFilter[])new QFilter[]{billIdf})) {
            billDyc.set(ASYNC_STATUS, (Object)AsyncStatusEnum.FINISHED.getValue());
        }
        try (TXHandle h = TX.requiresNew();){
            SaveServiceHelper.save((DynamicObject[])billDycs);
        }
    }

    private void markAsyncLogSuccess(Set<Object> logBillIds, Set<String> entityOperatorBillIdDimStrs) {
        String selectLogProps = "entity,operator,billid,success,log_tag";
        QFilter logBillIdsf = new QFilter("billid", "in", logBillIds);
        QFilter failf = new QFilter("success", "=", (Object)Boolean.FALSE);
        DynamicObject[] asyncLogDycs = BusinessDataServiceHelper.load((String)"bos_log_asyncop", (String)selectLogProps, (QFilter[])new QFilter[]{logBillIdsf, failf});
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        Date now = new Date();
        String time = sdf.format(now);
        String opMsg = RequestContext.get().getUserName() + "|" + time + "|" + ((Map)this.operateMeta.get("name")).get(ResManager.getLanguage());
        for (DynamicObject logDyc : asyncLogDycs) {
            String entity = logDyc.getString("entity.number");
            String billIdStr = logDyc.getString("billid");
            String entityOperatorBillIdDimStr = entity + "|" + logDyc.getString("operator") + "|" + billIdStr;
            if (!entityOperatorBillIdDimStrs.contains(entityOperatorBillIdDimStr)) continue;
            logDyc.set("success", (Object)Boolean.TRUE);
            logDyc.set("log_tag", (Object)(logDyc.getString("log_tag") + opMsg));
        }
        SaveServiceHelper.save((DynamicObject[])asyncLogDycs);
    }

    private Object getBillID(String billIdStr, String formId) {
        if (StringUtils.isEmpty((CharSequence)formId)) {
            return billIdStr;
        }
        int idType = EntityMetadataCache.getDataEntityType((String)formId).getPrimaryKey().getDbType();
        Object billId = idType == -5 ? Long.valueOf(billIdStr) : (idType == 4 ? Integer.valueOf(billIdStr) : billIdStr);
        return billId;
    }
}

