/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.changemodel.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.report.CellStyle;
import kd.bos.entity.tree.TreeNode;
import kd.bos.ext.scmc.changemodel.helper.ChangeModelHelper;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.metadata.AbstractElement;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.BarItemAp;

public class ChangeDisplayHelper {
    public static void markEntryChangeField(EntryGrid entryGrid, Map<String, List<String>> logFieldsMap, List<RowDataEntity> rows, String entryId) {
        if (entryGrid == null || logFieldsMap == null || rows == null || rows.size() == 0) {
            return;
        }
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>();
        for (RowDataEntity entity : rows) {
            List<String> fields = logFieldsMap.get(String.valueOf(entity.getDataEntity().get(entryId)));
            if (fields == null) continue;
            for (String field : fields) {
                CellStyle item = new CellStyle();
                item.setFieldKey(field);
                item.setRow(entity.getRowIndex());
                item.setBackColor("#ffebd2");
                cellStyles.add(item);
            }
        }
        entryGrid.setCellStyle(cellStyles);
    }

    public static void clearChangeFieldMark(IFormView view, Set<String> logFields) {
        ChangeDisplayHelper.markChangeFieldByColor(view, logFields, null);
    }

    private static void markChangeFieldByColor(IFormView view, Set<String> logFields, String color) {
        if (view == null || logFields == null) {
            return;
        }
        MainEntityType dataEntityType = view.getModel().getDataEntityType();
        HashMap fieldMap = new HashMap();
        HashMap<String, String> itemMap = new HashMap<String, String>();
        itemMap.put("bc", color);
        fieldMap.put("item", itemMap);
        HashMap<String, Set> entryFields = new HashMap<String, Set>(8);
        for (String field : logFields) {
            IDataEntityProperty property = dataEntityType.findProperty(field);
            if (property == null) continue;
            IDataEntityType parent = property.getParent();
            if (parent instanceof EntryType) {
                Set fields = entryFields.computeIfAbsent(parent.getName(), k -> new HashSet(8));
                fields.add(field);
                continue;
            }
            view.updateControlMetadata(field, fieldMap);
        }
        for (Map.Entry row : entryFields.entrySet()) {
            EntryGrid entryGrid = (EntryGrid)view.getControl((String)row.getKey());
            for (String field : (Set)row.getValue()) {
                entryGrid.setColumnProperty(field, "bc", (Object)color);
            }
        }
    }

    public static TreeNode findNodeById(TreeNode root, String targetId) {
        if (root == null || targetId == null) {
            return null;
        }
        LinkedList<TreeNode> queue = new LinkedList<TreeNode>();
        queue.offer(root);
        while (!queue.isEmpty()) {
            TreeNode curr = (TreeNode)queue.poll();
            if (curr.getId() != null && curr.getId().equals(targetId)) {
                return curr;
            }
            if (curr.getChildren() == null) continue;
            for (TreeNode child : curr.getChildren()) {
                queue.offer(child);
            }
        }
        return null;
    }

    public static void reNewBillDisplay(IFormView view) {
        String revisesaveKey;
        MainEntityType dataEntityType = view.getModel().getDataEntityType();
        String entityId = dataEntityType.getName();
        Set<String> canReviseFields = ChangeModelHelper.getCanReviseFields(entityId);
        ChangeDisplayHelper.setReviseDisplay(view, canReviseFields, "52", null);
        String reviseKey = ChangeDisplayHelper.getOperationKey(entityId, "revise");
        if (StringUtils.isNotBlank((CharSequence)reviseKey)) {
            view.setVisible(Boolean.valueOf(true), new String[]{reviseKey});
        }
        if (StringUtils.isNotBlank((CharSequence)(revisesaveKey = ChangeDisplayHelper.getOperationKey(entityId, "revisesave")))) {
            view.setVisible(Boolean.valueOf(false), new String[]{revisesaveKey});
        }
    }

    public static void setReviseDisplay(IFormView view, Set<String> canReviseFields) {
        ChangeDisplayHelper.setReviseDisplay(view, canReviseFields, "4", "#ffebd2");
    }

    public static void setReviseDisplay(IFormView view, Set<String> canReviseFields, String lockType, String backColor) {
        MainEntityType dataEntityType = view.getModel().getDataEntityType();
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        fieldMap.put("l", lockType);
        HashMap<String, String> itemMap = new HashMap<String, String>();
        itemMap.put("bc", backColor);
        fieldMap.put("item", itemMap);
        HashMap<String, Set> entryFields = new HashMap<String, Set>(8);
        for (String field : canReviseFields) {
            IDataEntityProperty property = dataEntityType.findProperty(field);
            if (property == null) continue;
            IDataEntityType parent = property.getParent();
            if (parent instanceof EntryType) {
                Set fields = entryFields.computeIfAbsent(parent.getName(), k -> new HashSet(8));
                fields.add(field);
                continue;
            }
            view.updateControlMetadata(field, fieldMap);
            view.setEnable(Boolean.valueOf(true), new String[]{field});
        }
        for (Map.Entry next : entryFields.entrySet()) {
            EntryGrid entryGrid = (EntryGrid)view.getControl((String)next.getKey());
            view.updateControlMetadata((String)next.getKey(), fieldMap);
            view.setEnable(Boolean.valueOf(true), new String[]{(String)next.getKey()});
            for (String field : (Set)next.getValue()) {
                entryGrid.setColumnProperty(field, "l", (Object)lockType);
                entryGrid.setColumnProperty(field, "bc", (Object)backColor);
                view.setEnable(Boolean.valueOf(true), -1, new String[]{field});
            }
        }
        String reviseKey = ChangeDisplayHelper.getOperationKey(dataEntityType.getName(), "revise");
        String revisesaveKey = ChangeDisplayHelper.getOperationKey(dataEntityType.getName(), "revisesave");
        if (StringUtils.isNotBlank((CharSequence)reviseKey)) {
            view.setVisible(Boolean.valueOf(false), new String[]{reviseKey});
        }
        if (StringUtils.isNotBlank((CharSequence)revisesaveKey)) {
            fieldMap = new HashMap();
            fieldMap.put("vi", 63);
            view.updateControlMetadata(revisesaveKey, fieldMap);
            view.setVisible(Boolean.valueOf(true), new String[]{revisesaveKey});
        }
    }

    public static String getOperationKey(String entityId, String opType) {
        List collect;
        List items;
        String validKey = "";
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)entityId, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        if (formMeta != null && (items = formMeta.getItems()) != null && (collect = items.stream().filter(k -> k instanceof BarItemAp).filter(k -> opType.equals(((BarItemAp)k).getOperationKey())).map(AbstractElement::getKey).collect(Collectors.toList())).size() > 0) {
            validKey = (String)collect.get(0);
        }
        return validKey;
    }
}

