/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.changemodel.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.ext.scmc.changemodel.helper.ChangeModelHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class ChangeLogHelper {
    public static String getChangeStatus(String entityId, Object pkId) {
        String changeStatus;
        if (StringUtils.isBlank((CharSequence)entityId) || pkId == null) {
            return "";
        }
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityId);
        if (entityType == null) {
            return "";
        }
        Map<String, String> fieldMapping = ChangeModelHelper.getCusParaMapping(entityId);
        QFilter q = new QFilter("id", "=", pkId);
        if (fieldMapping != null && fieldMapping.get("changestatus") != null && (changeStatus = fieldMapping.get("changestatus")) != null && entityType.getProperty(changeStatus) != null) {
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)ChangeModelHelper.class.getName(), (String)entityId, (String)changeStatus, (QFilter[])new QFilter[]{q}, null);){
                Row row;
                if (ds != null && (row = ds.next()) != null) {
                    String string = row.getString(changeStatus);
                    return string;
                }
            }
        }
        return ChangeLogHelper.getChangeStatusByLog(entityId, pkId);
    }

    public static String getChangeStatusByLog(String entityId, Object pkId) {
        if (entityId == null || pkId == null) {
            return null;
        }
        DynamicObject changeModel = ChangeModelHelper.getChangeModel(entityId);
        if (changeModel == null) {
            return null;
        }
        String XBillLogEntity = "plat_xbilllog";
        if (changeModel.getDynamicObject("xbilllog") != null) {
            XBillLogEntity = (String)changeModel.getDynamicObject("xbilllog").getPkValue();
        }
        QFilter q1 = new QFilter("srcbillid", "=", pkId);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)ChangeModelHelper.class.getName(), (String)XBillLogEntity, (String)"srcbillversion,changestatus ", (QFilter[])new QFilter[]{q1}, (String)"id desc", (int)1);){
            if (ds != null && ds.hasNext()) {
                String string = ds.next().getString("changestatus");
                return string;
            }
        }
        return null;
    }

    public static Set<String> getEntryKeyByLog(String entityId, Object pkId) {
        HashSet<String> entryKeys = new HashSet<String>(8);
        if (entityId == null || pkId == null) {
            return entryKeys;
        }
        DynamicObject changeModel = ChangeModelHelper.getChangeModel(entityId);
        if (changeModel == null) {
            return entryKeys;
        }
        String xLogEntity = "plat_xbilllog";
        if (changeModel != null && changeModel.getDynamicObject("xbilllog") != null) {
            xLogEntity = (String)changeModel.getDynamicObject("xbilllog").getPkValue();
        }
        QFilter q1 = new QFilter("srcbillid", "=", pkId);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)ChangeModelHelper.class.getName(), (String)xLogEntity, (String)"entryentity.entrykey entrykey", (QFilter[])new QFilter[]{q1}, null);){
            if (ds == null || !ds.hasNext()) {
                HashSet<String> hashSet = entryKeys;
                return hashSet;
            }
            for (Row row : ds) {
                if (!StringUtils.isNotBlank((CharSequence)row.getString("entrykey"))) continue;
                entryKeys.add(row.getString("entrykey"));
            }
        }
        return entryKeys;
    }

    public static Map<String, Map<String, List<String>>> getLastestLogFields(Object srcId, String entityId) {
        return ChangeLogHelper.getLogFields(srcId, null, entityId, false);
    }

    public static Map<String, Map<String, List<String>>> getAllLogFields(Object srcId, String entityId) {
        return ChangeLogHelper.getLogFields(srcId, null, entityId, true);
    }

    public static Map<String, Map<String, List<String>>> getLogFields4XBill(Object srcbillid, Object xbillId, String entityId) {
        return ChangeLogHelper.getLogFields(srcbillid, xbillId, entityId, false);
    }

    public static Map<String, Map<String, List<String>>> getLogFields(Object srcbillid, Object xbillId, String entityId, boolean isAllVer) {
        Object object;
        HashMap<String, Map<String, List<String>>> logFieldsMap = new HashMap<String, Map<String, List<String>>>(8);
        DynamicObject changeModel = ChangeModelHelper.getChangeModel(entityId);
        if (changeModel == null) {
            return logFieldsMap;
        }
        String xLogEntity = "plat_xbilllog";
        if (changeModel.getDynamicObject("xbilllog") != null) {
            xLogEntity = (String)changeModel.getDynamicObject("xbilllog").getPkValue();
        }
        QFilter q1 = new QFilter("srcbillid", "=", srcbillid);
        if (xbillId != null) {
            QFilter q2 = new QFilter("xbillid", "=", xbillId);
            q1.and(q2);
        }
        if (!isAllVer) {
            Integer version = 0;
            DataSet ds = QueryServiceHelper.queryDataSet((String)ChangeModelHelper.class.getName(), (String)xLogEntity, (String)"srcbillversion ", (QFilter[])new QFilter[]{q1}, (String)"id desc", (int)1);
            object = null;
            try {
                if (ds == null || !ds.hasNext()) {
                    HashMap<String, Map<String, List<String>>> hashMap = logFieldsMap;
                    return hashMap;
                }
                version = ds.next().getInteger("srcbillversion");
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (object != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
            QFilter q3 = "pm_xpurplanbilllog".equals(xLogEntity) || "pm_xpurapplybilllog".equals(xLogEntity) ? new QFilter("srcbillversion", "=", (Object)String.valueOf(version)) : new QFilter("srcbillversion", "=", (Object)version);
            q1.and(q3);
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)ChangeModelHelper.class.getName(), (String)xLogEntity, (String)"entryentity.rowid rowid,entryentity.entrykey entrykey,entryentity.fieldkey fieldkey", (QFilter[])new QFilter[]{q1}, null);){
            if (ds == null || !ds.hasNext()) {
                object = logFieldsMap;
                return object;
            }
            for (Row row : ds) {
                String entrykey = StringUtils.isEmpty((CharSequence)row.getString("entrykey")) ? "HEAD" : row.getString("entrykey");
                Map entryMap = logFieldsMap.computeIfAbsent(entrykey, k -> new HashMap());
                String rowid = StringUtils.isEmpty((CharSequence)row.getString("rowid")) ? "0" : row.getString("rowid");
                List fieldList = entryMap.computeIfAbsent(rowid, k -> new ArrayList());
                fieldList.add(row.getString("fieldkey"));
            }
        }
        return logFieldsMap;
    }
}

