/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.changemodel.operation;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.ext.scmc.changemodel.helper.ChangeModelHelper;
import kd.bos.ext.scmc.changemodel.validator.ReviseVaildValidator;
import kd.bos.service.operation.EntityOperateService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class ReviseValidOpService
extends EntityOperateService {
    protected void preparePropertys(List<String> fieldKeys) {
        super.preparePropertys(fieldKeys);
        Map<String, String> fieldMapping = ChangeModelHelper.getCusParaMapping(this.billEntityType.getName());
        if (fieldMapping != null && fieldMapping.size() > 0) {
            fieldMapping.forEach((k, v) -> this.getOption().setVariableValue(k, v));
            fieldKeys.addAll(ChangeModelHelper.getPreparePropertys(fieldMapping, this.getBillEntityType()));
        }
    }

    protected void addDefaultValidator(List<AbstractValidator> e) {
        super.addDefaultValidator(e);
        List<AbstractValidator> validators = ChangeModelHelper.getReviseValidations(this.billEntityType.getName(), this.operationKey);
        if (validators != null) {
            e.addAll(validators);
        }
        e.add(new ReviseVaildValidator());
    }

    protected void executeOperate(DynamicObject[] dynamicObjects) {
        if (dynamicObjects != null) {
            String changeStatusId = "";
            String versionId = "";
            String changerId = "";
            String changeDateId = "";
            Map variables = this.getOption().getVariables();
            if (variables.containsKey("changestatus")) {
                changeStatusId = this.getOption().getVariableValue("changestatus");
            }
            if (variables.containsKey("version")) {
                versionId = this.getOption().getVariableValue("version");
            }
            if (variables.containsKey("changer")) {
                changerId = this.getOption().getVariableValue("changer");
            }
            if (variables.containsKey("changedate")) {
                changeDateId = this.getOption().getVariableValue("changedate");
            }
            for (int i = 0; i < dynamicObjects.length; ++i) {
                DynamicObject bill = dynamicObjects[i];
                DynamicProperty prop = bill.getDynamicObjectType().getProperty(changeStatusId);
                if (prop != null) {
                    bill.set(changeStatusId, (Object)"C");
                }
                if ((prop = bill.getDynamicObjectType().getProperty(versionId)) != null) {
                    String version = bill.getString(versionId);
                    try {
                        if (StringUtils.isBlank((CharSequence)version)) {
                            bill.set(versionId, (Object)2);
                        } else {
                            int v = Integer.parseInt(version);
                            bill.set(versionId, (Object)(++v));
                        }
                    }
                    catch (Exception e) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u201c\u7248\u672c\u53f7\u201d\u5b57\u6bb5\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ReviseValidOpService_1", (String)"bos-ext-scmc", (Object[])new Object[0]));
                    }
                }
                if ((prop = bill.getDynamicObjectType().getProperty(changerId)) != null) {
                    DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((Object)UserServiceHelper.getCurrentUserId(), (String)"bos_user");
                    bill.set(changerId, (Object)user);
                }
                if ((prop = bill.getDynamicObjectType().getProperty(changeDateId)) != null) {
                    bill.set(changeDateId, (Object)TimeServiceHelper.now());
                }
                DynamicObject originalBill = BusinessDataServiceHelper.loadSingle((Object)bill.getPkValue(), (String)this.getBillEntityType().getName(), (String)String.join((CharSequence)",", ChangeModelHelper.getPreparePropertys(this.getOption().getVariables(), this.getBillEntityType())));
                dynamicObjects[i] = ChangeModelHelper.invokeReviseLogServise(originalBill, bill, "valid");
            }
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
    }
}

