/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.chargeagainst.handle;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.ext.scmc.chargeagainst.consts.BillOpEnum;
import kd.bos.ext.scmc.chargeagainst.service.CaLogService;
import kd.bos.ext.scmc.chargeagainst.util.CommonUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class BillOpHandle {
    private static final Log logger = LogFactory.getLog(BillOpHandle.class);
    private CaLogService caLogService;

    public static BillOpHandle build(CaLogService caLogService) {
        BillOpHandle handle = new BillOpHandle();
        handle.setCaLogService(caLogService);
        return handle;
    }

    public void billOpService(Map<String, List<DynamicObject>> allCaBills) {
        for (Map.Entry<String, List<DynamicObject>> allCaBill : allCaBills.entrySet()) {
            this.generateBillOpDeal(allCaBill);
        }
    }

    private void generateBillOpDeal(Map.Entry<String, List<DynamicObject>> allCaBill) {
        List<DynamicObject> allCaBillList = allCaBill.getValue();
        DynamicObject[] caBillArray = allCaBillList.toArray(new DynamicObject[allCaBillList.size()]);
        OperateOption option = CommonUtil.getCaOption();
        this.executeOp(caBillArray, option, BillOpEnum.SAVE);
        this.caLogService.getCaLogVo().setCastatus("2");
        this.caLogService.saveCaLog();
        this.executeOp(caBillArray, option, BillOpEnum.SUBMIT);
        this.executeOp(caBillArray, option, BillOpEnum.AUDIT);
    }

    private OperationResult executeOp(DynamicObject[] generatBill, OperateOption option, BillOpEnum op) {
        if (generatBill == null || generatBill.length == 0) {
            return null;
        }
        String billType = generatBill[0].getDataEntityType().getName();
        OperationResult result = OperationServiceHelper.executeOperate((String)op.getOpKey(), (String)billType, (DynamicObject[])generatBill, (OperateOption)option);
        List successPkIds = result.getSuccessPkIds();
        this.caLogService.getCaLogVo().setGenerateBillEntry(billType, successPkIds, op);
        if (!result.isSuccess()) {
            String errDetail = CommonUtil.getErrDetail(result);
            String errorMessage = op.getOpName() + "\u51b2\u9500\u5355\u636e" + billType + "\u5931\u8d25\uff1a" + errDetail;
            logger.error(errorMessage);
            CommonUtil.setErrorLog(billType, result, errorMessage, this.caLogService);
            String errMsg = ResManager.loadKDString((String)"{0}\u51b2\u9500\u5355\u636e\u5931\u8d25\uff1a{1}\u3002", (String)"ChargeAgainstOp_7", (String)"bos-ext-scmc", (Object[])new Object[]{op.getOpName(), errDetail});
            if (errMsg.endsWith("\u3002\u3002") || errMsg.endsWith("..")) {
                errMsg = errMsg.substring(0, errMsg.length() - 1);
            }
            throw new KDBizException(errMsg);
        }
        String opName = op.getOpName();
        logger.info(opName + "\u51b2\u9500\u5355\u636e\u6210\u529f");
        return result;
    }

    private void setErrorLog(String billType, OperationResult result, String errDetail) {
        HashSet<Object> successPkIds = new HashSet<Object>(result.getSuccessPkIds());
        this.caLogService.getCaLogVo().setGenerateBillEntry(billType, successPkIds, errDetail);
    }

    public CaLogService getCaLogService() {
        return this.caLogService;
    }

    public void setCaLogService(CaLogService caLogService) {
        this.caLogService = caLogService;
    }
}

