/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.operation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;

public class BalanceInventoryOp
extends FormOperate {
    public static final String IM_BALANCEINV_LOG = "im_balanceinv_log";
    private Log logger = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());
    public static final String PLAN_ORG_UNIT_FIELD = "planorgunitfield";
    private Map<String, Object> mapParam;

    public void initialize(Map<String, Object> opMeta) {
        super.initialize(opMeta);
        Map custParamObj = (Map)opMeta.get("parameter");
        String paramValue = (String)custParamObj.get("parameter");
        this.mapParam = StringUtils.isBlank((String)paramValue) ? new HashMap<String, Object>() : (Map)SerializationUtils.fromJsonString((String)paramValue, Map.class);
    }

    protected OperationResult invokeOperation() {
        String orgUnitField;
        ListSelectedRowCollection listSelectedData = this.getListSelectedData();
        Object[] selectBillIds = listSelectedData.getPrimaryKeyValues();
        Object[] selectEntryIds = listSelectedData.getEntryPrimaryKeyValues();
        String entityNum = this.getEntityId();
        Set<Long> balanceOrgIdSet = this.getBalanceOrgIdSet(entityNum, selectBillIds, orgUnitField = (String)this.mapParam.get(PLAN_ORG_UNIT_FIELD));
        if (balanceOrgIdSet == null || balanceOrgIdSet.isEmpty()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u5229\u5e93\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5\u5e73\u8861\u5229\u5e93\u64cd\u4f5c\u53c2\u6570\u8bbe\u7f6e\u4e2d\uff0c\u914d\u7f6e\u7684\u5229\u5e93\u7ec4\u7ec7\u5b57\u6bb5\u662f\u5426\u6709\u503c\u3002", (String)"balanceInvOp_0", (String)"bos-ext-scmc", (Object[])new Object[0]));
            return super.invokeOperation();
        }
        if (balanceOrgIdSet.size() > 1) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u9009\u62e9\u5355\u636e\u7684\u5229\u5e93\u7ec4\u7ec7\u4e0d\u76f8\u540c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"balanceInvOp_1", (String)"bos-ext-scmc", (Object[])new Object[0]));
            return super.invokeOperation();
        }
        Long balanceOrgId = null;
        Iterator<Long> iterator = balanceOrgIdSet.iterator();
        while (iterator.hasNext()) {
            Long orgId;
            balanceOrgId = orgId = iterator.next();
        }
        HashMap<String, Long> logParam = new HashMap<String, Long>();
        logParam.put("balanceOrgId", balanceOrgId);
        Long balanceLogId = (Long)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"IBalanceInventoryService", (String)"createBalanceInvLog", (Object[])new Object[]{logParam});
        this.showBalanceLogUI(balanceLogId);
        Long finalBalanceOrgId = balanceOrgId;
        ThreadPools.executeOnce((String)"balanceInventory", (Runnable)new /* Unavailable Anonymous Inner Class!! */);
        return super.invokeOperation();
    }

    private void showBalanceLogUI(Long balanceLogId) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(IM_BALANCEINV_LOG);
        showParameter.setBillStatus(BillOperationStatus.VIEW);
        showParameter.setPkId((Object)balanceLogId);
        showParameter.getOpenStyle().setShowType(ShowType.NonModal);
        showParameter.setHasRight(true);
        FormConfig fConfig = FormMetadataCache.getFormConfig((String)IM_BALANCEINV_LOG);
        fConfig.setHeight(new LocaleString("90%"));
        fConfig.setWidth(new LocaleString("90%"));
        showParameter.setFormConfig(fConfig);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private Set<Long> getBalanceOrgIdSet(String entityNum, Object[] bllIds, String balanceOrgField) {
        DataSet billDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entityNum, (String)balanceOrgField, (QFilter[])new QFilter("id", "in", (Object)bllIds).toArray(), (String)"");
        HashSet<Long> orgSet = new HashSet<Long>();
        for (Row bill : billDataSet) {
            orgSet.add(bill.getLong(balanceOrgField));
        }
        return orgSet;
    }

    static /* synthetic */ Log access$000(BalanceInventoryOp x0) {
        return x0.logger;
    }
}

