/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.operation;

import java.util.HashMap;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;

public class CostPriceQuery
extends AbstractOpBizRuleAction {
    private static final Log log = LogFactory.getLog(CostPriceQuery.class);

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        String operationKey = e.getOperationKey();
        String entityName = dataEntities[0].getDataEntityType().getName();
        if (entityName == null || operationKey == null) {
            return;
        }
        HashSet<Long> billIds = new HashSet<Long>(16);
        for (DynamicObject dataEntity : dataEntities) {
            billIds.add(dataEntity.getLong("id"));
        }
        HashMap<String, Object> param = new HashMap<String, Object>(4);
        param.put("billIds", billIds);
        param.put("entityName", entityName);
        param.put("operationKey", operationKey);
        try {
            log.info(String.format("\u8c03\u7528\u83b7\u53d6\u6210\u672c\u56de\u586b\u5e93\u5b58\u7684\u670d\u52a1\u5f00\u59cb,\u5b9e\u4f53\u540d\uff1a[%1$s], \u64cd\u4f5c\u540d\uff1a[%2$s]", entityName, operationKey));
            DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"CalCostService", (String)"setCalCost", (Object[])new Object[]{param});
            log.info("\u8c03\u7528\u83b7\u53d6\u6210\u672c\u56de\u586b\u5e93\u5b58\u7684\u670d\u52a1\u7ed3\u675f\u3002");
        }
        catch (Exception ex) {
            log.error("\u8c03\u7528\u83b7\u53d6\u6210\u672c\u56de\u586b\u5e93\u5b58\u7684\u670d\u52a1\u51fa\u73b0\u5f02\u5e38\u3002", (Throwable)ex);
            throw new KDBizException(ex.getMessage());
        }
    }
}

