/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.operation;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.LinkSetItemElement;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MaterielProp;
import kd.bos.entity.property.UnitProp;
import kd.bos.exception.KDBizException;
import kd.bos.ext.scmc.operation.helper.NoUpdateFieldsAnalysisExtHelper;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;

public class InventoryQueryOld
extends FormOperate
implements ICloseCallBack {
    private static final Log log = LogFactory.getLog(InventoryQueryOld.class);
    private final String KEY_METADATAKEY = "metadatakey";
    private final String KEY_CURRENTMETADATAKEY = "currentmetadatakey";
    private final String KEY_QFILTER = "qfilter";
    private final String KEY_UPDATE = "update";
    private final String KEY_MATCH = "match";
    private final String INVENTORY_QUERY = "inventory_query";
    private Map<String, Object> mapParam;
    private final String BD_MATERIALINVENTORYINFO = "bd_materialinventoryinfo";
    private final String BD_MATERIAL = "bd_material";
    private final String IM_MATERIALINVACC = "im_materialinvacc";
    private final String MATERIALINVACC_CALLBACK = "materialinvaccCallBack";
    private boolean isQueryCheck = true;
    private boolean isDraw = false;
    private static List<String> avbFields = Arrays.asList("avbbaseqty", "avbqty", "avbqty2nd");
    private static List<String> qtyFields = Arrays.asList("baseqty", "qty", "qty2nd");
    private static final String[] SOURCE_INFO_DIFF_PER_BILL = new String[]{"srcbillentity", "srcbillid", "srcbillnumber", "srcbillentryid", "srcbillentryseq", "mainbillid", "mainbillentryid", "mainbillentity", "mainbillentryseq", "mainbillnumber", "srcsysbillentryid", "srcsystem", "srcsysbillid", "conbillentity", "conbillid", "conbillnumber", "conbillentryid", "conbillrownum"};
    private static final String BILL_STATUS_A = "A";
    private static final String BILL_STATUS_B = "B";
    private static final String BILL_STATUS_C = "C";
    private static final String BILL_STATUS_D = "D";

    public void initialize(Map<String, Object> arg0) {
        super.initialize(arg0);
        Map custParamObj = (Map)arg0.get("parameter");
        String paramValue = (String)custParamObj.get("parameter");
        this.mapParam = StringUtils.isBlank((CharSequence)paramValue) ? new HashMap<String, Object>() : (Map)SerializationUtils.fromJsonString((String)paramValue, Map.class);
    }

    public OperationResult invokeOperation() {
        JSONObject param = new JSONObject();
        JSONObject fieldQFilter = this.getJsonObjectQFilterByBillField();
        param.put("qfilterfield", (Object)fieldQFilter);
        log.info("\u89e3\u6790\u4e4b\u540e\u8fc7\u6ee4\u5b57\u6bb5\u4fe1\u606f:" + fieldQFilter);
        Object returnData = this.getView().getReturnData();
        if (returnData instanceof QFilter) {
            QFilter qFilter = (QFilter)returnData;
            param.put("qfilter", (Object)qFilter);
        }
        param.put("mapparam", this.mapParam);
        param.put("isDraw", (Object)this.isDraw);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("im_materialinvacc");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCaption(this.getMsgInventoryQueryStr());
        parameter.setCustomParam("param", (Object)param);
        Map settingParam = (Map)this.mapParam.get("settingparam");
        String dealType = (String)settingParam.get("dealtype");
        if ("systemdeal".equals(dealType)) {
            parameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "materialinvaccCallBack"));
        } else if ("plugindeal".equals(dealType)) {
            String pluginName = (String)settingParam.get("pluginname");
            String actionId = (String)settingParam.get("actionid");
            parameter.setCloseCallBack(new CloseCallBack(pluginName, actionId));
        }
        this.getView().showForm(parameter);
        this.getView().returnDataToParent(this.mapParam);
        return super.invokeOperation();
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        Object object = e.getReturnData();
        if (object != null && "materialinvaccCallBack".equals(actionId)) {
            IFormView view = e.getView();
            JSONObject returnData = (JSONObject)object;
            this.dealInvData(view, returnData);
        }
    }

    private void dealInvData(IFormView view, JSONObject returnData) {
        Map mapParam = (Map)returnData.get((Object)"mapparam");
        DynamicObject[] invaccs = (DynamicObject[])returnData.get((Object)"data");
        Map settingParam = (Map)mapParam.get("settingparam");
        List fields = (List)mapParam.get("fielddata");
        String entryKey = "";
        int row = -1;
        if (fields != null) {
            for (int i = 0; i < fields.size(); ++i) {
                int[] rows;
                String[] keys;
                EntryGrid entryGrid;
                Map field = (Map)fields.get(i);
                String currentKey = (String)field.get("currentmetadatakey");
                if (currentKey == null || currentKey.indexOf(46) == -1 || (entryGrid = (EntryGrid)view.getControl(entryKey = (keys = currentKey.split("\\."))[keys.length - 2])) == null || (rows = entryGrid.getSelectRows()) == null || rows.length <= 0) continue;
                row = rows[0];
            }
        }
        String qtyRule = (String)settingParam.get("qtyrule");
        boolean newDeal = (Boolean)settingParam.get("newdeal");
        ArrayList<Map<String, Object>> updateFields = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> matchFields = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> returnFields = new ArrayList<Map<String, Object>>();
        if (fields != null) {
            for (int i = 0; i < fields.size(); ++i) {
                Map field = (Map)fields.get(i);
                String currentKey = (String)field.get("currentmetadatakey");
                if (!StringUtils.isNotBlank((CharSequence)currentKey)) continue;
                boolean isUpdateField = (Boolean)field.get("update");
                boolean isMatchField = (Boolean)field.get("match");
                if (isUpdateField) {
                    updateFields.add(field);
                }
                if (!isMatchField) continue;
                matchFields.add(field);
            }
        }
        returnFields.addAll(matchFields);
        returnFields.addAll(updateFields);
        IDataModel model = view.getModel();
        model.getDataEntity(true);
        Map<String, String> qtyKeyMap = this.getBillQtyAndQty2ndKey(returnFields);
        boolean updateQty2nd = false;
        String qtyUnit2nd = qtyKeyMap.get("qtyunit2nd");
        String qty = qtyKeyMap.get("qty");
        boolean isMatch = false;
        boolean isMatched = false;
        String matKey = this.getBillMatKey(matchFields);
        Boolean isUseLotMF = (Boolean)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"LotMainFileService", (String)"isUseLotMainFile", (Object[])new Object[0]);
        Map<Long, Long> lotMainFileMap = this.getLotMainFileByInvaccsId(invaccs, isUseLotMF, returnFields, view);
        for (int i = 0; i < invaccs.length; ++i) {
            DynamicObject invacc = invaccs[i];
            int setRow = row;
            if (StringUtils.isNotBlank((CharSequence)qtyUnit2nd) && StringUtils.isNotBlank((CharSequence)qty)) {
                BigDecimal pageQty2nd = (BigDecimal)model.getValue(qtyUnit2nd, setRow);
                BigDecimal pageQty = (BigDecimal)model.getValue(qty, setRow);
                updateQty2nd = pageQty != null && pageQty.compareTo(BigDecimal.ZERO) != 0 && (pageQty2nd == null || pageQty2nd.compareTo(BigDecimal.ZERO) == 0);
            }
            HashMap<String, BigDecimal> avbQtyMap = new HashMap<String, BigDecimal>();
            HashMap<String, BigDecimal> qtyMap = new HashMap<String, BigDecimal>();
            HashMap<String, String> invQtyMap = new HashMap<String, String>();
            if (row == -1) {
                if (matKey == null) {
                    isMatch = false;
                } else {
                    int nullRow = this.getNullRow(fields, view, matKey);
                    if (nullRow == -1) {
                        isMatch = false;
                    } else {
                        isMatch = true;
                        isMatched = false;
                        row = nullRow;
                    }
                }
            } else {
                for (Map map : matchFields) {
                    boolean valueIsEmpty;
                    boolean mkNotNull;
                    String key = (String)map.get("metadatakey");
                    String currentKey = (String)map.get("currentmetadatakey");
                    if (currentKey.indexOf(46) != -1) {
                        String[] keys = currentKey.split("\\.");
                        currentKey = keys[keys.length - 1];
                    }
                    Object currentValue = model.getValue(currentKey, row);
                    Object value = invacc.get(key);
                    boolean valueIsNull = currentValue == null || "".equals(currentValue);
                    boolean bl = mkNotNull = matKey != null && matKey.equals("material");
                    if (valueIsNull && mkNotNull) {
                        isMatch = true;
                        break;
                    }
                    isMatch = this.matchNull(currentValue, value);
                    if (!isMatch) break;
                    valueIsNull = null == currentValue && null == value;
                    boolean bl2 = valueIsEmpty = "".equals(currentValue) && "".equals(value);
                    if (valueIsNull || valueIsEmpty) continue;
                    if (value instanceof DynamicObject) {
                        IDataEntityType type = ((DynamicObject)value).getDataEntityType();
                        if ("bd_material".equals(type.getName())) {
                            DynamicObject materialStrategy = this.getBillMaterial(key, currentKey, invacc, view);
                            Object matPK = materialStrategy == null ? ((DynamicObject)currentValue).getPkValue() : materialStrategy.getPkValue();
                            boolean bl3 = isMatch = currentValue != null && matPK.equals(((DynamicObject)currentValue).getPkValue());
                            if (currentValue != null && !isMatch && this.getNullRow(returnFields, view, currentKey) != -1) {
                                row = this.getNullRow(returnFields, view, currentKey);
                                isMatch = true;
                                isMatched = false;
                                break;
                            }
                            if (isMatch) continue;
                            break;
                        }
                        isMatch = ((DynamicObject)value).getPkValue().equals(((DynamicObject)currentValue).getPkValue());
                        if (isMatch) continue;
                        break;
                    }
                    isMatch = currentValue != null && currentValue.equals(value);
                    if (isMatch) continue;
                    break;
                }
            }
            if (isMatch && !isMatched) {
                setRow = row;
                this.handleReturnDataInCurrentRow(updateFields, model, entryKey, setRow, invacc, qtyRule, view, avbFields, avbQtyMap, qtyFields, qtyMap, invQtyMap, isUseLotMF, lotMainFileMap);
                isMatched = true;
            } else if (newDeal) {
                if (!((Boolean)mapParam.get("isDraw")).booleanValue()) {
                    model.beginInit();
                    int newRow = model.createNewEntryRow(entryKey);
                    model.setEntryCurrentRowIndex(entryKey, newRow);
                    model.endInit();
                    setRow = newRow;
                    this.handleReturnDataInNewRow(model, entryKey, returnFields, invacc, view, avbFields, avbQtyMap, qtyFields, qtyMap, invQtyMap, newRow, isUseLotMF, lotMainFileMap);
                } else {
                    IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
                    pageCache.put("inventory_query", "1");
                    int n = model.getEntryCurrentRowIndex(entryKey);
                    model.beginInit();
                    model.copyEntryRow(entryKey, new int[]{n}, true);
                    int newRow = model.getEntryRowCount(entryKey) - 1;
                    model.setEntryCurrentRowIndex(entryKey, newRow);
                    model.endInit();
                    setRow = newRow;
                    this.handleReturnDataInNewRow(model, entryKey, returnFields, invacc, view, avbFields, avbQtyMap, qtyFields, qtyMap, invQtyMap, newRow, isUseLotMF, lotMainFileMap);
                    pageCache.remove("inventory_query");
                    this.copySouceFiledsInfo(model, n, newRow, entryKey, view);
                }
            }
            this.setBillQtyByDirFromQty(model, view, setRow, qtyMap, invQtyMap, updateQty2nd);
            this.setBillQtyByDirFromAvb(model, view, setRow, avbQtyMap, invQtyMap, updateQty2nd);
        }
        view.updateView(entryKey);
    }

    private Map<Long, Long> getLotMainFileByInvaccsId(DynamicObject[] invaccs, boolean isUseLotMF, List<Map<String, Object>> returnFields, IFormView view) {
        HashMap<Long, Long> map = new HashMap<Long, Long>(invaccs.length);
        if (isUseLotMF) {
            RowMeta billentryRowMeta = new RowMeta(new Field[]{new Field("id", (DataType)DataType.LongType), new Field("matPK", (DataType)DataType.LongType), new Field("orgId", (DataType)DataType.LongType), new Field("lotnum", (DataType)DataType.StringType)});
            DataSetBuilder billentryDsBuilder = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSetBuilder(billentryRowMeta);
            HashSet<String> lotnums = new HashSet<String>(invaccs.length);
            for (int i = 0; i < invaccs.length; ++i) {
                DynamicObject invacc = invaccs[i];
                Object orgId = invacc.getDynamicObject("org").getPkValue();
                Object matPK = invacc.getDynamicObject("material").getPkValue();
                Object id = invacc.getPkValue();
                String lotnum = invacc.getString("lotnum");
                lotnums.add(lotnum);
                billentryDsBuilder.append(new Object[]{id, matPK, orgId, lotnum});
            }
            DataSet billentryDataSet = billentryDsBuilder.build();
            DataSet lotMainFileDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_lot", (String)"id as mainfileid,number as mflotnumber, material as mfmaterialid,createorg as mfinvorg", (QFilter[])new QFilter("number", "in", lotnums).toArray(), (String)"");
            JoinDataSet tempDataSet = billentryDataSet.leftJoin(lotMainFileDataSet).on("lotnum", "mflotnumber");
            Integer unqCtrl = (Integer)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"LotMainFileService", (String)"getUnqctrl", (Object[])new Object[0]);
            if (unqCtrl == 2 || unqCtrl == 4) {
                tempDataSet.on("matPK", "mfmaterialid");
            }
            if (unqCtrl == 3 || unqCtrl == 4) {
                tempDataSet.on("orgId", "mfinvorg");
            }
            DataSet billLotRelWithMatDataSet = tempDataSet.select(billentryDataSet.getRowMeta().getFieldNames(), lotMainFileDataSet.getRowMeta().getFieldNames()).finish();
            while (billLotRelWithMatDataSet.hasNext()) {
                Row row = billLotRelWithMatDataSet.next();
                map.put(row.getLong("id"), row.getLong("mainfileid"));
            }
        }
        return map;
    }

    private String getMsgInventoryQueryPre() {
        return ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u3010%s\u3011\u4e0b\u3010%s\u3011\u7684%s\u3002", (String)"InventoryQuery_0", (String)"bos-ext-scmc", (Object[])new Object[0]);
    }

    private boolean isDrawByBOTP(IDataModel model, String entryKey) {
        IDataEntityProperty dataEntityProperty;
        int size;
        DynamicObject bill = model.getDataEntity(true);
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection(entryKey);
        if (entrys == null || (size = entrys.size()) == 0) {
            return false;
        }
        LinkSetElement linkSet = ConvertMetaServiceHelper.loadLinkSet((String)model.getDataEntityType().getName());
        if (linkSet == null || linkSet.getItems() == null || linkSet.getItems().isEmpty()) {
            return false;
        }
        String linkEntityKey = entryKey + "_lk";
        List items = linkSet.getItems();
        for (LinkSetItemElement item : items) {
            if (!entryKey.equals(item.getParentEntityKey())) continue;
            linkEntityKey = item.getLinkEntityKey();
            break;
        }
        if ((dataEntityProperty = model.getDataEntityType().findProperty(linkEntityKey)) == null) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            DynamicObjectCollection linkColl = entry.getDynamicObjectCollection(linkEntityKey);
            if (linkColl == null || linkColl.size() <= 0) continue;
            return true;
        }
        return false;
    }

    private String getMsgInventoryQueryStr() {
        return ResManager.loadKDString((String)"\u5e93\u5b58\u67e5\u8be2", (String)"InventoryQuery_1", (String)"bos-ext-scmc", (Object[])new Object[0]);
    }

    private JSONObject getJsonObjectQFilterByBillField() {
        JSONObject fieldQFilter = new JSONObject();
        IDataModel model = this.getView().getModel();
        if (this.mapParam != null) {
            List fields = (List)this.mapParam.get("fielddata");
            Map settingParam = (Map)this.mapParam.get("settingparam");
            String entryNoUpdateFieldkey = (String)settingParam.get("entrynoupdatefieldkey");
            if (fields != null) {
                NoUpdateFieldsAnalysisExtHelper.setNoUpdateFields(this.getView().getModel(), entryNoUpdateFieldkey, fields);
                for (int i = 0; i < fields.size(); ++i) {
                    Map field = (Map)fields.get(i);
                    boolean isQFilter = (Boolean)field.get("qfilter");
                    if (!isQFilter) continue;
                    String currentKey = (String)field.get("currentmetadatakey");
                    String metadatakey = (String)field.get("metadatakey");
                    if (StringUtils.isBlank((CharSequence)currentKey)) {
                        fieldQFilter.put(metadatakey, null);
                        continue;
                    }
                    if (currentKey.indexOf(46) != -1) {
                        this.setQFilterByEntryField(field, fieldQFilter, currentKey, model, entryNoUpdateFieldkey);
                        continue;
                    }
                    this.setQFilterByHeadField(field, fieldQFilter, currentKey, model);
                }
            }
        }
        return fieldQFilter;
    }

    private void setQFilterByEntryField(Map<String, Object> field, JSONObject fieldQFilter, String currentKey, IDataModel model, String entryNoUpdateFieldkey) {
        String entityKey;
        String key;
        String entryKey;
        String[] keys = currentKey.split("\\.");
        if (keys.length == 3) {
            entryKey = keys[0] + '.' + keys[1];
            key = keys[2];
            entityKey = keys[1];
        } else {
            entryKey = keys[0];
            key = keys[1];
            entityKey = keys[0];
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entityKey);
        if (entryGrid != null) {
            int[] rows = entryGrid.getSelectRows();
            Object billstatus = model.getValue("billstatus");
            if (this.isQueryCheck) {
                this.isDraw = this.isDrawByBOTP(model, entryKey);
                if (this.isDraw && BILL_STATUS_A.equals(billstatus) && rows.length != 1) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u67e5\u8be2\uff0c\u8bf7\u9009\u62e91\u884c\u6570\u636e\u3002", (String)"InventoryQuery_3", (String)"bos-ext-scmc", (Object[])new Object[0]));
                }
                if (rows.length > 1) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u67e5\u8be2\uff0c\u8bf7\u4e0d\u9009\u62e9\u6216\u8005\u9009\u62e91\u884c\u6570\u636e\u3002", (String)"InventoryQuery_4", (String)"bos-ext-scmc", (Object[])new Object[0]));
                }
            }
            this.isQueryCheck = false;
            String formId = this.getEntityId();
            String metadatakey = (String)field.get("metadatakey");
            if (rows.length > 0) {
                String entryNoUpdateFieldValue;
                List<String> entryNoUpdateFieldValueList;
                int row = rows[0];
                if (null != entryNoUpdateFieldkey && !entryNoUpdateFieldkey.isEmpty() && (entryNoUpdateFieldValueList = NoUpdateFieldsAnalysisExtHelper.getNoUpdateFieldsList(entryNoUpdateFieldValue = (String)model.getValue(entryNoUpdateFieldkey, row))).contains(key)) {
                    fieldQFilter.put(metadatakey, null);
                    return;
                }
                Object value = model.getValue(key, row);
                if (value instanceof DynamicObject) {
                    Object pkid = this.getDynamicObjectKey(key, value);
                    fieldQFilter.put(metadatakey, pkid);
                } else {
                    Object valueOfCurrKey = model.getValue(key, row);
                    if ("im_transapply".equals(formId)) {
                        if ("inorg".equals(key) && valueOfCurrKey == null) {
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8c03\u5165\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u5148\u7ef4\u62a4\u8c03\u5165\u7ec4\u7ec7\u6570\u636e\u540e\u518d\u8fdb\u884c\u5e93\u5b58\u67e5\u8be2\u3002", (String)"InventoryQueryEntryOutOrgNotNull", (String)"bos-ext-scmc", (Object[])new Object[0]), row + 1));
                        }
                        if ("outorg".equals(key) && valueOfCurrKey == null) {
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8c03\u51fa\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u5148\u7ef4\u62a4\u8c03\u51fa\u7ec4\u7ec7\u6570\u636e\u540e\u518d\u8fdb\u884c\u5e93\u5b58\u67e5\u8be2\u3002", (String)"InventoryQueryEntryInOrgNotNull", (String)"bos-ext-scmc", (Object[])new Object[0]), row + 1));
                        }
                    }
                    fieldQFilter.put(metadatakey, valueOfCurrKey);
                }
            } else {
                fieldQFilter.put(metadatakey, null);
            }
        }
    }

    private void setQFilterByHeadField(Map<String, Object> field, JSONObject fieldQFilter, String currentKey, IDataModel model) {
        if (model.getValue(currentKey) instanceof DynamicObject) {
            fieldQFilter.put((String)field.get("metadatakey"), ((DynamicObject)model.getValue(currentKey)).get("id"));
        } else {
            String formId;
            Object valueOfCurrKey = model.getValue(currentKey);
            switch (formId = this.getEntityId()) {
                case "im_materialreqbill": {
                    if (!"bizorg".equals(currentKey) || valueOfCurrKey != null) break;
                    throw new KDBizException(ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u5148\u7ef4\u62a4\u5e93\u5b58\u7ec4\u7ec7\u6570\u636e\u540e\u518d\u8fdb\u884c\u5e93\u5b58\u67e5\u8be2\u3002", (String)"InventoryQueryInvOrgNotNull", (String)"bos-ext-scmc", (Object[])new Object[0]));
                }
                case "im_transdirbill": {
                    if ("org".equals(currentKey) && valueOfCurrKey == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u5165\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u5148\u7ef4\u62a4\u8c03\u5165\u7ec4\u7ec7\u6570\u636e\u540e\u518d\u8fdb\u884c\u5e93\u5b58\u67e5\u8be2\u3002", (String)"InventoryQueryInOrgNotNull", (String)"bos-ext-scmc", (Object[])new Object[0]));
                    }
                    if (!"outorg".equals(currentKey) || valueOfCurrKey != null) break;
                    throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u51fa\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u5148\u7ef4\u62a4\u4e3b\u8c03\u51fa\u7ec4\u7ec7\u6570\u636e\u540e\u518d\u8fdb\u884c\u5e93\u5b58\u67e5\u8be2\u3002", (String)"InventoryQueryOutOrgNotNull", (String)"bos-ext-scmc", (Object[])new Object[0]));
                }
                default: {
                    if (!"org".equals(currentKey) || valueOfCurrKey != null) break;
                    throw new KDBizException(ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u5148\u7ef4\u62a4\u5e93\u5b58\u7ec4\u7ec7\u6570\u636e\u540e\u518d\u8fdb\u884c\u5e93\u5b58\u67e5\u8be2\u3002", (String)"InventoryQueryInvOrgNotNull", (String)"bos-ext-scmc", (Object[])new Object[0]));
                }
            }
            fieldQFilter.put((String)field.get("metadatakey"), valueOfCurrKey);
        }
    }

    private void handleReturnDataInCurrentRow(List<Map<String, Object>> updateFields, IDataModel model, String entryKey, int row, DynamicObject invacc, String qtyRule, IFormView view, List<String> avbFields, Map<String, BigDecimal> avbQtyMap, List<String> qtyFields, Map<String, BigDecimal> qtyMap, Map<String, String> invQtyMap, boolean isUseLotMF, Map<Long, Long> lotMainFileMap) {
        this.setLineType(model, entryKey, row, view);
        for (Map<String, Object> field : updateFields) {
            boolean notUpdate;
            IDataEntityType type;
            String key = (String)field.get("metadatakey");
            String currentKey = (String)field.get("currentmetadatakey");
            if (currentKey.indexOf(46) != -1) {
                String[] keys = currentKey.split("\\.");
                currentKey = keys[keys.length - 1];
            }
            if (StringUtils.isNotBlank((CharSequence)key) && key.contains("qty")) {
                BigDecimal reqqty = (BigDecimal)model.getValue(currentKey, row);
                BigDecimal proqty = (BigDecimal)invacc.get(key);
                BigDecimal value = reqqty != null && reqqty.compareTo(new BigDecimal(0)) != 0 && "minrule".equals(qtyRule) ? (reqqty.compareTo(proqty) > 0 ? proqty : reqqty) : ("reqqty".equals(qtyRule) ? reqqty : proqty);
                model.beginInit();
                model.setValue(currentKey, (Object)value, row);
                view.updateView(currentKey, row);
                model.endInit();
                if (avbFields.contains(key)) {
                    avbQtyMap.put(currentKey, value);
                } else if (qtyFields.contains(key)) {
                    qtyMap.put(currentKey, value);
                }
                invQtyMap.put(key, currentKey);
                continue;
            }
            Object accValue = invacc.get(key);
            if (accValue instanceof DynamicObject && "bd_material".equals((type = ((DynamicObject)accValue).getDataEntityType()).getName())) {
                DynamicObject materialStrategy = this.getBillMaterial(key, currentKey, invacc, view);
                Object matPK = materialStrategy == null ? ((DynamicObject)accValue).getPkValue() : materialStrategy.getPkValue();
                model.setValue(currentKey, matPK, row);
                continue;
            }
            boolean bl = notUpdate = "producedate".equals(currentKey) || "expirydate".equals(currentKey) || "lotnumber".equals(currentKey) && !model.getDataEntityType().getName().equals("im_transdirbill");
            if (notUpdate) {
                model.beginInit();
                model.setValue(currentKey, invacc.get(key), row);
                view.updateView(currentKey, row);
                model.endInit();
            } else {
                model.setValue(currentKey, invacc.get(key), row);
            }
            this.setLotIdValue(model, row, invacc, view, isUseLotMF, field, key, notUpdate, lotMainFileMap);
        }
    }

    private void setLotIdValue(IDataModel model, int row, DynamicObject invacc, IFormView view, boolean isUseLotMF, Map<String, Object> field, String key, boolean notUpdate, Map<Long, Long> lotMainFileMap) {
        if (isUseLotMF && "lotnum".equals(key)) {
            DynamicObject bill;
            String billtype;
            Set cfgDynamicObject;
            String currentKeyField = (String)field.get("currentmetadatakey");
            String entryType = "";
            if (currentKeyField.indexOf(46) != -1) {
                String[] keys = currentKeyField.split("\\.");
                entryType = keys[keys.length - 2];
            }
            if ((cfgDynamicObject = (Set)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"LotMainFileService", (String)"getLotMainFileBillConfigByBillAndLotNum", (Object[])new Object[]{billtype = (bill = model.getDataEntity()).getDataEntityType().getName(), entryType, bill, currentKeyField})) == null || cfgDynamicObject.size() == 0) {
                return;
            }
            ArrayList listCfgDynamicObject = new ArrayList(cfgDynamicObject);
            String lotId = ((DynamicObject)listCfgDynamicObject.get(0)).getString("lotidfield");
            if (lotId.indexOf(46) != -1) {
                String[] keys = lotId.split("\\.");
                lotId = keys[keys.length - 1];
            }
            if (lotMainFileMap == null) {
                return;
            }
            Long id = lotMainFileMap.get(invacc.getLong("id"));
            if (notUpdate) {
                model.beginInit();
                model.setValue(lotId, (Object)id, row);
                view.updateView(lotId, row);
                model.endInit();
            } else {
                model.setValue(lotId, (Object)id, row);
            }
        }
    }

    private void setLineType(IDataModel model, String entryKey, int row, IFormView view) {
        Map type = model.getDataEntityType().getAllEntities();
        EntityType entityType = (EntityType)type.get(entryKey);
        Map map = entityType.getFields();
        if (!map.containsKey("linetype")) {
            return;
        }
        QFilter filter = new QFilter("number", "=", (Object)"010");
        DynamicObject lineType = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_linetype", (QFilter[])filter.toArray());
        model.beginInit();
        model.setValue("linetype", lineType.getPkValue(), row);
        model.endInit();
    }

    private void handleReturnDataInNewRow(IDataModel model, String entityKey, List<Map<String, Object>> returnFields, DynamicObject invacc, IFormView view, List<String> avbFields, Map<String, BigDecimal> avbQtyMap, List<String> qtyFields, Map<String, BigDecimal> qtyMap, Map<String, String> invQtyMap, int newRow, boolean isUseLotMF, Map<Long, Long> lotMainFileMap) {
        this.setOtherFields(model, entityKey, returnFields, view, newRow);
        for (Map<String, Object> field : returnFields) {
            boolean notUpdate;
            IDataEntityType type;
            Object accValue;
            String key = (String)field.get("metadatakey");
            String currentKey = (String)field.get("currentmetadatakey");
            if (currentKey.indexOf(46) != -1) {
                String[] keys = currentKey.split("\\.");
                currentKey = keys[keys.length - 1];
            }
            if ((accValue = invacc.get(key)) instanceof DynamicObject && "bd_material".equals((type = ((DynamicObject)accValue).getDataEntityType()).getName())) {
                DynamicObject materialStrategy = this.getBillMaterial(key, currentKey, invacc, view);
                Object matPK = materialStrategy == null ? ((DynamicObject)accValue).getPkValue() : materialStrategy.getPkValue();
                model.beginInit();
                model.setValue(currentKey, null, newRow);
                model.endInit();
                model.setValue(currentKey, matPK, newRow);
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)key) && key.contains("qty") && accValue instanceof BigDecimal) {
                if (avbFields.contains(key)) {
                    avbQtyMap.put(currentKey, (BigDecimal)accValue);
                } else if (qtyFields.contains(key)) {
                    qtyMap.put(currentKey, (BigDecimal)accValue);
                }
                invQtyMap.put(key, currentKey);
            }
            boolean bl = notUpdate = "producedate".equals(currentKey) || "expirydate".equals(currentKey) || "lotnumber".equals(currentKey) && !model.getDataEntityType().getName().equals("im_transdirbill");
            if (StringUtils.isNotBlank((CharSequence)key) && key.contains("qty") || model.getDataEntityType().findProperty(currentKey) instanceof UnitProp || notUpdate) {
                model.beginInit();
                model.setValue(currentKey, invacc.get(key), newRow);
                view.updateView(currentKey, newRow);
                model.endInit();
            } else {
                model.setValue(currentKey, invacc.get(key), newRow);
            }
            this.setLotIdValue(model, newRow, invacc, view, isUseLotMF, field, key, notUpdate, lotMainFileMap);
        }
    }

    private void setOtherFields(IDataModel model, String entityKey, List<Map<String, Object>> returnFields, IFormView view, int newRow) {
        EntryGrid entryGrid = (EntryGrid)view.getControl(entityKey);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows != null && selectRows.length == 1) {
            int selectRowIndex = selectRows[0];
            HashSet<String> entryFillFields = new HashSet<String>();
            for (Map<String, Object> field : returnFields) {
                String currentKey = (String)field.get("currentmetadatakey");
                if (currentKey.indexOf(46) != -1) {
                    String[] keys = currentKey.split("\\.");
                    currentKey = keys[keys.length - 1];
                }
                entryFillFields.add(currentKey);
            }
            Map type = model.getDataEntityType().getAllEntities();
            EntityType entityType = (EntityType)type.get(entityKey);
            Map entryKeyMap = entityType.getFields();
            for (Map.Entry entryField : entryKeyMap.entrySet()) {
                String field = (String)entryField.getKey();
                IFieldHandle fieldHandle = (IFieldHandle)entryField.getValue();
                boolean copyable = fieldHandle.isCopyable();
                if (entryFillFields.contains(field) || !copyable) continue;
                model.beginInit();
                model.setValue(field, model.getValue(field, selectRowIndex), newRow);
                model.endInit();
            }
        } else {
            this.setLineType(model, entityKey, newRow, view);
        }
    }

    private void setBillQtyByDirFromQty(IDataModel model, IFormView view, int setRow, Map<String, BigDecimal> qtyMap, Map<String, String> invQtyMap, boolean updateQty2nd) {
        this.setBillQty(model, setRow, qtyMap, invQtyMap, "qty");
        if (invQtyMap.get("qty2nd") == null) {
            return;
        }
        model.beginInit();
        if (updateQty2nd) {
            model.setValue(invQtyMap.get("qty2nd"), (Object)BigDecimal.ZERO, setRow);
        } else if (invQtyMap.get("qty2nd") != null) {
            BigDecimal avbqty2ndDecimal = qtyMap.get(invQtyMap.get("qty2nd")).compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : qtyMap.get(invQtyMap.get("qty2nd"));
            model.setValue(invQtyMap.get("qty2nd"), (Object)avbqty2ndDecimal, setRow);
        }
        model.endInit();
        view.updateView(invQtyMap.get("qty2nd"), setRow);
    }

    private void setBillQtyByDirFromAvb(IDataModel model, IFormView view, int setRow, Map<String, BigDecimal> qtyMap, Map<String, String> invQtyMap, boolean updateQty2nd) {
        this.setBillQty(model, setRow, qtyMap, invQtyMap, "avbqty");
        if (invQtyMap.get("avbqty2nd") == null) {
            return;
        }
        model.beginInit();
        if (updateQty2nd) {
            model.setValue(invQtyMap.get("avbqty2nd"), (Object)BigDecimal.ZERO, setRow);
        } else if (invQtyMap.get("avbqty2nd") != null) {
            BigDecimal avbqty2ndDecimal = qtyMap.get(invQtyMap.get("avbqty2nd")).compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : qtyMap.get(invQtyMap.get("avbqty2nd"));
            model.setValue(invQtyMap.get("avbqty2nd"), (Object)avbqty2ndDecimal, setRow);
        }
        model.endInit();
        view.updateView(invQtyMap.get("avbqty2nd"), setRow);
    }

    private void setBillQty(IDataModel model, int setRow, Map<String, BigDecimal> qtyMap, Map<String, String> invQtyMap, String invQtyf) {
        if (invQtyMap.get(invQtyf) != null) {
            model.beginInit();
            model.setValue(invQtyMap.get(invQtyf), null, setRow);
            model.endInit();
            model.setValue(invQtyMap.get(invQtyf), (Object)qtyMap.get(invQtyMap.get(invQtyf)), setRow);
        }
    }

    private String getBillMatKey(List<Map<String, Object>> matchFields) {
        for (Map<String, Object> field : matchFields) {
            String key = (String)field.get("metadatakey");
            String currentKey = (String)field.get("currentmetadatakey");
            if (currentKey.indexOf(46) != -1) {
                currentKey = currentKey.substring(currentKey.indexOf(46) + 1);
            }
            if (!key.equals("material")) continue;
            return currentKey;
        }
        return null;
    }

    private Map<String, String> getBillQtyAndQty2ndKey(List<Map<String, Object>> matchFields) {
        HashMap<String, String> keyMap = new HashMap<String, String>();
        for (Map<String, Object> field : matchFields) {
            String key = (String)field.get("metadatakey");
            String currentKey = (String)field.get("currentmetadatakey");
            if (currentKey.indexOf(46) != -1) {
                currentKey = currentKey.substring(currentKey.indexOf(46) + 1);
            }
            if ("avbqty".equals(key) || "qty".equals(key)) {
                keyMap.put("qty", currentKey);
            }
            if (!"avbqty2nd".equals(key) && !"qty2nd".equals(key)) continue;
            keyMap.put("qtyunit2nd", currentKey);
        }
        return keyMap;
    }

    private int getNullRow(List<Map<String, Object>> fields, IFormView view, String matKey) {
        String entityKey = this.getBillEntryKey(fields, view);
        if (entityKey == null) {
            return -1;
        }
        IDataModel model = view.getModel();
        DynamicObjectCollection entryCol = model.getEntryEntity(entityKey);
        if (entryCol == null || entryCol.size() == 0) {
            return -1;
        }
        for (int i = 0; i < entryCol.size(); ++i) {
            if (((DynamicObject)entryCol.get(i)).getDynamicObject(matKey) != null) continue;
            return i;
        }
        return -1;
    }

    private String getBillEntryKey(List<Map<String, Object>> fields, IFormView view) {
        if (null == fields || fields.size() == 0) {
            return null;
        }
        for (int i = 0; i < fields.size(); ++i) {
            String[] keys;
            String entityKey;
            EntryGrid entryGrid;
            Map<String, Object> field = fields.get(i);
            String currentKey = (String)field.get("currentmetadatakey");
            if (currentKey == null || currentKey.indexOf(46) == -1 || (entryGrid = (EntryGrid)view.getControl(entityKey = (keys = currentKey.split("\\."))[keys.length - 2])) == null) continue;
            return entityKey;
        }
        return null;
    }

    private boolean matchNull(Object currentValue, Object value) {
        boolean valueIsNotEmptyAndCvalueIsEmpty;
        boolean isMatch = true;
        boolean resultIsNull = null == currentValue && null == value;
        boolean resultIsEmpty = "".equals(currentValue) && "".equals(value);
        boolean cValueIsNotNullAndValueIsNull = null != currentValue && null == value;
        boolean cValueIsNotEmptyAndValueIsEmpty = !"".equals(currentValue) && "".equals(value);
        boolean valueIsNotNullAndCvalueIsNull = null != value && null == currentValue;
        boolean bl = valueIsNotEmptyAndCvalueIsEmpty = !"".equals(value) && "".equals(currentValue);
        if (resultIsNull || resultIsEmpty) {
            isMatch = true;
        }
        if (cValueIsNotNullAndValueIsNull || cValueIsNotEmptyAndValueIsEmpty) {
            isMatch = false;
        }
        if (valueIsNotNullAndCvalueIsNull || valueIsNotEmptyAndCvalueIsEmpty) {
            isMatch = false;
        }
        return isMatch;
    }

    private Object getDynamicObjectKey(String key, Object value) {
        Object pkid = null;
        IDataEntityProperty dataEntityProperty = (IDataEntityProperty)MetadataServiceHelper.getDataEntityType((String)this.getView().getEntityId()).getAllFields().get(key);
        if (dataEntityProperty instanceof MaterielProp && !((MaterielProp)dataEntityProperty).getBaseEntityId().equals("bd_material")) {
            DynamicObject material = ((DynamicObject)value).getDynamicObject("masterid");
            pkid = material.getPkValue();
        } else {
            pkid = ((DynamicObject)value).getPkValue();
        }
        return pkid;
    }

    private DynamicObject getBillMaterial(String key, String currentKey, DynamicObject invacc, IFormView view) {
        IDataEntityType strategyType = ((MaterielProp)MetadataServiceHelper.getDataEntityType((String)view.getEntityId()).getAllFields().get(currentKey)).getComplexType();
        String materialStrategy = strategyType.getName();
        if (materialStrategy.equals("bd_material")) {
            return null;
        }
        DynamicObject material = invacc.getDynamicObject(key);
        DynamicObject accOrg = invacc.getDynamicObject("org");
        String materialName = invacc.getDynamicObject(key).getLocaleString("name").getLocaleValue();
        String materialStrategyname = strategyType.getDisplayName().getLocaleValue();
        QFilter qFilter = new QFilter("masterid.id", "=", material.getPkValue());
        log.info("\u5373\u65f6\u5e93\u5b58\u4e2d\u7269\u6599 : " + material.getString("number") + "\uff0c ID = " + material.getPkValue());
        long orgId = "bd_materialinventoryinfo".equals(materialStrategy) ? Long.parseLong(accOrg.getPkValue().toString()) : this.getMainOrgId(view);
        String orgName = "bd_materialinventoryinfo".equals(materialStrategy) ? accOrg.getLocaleString("name").getLocaleValue() : this.getMainOrgName(view);
        material = this.getMaterialStrategyDyc(qFilter, orgId, materialStrategy, orgName, materialName, materialStrategyname);
        return material;
    }

    private DynamicObject getMaterialStrategyDyc(QFilter qFilter, long orgId, String materialFormId, String orgName, String materialName, String strategyName) {
        qFilter.and(BaseDataServiceHelper.getBaseDataFilter((String)materialFormId, (Long)orgId));
        DynamicObject material = BusinessDataServiceHelper.loadSingleFromCache((String)materialFormId, (QFilter[])new QFilter[]{qFilter});
        if (material == null) {
            throw new KDBizException(String.format(this.getMsgInventoryQueryPre(), orgName, materialName, strategyName));
        }
        return material;
    }

    private Long getMainOrgId(IFormView view) {
        String purMainOrgf = view.getModel().getDataEntityType().getMainOrg();
        DynamicObject orgDyc = (DynamicObject)view.getModel().getValue(purMainOrgf);
        if (orgDyc == null) {
            throw new KDBizException(InventoryQueryOld.getMsgInventoryQueryOrgNotNull());
        }
        return Long.valueOf(orgDyc.getPkValue().toString());
    }

    private static String getMsgInventoryQueryOrgNotNull() {
        return ResManager.loadKDString((String)"\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InventoryQuery_2", (String)"bos-ext-scmc", (Object[])new Object[0]);
    }

    private String getMainOrgName(IFormView view) {
        String mainOrgf = view.getModel().getDataEntityType().getMainOrg();
        DynamicObject orgDyc = (DynamicObject)view.getModel().getValue(mainOrgf);
        if (orgDyc == null) {
            throw new KDBizException(InventoryQueryOld.getMsgInventoryQueryOrgNotNull());
        }
        return orgDyc.getLocaleString("name").getLocaleValue();
    }

    private void copySouceFiledsInfo(IDataModel model, int currentRowIndex, int newRowIndex, String entryKey, IFormView view) {
        model.beginInit();
        DynamicObject rowData = model.getEntryRowEntity(entryKey, currentRowIndex);
        DynamicObject newRowData = model.getEntryRowEntity(entryKey, newRowIndex);
        newRowData.getDataEntityState().setPushChanged(true);
        for (String logo : SOURCE_INFO_DIFF_PER_BILL) {
            IDataEntityProperty dataEntiryProperty = model.getDataEntityType().findProperty(logo);
            if (dataEntiryProperty == null) continue;
            newRowData.set(logo, rowData.get(logo));
            view.updateView(logo, newRowIndex);
        }
        model.endInit();
    }
}

