/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.operation.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;

public class NoUpdateFieldsAnalysisExtHelper {
    private static final Log log = LogFactory.getLog(NoUpdateFieldsAnalysisExtHelper.class);
    private static final String NOUPDATEFIELDSKEY = "setnull";
    public static final String SUBSUFFIX = "1";
    public static final String MATERIALKEY = "materialKey";
    public static final String ENTRYKEY = "entryKey";

    public static List<String> getNoUpdateFieldsList(String noUpdateInvFields) {
        List<String> updateInvFieldsList = new ArrayList<String>(4);
        boolean jsonType = NoUpdateFieldsAnalysisExtHelper.getJSONType(noUpdateInvFields);
        if (!jsonType) {
            return updateInvFieldsList;
        }
        Map updateInvFieldsMap = (Map)SerializationUtils.fromJsonString((String)noUpdateInvFields, Map.class);
        updateInvFieldsList = (List)updateInvFieldsMap.get(NOUPDATEFIELDSKEY);
        if (null == updateInvFieldsList) {
            updateInvFieldsList = new ArrayList(4);
        }
        return updateInvFieldsList;
    }

    private static boolean getJSONType(String str) {
        boolean result = false;
        if (StringUtils.isNotBlank((CharSequence)str)) {
            if ((str = str.trim()).startsWith("{") && str.endsWith("}")) {
                result = true;
            } else if (str.startsWith("[") && str.endsWith("]")) {
                result = true;
            }
        }
        return result;
    }

    public static void setNoUpdateFields(IDataModel model, String entryNoUpdateFieldKey, List<Map<String, Object>> fields) {
        if (null == entryNoUpdateFieldKey || entryNoUpdateFieldKey.isEmpty()) {
            return;
        }
        Map<String, String> keyMap = NoUpdateFieldsAnalysisExtHelper.getKeyMap(fields);
        String materialKey = keyMap.get(MATERIALKEY);
        String entryKey = keyMap.get(ENTRYKEY);
        String formId = model.getDataEntityType().getName();
        int rowCount = model.getEntryRowCount(entryKey);
        DynamicObjectCollection entryEntity = model.getEntryEntity(entryKey);
        HashSet<Object> materialIdSet = new HashSet<Object>(entryEntity.size());
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject material = (DynamicObject)model.getValue(materialKey, i);
            if (null == material) continue;
            materialIdSet.add(material.getPkValue());
        }
        log.info("----------NoUpdateFieldsAnalysisHelper,materialIdSet:" + materialIdSet + ";formId:" + formId + ";entryKey:" + entryKey);
        Map noUpdateFiledsMap = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"sbd", (String)"NoUpdateInvService", (String)"getNoUpdateFields", (Object[])new Object[]{formId, entryKey, materialIdSet});
        log.info("---------------NoUpdateFieldsAnalysisHelper,noUpdateFiledsMap:" + noUpdateFiledsMap);
        for (int i = 0; i < rowCount; ++i) {
            String noUpdateFieldsValue;
            DynamicObject material = (DynamicObject)model.getValue(materialKey, i);
            if (null == material || !(noUpdateFieldsValue = (String)model.getValue(entryNoUpdateFieldKey, i)).isEmpty()) continue;
            String value = (String)noUpdateFiledsMap.get(material.getPkValue());
            model.setValue(entryNoUpdateFieldKey, (Object)value, i);
        }
    }

    public static Map<String, String> getKeyMap(List<Map<String, Object>> filedData) {
        HashMap<String, String> keyMap = new HashMap<String, String>(4);
        String materialKey = "material";
        String entryKey = "billentry";
        for (Map<String, Object> fieldMap : filedData) {
            String currentKey = (String)fieldMap.get("currentmetadatakey");
            String[] keys = currentKey.split("\\.");
            if (keys.length == 2) {
                if (keys[1].endsWith(SUBSUFFIX)) {
                    materialKey = materialKey + SUBSUFFIX;
                }
                entryKey = keys[0];
                break;
            }
            if (keys.length != 3) continue;
            if (keys[2].endsWith(SUBSUFFIX)) {
                materialKey = materialKey + SUBSUFFIX;
            }
            entryKey = keys[1];
            break;
        }
        keyMap.put(MATERIALKEY, materialKey);
        keyMap.put(ENTRYKEY, entryKey);
        return keyMap;
    }
}

