/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.sn.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.KdtxRequestContext;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.JsonSubEntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.NameVersionEntryType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.TreeSubEntryType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.formula.BOSExpressionContext;
import kd.bos.entity.formula.CalcExprParser;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.function.FunctionManage;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.constant.GlobalSessionType;
import kd.bos.kdtx.sdk.constant.Propagation;
import kd.bos.kdtx.sdk.context.DtxContext;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.kdtx.sdk.session.ec.ECSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public class SerialNumberHelper {
    private static final Log logger = LogFactory.getLog(SerialNumberHelper.class);
    private static final String SCMC_SN_SERVICE = "scmc_sn_service";
    private static final String HANDLE_SAVE_SERIAL_NUMBER = "handleSerialNumber";
    private static List<String> ignoreColumns = Arrays.asList("billstatus", "auditor", "auditdate", "auditor_id");

    public static Map<Object, List<String>> validateCallSNService(Collection<DynamicObject> bills, String operate) {
        IDataEntityProperty property;
        Iterator<DynamicObject> entryKey;
        if (bills == null || bills.size() == 0) {
            return new HashMap<Object, List<String>>(0);
        }
        ArrayList<Long> billIdList = new ArrayList<Long>(bills.size());
        ArrayList<Long> hasSNBillIdList = new ArrayList<Long>(bills.size());
        ArrayList<Object> hasSNentryIdList = new ArrayList<Object>(16);
        String billtype = null;
        boolean isFromDataBase = true;
        boolean notExistSingleSerialRow = true;
        boolean isHasSubEntry = false;
        int billsize = bills.size();
        boolean dirtyFlag = false;
        DynamicObject billSingle = null;
        boolean hasSerialNumberCol = false;
        Object billEntryType = null;
        Object billSubEntryType = null;
        DynamicObject firstBill = null;
        Optional<DynamicObject> first = bills.stream().findFirst();
        if (first.isPresent()) {
            firstBill = first.get();
        }
        if (firstBill == null) {
            return new HashMap<Object, List<String>>(0);
        }
        BillEntityType dataEntityType = (BillEntityType)firstBill.getDataEntityType();
        billtype = dataEntityType.getName();
        Map allEntities = dataEntityType.getAllEntities();
        Map<String, String> billEntityMaps = SerialNumberHelper.getBillEntity(allEntities);
        if (billEntityMaps != null && !billEntityMaps.isEmpty()) {
            if (billEntityMaps.containsKey("entry")) {
                billEntryType = billEntityMaps.get("entry");
            }
            if (billEntityMaps.containsKey("subEntry")) {
                billSubEntryType = billEntityMaps.get("subEntry");
            }
        }
        isFromDataBase = firstBill.getDataEntityState().getFromDatabase();
        Collection<DynamicObject> allBillConfigs = SerialNumberHelper.getSNBillConfigByBillType(billtype);
        if (!allBillConfigs.isEmpty()) {
            for (DynamicObject config : allBillConfigs) {
                entryKey = config.getString("srcbillentry");
                if (allEntities == null) continue;
                EntityType entityType = (EntityType)allEntities.get(entryKey);
                if (entityType instanceof SubEntryType) {
                    billSubEntryType = entryKey;
                    continue;
                }
                if (!(entityType instanceof EntryType)) continue;
                billEntryType = entryKey;
            }
        }
        if (StringUtils.isNotEmpty(billSubEntryType) && StringUtils.isNotEmpty((String)billEntryType)) {
            IDataEntityProperty subEntryProp = dataEntityType.findProperty((String)billSubEntryType);
            isHasSubEntry = SerialNumberHelper.getHasSubEntry(billtype) && subEntryProp != null && subEntryProp.getParent() != null && ((String)billEntryType).equals(subEntryProp.getParent().getName());
        }
        hasSerialNumberCol = (property = dataEntityType.findProperty("serialnumber")) != null && property.getParent() != null && StringUtils.isNotEmpty((String)billEntryType) && ((String)billEntryType).equals(property.getParent().getName());
        HashMap<Long, List> configMap = new HashMap<Long, List>(bills.size());
        if (allBillConfigs != null) {
            for (DynamicObject config : allBillConfigs) {
                for (DynamicObject bill : bills) {
                    Long billId = bill.getLong("id");
                    boolean dynamicObjectMatchCfg = SerialNumberHelper.isDynamicObjectMatchCfg(billtype, bill, config);
                    if (!dynamicObjectMatchCfg) continue;
                    List entryConfigs = configMap.computeIfAbsent(billId, k -> new ArrayList());
                    entryConfigs.add(config);
                }
            }
        }
        entryKey = bills.iterator();
        while (entryKey.hasNext()) {
            DynamicObject bill;
            billSingle = bill = entryKey.next();
            Long billid = (Long)bill.getPkValue();
            List configs = (List)configMap.get(billid);
            billIdList.add(billid);
            if (SerialNumberHelper.isInvBillEnableSerial(bill, configs, operate) && !SerialNumberHelper.isVirtualBill(bill) && !SerialNumberHelper.isInitBill(bill)) {
                hasSNBillIdList.add(billid);
                if (operate.equals("save") || billsize == 1 && operate.equals("submit")) {
                    SerialNumberHelper.putSNEntryIds(hasSNentryIdList, bill, configs, operate);
                }
            }
            dirtyFlag = SerialNumberHelper.checkDirtyFlag(bill, isHasSubEntry, (String)billEntryType, (String)billSubEntryType);
            if (billsize != 1 || !operate.equals("submit") || !hasSerialNumberCol || !dirtyFlag || isHasSubEntry) continue;
            DynamicObjectCollection billentries = bill.getDynamicObjectCollection((String)billEntryType);
            for (DynamicObject billentry : billentries) {
                String serialnumber;
                long entryid = (Long)billentry.getPkValue();
                if (entryid != 0L || StringUtils.isBlank((String)(serialnumber = billentry.getString("serialnumber")))) continue;
                notExistSingleSerialRow = false;
            }
        }
        if (isFromDataBase && notExistSingleSerialRow && !hasSNBillIdList.isEmpty() && !isHasSubEntry && billsize == 1 && operate.equals("submit") && dirtyFlag && hasSerialNumberCol) {
            SerialNumberHelper.copySerialnumToRel(new DynamicObject[]{billSingle}, (String)billEntryType);
        }
        if (operate.equals("save") || billsize == 1 && operate.equals("submit")) {
            DispatchServiceHelper.invokeBizService((String)"scmc", (String)"sbs", (String)"SerialNumberService", (String)"validateSNByBillDelEntry", (Object[])new Object[]{billtype, operate, billIdList, hasSNentryIdList});
        }
        if (hasSNBillIdList.isEmpty() || operate.equals("save")) {
            return new HashMap<Object, List<String>>(0);
        }
        if (!isFromDataBase || !notExistSingleSerialRow) {
            Long billid = billSingle.getLong("id");
            String message = ResManager.loadKDString((String)"\u5305\u542b\u5e8f\u5217\u53f7\u63a7\u5236\u7684\u5355\u636e\u8bf7\u5148\u4fdd\u5b58\u540e\u518d\u63d0\u4ea4\u3002", (String)"SerialNumberHelper_0", (String)"bos-ext-scmc", (Object[])new Object[0]);
            HashMap<Object, List<String>> errorMessageData = new HashMap<Object, List<String>>(1);
            errorMessageData.put(billid, Collections.singletonList(message));
            return errorMessageData;
        }
        if (billsize == 1 && operate.equals("submit") && dirtyFlag) {
            return (Map)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"sbs", (String)"SerialNumberService", (String)"validateSNBySingleBillOperate", (Object[])new Object[]{billtype, operate, billSingle});
        }
        return (Map)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"sbs", (String)"SerialNumberService", (String)"validateSNByBillOperate", (Object[])new Object[]{billtype, operate, hasSNBillIdList});
    }

    private static Map<String, String> getBillEntity(Map<String, EntityType> allEntities) {
        if (allEntities == null || allEntities.isEmpty()) {
            return null;
        }
        HashMap<String, String> billEntity = new HashMap<String, String>(16);
        for (Map.Entry<String, EntityType> entry : allEntities.entrySet()) {
            String key = entry.getKey();
            EntityType value = entry.getValue();
            if (value instanceof LinkEntryType || value instanceof JsonSubEntryType || value instanceof NameVersionEntryType || value instanceof TreeSubEntryType) continue;
            if (value instanceof SubEntryType) {
                billEntity.putIfAbsent("subEntry", key);
                continue;
            }
            if (!(value instanceof EntryType) || "snentity".equals(key)) continue;
            billEntity.putIfAbsent("entry", key);
        }
        return billEntity;
    }

    public static void saveSNHandle(DynamicObject[] entities, boolean isFromDataBase) {
        HashSet<Object> ids = new HashSet<Object>(16);
        HashSet<Object> entryIds = new HashSet<Object>(16);
        boolean isHasSubEntry = false;
        String billtype = null;
        Map<Long, List<DynamicObject>> billSerialConfigs = SerialNumberHelper.getBillSerialConfigs(entities);
        for (DynamicObject entity : entities) {
            if (SerialNumberHelper.isVirtualBill(entity)) continue;
            if (billtype == null) {
                billtype = entity.getDynamicObjectType().getName();
                isHasSubEntry = SerialNumberHelper.getHasSubEntry(billtype);
            }
            ids.add(entity.getPkValue().toString());
            List<DynamicObject> configs = billSerialConfigs.get(entity.getLong("id"));
            SerialNumberHelper.putSNEntryIds(entryIds, entity, configs, "save");
        }
        if (isFromDataBase) {
            SerialNumberHelper.deleteRelationAndTrack(ids, entryIds, billtype);
        } else {
            if (entryIds.isEmpty()) {
                return;
            }
            SerialNumberHelper.carrySerialNumber(billtype, ids, entities);
        }
        if (entryIds.size() > 0 && !isHasSubEntry) {
            SerialNumberHelper.copySerialnumToRel(entities, "billentry");
        }
    }

    private static void carrySerialNumber(String billType, Set<Object> ids, DynamicObject[] entities) {
        ECSession session = (ECSession)DtxContext.getDtxSession();
        if (session == null || StringUtils.isEmpty((String)KdtxRequestContext.get().getXid()) || !SCMC_SN_SERVICE.equals(session.getScenesCode())) {
            ECGlobalSession.begin((String)SCMC_SN_SERVICE, (DBRoute)DBRoute.of((String)"scm"), (GlobalSessionType)GlobalSessionType.COMBINATION);
        }
        ECGlobalSession.setBusinessType((String)HANDLE_SAVE_SERIAL_NUMBER);
        ArrayList<String> businessInfoList = new ArrayList<String>(ids.size());
        for (Object billId : ids) {
            businessInfoList.add(billType + "#" + billId.toString());
        }
        ECGlobalSession.setBusinessInfo(businessInfoList);
        ECGlobalSession.setAsync((boolean)false);
        CommonParam param = new CommonParam();
        param.put((Object)"bills", (Object)entities);
        ECGlobalSession.register((String)"scmc", (String)"sbs", (String)"CarrySerialNumberService", (Param)param, (String)"handleCarrySnRelation", businessInfoList);
    }

    private static void deleteRelationAndTrack(Set<Object> ids, Set<Object> entryIds, String billType) {
        ECSession session = (ECSession)DtxContext.getDtxSession();
        if (session == null || StringUtils.isEmpty((String)KdtxRequestContext.get().getXid()) || !SCMC_SN_SERVICE.equals(session.getScenesCode())) {
            ECGlobalSession.begin((String)SCMC_SN_SERVICE, (DBRoute)DBRoute.of((String)"scm"), (GlobalSessionType)GlobalSessionType.COMBINATION);
        }
        ECGlobalSession.setBusinessType((String)HANDLE_SAVE_SERIAL_NUMBER);
        ArrayList<String> businessInfoList = new ArrayList<String>(ids.size());
        for (Object billId : ids) {
            businessInfoList.add(billType + "#" + billId.toString());
        }
        ECGlobalSession.setBusinessInfo(businessInfoList);
        ECGlobalSession.setAsync((boolean)false);
        Set newBillIds = ids.stream().map(id -> Long.parseLong(id.toString())).collect(Collectors.toSet());
        Set newKeepEntryIds = entryIds.stream().map(entryId -> Long.parseLong(entryId.toString())).collect(Collectors.toSet());
        CommonParam param = new CommonParam();
        param.put((Object)"billtype", (Object)billType);
        param.put((Object)"billids", newBillIds);
        param.put((Object)"entryids", newKeepEntryIds);
        ECGlobalSession.register((String)"scmc", (String)"sbs", (String)"DeleteSnBillRelationService", (Param)param, (String)"handleDeleteSnRelation", businessInfoList);
        param = new CommonParam();
        param.put((Object)"billtype", (Object)billType);
        param.put((Object)"newbillIds", newBillIds);
        param.put((Object)"newkeepEntryIds", newKeepEntryIds);
        param.put((Object)"flag", (Object)(entryIds.isEmpty() ? "1" : "2"));
        ECGlobalSession.register((String)"scmc", (String)"sbs", (String)"DeleteMoveTrackService", (Param)param, (String)"handleDeleteSnMoveTrack", businessInfoList);
    }

    public static void operateCallSNService(DynamicObject[] bills, String operate) {
        if (bills == null || bills.length == 0) {
            return;
        }
        HashSet<Object> billIdSet = new HashSet<Object>(bills.length);
        ArrayList<Long> hasSNBillIdList = new ArrayList<Long>(bills.length);
        String billType = bills[0].getDynamicObjectType().getName();
        Map<Long, List<DynamicObject>> billSerialConfigs = SerialNumberHelper.getBillSerialConfigs(bills);
        for (DynamicObject bill : bills) {
            Long billid = (Long)bill.getPkValue();
            billIdSet.add(billid);
            List<DynamicObject> configs = billSerialConfigs.get(billid);
            if (!SerialNumberHelper.isInvBillEnableSerial(bill, configs, operate) || SerialNumberHelper.isVirtualBill(bill) || SerialNumberHelper.isInitBill(bill)) continue;
            hasSNBillIdList.add(billid);
        }
        if (bills.length == 1 && operate.equals("submit")) {
            HashSet<Object> hasSNentryIdSet = new HashSet<Object>(16);
            DynamicObject bill = bills[0];
            List<DynamicObject> configs = billSerialConfigs.get(bill.getLong("id"));
            SerialNumberHelper.putSNEntryIds(hasSNentryIdSet, bill, configs, operate);
            SerialNumberHelper.deleteRelationAndTrack(billIdSet, hasSNentryIdSet, billType);
        }
        if (hasSNBillIdList.isEmpty()) {
            return;
        }
        ECSession session = (ECSession)DtxContext.getDtxSession();
        if (session == null || StringUtils.isEmpty((String)KdtxRequestContext.get().getXid()) || !SCMC_SN_SERVICE.equals(session.getScenesCode())) {
            ECGlobalSession.begin((String)SCMC_SN_SERVICE, (DBRoute)DBRoute.of((String)"scm"), (GlobalSessionType)GlobalSessionType.COMBINATION);
        }
        ECGlobalSession.setBusinessType((String)HANDLE_SAVE_SERIAL_NUMBER);
        ArrayList<String> businessInfoList = new ArrayList<String>(hasSNBillIdList.size());
        for (Long billId : hasSNBillIdList) {
            businessInfoList.add(billType + "#" + billId.toString());
        }
        ECGlobalSession.setBusinessInfo(businessInfoList);
        ECGlobalSession.setAsync((boolean)false);
        CommonParam param = new CommonParam();
        param.put((Object)"billtype", (Object)billType);
        param.put((Object)"operate", (Object)operate);
        param.put((Object)"billIds", hasSNBillIdList);
        ECGlobalSession.register((String)"scmc", (String)"sbs", (String)"SerialNumberECService", (Param)param, (String)"callSnService", businessInfoList);
    }

    public static void callSnService(DynamicObject[] bills, String operate) {
        if (bills == null || bills.length == 0) {
            return;
        }
        ArrayList<Long> hasSNBillIdList = new ArrayList<Long>(bills.length);
        String billType = bills[0].getDynamicObjectType().getName();
        Map<Long, List<DynamicObject>> billSerialConfigs = SerialNumberHelper.getBillSerialConfigs(bills);
        for (DynamicObject bill : bills) {
            Long billId = (Long)bill.getPkValue();
            List<DynamicObject> configs = billSerialConfigs.get(billId);
            if (!SerialNumberHelper.isInvBillEnableSerial(bill, configs, operate) || SerialNumberHelper.isVirtualBill(bill) || SerialNumberHelper.isInitBill(bill)) continue;
            hasSNBillIdList.add(billId);
        }
        if (hasSNBillIdList.isEmpty()) {
            return;
        }
        logger.debug("BillTplOp:\u6ce8\u518c\u5e8f\u5217\u53f7\u5904\u7406\u5206\u5e03\u5f0f\u4e8b\u52a1");
        ECGlobalSession.begin((String)"scm_bill_audit", (DBRoute)DBRoute.of((String)"scmc"), (Propagation)Propagation.REQUIRES_NEW);
        CommonParam param = new CommonParam();
        param.put((Object)"billtype", (Object)billType);
        param.put((Object)"operate", (Object)"audit");
        param.put((Object)"billIds", hasSNBillIdList);
        ECGlobalSession.register((String)"scmc", (String)"sbs", (String)"SerialNumberAuditECService", (Param)param, (String)"callSnService");
        ECGlobalSession.setBusinessType((String)"snService");
        ArrayList<String> businessInfoList = new ArrayList<String>(hasSNBillIdList.size());
        for (Long billId : hasSNBillIdList) {
            businessInfoList.add(billType + "#" + billId.toString());
        }
        ECGlobalSession.setBusinessInfo(businessInfoList);
        ECGlobalSession.setAsync((boolean)false);
    }

    private static boolean checkDirtyFlag(DynamicObject bill, boolean isHasSubEntry, String billEntryType, String billSubEntryType) {
        DataEntityState state = bill.getDataEntityState();
        long dirtySize = state.GetDirtyProperties().stream().filter(dirtyProp -> !ignoreColumns.contains(dirtyProp.getName())).count();
        if (dirtySize > 0L || state.getRemovedItems().booleanValue()) {
            return true;
        }
        DynamicObjectCollection billentries = bill.getDynamicObjectCollection(billEntryType);
        for (DynamicObject billentry : billentries) {
            state = billentry.getDataEntityState();
            if (state.getDataEntityDirty() || state.getRemovedItems().booleanValue()) {
                return true;
            }
            if (!isHasSubEntry) continue;
            DynamicObjectCollection subentries = billentry.getDynamicObjectCollection(billSubEntryType);
            for (DynamicObject subentry : subentries) {
                if (!subentry.getDataEntityState().getDataEntityDirty()) continue;
                return true;
            }
        }
        return false;
    }

    public static void copySerialnumToRel(DynamicObject[] bills, String entryName) {
        if (!(bills[0].getDataEntityType() instanceof BillEntityType)) {
            return;
        }
        BillEntityType billEntity = (BillEntityType)bills[0].getDataEntityType();
        IDataEntityProperty entryProp = billEntity.findProperty(entryName);
        IDataEntityProperty snProp = billEntity.findProperty("serialnumber");
        if (entryProp == null || snProp == null || snProp.getParent() == null || !entryName.equals(snProp.getParent().getName())) {
            return;
        }
        String billtype = billEntity.getName();
        for (DynamicObject bill : bills) {
            long billid = (Long)bill.getPkValue();
            if (billid <= 0L) continue;
            DynamicObject org = SerialNumberHelper.getBillMainOrg(bill, billtype);
            DynamicObjectCollection entries = bill.getDynamicObjectCollection(entryName);
            HashMap<Long, List<Map<String, Object>>> allEntrySerials = new HashMap<Long, List<Map<String, Object>>>(entries.size());
            for (DynamicObject entry : entries) {
                String serialnumber;
                long entryid = (Long)entry.getPkValue();
                if (entryid <= 0L || StringUtils.isBlank((String)(serialnumber = entry.getString("serialnumber")))) continue;
                ArrayList serialList = new ArrayList(1);
                HashMap<String, Object> serial = new HashMap<String, Object>(2);
                serial.put("snnumber", serialnumber);
                serial.put("invorg", org != null ? org.getPkValue() : null);
                serialList.add(serial);
                allEntrySerials.put(entryid, serialList);
            }
            if (allEntrySerials.isEmpty()) continue;
            SerialNumberHelper.quickFullInputSerialNumber(true, billtype, billid, entryName, allEntrySerials, Collections.emptyMap());
        }
    }

    public static void quickFullInputSerialNumber(Boolean forceClear, String billType, Long billId, String entryName, Map<Long, List<Map<String, Object>>> allEntrySerials, Map<Long, Map<String, Object>> entrySrcMap) {
        QFilter filter = new QFilter("billtype", "=", (Object)billType).and("entrykey", "=", (Object)entryName).and("billid", "=", (Object)billId).and("entryid", "in", allEntrySerials.keySet());
        Map billSNRelationsById = BusinessDataServiceHelper.loadFromCache((String)"sbs_billsnrelation", (QFilter[])filter.toArray());
        HashMap<Long, DynamicObject> billSNRelationsByEntryId = new HashMap<Long, DynamicObject>(billSNRelationsById.size());
        for (DynamicObject billSNRelation : billSNRelationsById.values()) {
            Long entryId = billSNRelation.getLong("entryid");
            billSNRelationsByEntryId.put(entryId, billSNRelation);
        }
        ArrayList<DynamicObject> billSNRelationsForSave = new ArrayList<DynamicObject>(allEntrySerials.size());
        for (Map.Entry<Long, List<Map<String, Object>>> entrySerials : allEntrySerials.entrySet()) {
            DynamicObjectCollection entryEntity;
            Long entryId = entrySerials.getKey();
            List<Map<String, Object>> serialList = entrySerials.getValue();
            DynamicObject billSNRelation = (DynamicObject)billSNRelationsByEntryId.get(entryId);
            if (billSNRelation == null) {
                Map<String, Object> entrySrc;
                billSNRelation = BusinessDataServiceHelper.newDynamicObject((String)"sbs_billsnrelation");
                billSNRelation.set("billtype", (Object)billType);
                billSNRelation.set("entrykey", (Object)entryName);
                billSNRelation.set("billid", (Object)billId);
                billSNRelation.set("entryid", (Object)entryId);
                if (entrySrcMap != null && (entrySrc = entrySrcMap.get(entryId)) != null) {
                    billSNRelation.set("srcbilltype", entrySrc.get("srcbilltype"));
                    billSNRelation.set("srcbillid", entrySrc.get("srcbillid"));
                    billSNRelation.set("srcentrykey", entrySrc.get("srcentrykey"));
                    billSNRelation.set("srcentryid", entrySrc.get("srcentryid"));
                    billSNRelation.set("srcisreq", entrySrc.get("srcisreq"));
                }
            }
            if ((entryEntity = billSNRelation.getDynamicObjectCollection("entryentity")).size() > 0) {
                if (!forceClear.booleanValue()) continue;
                entryEntity.clear();
            }
            for (int i = 1; i <= serialList.size(); ++i) {
                Map<String, Object> serial = serialList.get(i - 1);
                DynamicObject singleSn = entryEntity.addNew();
                singleSn.set("handlestatus", (Object)"A");
                singleSn.set("seq", (Object)i);
                for (Map.Entry<String, Object> serialItem : serial.entrySet()) {
                    singleSn.set(serialItem.getKey(), serialItem.getValue());
                }
            }
            billSNRelationsForSave.add(billSNRelation);
        }
        if (!billSNRelationsForSave.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])billSNRelationsForSave.toArray(new DynamicObject[0]));
        }
    }

    private static DynamicObject getBillMainOrg(DynamicObject bill, String billtype) {
        DynamicObject org = "im_transdirbill".equals(billtype) ? (DynamicObject)bill.get("outorg") : (DynamicObject)bill.get("org");
        return org;
    }

    public static Map<Long, List<DynamicObject>> getBillSerialConfigs(DynamicObject[] bills) {
        HashMap<Long, List<DynamicObject>> configs = new HashMap<Long, List<DynamicObject>>(bills.length);
        String billType = bills[0].getDynamicObjectType().getName();
        Collection<DynamicObject> snBillConfigs = SerialNumberHelper.getSNBillConfigByBillType(billType);
        for (DynamicObject config : snBillConfigs) {
            for (DynamicObject bill : bills) {
                Long billId = bill.getLong("id");
                boolean dynamicObjectMatchCfg = SerialNumberHelper.isDynamicObjectMatchCfg(billType, bill, config);
                if (!dynamicObjectMatchCfg) continue;
                List entryConfigs = configs.computeIfAbsent(billId, k -> new ArrayList());
                entryConfigs.add(config);
            }
        }
        return configs;
    }

    private static Collection<DynamicObject> getSNBillConfigByBillType(String billType) {
        Map cfgs = BusinessDataServiceHelper.loadFromCache((String)"sbs_snbillconfig", (QFilter[])new QFilter("srcbillobj", "=", (Object)billType).and("enable", "=", (Object)Boolean.TRUE).toArray());
        return cfgs.values().stream().sorted((cfg1, cfg2) -> {
            Long result = (Long)cfg1.getPkValue() - (Long)cfg2.getPkValue();
            return result > 0L ? 1 : (result < 0L ? -1 : 0);
        }).collect(Collectors.toList());
    }

    public static DynamicObject getSNBillConfigByBillId(String billtype, String entrytype, Long billid) {
        Collection<DynamicObject> cfgs = SerialNumberHelper.getSNBillConfig(billtype, entrytype);
        for (DynamicObject cfg : cfgs) {
            DynamicObject result;
            QFilter filter = new QFilter("id", "=", (Object)billid);
            QFilter cfgFilter = SerialNumberHelper.parseBillFilter(cfg.getString("billfilter"), billtype);
            if (cfgFilter != null) {
                filter.and(cfgFilter);
            }
            if ((result = QueryServiceHelper.queryOne((String)billtype, (String)"id", (QFilter[])filter.toArray())) == null) continue;
            return cfg;
        }
        return null;
    }

    public static QFilter parseBillFilter(String jsonCondition, String billtype) {
        if (jsonCondition == null || jsonCondition.isEmpty() || billtype == null) {
            return null;
        }
        FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)jsonCondition, FilterCondition.class);
        FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)billtype), condition);
        fb.buildFilter();
        return fb.getQFilter();
    }

    private static void handleUnSaveBillConfig(Map<String, DynamicObject> configs, String billtype, DynamicObject bill, Long billId, String entryType) {
        Collection<DynamicObject> cfgs = SerialNumberHelper.getSNBillConfig(billtype, entryType);
        if (cfgs != null && !cfgs.isEmpty()) {
            for (DynamicObject cfg : cfgs) {
                boolean dynamicObjectMatchCfg = SerialNumberHelper.isDynamicObjectMatchCfg(billtype, bill, cfg);
                if (!dynamicObjectMatchCfg) continue;
                configs.put(billId + entryType, cfg);
                break;
            }
        }
    }

    public static boolean isDynamicObjectMatchCfg(String billtype, DynamicObject billObj, DynamicObject cfg) {
        String jsonCondition = cfg.getString("billfilter");
        if (jsonCondition == null || jsonCondition.isEmpty() || billtype == null) {
            return true;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)jsonCondition, FilterCondition.class);
        if (filterCondition.getFilterRow().isEmpty()) {
            return true;
        }
        MainEntityType mainType = (MainEntityType)billObj.getDataEntityType();
        FilterBuilder builder = new FilterBuilder(mainType, filterCondition);
        String[] script = builder.buildFilterScript();
        BOSExpression expr = new BOSExpression(script[0]);
        RowDataModel rowModel = new RowDataModel(billtype, mainType);
        BOSExpressionContext expContext = new BOSExpressionContext(rowModel);
        expContext.getRowDataModel().setRowContext((Object)billObj, 0);
        Boolean result = (Boolean)CalcExprParser.getExpressionValue((BOSExpression)expr, (ExpressionContext)expContext, (FunctionManage)FunctionManage.get());
        return result;
    }

    public static Collection<DynamicObject> getSNBillConfig(String billtype, String entrytype) {
        Map cfgs = BusinessDataServiceHelper.loadFromCache((String)"sbs_snbillconfig", (QFilter[])new QFilter("srcbillobj", "=", (Object)billtype).and("srcbillentry", "=", (Object)entrytype).and("enable", "=", (Object)Boolean.TRUE).toArray());
        return cfgs.values().stream().sorted((cfg1, cfg2) -> {
            Long result = (Long)cfg1.getPkValue() - (Long)cfg2.getPkValue();
            return result > 0L ? 1 : (result < 0L ? -1 : 0);
        }).collect(Collectors.toList());
    }

    public static void putSNEntryIds(Collection<Object> hasSNentryIdCollection, DynamicObject bill, List<DynamicObject> billSerialConfig, String operate) {
        if (billSerialConfig == null || billSerialConfig.isEmpty()) {
            return;
        }
        for (DynamicObject config : billSerialConfig) {
            String entryKey;
            DynamicObjectCollection billEntries;
            String entryName = config.getString("srcbillentry");
            String materialCol = config.getString("materialcol");
            String materialMasterCol = config.getString("materialmastercol");
            String unEmptyMaterialCol = StringUtils.isEmpty((String)materialCol) ? materialMasterCol : materialCol;
            String invOrgCol = SerialNumberHelper.getOrgCol(config.getDynamicObjectCollection("snmainfentry"));
            List<String> fullEntryNames = SerialNumberHelper.getFullEntryName(unEmptyMaterialCol, entryName);
            if (fullEntryNames.isEmpty() || (billEntries = bill.getDynamicObjectCollection(entryKey = fullEntryNames.get(0))) == null || billEntries.isEmpty()) continue;
            for (DynamicObject entry : billEntries) {
                if (fullEntryNames.size() == 1) {
                    if (!SerialNumberHelper.getMaterialInvInfoEnable(bill, operate, materialCol, materialMasterCol, invOrgCol, entry, false, entryKey)) continue;
                    hasSNentryIdCollection.add(entry.getPkValue());
                    continue;
                }
                String subEntryKey = fullEntryNames.get(1);
                DynamicObjectCollection subEntries = entry.getDynamicObjectCollection(subEntryKey);
                if (subEntries == null || subEntries.isEmpty()) continue;
                for (DynamicObject subEntry : subEntries) {
                    if (!SerialNumberHelper.getMaterialInvInfoEnable(bill, operate, materialCol, materialMasterCol, invOrgCol, subEntry, true, subEntryKey)) continue;
                    hasSNentryIdCollection.add(subEntry.getPkValue());
                }
            }
        }
    }

    private static boolean getMaterialInvInfoEnable(DynamicObject bill, String operate, String materialCol, String materialMasterCol, String invOrgCol, DynamicObject entry, boolean isSubEntry, String entryKey) {
        if (materialCol.isEmpty()) {
            return SerialNumberHelper.getMaterialInvInfoExistByMaterialColAndInvOrgCol(bill, materialMasterCol, invOrgCol, entry, operate, isSubEntry, entryKey);
        }
        DynamicObject materialInvInfo = (DynamicObject)SerialNumberHelper.getValueByName(bill, entry, materialCol);
        if (materialInvInfo == null) {
            return false;
        }
        if ("bd_materialinventoryinfo".equals(materialInvInfo.getDynamicObjectType().getName())) {
            return materialInvInfo.getBoolean("enableserial");
        }
        return SerialNumberHelper.getMaterialInvInfoExistByMaterialColAndInvOrgCol(bill, materialCol, invOrgCol, entry, operate, isSubEntry, entryKey);
    }

    public static boolean getHasSubEntry(String billtype) {
        return "im_assembbill".equals(billtype) || "im_adjustbill".equals(billtype) || "im_disassemblebill".equals(billtype);
    }

    public static boolean isInvBillEnableSerial(DynamicObject bill, List<DynamicObject> configs, String operate) {
        if (configs == null || configs.isEmpty()) {
            return false;
        }
        for (DynamicObject config : configs) {
            String entryName = config.getString("srcbillentry");
            String materialCol = config.getString("materialcol");
            String materialMasterCol = config.getString("materialmastercol");
            String unEmptyMaterialCol = StringUtils.isEmpty((String)materialCol) ? materialMasterCol : materialCol;
            String invOrgCol = SerialNumberHelper.getOrgCol(config.getDynamicObjectCollection("snmainfentry"));
            List<String> fullEntryNames = SerialNumberHelper.getFullEntryName(unEmptyMaterialCol, entryName);
            if (fullEntryNames.isEmpty()) continue;
            String entryKey = fullEntryNames.get(0);
            DynamicObjectCollection billEntry = bill.getDynamicObjectCollection(fullEntryNames.get(0));
            if (billEntry == null || billEntry.isEmpty()) {
                return false;
            }
            for (DynamicObject entry : billEntry) {
                if (fullEntryNames.size() == 1) {
                    if (!SerialNumberHelper.getMaterialInvInfoEnable(bill, operate, materialCol, materialMasterCol, invOrgCol, entry, false, entryKey)) continue;
                    return true;
                }
                String subEntryKey = fullEntryNames.get(1);
                DynamicObjectCollection subBillEntry = entry.getDynamicObjectCollection(fullEntryNames.get(1));
                if (subBillEntry == null || subBillEntry.isEmpty()) continue;
                for (DynamicObject subEntry : subBillEntry) {
                    if (!SerialNumberHelper.getMaterialInvInfoEnable(bill, operate, materialCol, materialMasterCol, invOrgCol, subEntry, true, subEntryKey)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static List<String> getFullEntryName(String unEmptyMaterialCol, String entryName) {
        String[] split = unEmptyMaterialCol.split("\\.");
        ArrayList<String> result = new ArrayList<String>(split.length);
        for (String str : split) {
            result.add(str);
            if (entryName.equals(str)) break;
        }
        return result;
    }

    public static String getOrgCol(DynamicObjectCollection snMainColEntry) {
        if (snMainColEntry == null || snMainColEntry.isEmpty()) {
            return "";
        }
        String invOrgCol = "";
        for (DynamicObject object : snMainColEntry) {
            if (!"invorg".equals(object.getString("snmainfcol"))) continue;
            invOrgCol = object.getString("snmainfsrcbillcol");
            break;
        }
        return invOrgCol;
    }

    private static boolean getMaterialInvInfoExistByMaterialColAndInvOrgCol(DynamicObject bill, String materialCol, String invOrgCol, DynamicObject entry, String operate, boolean isSubEntry, String entryKey) {
        String materialRealCol = materialCol.substring(materialCol.indexOf(entryKey) + entryKey.length() + 1);
        DynamicObject materialInfo = entry.getDynamicObject(materialRealCol);
        if (materialInfo == null) {
            if ("save".equals(operate) || "delete".equals(operate)) {
                return false;
            }
            String msg = ResManager.loadKDString((String)"\u83b7\u53d6\u7b2c{0}\u884c\u5206\u5f55\u7269\u6599\u5931\u8d25\uff0c\u65e0\u6cd5\u66f4\u65b0\u5e8f\u5217\u53f7\u4e3b\u6863\uff0c\u8bf7\u68c0\u67e5\u5e8f\u5217\u53f7\u670d\u52a1\u914d\u7f6e\u3002", (String)"IM-W-324706", (String)"bos-ext-scmc", (Object[])new Object[]{entry.getInt("seq")});
            if (isSubEntry) {
                msg = ResManager.loadKDString((String)"\u83b7\u53d6\u7b2c{0}\u884c\u5b50\u5206\u5f55\u7269\u6599\u5931\u8d25\uff0c\u65e0\u6cd5\u66f4\u65b0\u5e8f\u5217\u53f7\u4e3b\u6863\uff0c\u8bf7\u68c0\u67e5\u5e8f\u5217\u53f7\u670d\u52a1\u914d\u7f6e\u3002", (String)"IM-W-884521", (String)"bos-ext-scmc", (Object[])new Object[]{entry.getInt("seq")});
            }
            throw new KDBizException(msg);
        }
        DynamicObject invOrgInfo = (DynamicObject)SerialNumberHelper.getValueByName(bill, entry, invOrgCol);
        if (invOrgInfo == null) {
            if ("save".equals(operate) || "delete".equals(operate)) {
                return false;
            }
            String msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e8f\u5217\u53f7\u4e3b\u6863\u6620\u5c04\u7684\u5e93\u5b58\u7ec4\u7ec7\u5b57\u6bb5\u503c\u3002", (String)"BOSEXT-E-845634", (String)"bos-ext-scmc", (Object[])new Object[0]);
            if (invOrgCol.contains(".")) {
                msg = isSubEntry ? ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7b2c{0}\u884c\u5b50\u5206\u5f55\u5bf9\u5e94\u7684\u5e8f\u5217\u53f7\u4e3b\u6863\u6620\u5c04\u7684\u5e93\u5b58\u7ec4\u7ec7\u5b57\u6bb5\u503c\u3002", (String)"BOSEXT-E-447681", (String)"bos-ext-scmc", (Object[])new Object[]{entry.getInt("seq")}) : ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7b2c{0}\u884c\u5206\u5f55\u5bf9\u5e94\u7684\u5e8f\u5217\u53f7\u4e3b\u6863\u6620\u5c04\u7684\u5e93\u5b58\u7ec4\u7ec7\u5b57\u6bb5\u503c\u3002", (String)"BOSEXT-E-801144", (String)"bos-ext-scmc", (Object[])new Object[]{entry.getInt("seq")});
            }
            throw new KDBizException(msg);
        }
        return SerialNumberHelper.getMaterialInvInfoExist(materialInfo.getLong("masterid"), invOrgInfo.getLong("id"));
    }

    public static boolean getMaterialInvInfoExist(Long materialMasterId, Long invOrgId) {
        QFilter qFilter = new QFilter("masterid", "=", (Object)materialMasterId).and(BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)invOrgId).and("enableserial", "=", (Object)true));
        boolean exists = QueryServiceHelper.exists((String)"bd_materialinventoryinfo", (QFilter[])qFilter.toArray());
        return exists;
    }

    private static Object getValueByName(DynamicObject bill, DynamicObject entry, String colName) {
        if (colName.contains(".")) {
            return entry.get(SerialNumberHelper.getPureKey(colName));
        }
        return bill.get(colName);
    }

    private static String getPureKey(String currentKey) {
        if (currentKey.lastIndexOf(46) != -1) {
            return currentKey.substring(currentKey.lastIndexOf(46) + 1);
        }
        return currentKey;
    }

    public static boolean isEnableSerial(DynamicObject material) {
        if (material == null) {
            return false;
        }
        return material.getBoolean("enableserial");
    }

    public static boolean isVirtualBill(DynamicObject bill) {
        String formId;
        switch (formId = bill.getDynamicObjectType().getName()) {
            case "im_purinbill": 
            case "im_transinbill": 
            case "im_saloutbill": 
            case "im_transoutbill": {
                return bill.getBoolean("isvirtualbill");
            }
        }
        return false;
    }

    public static boolean isInitBill(DynamicObject bill) {
        String formId;
        switch (formId = bill.getDynamicObjectType().getName()) {
            case "im_purinbill": 
            case "im_saloutbill": 
            case "im_osmaterialreqoutbill": 
            case "im_ospurinbill": {
                return bill.getBoolean("isinitbill");
            }
        }
        return false;
    }

    public static Set<String> getSerialCols(String billType) {
        HashSet<String> result = new HashSet<String>(16);
        String cols = "billfilter, materialcol, materialmastercol, snmainfentry.snmainfsrcbillcol as invCol";
        QFilter filter = new QFilter("srcbillobj.number", "=", (Object)billType).and("enable", "=", (Object)"1").and("snmainfentry.snmainfcol", "=", (Object)"invorg");
        DynamicObjectCollection snBillConfig = QueryServiceHelper.query((String)"sbs_snbillconfig", (String)cols, (QFilter[])new QFilter[]{filter});
        if (snBillConfig == null || snBillConfig.isEmpty()) {
            return result;
        }
        for (DynamicObject config : snBillConfig) {
            String materialCol = config.getString("materialcol");
            String materialMasterCol = config.getString("materialmastercol");
            String invCol = config.getString("invCol");
            String filterStr = config.getString("billfilter");
            QFilter cfgFilter = SerialNumberHelper.parseBillFilter(filterStr, billType);
            if (cfgFilter != null) {
                ArrayList<String> properties = new ArrayList<String>(4);
                SerialNumberHelper.getAllFilterProperty(cfgFilter, properties);
                result.addAll(properties);
            }
            if (StringUtils.isNotEmpty((String)materialCol)) {
                result.add(materialCol);
            }
            if (StringUtils.isNotEmpty((String)materialMasterCol)) {
                if (materialMasterCol.endsWith(".masterid")) {
                    result.add(materialMasterCol.substring(0, materialMasterCol.indexOf(".masterid")));
                } else {
                    result.add(materialMasterCol);
                }
            }
            if (!StringUtils.isNotEmpty((String)invCol)) continue;
            result.add(invCol);
        }
        return result;
    }

    private static void getAllFilterProperty(QFilter cfgFilter, List<String> properties) {
        String[] properties1 = cfgFilter.getProperties();
        properties.addAll(Arrays.asList(properties1));
        List nests = cfgFilter.getNests(true);
        if (nests == null || nests.isEmpty()) {
            return;
        }
        for (QFilter.QFilterNest nest : nests) {
            QFilter filter = nest.getFilter();
            if (filter == null) continue;
            SerialNumberHelper.getAllFilterProperty(filter, properties);
        }
    }
}

