/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fircm.workflow;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.ext.fircm.dto.ApproveTaskResult;
import kd.bos.ext.fircm.dto.WorkFlowNodeCreditRecordDto;
import kd.bos.ext.fircm.enums.WorkFlowAuditTypeEnum;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.api.WorkflowElement;
import kd.bos.workflow.engine.extitf.IWorkflowPlugin;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityImpl;
import kd.ssc.task.workflow.dto.CreditPointDTO;

public class CreditScoreAccountWorkflowPlugin
implements IWorkflowPlugin {
    private static final Log log = LogFactory.getLog(CreditScoreAccountWorkflowPlugin.class);
    private static final String CREDITSUBSCOREINFO = "creditSubScoreInfo";
    private static final Set<String> ALLOWFLOWTYPES = new HashSet<String>(){
        {
            this.add("EndNoneEvent");
            this.add("EndCancelEvent");
            this.add("EndTerminateEvent");
            this.add("UserTask");
        }
    };
    private static final Set<String> ALLOWUSERTASKNODEEVENT = new HashSet<String>(){
        {
            this.add("start@normal");
            this.add("start@reject");
        }
    };

    public void notify(AgentExecution execution) {
        String eventName;
        WorkflowElement currentFlowElement = execution.getCurrentFlowElement();
        String flowType = currentFlowElement == null ? null : currentFlowElement.getType();
        if (!this.isAllowExecute(flowType, eventName = execution.getEventName())) {
            log.error(String.format("CreditScoreAccountWorkflowPlugin#notify call error,don't allow execute.flowType:%s,eventName:%s", flowType, eventName));
            return;
        }
        String flowCSSInfoStr = (String)execution.getVariable(CREDITSUBSCOREINFO);
        if (flowCSSInfoStr == null || flowCSSInfoStr.isEmpty()) {
            return;
        }
        List flowCSSInfo = SerializationUtils.fromJsonStringToList((String)flowCSSInfoStr, WorkFlowNodeCreditRecordDto.class);
        if (flowCSSInfo.size() < 1) {
            return;
        }
        this.handleCreditSubInfo(flowCSSInfo, execution);
    }

    private void handleCreditSubInfo(List<WorkFlowNodeCreditRecordDto> creditSubInfo, AgentExecution execution) {
        String billId = execution.getBusinessKey();
        String entityNumber = execution.getEntityNumber();
        String billNumber = ((ExecutionEntityImpl)execution).getBillNo();
        Long creatorId = ((ExecutionEntityImpl)execution).getCreatorId();
        CreditPointDTO creditPointDTO = new CreditPointDTO(billId, entityNumber, billNumber, creatorId);
        Long userIdByAppObj = (Long)DispatchServiceHelper.invokeBizService((String)"fi", (String)"fircm", (String)"ICreditService", (String)"getCreditArgAppObj", (Object[])new Object[]{creditPointDTO.getBillNumber(), creditPointDTO.getBillId()});
        Optional.ofNullable(userIdByAppObj).ifPresent(creditPointDTO::setUserId);
        if (creditPointDTO.getUserId() == -1L) {
            log.error(String.format("handleCreditSubInfo error, billType:{%s}, billNo:{%s}", creditPointDTO.getBillNumber(), creditPointDTO.getBillNo()));
            return;
        }
        Map<Long, Map<String, Object>> distinctSubScores = this.getDistinctSubScores(creditSubInfo);
        HashSet<Long> handledIds = new HashSet<Long>(8);
        for (Map.Entry<Long, Map<String, Object>> item : distinctSubScores.entrySet()) {
            Long id = item.getKey();
            Map<String, Object> detailMap = item.getValue();
            String description = (String)detailMap.get("description");
            long hisTaskId = (Long)detailMap.get("hisTaskId");
            creditPointDTO.setHisTaskId(hisTaskId);
            String creditPointDTOStr = SerializationUtils.toJsonString((Object)creditPointDTO);
            try {
                if (id.equals(0L)) {
                    DispatchServiceHelper.invokeBizService((String)"fi", (String)"fircm", (String)"ICreditService", (String)"insertCreditModLogOfZero", (Object[])new Object[]{creditPointDTOStr, "2", description});
                } else {
                    DispatchServiceHelper.invokeBizService((String)"fi", (String)"fircm", (String)"ICreditService", (String)"deductCreditPoints", (Object[])new Object[]{Collections.singletonList(id), "2", creditPointDTOStr, description});
                }
                handledIds.add(id);
            }
            catch (Exception e) {
                log.error(String.format("handleCreditSubInfo call ICreditService error,creditPointDTOStr:%s,distinctSubScores:%s,handledSubScores:%s", creditPointDTOStr, distinctSubScores, handledIds), (Throwable)e);
                this.removeHandledIds(handledIds, creditSubInfo);
                execution.setVariable(CREDITSUBSCOREINFO, (Object)SerializationUtils.toJsonString(creditSubInfo));
                throw new KDException((Throwable)e, new ErrorCode("handleCreditSubInfo call ICreditService error:", e.getMessage()), new Object[0]);
            }
        }
        execution.setVariable(CREDITSUBSCOREINFO, (Object)"");
    }

    private boolean isAllowExecute(String flowType, String eventName) {
        boolean isAllow = false;
        if (ALLOWFLOWTYPES.contains(flowType)) {
            if ("UserTask".equalsIgnoreCase(flowType)) {
                if (ALLOWUSERTASKNODEEVENT.contains(eventName)) {
                    isAllow = true;
                }
            } else {
                isAllow = true;
            }
        } else if (flowType == null && "withdraw_audited_proc".equals(eventName)) {
            isAllow = true;
        }
        return isAllow;
    }

    private Map<Long, Map<String, Object>> getDistinctSubScores(List<WorkFlowNodeCreditRecordDto> creditSubInfo) {
        HashMap<Long, Map<String, Object>> re = new HashMap<Long, Map<String, Object>>(8);
        for (WorkFlowNodeCreditRecordDto item : creditSubInfo) {
            List<ApproveTaskResult> approveTaskResults = item.getApproveTaskResults();
            String flowNodeName = item.getFlowNodeName();
            for (ApproveTaskResult approveTaskResult : approveTaskResults) {
                List<Long> creditScoreIds = approveTaskResult.getCreditScoreId();
                String auditType = approveTaskResult.getAuditType();
                String description = flowNodeName + approveTaskResult.getResultDescription();
                if (!WorkFlowAuditTypeEnum.isInclude(auditType)) {
                    log.info("handleCreditSubInfo invoke an creditRecord of error auditType:" + item);
                    continue;
                }
                HashMap<String, Object> detailMap = new HashMap<String, Object>(2);
                for (Long creditScoreId : creditScoreIds) {
                    if (re.containsKey(creditScoreId)) {
                        String newDes = ((Map)re.get(creditScoreId)).get("description") + "\u3001" + description;
                        detailMap.put("description", newDes);
                    } else {
                        detailMap.put("description", description);
                    }
                    detailMap.put("hisTaskId", approveTaskResult.getHisTaskId());
                    re.put(creditScoreId, detailMap);
                }
            }
        }
        return re;
    }

    private void removeHandledIds(Set<Long> handledIds, List<WorkFlowNodeCreditRecordDto> creditSubInfo) {
        Iterator<WorkFlowNodeCreditRecordDto> recordDtoIterator = creditSubInfo.iterator();
        while (recordDtoIterator.hasNext()) {
            WorkFlowNodeCreditRecordDto recordDto = recordDtoIterator.next();
            List<ApproveTaskResult> approveTaskResults = recordDto.getApproveTaskResults();
            Iterator<ApproveTaskResult> taskResultIterator = approveTaskResults.iterator();
            while (taskResultIterator.hasNext()) {
                ApproveTaskResult taskResult = taskResultIterator.next();
                List<Long> creditScoreIds = taskResult.getCreditScoreId();
                creditScoreIds.removeIf(handledIds::contains);
                if (creditScoreIds.size() >= 1) continue;
                taskResultIterator.remove();
            }
            if (approveTaskResults.size() >= 1) continue;
            recordDtoIterator.remove();
        }
    }
}

