/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scm.operation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.formula.BOSExpressionContext;
import kd.bos.entity.formula.CalcExprParser;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.function.FunctionManage;
import kd.bos.entity.operate.DefaultEntityOperate;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.mvc.form.FormView;
import kd.bos.mvc.list.ListView;
import kd.bos.parameter.ParameterShowParameter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ScmOpenFormOperation
extends DefaultEntityOperate {
    public OperationResult invokeOperation() {
        OperationResult operationResult = this.callEntityOperate();
        if (operationResult.getSuccessPkIds().size() > 0) {
            operationResult.setShowMessage(false);
            Object parameter = this.getParameter().get("parameter");
            if (!ObjectUtils.isEmpty(parameter)) {
                String form;
                Map paramMap = (Map)SerializationUtils.fromJsonString((String)String.valueOf(parameter), Map.class);
                String string = form = paramMap.get("form") == null ? "" : String.valueOf(paramMap.get("form"));
                if (StringUtils.isNotEmpty((CharSequence)form)) {
                    String entityId = MetadataDao.getNumberById((String)form);
                    String modelType = (String)paramMap.get("modeltype");
                    List customParamItems = (List)paramMap.get("customParams");
                    HashMap<String, Object> customParamsMap = new HashMap<String, Object>(16);
                    if (customParamItems != null) {
                        FunctionManage funcLib = FunctionManage.get();
                        if (this.getView() instanceof ListView) {
                            DynamicObject[] dynamicObjects;
                            for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((Object[])operationResult.getSuccessPkIds().toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)this.getEntityId()).getDynamicObjectType())) {
                                this.prepareCustomParam(dynamicObject, customParamItems, customParamsMap, funcLib);
                            }
                        } else if (this.getView() instanceof FormView) {
                            this.prepareCustomParam(this.getView().getModel().getDataEntity(true), customParamItems, customParamsMap, funcLib);
                        }
                    }
                    this.showForm(entityId, modelType, customParamsMap);
                }
            }
        }
        return operationResult;
    }

    private void prepareCustomParam(DynamicObject dynamicObject, List<Map<String, Object>> customParamItems, Map<String, Object> customParamsMap, FunctionManage funcLib) {
        String entityKey = dynamicObject.getDynamicObjectType().getName();
        RowDataModel rowModel = new RowDataModel(entityKey, EntityMetadataCache.getDataEntityType((String)entityKey));
        rowModel.setRowContext(dynamicObject);
        BOSExpressionContext expContext = new BOSExpressionContext(rowModel);
        for (Map<String, Object> customParamItem : customParamItems) {
            Object formula = customParamItem.get("formula");
            if (ObjectUtils.isEmpty((Object)formula)) continue;
            if (((Boolean)customParamItem.get("multi")).booleanValue()) {
                List values = customParamsMap.getOrDefault(customParamItem.get("key"), new ArrayList());
                values.add(CalcExprParser.getExpressionValue((String)((String)formula), (ExpressionContext)expContext, (FunctionManage)funcLib));
                customParamsMap.put((String)customParamItem.get("key"), values);
                continue;
            }
            customParamsMap.put((String)customParamItem.get("key"), CalcExprParser.getExpressionValue((String)((String)formula), (ExpressionContext)expContext, (FunctionManage)funcLib));
        }
    }

    public boolean needSelectData() {
        return true;
    }

    private void showForm(String number, String modelType, Map<String, Object> customParams) {
        Class<?> clasz = this.getpType().get(modelType);
        if (clasz == null) {
            return;
        }
        FormShowParameter showParameter = (FormShowParameter)TypesContainer.createInstance(clasz);
        OpenStyle openStyle = new OpenStyle();
        switch (modelType) {
            case "list": {
                ((ListShowParameter)showParameter).setBillFormId(number);
                openStyle.setShowType(ShowType.Modal);
                break;
            }
            case "form": 
            case "bill": 
            case "base": {
                showParameter.setFormId(number);
                openStyle.setShowType(ShowType.Modal);
                break;
            }
        }
        Object parameter = this.getParameter().get("parameter");
        if (!ObjectUtils.isEmpty(parameter)) {
            Map paramMap = (Map)SerializationUtils.fromJsonString((String)String.valueOf(parameter), Map.class);
            if (StringUtils.isNotBlank(paramMap.get("showtype"))) {
                openStyle.setShowType(ShowType.forValue((int)Integer.parseInt((String)paramMap.get("showtype"))));
            }
            if (StringUtils.isNotBlank(paramMap.get("targetkey"))) {
                openStyle.setTargetKey((String)paramMap.get("targetkey"));
            }
        }
        showParameter.setOpenStyle(openStyle);
        showParameter.setCustomParams(customParams);
        this.getView().showForm(showParameter);
    }

    private Map<String, Class<?>> getpType() {
        HashMap ptypes = new HashMap(16);
        ptypes.put("form", FormShowParameter.class);
        ptypes.put("bill", BillShowParameter.class);
        ptypes.put("base", BaseShowParameter.class);
        ptypes.put("list", ListShowParameter.class);
        ptypes.put("report", ReportShowParameter.class);
        ptypes.put("parameter", ParameterShowParameter.class);
        return ptypes;
    }
}

