/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.data.idi.formplugin;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.data.idi.formplugin.SmartPanelPlugin;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;

public class IDISampleFormPlugin
extends SmartPanelPlugin {
    private static final String CallBackActionId_ObjectId = "objectid";
    private static final String CallBackActionId_SchemaNumber = "schemanumber";
    private static final String Key_Base_ObjectType = "objecttype";
    private static final String Key_Text_MatchSchemaNumber = "matchschemanumber";
    private static final String Key_Text_ObjectId = "objectid";
    private static final String Key_Text_ObjectNumber = "objectnumber";
    private static final String Key_Text_SchemaNumber = "schemanumber";
    private static final String Key_btn_ok = "btnok";
    private static Log logger = LogFactory.getLog(SmartPanelPlugin.class);

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        MainEntityType billType = EntityMetadataCache.getDataEntityType((String)"bos_entityobject");
        DynamicObject billObj = BusinessDataServiceHelper.loadSingle((Object)"cas_paybill", (DynamicObjectType)billType);
        this.getModel().setValue(Key_Base_ObjectType, (Object)billObj);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"objectid"});
        this.addClickListeners(new String[]{"schemanumber"});
        this.addClickListeners(new String[]{Key_btn_ok});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equalsIgnoreCase((CharSequence)"objectid", (CharSequence)source.getKey())) {
            this.showBillList();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"schemanumber", (CharSequence)source.getKey())) {
            this.showSchemaList();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)Key_btn_ok, (CharSequence)source.getKey())) {
            DynamicObject objectType = (DynamicObject)this.getModel().getValue(Key_Base_ObjectType);
            Object billId = this.getModel().getValue("objectid");
            if (objectType == null || billId == null || StringUtils.isEmpty((CharSequence)String.valueOf(billId)) || StringUtils.isEmpty((CharSequence)objectType.getString("number"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u3002", (String)"IDISampleFormPlugin_3", (String)"bos-ext-data", (Object[])new Object[0]));
                return;
            }
            this.getView().setVisible(Boolean.valueOf(true), new String[]{this.getSmartPanelKey()});
            String schemaNumber = (String)this.getModel().getValue("schemanumber");
            if (StringUtils.isNotEmpty((CharSequence)schemaNumber)) {
                this.getModel().setValue(Key_Text_MatchSchemaNumber, (Object)schemaNumber);
                this.updateSmartPanel(objectType.getString("number"), billId, schemaNumber);
            } else {
                Map map;
                List list;
                DynamicObject billObj = BusinessDataServiceHelper.loadSingle((Object)billId, (String)objectType.getString("number"));
                if (billObj == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5b58\u5728\u3002", (String)"IDISampleFormPlugin_0", (String)"bos-ext-data", (Object[])new Object[0]));
                    return;
                }
                String matchSchemaNumber = null;
                String result = (String)DispatchServiceHelper.invokeBizService((String)"data", (String)"idi", (String)"IDISchemaService", (String)"findMatchSchema", (Object[])new Object[]{billObj});
                if (StringUtils.isNotEmpty((CharSequence)result) && (list = SerializationUtils.fromJsonStringToList((String)result, Map.class)) != null && list.size() > 0 && (map = (Map)list.get(0)) != null) {
                    matchSchemaNumber = (String)map.get("number");
                }
                if (StringUtils.isEmpty(matchSchemaNumber)) {
                    this.getModel().setValue(Key_Text_MatchSchemaNumber, (Object)"");
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5339\u914d\u7684\u65b9\u6848\u3002", (String)"IDISampleFormPlugin_1", (String)"bos-ext-data", (Object[])new Object[0]));
                    return;
                }
                this.getModel().setValue(Key_Text_MatchSchemaNumber, matchSchemaNumber);
                result = (String)DispatchServiceHelper.invokeBizService((String)"data", (String)"idi", (String)"IDISchemaService", (String)"executeSchema", (Object[])new Object[]{billObj, matchSchemaNumber});
                if (StringUtils.isNotEmpty((CharSequence)result)) {
                    CustomControl control = (CustomControl)this.getView().getControl(this.getSmartPanelKey());
                    try {
                        map = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
                        control.setData((Object)map);
                    }
                    catch (Exception ex) {
                        logger.error((Throwable)ex);
                    }
                }
            }
        }
    }

    private void showBillList() {
        DynamicObject objectType = (DynamicObject)this.getModel().getValue(Key_Base_ObjectType);
        if (objectType == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u5bf9\u8c61\u7c7b\u578b\u3002", (String)"IDISampleFormPlugin_2", (String)"bos-ext-data", (Object[])new Object[0]));
            return;
        }
        String entityNumber = (String)objectType.getPkValue();
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)entityNumber, (boolean)false);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "objectid");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showSchemaList() {
        DynamicObject objectType = (DynamicObject)this.getModel().getValue(Key_Base_ObjectType);
        if (objectType == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u5bf9\u8c61\u7c7b\u578b\u3002", (String)"IDISampleFormPlugin_2", (String)"bos-ext-data", (Object[])new Object[0]));
            return;
        }
        String entityNumber = (String)objectType.getPkValue();
        QFilter filter = new QFilter("sourceentitynumber", "=", (Object)entityNumber);
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"idi_schema", (boolean)false);
        showParameter.getListFilterParameter().setQFilters(Collections.singletonList(filter));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "schemanumber");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection rows;
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equalsIgnoreCase((CharSequence)"objectid", (CharSequence)closedCallBackEvent.getActionId())) {
            ListSelectedRowCollection rows2 = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (rows2 != null && !rows2.isEmpty()) {
                this.getModel().setValue("objectid", rows2.get(0).getPrimaryKeyValue());
                this.getModel().setValue(Key_Text_ObjectNumber, (Object)rows2.get(0).getBillNo());
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"schemanumber", (CharSequence)closedCallBackEvent.getActionId()) && (rows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()) != null && !rows.isEmpty()) {
            this.getModel().setValue("schemanumber", (Object)rows.get(0).getNumber());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("objectid".equals(e.getProperty().getName())) {
            this.getModel().setValue("schemanumber", null);
        }
    }
}

