/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.data.idi.model;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.exception.KDBizException;
import kd.bos.ext.data.idi.model.HighLightCursor;
import kd.bos.ext.data.idi.model.HighLightHandler;
import kd.bos.form.AbstractFormView;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.util.StringUtils;
import kd.bos.util.CollectionUtils;

public class EntryHighLight {
    private String entryName;
    private String[] entryFields;
    private int[] entryIndexes;
    private Set<String> customFuncEntryFieldSet;
    private int entrySize;

    public String getEntryName() {
        return this.entryName;
    }

    public void setEntryName(String entryName) {
        this.entryName = entryName;
    }

    public String[] getEntryFields() {
        return this.entryFields;
    }

    public void setEntryFields(String[] entryFields) {
        this.entryFields = entryFields;
    }

    public int[] getEntryIndexes() {
        return this.entryIndexes;
    }

    public void setEntryIndexes(int[] entryIndexes) {
        this.entryIndexes = entryIndexes;
    }

    public Set<String> getCustomFuncEntryFieldSet() {
        return this.customFuncEntryFieldSet;
    }

    public void setCustomFuncEntryFieldSet(Set<String> customFuncEntryFieldSet) {
        this.customFuncEntryFieldSet = customFuncEntryFieldSet;
    }

    public int getEntrySize() {
        return this.entrySize;
    }

    public void setEntrySize(int entrySize) {
        this.entrySize = entrySize;
    }

    public EntryHighLight clone() {
        EntryHighLight other = new EntryHighLight();
        other.setEntryName(this.entryName);
        if (this.entryFields != null && this.entryFields.length > 0) {
            String[] newEntryFields = new String[this.entryFields.length];
            System.arraycopy(this.entryFields, 0, newEntryFields, 0, this.entryFields.length);
            other.setEntryFields(newEntryFields);
        }
        if (CollectionUtils.isNotEmpty(this.customFuncEntryFieldSet)) {
            HashSet<String> newCustomFuncEntryFieldSet = new HashSet<String>(10);
            newCustomFuncEntryFieldSet.addAll(this.customFuncEntryFieldSet);
            other.setCustomFuncEntryFieldSet(newCustomFuncEntryFieldSet);
        }
        return other;
    }

    public HighLightCursor findFirst() {
        if (this.entryFields != null && this.entryFields.length > 0 && (this.entryIndexes != null && this.entryIndexes.length > 0 || this.entrySize > 0)) {
            String field;
            int entryIndex;
            if (CollectionUtils.isNotEmpty(this.customFuncEntryFieldSet)) {
                entryIndex = 0;
                field = this.isMatchRowIndex(entryIndex) ? this.entryFields[0] : this.findFirstCustomFuncEntryField();
            } else {
                entryIndex = this.entryIndexes[0];
                field = this.entryFields[0];
            }
            return new HighLightCursor(this.entryName, field, entryIndex);
        }
        return null;
    }

    public HighLightCursor findEnd() {
        if (this.entryFields != null && this.entryFields.length > 0 && (this.entryIndexes != null && this.entryIndexes.length > 0 || this.entrySize > 0)) {
            return this.findEntryFieldEnd();
        }
        return null;
    }

    private HighLightCursor findEntryFieldEnd() {
        String field;
        int entryIndex;
        int endIndex = this.entryFields.length - 1;
        if (CollectionUtils.isNotEmpty(this.customFuncEntryFieldSet)) {
            entryIndex = this.entrySize - 1;
            field = this.isMatchRowIndex(entryIndex) ? this.entryFields[endIndex] : this.findLastCustomFuncEntryField();
        } else {
            entryIndex = this.entryIndexes[this.entryIndexes.length - 1];
            field = this.entryFields[endIndex];
        }
        return new HighLightCursor(this.entryName, field, entryIndex);
    }

    public HighLightCursor previousCursor(HighLightCursor curHighLightCursor) {
        if (curHighLightCursor == null) {
            return null;
        }
        if (curHighLightCursor.isEntry()) {
            boolean isFirst;
            int entryIndex = curHighLightCursor.getEntryIndex();
            boolean hasCustomFunctionField = CollectionUtils.isNotEmpty(this.customFuncEntryFieldSet);
            int startIndex = hasCustomFunctionField ? 0 : this.entryIndexes[0];
            boolean isFirstRow = startIndex == entryIndex;
            boolean curIndexIsMatchRow = this.isMatchRowIndex(entryIndex);
            boolean bl = curIndexIsMatchRow ? isFirstRow && this.entryFields[0].equals(curHighLightCursor.getEntryField()) : (isFirst = isFirstRow && curHighLightCursor.getEntryField().equals(this.findFirstCustomFuncEntryField()));
            if (isFirst) {
                return null;
            }
            if (curIndexIsMatchRow) {
                for (int i = 0; i < this.entryFields.length; ++i) {
                    if (!this.entryFields[i].equals(curHighLightCursor.getEntryField())) continue;
                    if (i == 0) {
                        if (CollectionUtils.isNotEmpty(this.customFuncEntryFieldSet)) {
                            if (entryIndex > 0) {
                                int preEntryIndex = entryIndex - 1;
                                String preEntryField = this.isMatchRowIndex(preEntryIndex) ? this.entryFields[this.entryFields.length - 1] : this.findLastCustomFuncEntryField();
                                return new HighLightCursor(this.entryName, preEntryField, preEntryIndex);
                            }
                        } else {
                            int preEntryIndex = this.findPreEntryIndex(entryIndex);
                            if (preEntryIndex > -1) {
                                return new HighLightCursor(this.entryName, this.entryFields[this.entryFields.length - 1], preEntryIndex);
                            }
                        }
                        break;
                    }
                    return new HighLightCursor(this.entryName, this.entryFields[i - 1], entryIndex);
                }
            } else {
                String firstCustomFuncEntryField = this.findFirstCustomFuncEntryField();
                if (firstCustomFuncEntryField.equals(curHighLightCursor.getEntryField())) {
                    if (entryIndex > 0) {
                        int preEntryIndex = entryIndex - 1;
                        String preEntryField = this.isMatchRowIndex(preEntryIndex) ? this.entryFields[this.entryFields.length - 1] : this.findLastCustomFuncEntryField();
                        return new HighLightCursor(this.entryName, preEntryField, preEntryIndex);
                    }
                } else {
                    String nearFunctionField = null;
                    for (int i = 0; i < this.entryFields.length && !this.entryFields[i].equals(curHighLightCursor.getEntryField()); ++i) {
                        if (!this.customFuncEntryFieldSet.contains(this.entryFields[i])) continue;
                        nearFunctionField = this.entryFields[i];
                    }
                    if (StringUtils.isEmpty(nearFunctionField)) {
                        throw new KDBizException("\u8ba1\u7b97\u5206\u5f55\u4e0a\u4e00\u5149\u6807\u5f02\u5e38\uff0c\u627e\u4e0d\u5230\u4e0a\u4e00\u5206\u5f55\u5b57\u6bb5");
                    }
                    return new HighLightCursor(this.entryName, nearFunctionField, entryIndex);
                }
            }
        }
        return null;
    }

    private int findNextEntryIndex(int entryIndex) {
        int nearNextIndex = -1;
        if (this.entryIndexes != null && this.entryIndexes.length > 0) {
            for (int i = 0; i < this.entryIndexes.length; ++i) {
                if (entryIndex >= this.entryIndexes[i]) continue;
                nearNextIndex = this.entryIndexes[i];
                break;
            }
        }
        return nearNextIndex;
    }

    private int findPreEntryIndex(int entryIndex) {
        int nearPreIndex = -1;
        if (this.entryIndexes != null && this.entryIndexes.length > 0) {
            for (int i = this.entryIndexes.length - 1; i >= 0; --i) {
                if (this.entryIndexes[i] >= entryIndex) continue;
                nearPreIndex = this.entryIndexes[i];
                break;
            }
        }
        return nearPreIndex;
    }

    public HighLightCursor nextCursor(HighLightCursor curHighLightCursor) {
        if (curHighLightCursor == null) {
            return null;
        }
        if (curHighLightCursor.isEntry()) {
            boolean isEnd;
            boolean isEndRow;
            String entryFiled = curHighLightCursor.getEntryField();
            boolean hasCustomFunctionField = CollectionUtils.isNotEmpty(this.customFuncEntryFieldSet);
            int entryIndex = curHighLightCursor.getEntryIndex();
            int fieldEndIndex = this.entryFields.length - 1;
            int entryEndIndex = hasCustomFunctionField ? this.entrySize - 1 : this.entryIndexes[this.entryIndexes.length - 1];
            boolean curIndexIsMatchRow = this.isMatchRowIndex(entryIndex);
            boolean bl = isEndRow = entryEndIndex == entryIndex;
            boolean bl2 = curIndexIsMatchRow ? isEndRow && this.entryFields[fieldEndIndex].equals(entryFiled) : (isEnd = isEndRow && entryFiled.equals(this.findLastCustomFuncEntryField()));
            if (isEnd) {
                return null;
            }
            if (curIndexIsMatchRow) {
                for (int i = 0; i < this.entryFields.length; ++i) {
                    if (!this.entryFields[i].equals(entryFiled)) continue;
                    if (i == fieldEndIndex) {
                        if (this.customFuncEntryFieldSet != null && !this.customFuncEntryFieldSet.isEmpty()) {
                            if (entryIndex < entryEndIndex) {
                                int nextEntryIndex = entryIndex + 1;
                                String nextEntryField = this.isMatchRowIndex(nextEntryIndex) ? this.entryFields[0] : this.findFirstCustomFuncEntryField();
                                return new HighLightCursor(this.entryName, nextEntryField, nextEntryIndex);
                            }
                        } else {
                            int nextEntryIndex = this.findNextEntryIndex(entryIndex);
                            if (nextEntryIndex > -1) {
                                return new HighLightCursor(this.entryName, this.entryFields[0], nextEntryIndex);
                            }
                        }
                        break;
                    }
                    return new HighLightCursor(this.entryName, this.entryFields[i + 1], entryIndex);
                }
            } else {
                String lastCustomFuncEntryField = this.findLastCustomFuncEntryField();
                if (lastCustomFuncEntryField.equals(entryFiled)) {
                    if (entryIndex < entryEndIndex) {
                        int nextEntryIndex = entryIndex + 1;
                        String nextEntryField = this.isMatchRowIndex(nextEntryIndex) ? this.entryFields[0] : this.findFirstCustomFuncEntryField();
                        return new HighLightCursor(this.entryName, nextEntryField, nextEntryIndex);
                    }
                } else {
                    String nearFunctionField = null;
                    for (int i = fieldEndIndex; i >= 0 && !this.entryFields[i].equals(entryFiled); --i) {
                        if (!this.customFuncEntryFieldSet.contains(this.entryFields[i])) continue;
                        nearFunctionField = this.entryFields[i];
                    }
                    if (StringUtils.isEmpty(nearFunctionField)) {
                        throw new KDBizException("\u8ba1\u7b97\u5206\u5f55\u4e0b\u4e00\u5149\u6807\u5f02\u5e38\uff0c\u627e\u4e0d\u5230\u4e0b\u4e00\u5206\u5f55\u5b57\u6bb5");
                    }
                    return new HighLightCursor(this.entryName, nearFunctionField, entryIndex);
                }
            }
        }
        return null;
    }

    private String findFirstCustomFuncEntryField() {
        String field = null;
        if (CollectionUtils.isNotEmpty(this.customFuncEntryFieldSet)) {
            for (int i = 0; i < this.entryFields.length; ++i) {
                if (!this.customFuncEntryFieldSet.contains(this.entryFields[i])) continue;
                field = this.entryFields[i];
                break;
            }
        }
        return field;
    }

    private String findLastCustomFuncEntryField() {
        String field = null;
        if (CollectionUtils.isNotEmpty(this.customFuncEntryFieldSet)) {
            for (int i = this.entryFields.length - 1; i >= 0; --i) {
                if (!this.customFuncEntryFieldSet.contains(this.entryFields[i])) continue;
                field = this.entryFields[i];
                break;
            }
        }
        return field;
    }

    private boolean isMatchRowIndex(int entryIndex) {
        boolean isMatch = false;
        if (this.entryIndexes != null && this.entryIndexes.length > 0) {
            for (int index : this.entryIndexes) {
                if (index != entryIndex) continue;
                isMatch = true;
                break;
            }
        }
        return isMatch;
    }

    public void createHighLightCommand(AbstractFormView billView, HighLightCursor cursor) {
        if (billView == null) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)billView.getControl(this.entryName);
        int pageSize = entryGrid.getPageRow();
        int startRowIndex = 0;
        int endRowIndex = pageSize;
        if (cursor != null && cursor.isEntry() && cursor.getEntryName().equals(this.entryName)) {
            boolean inCurrentPage;
            AbstractGrid.GridState entryState = entryGrid.getEntryState();
            int currentPageIndex = entryState.getCurrentPageIndex();
            int dataPageIndex = cursor.getEntryIndex() / pageSize + 1;
            boolean bl = inCurrentPage = dataPageIndex == currentPageIndex;
            if (!inCurrentPage) {
                entryGrid.setPageIndex(dataPageIndex);
            }
            startRowIndex = (dataPageIndex - 1) * pageSize;
            endRowIndex = startRowIndex + pageSize;
        }
        if (CollectionUtils.isNotEmpty(this.customFuncEntryFieldSet)) {
            for (int i = startRowIndex; i < endRowIndex; ++i) {
                for (String functionField : this.customFuncEntryFieldSet) {
                    List<Map<String, Object>> rowStyle = HighLightHandler.createEntryCommand(functionField, i, cursor != null && cursor.ignoreEntryField(this.entryName, functionField, i));
                    billView.getClientProxy().invokeControlMethod(this.entryName, "setCellStyle", new Object[]{rowStyle});
                }
            }
        }
        if (this.entryFields != null && this.entryFields.length > 0 && this.entryIndexes != null && this.entryIndexes.length > 0) {
            for (int matchRowIndex : this.entryIndexes) {
                if (matchRowIndex < startRowIndex || matchRowIndex >= endRowIndex) continue;
                for (String entryField : this.entryFields) {
                    if (this.customFuncEntryFieldSet != null && this.customFuncEntryFieldSet.contains(entryField)) continue;
                    List<Map<String, Object>> rowStyle = HighLightHandler.createEntryCommand(entryField, matchRowIndex, cursor != null && cursor.ignoreEntryField(this.entryName, entryField, matchRowIndex));
                    billView.getClientProxy().invokeControlMethod(this.entryName, "setCellStyle", new Object[]{rowStyle});
                }
            }
        }
        if (cursor != null && !StringUtils.isEmpty((Object)cursor.getEntryName()) && cursor.getEntryName().equals(this.getEntryName())) {
            HighLightHandler.createEntryFocus(cursor, billView);
        }
    }

    public void createHighLightCommandToNewCursor(AbstractFormView billView, HighLightCursor newCursor) {
        if (billView == null) {
            return;
        }
        if (newCursor != null && newCursor.isEntry() && newCursor.getEntryName().equals(this.entryName)) {
            EntryGrid entryGrid = (EntryGrid)billView.getControl(this.entryName);
            int pageSize = entryGrid.getPageRow();
            AbstractGrid.GridState entryState = entryGrid.getEntryState();
            int currentPageIndex = entryState.getCurrentPageIndex();
            int dataPageIndex = newCursor.getEntryIndex() / pageSize + 1;
            boolean inCurrentPage = dataPageIndex == currentPageIndex;
            boolean curEntry = false;
            if (!inCurrentPage) {
                entryGrid.setPageIndex(dataPageIndex);
                int startRowIndex = (dataPageIndex - 1) * pageSize;
                int endRowIndex = startRowIndex + pageSize;
                if (CollectionUtils.isNotEmpty(this.customFuncEntryFieldSet)) {
                    for (int i = startRowIndex; i < endRowIndex; ++i) {
                        for (String functionField : this.customFuncEntryFieldSet) {
                            List<Map<String, Object>> rowStyle = HighLightHandler.createEntryCommand(functionField, i, newCursor.isEntry() && newCursor.ignoreEntryField(this.entryName, functionField, i));
                            billView.getClientProxy().invokeControlMethod(this.entryName, "setCellStyle", new Object[]{rowStyle});
                        }
                    }
                }
                if (this.entryFields != null && this.entryFields.length > 0 && this.entryIndexes != null && this.entryIndexes.length > 0) {
                    for (int matchRowIndex : this.entryIndexes) {
                        if (matchRowIndex < startRowIndex || matchRowIndex >= endRowIndex) continue;
                        for (String entryField : this.entryFields) {
                            if (this.customFuncEntryFieldSet != null && this.customFuncEntryFieldSet.contains(entryField)) continue;
                            List<Map<String, Object>> rowStyle = HighLightHandler.createEntryCommand(entryField, matchRowIndex, newCursor.isEntry() && newCursor.ignoreEntryField(this.entryName, entryField, matchRowIndex));
                            billView.getClientProxy().invokeControlMethod(this.entryName, "setCellStyle", new Object[]{rowStyle});
                        }
                    }
                }
            } else if (newCursor.isEntry()) {
                List<Map<String, Object>> rowStyle = HighLightHandler.createEntryCommand(newCursor.getEntryField(), newCursor.getEntryIndex(), true);
                billView.getClientProxy().invokeControlMethod(this.entryName, "setCellStyle", new Object[]{rowStyle});
            }
        }
        if (newCursor != null && !StringUtils.isEmpty((Object)newCursor.getEntryName()) && newCursor.getEntryName().equals(this.getEntryName())) {
            HighLightHandler.createEntryFocus(newCursor, billView);
        }
    }

    public void createCommandToCancel(AbstractFormView billView) {
        if (billView == null) {
            return;
        }
        if (CollectionUtils.isNotEmpty(this.customFuncEntryFieldSet)) {
            for (int i = 0; i < this.entrySize; ++i) {
                for (String functionField : this.customFuncEntryFieldSet) {
                    List<Map<String, Object>> rowStyle = HighLightHandler.createEntryCommandCancel(functionField, i);
                    billView.getClientProxy().invokeControlMethod(this.entryName, "setCellStyle", new Object[]{rowStyle});
                }
            }
        }
        if (this.entryFields != null && this.entryFields.length > 0 && this.entryIndexes != null && this.entryIndexes.length > 0) {
            for (int matchRowIndex : this.entryIndexes) {
                for (String entryField : this.entryFields) {
                    if (this.customFuncEntryFieldSet != null && this.customFuncEntryFieldSet.contains(entryField)) continue;
                    List<Map<String, Object>> rowStyle = HighLightHandler.createEntryCommandCancel(entryField, matchRowIndex);
                    billView.getClientProxy().invokeControlMethod(this.entryName, "setCellStyle", new Object[]{rowStyle});
                }
            }
        }
    }
}

