/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.es.mapper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dts.RowInfo;
import kd.bos.dts.impl.fulltext.Mapper;
import kd.bos.dts.multientity.MultiEntity;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.ext.hr.es.me.constants.EnumDataChangeType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.CollectionUtils;

public class AnObjSynMapper
implements Mapper {
    private static final Log LOGGER = LogFactory.getLog(AnObjSynMapper.class);
    private String anObjId;
    private String mainEntityNumber = null;

    public List<RowInfo> preHandle(List<RowInfo> list) {
        MainEntityType dataEntityType;
        String tableName;
        LOGGER.info("AnObjSynMapper_preHandle_start!anObjId:{}", (Object)this.anObjId);
        if (CollectionUtils.isEmpty(list) || StringUtils.isEmpty((CharSequence)this.anObjId)) {
            LOGGER.info("AnObjSynMapper_preHandle_empty,list:{}", list);
            return null;
        }
        RowInfo firstRowInfo = list.get(0);
        if (firstRowInfo == null) {
            LOGGER.info("AnObjSynMapper_preHandle_firstRowInfo == null");
            return null;
        }
        String dataChangeType = firstRowInfo.getType();
        String entityNumber = firstRowInfo.getEntityNumber();
        if (entityNumber == null) {
            entityNumber = this.getMultiEntity().getMainEntityNumber(null);
        }
        if (!(tableName = firstRowInfo.getTable()).equals((dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber)).getAlias())) {
            LOGGER.info("AnObjSynMapper_preHandle_!tableName.equals(dataEntityType.getAlias()),tableName:{},dataEntityType.getAlias():{}", (Object)tableName, (Object)dataEntityType.getAlias());
            return null;
        }
        boolean isBatchImportData = true;
        ArrayList<Object> idList = new ArrayList<Object>(10);
        for (RowInfo rowInfo : list) {
            if (isBatchImportData && !EnumDataChangeType.NEW.getType().equals(dataChangeType)) {
                isBatchImportData = false;
            }
            idList.add(rowInfo.getKeyObject());
        }
        try {
            if (CollectionUtils.isNotEmpty(idList)) {
                boolean mainEntity = this.getMultiEntity().isMainEntity(entityNumber);
                LOGGER.info("ANO_DTS_SYNC batchImportData! anObjId:{}, dataChangeType:{}, batch size:{},isMainEntityNum:{}", new Object[]{this.anObjId, dataChangeType, idList.size(), mainEntity});
                if (isBatchImportData && idList.size() > 0 && mainEntity) {
                    long time = System.currentTimeMillis();
                    DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrptmc", (String)"IHRPTMCAnoSynDataService", (String)"batchSynData", (Object[])new Object[]{Long.parseLong(this.anObjId), idList});
                    long time2 = System.currentTimeMillis();
                    LOGGER.info("AnObjSynMapper_preHandle_batchImportData_time:{}", (Object)(time2 - time));
                }
            }
        }
        catch (Exception exc) {
            LOGGER.error("ANO_DTS_SYNC importData Exception,anObjId:{}, isBatchImportData{}, error:{}", new Object[]{this.anObjId, isBatchImportData, exc.getMessage()});
            throw new KDBizException(exc.getMessage());
        }
        return null;
    }

    public void endInit(String opType, String entityNumber) {
        LOGGER.info("ANO_DTS_SYNC batchImport finish! anObjId:{}, opType:{}, entityNumber:{}", new Object[]{this.anObjId, opType, entityNumber});
        if (StringUtils.isEmpty((CharSequence)this.anObjId) || StringUtils.isEmpty((CharSequence)opType)) {
            return;
        }
        if (!opType.equals("insert")) {
            return;
        }
        DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrptmc", (String)"IHRPTMCAnoSynDataService", (String)"endSyn", (Object[])new Object[]{Long.parseLong(this.anObjId)});
    }

    public Map<?, ?> convert2Es(String s, RowInfo rowInfo) {
        return null;
    }

    public String getKeyId(RowInfo rowInfo) {
        return null;
    }

    public String getIndexName(String s) {
        return null;
    }

    public String getESDataType() {
        return null;
    }

    public void setRegion(String s) {
    }

    public String getFieldStoredName(String s, String s1) {
        return null;
    }

    public MultiEntity getMultiEntity() {
        return new AnObjMulEntity();
    }

    class AnObjMulEntity
    implements MultiEntity {
        AnObjMulEntity() {
        }

        public String getMainEntityNumber(String entityNumber) {
            String mainEntityNumber = this.getMainEntityNumber();
            if (StringUtils.isEmpty((CharSequence)mainEntityNumber)) {
                throw new KDBizException("mainEntityNumber error");
            }
            return mainEntityNumber;
        }

        public boolean isMainEntity(String entityNumber) {
            String mainEntityNumber = this.getMainEntityNumber();
            if (StringUtils.isEmpty((CharSequence)mainEntityNumber)) {
                throw new KDBizException("mainEntityNumber error");
            }
            return entityNumber.equals(mainEntityNumber);
        }

        private String getMainEntityNumber() {
            if (StringUtils.isEmpty((CharSequence)AnObjSynMapper.this.mainEntityNumber)) {
                AnObjSynMapper.this.mainEntityNumber = (String)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrptmc", (String)"IHRPTMCAnoSynDataService", (String)"getMainEntityNumber", (Object[])new Object[]{Long.parseLong(AnObjSynMapper.this.anObjId)});
            }
            return AnObjSynMapper.this.mainEntityNumber;
        }
    }
}

